<?php

if (!defined("__CORE_DIR")) {
	exit("Access Denied");
}
class Ctl extends Factory
{
	protected $_allow_fields = "";

	public function __construct(&$system)
	{
		parent::__construct($system);
		$this->cookie = $system->cookie;
		$this->InitializeApp();
	}

	protected function InitializeApp()
	{
		$this->err->template("view:page/notice.html");
		$this->system->objctl = &$this;
		$this->auth = &$this->system->auth;
		$this->MEMBER = &$this->system->MEMBER;
		$this->uid = $this->MEMBER["uid"];
		$this->uname = $this->MEMBER["uname"];
		$this->seo = K::m("helper/seo");
	}

	protected function _init_pagedata()
	{
		parent::_init_pagedata();
		$theme = $this->default_theme();
		$this->pagedata["MEMBER"] = $this->MEMBER;
		$site = $this->system->config->get("site");
		$this->pagedata["pager"]["url"] = $site["url"];
		$this->pagedata["pager"]["res"] = __CFG::RES_URL;
		$this->pagedata["pager"]["sitecount"] = K::m("magic/magic")->sitecount();
		$this->pagedata["request"] = $this->request;
		$this->pagedata["pager"]["theme"] = $site["siteurl"] . "/themes";
		$this->pagedata["SEO"] = $this->seo->_SEO;
		$this->pagedata["nowtime"] = __TIME;
		$output = K::m("system/frontend");
		$output->setCompileDir(__CFG::DIR . "data/tplcache");
	}

	public function check_fields($data, $fields = NULL)
	{
		if ($fields === NULL) {
			$fields = $this->_allow_fields;
		}

		if (!is_array($fields)) {
			$fields = explode(",", $fields);
		}

		foreach ((array) $data as $k => $v ) {
			if (!in_array($k, $fields)) {
				unset($data[$k]);
			}
		}

		return $data;
	}

	public function check_login()
	{
		if (!$this->uid) {
			if ($this->request["XREQ"] || $this->request["MINI"]) {
				$this->err->add("很抱歉，你还没有登录不能访问", 101);
			}
			else {
				$this->tmpl = "passport/login.html";
			}

			$this->err->response();
			exit();
		}

		return true;
	}

	protected function set_resource_view(&$output)
	{
		$theme = $this->default_theme();
		$output->setTemplateDir(__CFG::TMPL_DIR . $theme["theme"]);
		$output->registerFilter("pre", array($this, "smarty_pre_filter"));
		$output->registerFilter("post", array($this, "smarty_post_filter"));
		$output->default_template_handler_func = array($this, "theme_default_handler");
	}

	public function smarty_pre_filter($source, $smarty)
	{
		$s = array("/(<\{KT[^\}]*\}>)/", "/(<\{\/KT\}>)/", "/(<\{AD[^\}]*\}>)/", "/(<\{\/AD\}>)/", "/(<\{calldata[^\}]*\}>)/", "/(<\{\/calldata\}>)/");
		$r = array("\1<{literal}>", "<{/literal}>\1", "\1<{literal}>", "<{/literal}>\1", "\1<{literal}>", "<{/literal}>\1");
		//return preg_replace($s, $r, $source);
		return $source;
	}

	public function smarty_post_filter($source, $smarty)
	{
		if ($file_dependency = $smarty->properties["file_dependency"]) {
			foreach ($smarty->properties["file_dependency"] as $info ) {
				$tmpl = $smarty->template_resource;

				if ($info[2] == "file") {
					$theme = substr($info[0], strlen(__CFG::TMPL_DIR), -strlen($tmpl));
					$theme = str_replace("\\", "/", $theme);
					$theme = str_replace("/", "", $theme);
					$site = $this->system->config->get("site");
					$theme_url = trim($site["url"], "/") . "/themes/" . $theme;

					return preg_replace("/%THEME%/", $theme_url, $source);
				}
			}
		}

		return $source;
	}

	public function theme_default_handler($type, $name, &$content, &$modified, $smarty)
	{
		if ($type == "file") {
			$file = __CFG::TMPL_DIR . "default" . DIRECTORY_SEPARATOR . $name;
			return $file;
		}

		return false;
	}

	public function error($error)
	{
		if (is_numeric($error)) {
			$this->system->response_code($error);
		}

		$this->tmpl = "page/" . $error . ".html";
		$this->output();
	}

	public function shutdown()
	{
	}

	protected function default_theme()
	{
		static $theme;

		if ($theme === NULL) {
			if ($city_theme_id = (int) $this->request["city"]["theme_id"]) {
				$theme = K::m("system/theme")->theme(NULL, $city_theme_id);
			}

			if (empty($theme)) {
				$theme = K::m("system/theme")->default_theme();
			}
		}

		return $theme;
	}

	protected function check_shop($shop_id = NULL)
	{
		if (!$shop_id = (int) $shop_id) {
			$this->error(404);
		}
		else if (!$shop = K::m("shop/shop")->detail($shop_id, true)) {
			$this->error(404);
		}
		else {
			if (empty($shop["audit"]) && (empty($this->uid) || ($this->uid != $shop["uid"]))) {
				$this->err->add("商铺审核中不能访问", 212);
				$this->err->response();
			}
		}

		if ($uid = $shop["uid"]) {
			$shop["member"] = K::m("member/view")->detail($uid);
		}

		$theme = $this->default_theme();
		$skin_cfg = __CFG::TMPL_DIR . $theme["theme"] . "/shop/config.php";

		if (!file_exists($skin_cfg)) {
			$skin_cfg = __CFG::TMPL_DIR . "default/shop/config.php";
		}

		$skins = include ($skin_cfg);

		if (!$skin = $shop["skin"]) {
			$skin = "default";
		}

		$shop["skin_cfg"] = $skins[$skin];
		$this->pagedata["shop"] = $shop;
		return $shop;
	}
}


?>
