﻿<%
'// <summary>
'// 数据库操作
'// </summary>
function db(byval SQLstr,byval SQLtype)
	select case SQLtype
	case 0
		conn.Execute (SQLstr)
	case 1
		set db = conn.execute(SQLstr)
	case 2
		set db = server.createobject("Adodb.Recordset")
		db.open SQLstr, conn, 1, 1
	case 3:
		set db = server.createobject("Adodb.Recordset")
		db.open SQLstr, conn, 1, 3
	End select
End function

'// <summary>
'// 关闭数据库
'// </summary>
Sub ConnClose()
	If VarType(conn) = 8 Then Conn.close: set Conn = Nothing
End Sub

'// <summary>
'// 载入include文件
'// </summary>
Function Include(filePath)
    dim stm
    On Error Resume Next
    Set stm = Server.CreateObject("adodb.stream")
    With stm
        .Type = 2
        .Mode = 3
        .Open
        .Charset = "utf-8"
        .Position = 0
        .LoadFromFile Server.MapPath(filePath)
        If Err.Number<>0 Then
			Response.Write "出错，文件不存在."
			Err.Clear
			Set stm = Noting
			Exit Function
        End if
        pContent = .ReadText
        .Close
    End With
    Set stm = Nothing

	set jRegExp=new RegExp
	jRegExp.pattern="^\s*="
	IncludeEnd=1
	IncludeStart=inStr(IncludeEnd,pContent,"<%")+2
	do while IncludeStart>IncludeEnd+1 
		Response.write mid(pContent,IncludeEnd,IncludeStart-IncludeEnd-2)
		IncludeEnd=inStr(IncludeStart,pContent,"%\>")+2
		Execute(jRegExp.replace(mid(pContent,IncludeStart,IncludeEnd-IncludeStart-2),"Response.Write "))
		IncludeStart=inStr(IncludeEnd,pContent,"<%")+2
	loop
	Response.write mid(pContent,IncludeEnd) 
	set jRegExp=nothing
End Function

'// <summary>
'// 载入语言包
'// </summary>
sub GetLanguage(fString)
	If fString="" Then
		fString="zh-cn"
	End if
	If fString="zh-cn" Then
		Include(""&defInstalldir&"global/language/zh-cn.asp")
	Elseif fString="en-us" Then
		Include(""&defInstalldir&"global/language/en-us.asp")
	Else
		Include(""&defInstalldir&"global/language/zh-cn.asp")
	End if
End sub

'// <summary>
'// 检查组件是否已经安装
'// strClassString ----组件名
'// True -----已经安装
'// False -----没有安装
'// </summary>
Function IsObjInstalled(fString)
	On Error Resume Next
	IsObjInstalled = False
	Err = 0
	dim xTestObj
	set xTestObj = Server.CreateObject(fString)
	If 0 = Err Then IsObjInstalled = True
	set xTestObj = Nothing
	Err = 0
End Function

'// <summary>
'// 返回当前页的完整URL
'// </summary>
Function getCurrentPageURL()
	dim strReturnPage,strQuery,thing
	strReturnPage="http://" & Request.ServerVariables("HTTP_HOST") & Request.ServerVariables("SCRIPT_NAME")
	strQuery=""
	for each thing in Request.QueryString
	    if thing<>"Page" Then
	   		if strQuery="" Then
	   			strQuery=thing & "=" & Request.QueryString(thing) 
	   		Else
	   			strQuery=strQuery & "&" & thing & "=" & Request.QueryString(thing) 
	   		End if
	    End if
	Next
	if strQuery="" Then
		getCurrentPageURL=strReturnPage
	Else
		getCurrentPageURL=strReturnPage & "?" & strQuery
	End if
End Function

'// <summary>
'// 禁止外部提交
'// </summary>
Function checkpost(byval fString)
	dim pReferer, pName
	pReferer = cstr(request.servervariables("http_referer"))
	pName = cstr(request.servervariables("server_name"))
	if Mid(pReferer, 8, len(pName)) <> pName Then
		if Not fString Then
			Response.Write "Error." : response.End
		Else
			checkpost = False
		End if
	Else
		checkpost = True
	End if
End Function

'// <summary>
'// URL编码和解码
'// </summary>
function URLdecoding(fString)
    dim i,strreturn,strSpecial
    strSpecial = "!""#$%&'()*+,/:;<=>?@[\]^`{|}~%"
    strreturn = ""
    for i = 1 to len(fString)    
        thischr = mid(fString,i,1)
        if thischr="%" then
            intasc=eval("&h"+mid(fString,i+1,2))
            if instr(strSpecial,chr(intasc))>0 then
                strreturn= strreturn & chr(intasc)
                i=i+2
            Else
                intasc=eval("&h"+mid(fString,i+1,2)+mid(fString,i+4,2))
                strreturn= strreturn & chr(intasc)
                i=i+5
            End if
        Else
            if thischr="+" then
                strreturn= strreturn & " "
            Else
                strreturn= strreturn & thischr
            End if
        End if
    Next
    urldecoding = strreturn
End Function

Function URLencoding(fString)
    dim i,strreturn,strSpecial
    strSpecial = "!""#$%&'()*+,/:;<=>?@[\]^`{|}~%"
    strreturn = ""
    for i = 1 to len(fString)
        thischr = mid(fString,i,1)
        if abs(asc(thischr)) < &hff then
            if thischr=" " then
                strreturn = strreturn & "+"
            Elseif instr(strSpecial,thischr)>0 then
                strreturn = strreturn & "%" & hex(asc(thischr))
            Else
                strreturn = strreturn & thischr
            End if
        Else
            innercode = asc(thischr)
            if innercode < 0 then
                innercode = innercode + &h10000
            End if
            hight8 = (innercode  and &hff00)\ &hff
            low8 = innercode and &hff
            strreturn = strreturn & "%" & hex(hight8) &  "%" & hex(low8)
        End if
    Next
    urlencoding = strreturn
End Function

'// <summary>
'// 验证为空
'// </summary>
Function IsBlank(ByRef strng)
	IsBlank = False
	Select Case VarType(strng)
	Case 0, 1
		IsBlank = True
	Case 8
		If Len(strng) = 0 Then
			IsBlank = True
		End if
	Case 9
		tmpType = TypeName(strng)
		If (tmpType = "Nothing") Or (tmpType = "Empty") Then
			IsBlank = True
		End if
	Case 8192, 8204, 8209
		If UBound(strng) = -1 Then
			IsBlank = True
		End if
	End Select
End Function

'// <summary>
'// 将字符转为整型数值 
'// </summary>
Function GetFix(ByVal fString)
    If IsNumeric(fString) Then
        GetFix = Fix(cdbl(fString))
    Else
        GetFix = 0
    End if
End Function

'// <summary>
'// 关键字高亮
'// </summary>
Function GetHighlight(pText,fString)  
	IF fString="" Then:GetHighlight=pText:Exit Function
	fString=Replace(fString,"?","？")
	pText=ReplaceText(pText,"("&fString&")","<font color=red>$1</font>")
	GetHighlight=pText
End Function

Function ReplaceText(substr,strPattern,replaceMent)
	Set jRegExp=New RegExp
	jRegExp.Pattern=strPattern
	jRegExp.IgnoreCase=True
	jRegExp.Global=True
	ReplaceText=jRegExp.Replace(""&substr&"",""&replaceMent&"")
	Set jRegExp=nothing
End Function

'// <summary>
'// 压缩代码
'// </summary>
function Getzip(byval fString)
	dim jRegExp
	Set jRegExp=New RegExp
	jRegExp.IgnoreCase=True
	jRegExp.Global=True
	jRegExp.pattern=" +":fString=jRegExp.replace(fString,chr(32))
	jRegExp.pattern="\t+|\r+|\n+":fString=jRegExp.replace(fString,"")
	jRegExp.pattern="\r+":fString=jRegExp.replace(fString,"")
	jRegExp.pattern="\n+":fString=jRegExp.replace(fString,"")
	set jRegExp=nothing
	Getzip = fString
End function

'// <summary>
'// 过滤字符
'// </summary>
Function GetLeach(ByVal fString,ByVal style)
	IF Len(fString)=0 Or IsNull(fString) Or IsArray(fString) Then GetLeach="":Exit Function
	fString=Trim(fString)
	select Case style
		Case "1"
			fString=Replace(fString,Chr(32),"&nbsp;")
			fString=Replace(fString,Chr(13),"")
			fString=Replace(fString,Chr(10)&Chr(10),"<br>")
			fString=Replace(fString,Chr(10),"<br>")
		Case "2"
			fString=Replace(fString,Chr(8),"")'回格
			fString=Replace(fString,Chr(9),"")'tab(水平制表符)
			fString=Replace(fString,Chr(10),"")'换行
			fString=Replace(fString,Chr(11),"")'tab(垂直制表符) 
			fString=Replace(fString,Chr(12),"")'换页
			fString=Replace(fString,Chr(13),"")'回车 chr(13)&chr(10) 回车和换行的组合
			fString=Replace(fString,Chr(22),"")
			fString=Replace(fString,Chr(32),"")'空格 SPACE 
			fString=Replace(fString,Chr(33),"")'! 
			fString=Replace(fString,Chr(34),"")'" 
			fString=Replace(fString,Chr(35),"")'#
			fString=Replace(fString,Chr(36),"")'$ 
			fString=Replace(fString,Chr(37),"")'%  
			fString=Replace(fString,Chr(38),"")'&
			fString=Replace(fString,Chr(39),"")'' 
			fString=Replace(fString,Chr(40),"")'(  
			fString=Replace(fString,Chr(41),"")')
			fString=Replace(fString,Chr(42),"")'*
			fString=Replace(fString,Chr(43),"")'+
			fString=Replace(fString,Chr(44),"")',
			'fString=Replace(fString,Chr(45),"")'-
			fString=Replace(fString,Chr(46),"")'.
			fString=Replace(fString,Chr(47),"")'/
			fString=Replace(fString,Chr(58),"")':
			fString=Replace(fString,Chr(59),"")';
			fString=Replace(fString,Chr(60),"")'<
			fString=Replace(fString,Chr(61),"")'=
			fString=Replace(fString,Chr(62),"")'>
			fString=Replace(fString,Chr(63),"")'?
			fString=Replace(fString,Chr(64),"")'@
			fString=Replace(fString,Chr(91),"")'\ 
			fString=Replace(fString,Chr(92),"")'\ 
			fString=Replace(fString,Chr(93),"")']  
			fString=Replace(fString,Chr(94),"")'^
			fString=Replace(fString,Chr(95),"")'_
			fString=Replace(fString,Chr(96),"")'`
			fString=Replace(fString,Chr(123),"")'{   
			fString=Replace(fString,Chr(124),"")'| 
			fString=Replace(fString,Chr(125),"")'}
			fString=Replace(fString,Chr(126),"")'~
	Case Else
		fString=Replace(fString, "&", "&amp;")
		fString=Replace(fString, "'", "&#39;")
		fString=Replace(fString, """", "&#34;")
		fString=Replace(fString, "<", "&lt;")
		fString=Replace(fString, ">", "&gt;")
	End select
	IF Instr(Lcase(fString),"expression")>0 Then
		fString=Replace(fString,"expression","e&#173;xpression", 1, -1, 0)
	End If
	GetLeach=fString  
End Function

'// <summary>
'// 转换HTML代码
'// </summary>
Function HTMLEncode(ByVal reString)
    Dim Str
    Str = reString
    If Not IsNull(Str) Then
        Str = Replace(Str, ">", "&gt;")
        Str = Replace(Str, "<", "&lt;")
        Str = Replace(Str, Chr(9), "&#160;&#160;&#160;&#160;")
        Str = Replace(Str, Chr(32)&Chr(32), "&nbsp;&nbsp;")
        Str = Replace(Str, Chr(39), "&#39;")
        Str = Replace(Str, Chr(34), "&quot;")
        Str = Replace(Str, Chr(13), "")
        Str = Replace(Str, Chr(10), "<br/>")
        HTMLEncode = Str
    End If
End Function

'// <summary>
'// 反转换HTML代码
'// </summary>
Function HTMLDecode(ByVal reString)
    Dim Str
    Str = reString
    If Not IsNull(Str) Then
        Str = Replace(Str, "&gt;", ">")
        Str = Replace(Str, "&lt;", "<")
        Str = Replace(Str, "&#160;&#160;&#160;&#160;", Chr(9))
        Str = Replace(Str, "&nbsp;&nbsp;", Chr(32)&Chr(32))
        Str = Replace(Str, "&#39;", Chr(39))
        Str = Replace(Str, "&quot;", Chr(34))
        Str = Replace(Str, "", Chr(13))
        Str = Replace(Str, "<br/>", Chr(10))
        HTMLDecode = Str
    End If
End Function

'// <summary>
'// 转换内容
'// </summary>
Function GetEnCode(ByVal fString)
    set jRegexp=New RegExp
    jRegexp.ignorecase=true
    jRegexp.global=true
    if fString="<p>&nbsp;</p>" then fString="":Exit function
    fString=replace(fString,"&","&amp;")
    fString=replace(fString,"'","&#39;")
    fString=replace(fString,"""","&#34;")
    fString=replace(fString,"<","&lt;")
    fString=replace(fString,">","&gt;")
    jRegexp.pattern="(w)(here)"
    fString=jRegexp.replace(fString,"$1h&#101;re")
    jRegexp.pattern="(s)(elect)"
    fString=jRegexp.replace(fString,"$1el&#101;ct")
    jRegexp.pattern="(i)(nsert)"
    fString=jRegexp.replace(fString,"$1ns&#101;rt")
    jRegexp.pattern="(c)(reate)"
    fString=jRegexp.replace(fString,"$1r&#101;ate")
    jRegexp.pattern="(d)(rop)"
    fString=jRegexp.replace(fString,"$1ro&#112;")
    jRegexp.pattern="(a)(lter)"
    fString=jRegexp.replace(fString,"$1lt&#101;r")
    jRegexp.pattern="(d)(elete)"
    fString=jRegexp.replace(fString,"$1el&#101;te")
    jRegexp.pattern="(u)(pdate)"
    fString=jRegexp.replace(fString,"$1p&#100;ate")
    jRegexp.pattern="(\s)(or)"
    fString=jRegexp.replace(fString,"$1o&#114;")
    jRegexp.pattern="(java)(script)"
    fString=jRegexp.replace(fString,"$1scri&#112;t")
    jRegexp.pattern="(j)(script)"
    fString=jRegexp.replace(fString,"$1scri&#112;t")
    jRegexp.pattern="(vb)(script)"
    fString=jRegexp.replace(fString,"$1scri&#112;t")
    if instr(fString,"expression")<>0 then
    	fString=replace(fString,"expression","e&#173;xpression",1,-1,0)
    End if
    GetEnCode=fString
    set jRegexp=nothing
End Function

'// <summary>
'// 反转换内容
'// </summary>
Function GetDeCode(ByVal fString)
	if isnull(fString) then
		GetDeCode=""
		Exit function
	End if
	fString=replace(fString,"&amp;","&")
	fString=replace(fString,"&#39;","'")
	fString=replace(fString,"&#34;","""")
	fString=replace(fString,"&lt;","<")
	fString=replace(fString,"&gt;",">")
	fString=replace(fString,chr(10),vbcrlf)
	GetDeCode=fString
End Function

'// <summary>
'// 过滤HTML标签
'// </summary>
Function CutHTML(ByVal fString)
    Set jRegExp=New RegExp
    jRegExp.IgnoreCase=True
    jRegExp.Global=True
    pArray=Array("p","div","span","table","ul","font","b","u","i","h1","h2","h3","h4","h5","h6")
    For i=0 To UBound(pArray)
        t2=0
        t3=0
        jRegExp.Pattern="\<"&pArray(i)&"( [^\<\>]+|)\>"
        Set Matches=jRegExp.Execute(fString)
        For Each Match In Matches
            t2=t2+1
        Next
        jRegExp.Pattern="\</"&pArray(i)&"\>"
        Set Matches=jRegExp.Execute(fString)
        For Each Match In Matches
            t3=t3+1
        Next
        For j=1 To t2-t3
            fString=fString+"</"&pArray(i)&">"
        Next
    Next
    CutHTML=fString
End Function

'// <summary>
'// 切割内容
'// </summary>
Function CutStr(byVal fString, byVal StrLen)
	Dim l,t,c,i
	IF IsNull(fString) Then CutStr="":Exit Function
	l=Len(fString)
	StrLen=Int(StrLen)
	t=0
	For i=1 To l
		c=Asc(Mid(fString,i,1))
		IF c<0 Or c>255 Then t=t+2 Else t=t+1
		IF t>=StrLen Then
			CutStr=Left(fString,i)&"..."
			Exit For
		Else
			CutStr=fString
		End IF
	Next
End Function

'// <summary>
'// 求字符串长度。汉字算两个字符，英文算一个字符。
'// </summary>
function GetLength(fString)
	ON ERROR RESUME NEXT
	dim WINNT_CHINESE
	WINNT_CHINESE    = (len("中国")=2)
	if WINNT_CHINESE Then
        dim l,t,c
        dim i
        l=len(fString)
        t=l
        for i=1 to l
        	c=asc(mID(fString,i,1))
            if c<0 Then c=c+65536
            if c>255 Then
                t=t+1
            End if
        Next
        GetLength=t
    Else 
        GetLength=len(fString)
    End if
    if err.number<>0 Then err.clear
End Function

'// <summary>
'// 格式化时间
'// </summary>
Function GetFormatTime(timeVal, timeFormat)
	dim tempVal
	If IsDate(timeVal) Then
		tempVal = timeVal : tempVal = Lcase(timeFormat)
		tempVal = Replace(tempVal,"yyyy",Year(timeVal)) : tempVal = Replace(tempVal,"yy",Right(Year(timeVal),2))
		tempVal = Replace(tempVal,"mm",Right("0" & Month(timeVal),2)) : tempVal = Replace(tempVal,"m",Month(timeVal))
		tempVal = Replace(tempVal,"dd",Right("0" & Day(timeVal),2)) : tempVal = Replace(tempVal,"d",Day(timeVal))
		tempVal = Replace(tempVal,"hh",Right("0" & Hour(timeVal),2)) : tempVal = Replace(tempVal,"h",Hour(timeVal))
		tempVal = Replace(tempVal,"nn",Right("0" & Minute(timeVal),2)) : tempVal = Replace(tempVal,"n",Minute(timeVal))
		tempVal = Replace(tempVal,"ss",Right("0" & Second(timeVal),2)) : tempVal = Replace(tempVal,"s",Second(timeVal))
	Else
		tempVal = timeVal
	End If
	GetFormatTime  =  tempVal
End Function

'****************************************************
'函数名：SendMail
'参  数：MailtoAddress  ----收信人地址
'			Subject       -----主题
'			MailBody      -----信件内容
'****************************************************
Function SendMail(byval MailtoAddress,byval Subject,byval MailBody)
	SendMail = false
	if MailtoAddress = "" then Exit Function
	err.clear
	on error resume next
	select case defMialMode
		case "":Exit Function
		case "jmail"
			dim jmail
			set jmail = server.createobject("jmail.message")
			jmail.charset = "utf-8"
			jmail.contenttype = "text/html"
			jmail.addrecipient MailtoAddress
			jmail.subject = Subject
			jmail.body = MailBody
			jmail.from = defMailUserName
			jmail.mailserverusername = defMailUserName
			jmail.mailserverpassword = defMailPassWord
			jmail.send defMailServer
			set jmail = nothing
			if err then
				response.write "组件：jmail，函数：sendmail<br>详情："&err.description
				err.clear
				Exit Function
			Else
				SendMail = true
			End if
		case "cdosys"
			dim objmail,objconfig
			set objmail = server.createobject("cdo.message") 
			set objconfig = server.createobject("cdo.configuration") 
			objconfig.fields("http://schemas.microsoft.com/cdo/configuration/smtpserverport") = 25 
			objconfig.fields("http://schemas.microsoft.com/cdo/configuration/sendusing") = 2 
			objconfig.fields("http://schemas.microsoft.com/cdo/configuration/smtpserver") = defMailServer
			objconfig.fields("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate") = 1 
			objconfig.fields("http://schemas.microsoft.com/cdo/configuration/sendusername") = defMailUserName
			objconfig.fields("http://schemas.microsoft.com/cdo/configuration/sendpassword") = defMailPassWord
			objconfig.fields("http://schemas.microsoft.com/cdo/configuration/languagecode") = "0x0804" 
			objconfig.fields.update() 
			set objmail.configuration = objconfig
			objmail.subject = Subject
			objmail.from = defMailUserName
			objmail.to = MailtoAddress
			objmail.htmlbody = MailBody
			objmail.send 
			set objmail = nothing
			set objconfig = nothing
			if err then 
				response.write "组件：cdosys，函数：sendmail<br>详情："&err.description
				err.clear
				Exit Function
			Else
				SendMail = true
			End if
	End select
End Function

'// <summary>
'// 图片水印
'// </summary>
Function Jpeg_Canvas(ByVal pFormerlyFile)
	IF Not IsObjInstalled("Persits.Jpeg") Then Exit Function
	IF GeIsPicture(pFormerlyFile)=0 Then Exit Function
	Dim aspJpeg
	Set aspJpeg=Server.CreateObject("Persits.Jpeg")
	IF aspJpeg.Expires<Now Then Exit Function
	aspJpeg.Open Trim(Server.MapPath(pFormerlyFile))
	IF aspJpeg.OriginalWidth>defJpegCoordinate(0)*2 Then
		IF defJpegStyle Then
			IF Len(defJpegPrintText)>0 And Len(defJpegColor)>0 Then
				Dim LogoWidth,LogoHeight,iLeft,iTop
				LogoWidth=(defJpegSize+1)*GetLength(defJpegPrintText)/2
				LogoHeight=defJpegSize+1

				iLeft=GetPosition_X(aspJpeg.OriginalWidth, LogoWidth, defJpegCoordinate(0))
				iTop=GetPosition_Y(aspJpeg.OriginalHeight, LogoHeight, defJpegCoordinate(1))
				
				aspJpeg.Canvas.Font.COLOR=defJpegColor         ' 文字的颜色
				aspJpeg.Canvas.Font.Family=defJpegFamily         ' 文字的字体
				aspJpeg.Canvas.Font.Size=defJpegSize          ' 文字的大小
				aspJpeg.Canvas.Font.Bold=defJpegBold              ' 文字是否粗体
				aspJpeg.Canvas.Font.Quality=4                              ' Antialiased
				aspJpeg.Canvas.PrintText iLeft,iTop,defJpegPrintText         ' 加入文字及坐标位置
				aspJpeg.Canvas.Pen.COLOR=&H0               ' 边框的颜色
				aspJpeg.Canvas.Pen.Width=1                 ' 边框的粗细
				aspJpeg.Canvas.Brush.Solid=False           ' 图片边框内是否填充颜色
				aspJpeg.Quality=defJpegQuality
				aspJpeg.Save Trim(Server.MapPath(pFormerlyFile))     ' 生成文件
			End IF
		Else
			Dim Fso
			Set Fso=CreateObject("Scrip"&"ting."&"File"&"System"&"Object")
			IF Not Fso.FileExists(Server.MapPath(defJpegImage)) Then
				Exit Function
			End IF
			Set Fso=Nothing
			Dim subAspJpeg
			Set subAspJpeg=Server.CreateObject("Persits.Jpeg")
			subAspJpeg.Open Server.MapPath(defJpegImage)  '打开水印图片

			iLeft=GetPosition_X(aspJpeg.OriginalWidth,subAspJpeg.Width,defJpegCoordinate(0))
			iTop=GetPosition_Y(aspJpeg.OriginalHeight,subAspJpeg.Height,defJpegCoordinate(1))
			
			IF defJpegBackground="" Then
				aspJpeg.DrawImage iLeft,iTop,subAspJpeg,defJpegLucency,100
			Else
				aspJpeg.DrawImage iLeft,iTop,subAspJpeg,defJpegLucency,defJpegBackground,100
			End IF
			aspJpeg.Quality=defJpegQuality
			aspJpeg.Save pFormerlyFile
			Set subAspJpeg=Nothing	
		End IF
	End IF
	Set aspJpeg= Nothing
End Function

'// <summary>
'// 生成缩略图
'// </summary>
Function Jpeg_Thumbnail(ByVal pFormerlyFile,ByVal pNewFile,ByVal pWidth,ByVal pHeight)
	If pNewFile="" Then
		pFileName = left(pFormerlyFile,instr(pFormerlyFile,".")-1)
		pFileExtended = mid(pFormerlyFile,InstrRev(pFormerlyFile,".")+1)
		pNewFile = pFileName & "_" & pWidth & "_" & pHeight & "." & pFileExtended
	End if
	If pWidth = "" Then pWidth = defJpegThumbwidth
	If pHeight = "" Then pHeight = defJpegThumbHeight
	IF Not IsObjInstalled("Persits.Jpeg") Then Exit Function
	IF GeIsPicture(pFormerlyFile)=0 Then Exit Function
	Dim aspJpeg,subAspJpeg,Proportional_Height,Proportional_Width
	Set aspJpeg=Server.CreateObject("Persits.Jpeg")
	Set subAspJpeg=Server.CreateObject("Persits.Jpeg")
	IF aspJpeg.Expires<Now Then Exit Function
	aspJpeg.Open Trim(Server.MapPath(pFormerlyFile))
	subAspJpeg.Open Trim(Server.MapPath(pFormerlyFile))
	Proportional_Width=pWidth/aspJpeg.OriginalWidth
	Proportional_Height=pHeight/aspJpeg.OriginalHeight
	IF pWidth>0 Then
		IF pHeight>0 Then
			Select Case defJpegMeans
			Case "0"'常规算法：宽度和高度都大于0时，直接缩小成指定大小，其中一个为0时，按比例缩小
				IF Proportional_Width<1 Or Proportional_Height<1 Then
					aspJpeg.Width=pWidth
					aspJpeg.Height=pHeight
					aspJpeg.Quality=defJpegQuality
					aspJpeg.save Trim(Server.MapPath(pNewFile))
				End IF
			Case "1"'裁剪法：宽度和高度都大于0时，先按最佳比例缩小再裁剪成指定大小，其中一个为0时，按比例缩小
				IF Proportional_Width<1 Or Proportional_Height<1 Then
					If Proportional_Width<Proportional_Height Then
						aspJpeg.Height=pHeight
						aspJpeg.Width=Round(aspJpeg.OriginalWidth * Proportional_Height)   '按缩小成大比例者
					Else
						aspJpeg.Width=pWidth
						aspJpeg.Height=Round(aspJpeg.OriginalHeight * Proportional_Width)
					End IF
					aspJpeg.Crop 0, 0, pWidth, pHeight
					aspJpeg.Quality=defJpegQuality
					aspJpeg.Save Trim(Server.MapPath(pNewFile))
				End IF
			Case "2"'补充法：在指定大小的背景图上附加上按最佳比例缩小的图片
				'创建一个指定大小的背景图
				subAspJpeg.Width=pWidth
				subAspJpeg.Height=pHeight
				subAspJpeg.Canvas.Brush.Solid=True	' 图片边框内是否填充颜色
				subAspJpeg.Canvas.Brush.COLOR="&HFFFFFF"  '设定背景颜色
				subAspJpeg.Canvas.Bar -1, -1, subAspJpeg.Width+1, subAspJpeg.Height+1 '填充

				'按最佳比例缩小图片
				IF Proportional_Width>Proportional_Height Then
					IF Proportional_Height<1 Then
						aspJpeg.Height=pHeight
						aspJpeg.Width=Round(aspJpeg.OriginalWidth*Proportional_Height)   '按缩小成小比例者
					End IF
				Else
					IF Proportional_Width<1 Then
						aspJpeg.Width=pWidth
						aspJpeg.Height=Round(aspJpeg.OriginalHeight*Proportional_Width)
					End IF
				End IF

				'得到缩略图的坐标
				iLeft=(subAspJpeg.Width-aspJpeg.Width)/2
				iTop=(subAspJpeg.Height-aspJpeg.Height)/2
				subAspJpeg.DrawImage iLeft,iTop,aspJpeg   '将缩略图附加到背景上
				subAspJpeg.Quality=defJpegQuality
				subAspJpeg.Save Trim(Server.MapPath(pNewFile))
			End Select

		Else
			IF Proportional_Width<1 Then
				aspJpeg.Width=pWidth
				aspJpeg.Height=Round(aspJpeg.OriginalHeight*Proportional_Width)
				aspJpeg.Quality=defJpegQuality
				aspJpeg.Save Trim(Server.MapPath(pNewFile))
			End IF
		End If

	Else
		IF pHeight>0 And Proportional_Height<1 Then
			aspJpeg.Height=pHeight
			aspJpeg.Width=Round(aspJpeg.OriginalWidth*Proportional_Height)
			aspJpeg.Quality=defJpegQuality
			aspJpeg.Save Trim(Server.MapPath(pNewFile))
		End IF
	End If
	Set aspJpeg=Nothing
	Set subAspJpeg=Nothing
	if Err Then
		Jpeg_Thumbnail = pFormerlyFile
	Else
		Jpeg_Thumbnail = pNewFile
	End if
End Function

Function GetPosition_X(ByVal pOriginalWidth,ByVal psubWidth,ByVal pCoordinate)
    Select Case defJpegCoordinateStart
		Case 0:GetPosition_X=pCoordinate'左上
		Case 1:GetPosition_X=pCoordinate'左下
		Case 2:GetPosition_X=(pOriginalWidth-psubWidth)/2'居中
		Case 3:GetPosition_X=pOriginalWidth-psubWidth-pCoordinate'右上
		Case 4:GetPosition_X=pOriginalWidth-psubWidth-pCoordinate'右下
		Case Else:GetPosition_X=0'不显示
	End Select
End Function

Function GetPosition_Y(ByVal pOriginalHeight,ByVal psubHeight,ByVal pCoordinate)
    Select Case defJpegCoordinateStart
		Case 0:GetPosition_Y=pCoordinate'左上
		Case 1:GetPosition_Y=pOriginalHeight-psubHeight-pCoordinate'左下
		Case 2:GetPosition_Y=(pOriginalHeight-psubHeight)/2'居中
		Case 3:GetPosition_Y=pCoordinate'右上
		Case 4:GetPosition_Y=pOriginalHeight-psubHeight-pCoordinate'右下
		Case Else:GetPosition_Y=0'不显示
    End Select
End Function

'// <summary>
'// 验证是否图片
'// </summary>
Function GeIsPicture(str)
	Select Case GetFileExtended(Lcase(str))
		Case "jpg","gif","jpeg","bmp","png":GeIsPicture=1
		Case Else:GeIsPicture=0
   End Select
End Function

'// <summary>
'// 获得文件扩展名
'// </summary>
Function GetFileExtended(fString)
	GetFileExtended = mid(fString,InstrRev(fString,".")+1)
End Function

'// <summary>
'// 判断目录是否存在
'// </summary>
Function GetIsFolder(fString)
	dim fso
	set fso = CreateObject("Scripting.File"&"System"&"Object")
	If fso.FolderExists(Server.MapPath(fString)) Then
		GetIsFolder = True
	Else
		GetIsFolder = False
	End if
	set fso = nothing
End Function

'// <summary>
'// 创建目录
'// </summary>
Function GetCreateFolder(Byval fString)
	On Error Resume Next 
	dim astrPath, ulngPath, i, strTmpPath , strPath
	dim fso
	strPath = Server.MapPath(fString)
	If InStr(strPath, "\") <=0 or InStr(strPath, ":") <= 0 Then 
		CreateFolder = False 
		Exit Function 
	End if
	set fso = Server.CreateObject("Scripting.File"&"System"&"Object") 
	If fso.FolderExists(strPath) Then 
		CreateFolder = True 
		Exit Function 
	End if 
	astrPath = Split(strPath, "\") 
	ulngPath = UBound(astrPath) 
	strTmpPath = "" 
	For i = 0 To ulngPath 
		strTmpPath = strTmpPath & astrPath(i) & "\" 
		If Not fso.FolderExists(strTmpPath) Then 
			'创建 
			fso.CreateFolder(strTmpPath) 
		End if 
	Next 
	set fso = Nothing 
	If Err = 0 Then 
		CreateFolder = True 
	Else 
		Err.Clear
		CreateFolder = False 
	End if 
End Function  

'// <summary>
'// 测试某一文件是否存在
'// </summary>
Public Function GetIsFile(ByVal fString)
	GetIsFile=False
	set fso = CreateObject("Scripting.File"&"System"&"Object")
	If fso.FileExists(Server.MapPath(fString)) Then
		GetIsFile=True
	End if
	set fso = Nothing
End Function

'// <summary>
'// 文件复制
'// </summary>
Function GetCopyFile(SourceFile,DestinationFile)
	set fso = CreateObject("Scripting.File"&"System"&"Object")
	If GetIsFile(SourceFile) = True Then
		set f = fso.GetFile(Server.MapPath(SourceFile))
		f.Copy (Server.MapPath(DestinationFile))
		GetCopyFile = 1
	Else
		GetCopyFile = -1
	End if
	set fso = Nothing
End Function

'// <summary>
'// 删除文件或文件夹
'// </summary>
Function GetFileDel(fString,pType)
	On Error Resume Next
	set fso = Server.CreateObject("Scripting.File"&"System"&"Object")
	if pType=0 Then
		if not fso.fileExists(Server.MapPath(fString)) Then exit function 'IF文件不存在，退出
		fso.deletefile(Server.MapPath(fString))
	Else
		if not fso.folderExists(Server.MapPath(fString)) Then exit function 'IF文件不存在，退出
		fso.deletefolder(Server.MapPath(fString))
	End if
	set fso = Nothing
End Function

'// <summary>
'// 移动文件或文件夹
'// </summary>
Function GetFileMove(SourceFile,DestinationFile,pType) 
	SourceFile = Server.MapPath(SourceFile) 
	DestinationFile = Server.MapPath(DestinationFile) 
	Set fso = CreateObject("Scripting.FileSystemObject")
	if pType=0 Then
		if Not fso.fileExists(SourceFile) Then exit function 'IF文件不存在，退出
		fso.MoveFile SourceFile,DestinationFile
	Else
		if Not fso.folderExists(SourceFile) Then Exit function 'IF文件夹不存在，退出
		fso.MoveFolder SourceFile,DestinationFile
	End if
	Set fso = Nothing 
End Function

'// <summary>
'// 取得文件的大小
'// </summary>
Function GetFileSize(fString)
	set fso = CreateObject("Scripting.File"&"System"&"Object")
	If GetIsFile(fString) = True Then
		set f = fso.Getfile(Server.MapPath(fString))
		GetFileSize = f.Size
	Else
		GetFileSize = 0
	End if
	set fso = Nothing
End Function 

'// <summary>
'// 格式化文件大小
'// </summary>
Function GetFormatFileSize(FileSize)
	If FileSize<1024 then GetFormatFileSize = FileSize & " Byte"
		If FileSize/1024 <1024 And FileSize/1024 > 1 then 
			FileSize = FileSize/1024
            GetFormatFileSize=round(FileSize*100)/100 & " KB"
        Elseif FileSize/(1024*1024) > 1 Then
            FileSize = FileSize/(1024*1024)
            GetFormatFileSize = round(FileSize*100)/100 & " MB"
	End If
End function

'// <summary>
'// 读取文件内容
'// </summary>
Function GetOpenFile(ByVal fileUrl)
    dim oStream
    On Error Resume Next
    set oStream = Server.CreateObject("adodb.stream")
    With oStream
        .Type = 2
        .Mode = 3
        .Open
        .Charset = "utf-8"
        .Position = 0
        .LoadFromFile Server.MapPath(fileUrl)
        If Err.Number<>0 Then
			Err.Clear
			set oStream = Noting
			Exit Function
        End if
        GetOpenFile = .ReadText
        .Close
    End With
    set oStream = Nothing
End Function

'// <summary>
'// 写入文件内容
'// </summary>
function GetCreateFile(ByVal fileUrl, ByVal oContent)
	On Error Resume Next
	fileUrl = replace(fileUrl, "\", "/") : fileUrl = replace(fileUrl, "//", "/")
	If Right(fileUrl, 1) = "/" Then GetCreateFile = False: Exit Function
		Call GetCreateFolder(Left(fileUrl, InStrRev(fileUrl,"/")))	'自动创建文件夹
	If InStr(fileUrl, ":") = 0 Then fileUrl = Server.MapPath(fileUrl)
	dim oStream
	set oStream = CreateObject("adodb.stream")
	oStream.Type = 2 '设置为可读可写
	oStream.Mode = 3 '设置内容为文本
	oStream.Charset = "utf-8"
	oStream.Open
	oStream.WriteText oContent
	oStream.SaveToFile fileUrl, 2
	oStream.Close
	set oStream = Nothing
	If Err.Number <> 0 Then Err.Clear
End Function

'// <summary>
'// 生成文件名
'// </summary>
function GetFileName() 
	dim rannum 
	dim dtnow 
	dtnow=now() 
	randomize 
	rannum=int(90*rnd)+10 
	GetFileName=year(dtnow) &"_"& right("0" & month(dtnow),2) &"_"& right("0" & day(dtnow),2) &"_"& right("0" & hour(dtnow),2) & right("0" & minute(dtnow),2) & right("0" & second(dtnow),2) & rannum 
End Function

'// <summary>
'// 过滤目录名称或文件名
'// </summary>
function GetLeachFolder(fString,pText)
	if isnull(fString) or trim(fString)="" Then
		GetLeachFolder=""
		exit function
	End if
	if pText=0 Then
		fString = replace(fString, Chr("46"), Chr("95"))
		fString = replace(fString, Chr("37"), Chr("95"))
    Else
		fString = replace(fString, Chr("46")&Chr("46"), Chr("95"))
		fString = replace(fString, Chr("47")&Chr("47"), Chr("95"))
	End if
    GetLeachFolder = fString
End function

'// <summary>
'// 显示错误提示信息
'// </summary>
sub ErrMsg(Message)
	dim strErr
	strErr=strErr & "<!DOCTYPE html PUBLIC ""-//W3C//DTD XHTML 1.0 Strict//EN"" ""http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"">" & vbCrlf
	strErr=strErr & "<html xmlns=""http://www.w3.org/1999/xhtml"">" & vbCrlf
	strErr=strErr & "<head>" & vbcrlf
	strErr=strErr & "<title>提示信息</title>" & vbcrlf
	strErr=strErr & "<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>" & vbcrlf
	strErr=strErr & "<style type='text/css'>" & vbcrlf
	strErr=strErr & "<!--" & vbcrlf
	strErr=strErr & "html, body, div, h1, h2, h3, h4, h5, h6, ul, ol, dl, li, dt, dd, p, blockquote, pre, form, fieldset, th, span{padding:0;margin:0;}body{font-size: 12px; font-family: Arial, ""SimSun"";background-color:#ffffff;}*html{background-image:url(about:blank);background-attachment:fixed;}a{text-decoration:none; color:#666666;outline:none;}a:active{star:expression(this.onfocus=this.blur());}a:hover{cursor:pointer; color:#515151}.message-wrap{width:50%;margin:20px auto;border:#dfdfdf 1px solid;overflow:hidden; padding:0;}.message-wrap h1{margin:0 0 5px 0;padding:0 0 5px 0; color:#000; font-size:12px; font-weight:lighter;padding:5px;background-color: #e8f3fd;border-bottom:#e8ebef 1px solid;}.message-wrap p{margin:5px;list-style:disc;}.message-wrap span{float:left;padding-top: 5px;}" & vbcrlf
	strErr=strErr & "-->" & vbcrlf
	strErr=strErr & "</style>" & vbcrlf
	strErr=strErr & "</head>" & vbcrlf
	strErr=strErr & "<body>" & vbcrlf
	strErr=strErr & "<div class=""message-wrap"">" & vbcrlf
	strErr=strErr & "<h1>提示信息</h1>" & vbcrlf
	strErr=strErr & "<p>" & Message &"" & vbcrlf
	strErr=strErr & "<span><a href=""javascript:history.back(1)"">点击这里返回</a></span>" & vbcrlf
	strErr=strErr & "</p>" & vbcrlf
	strErr=strErr & "</div>" & vbcrlf
	strErr=strErr & "</body>" & vbcrlf
	strErr=strErr & "</html>" & vbcrlf
	response.write strErr
End sub

'// <summary>
'// 显示成功提示信息
'// </summary>
sub performMsg(Perform, BackUrl)
    dim strPerform
	strPerform=strPerform & "<!DOCTYPE html PUBLIC ""-//W3C//DTD XHTML 1.0 Strict//EN"" ""http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"">" & vbCrlf
	strPerform=strPerform & "<html xmlns=""http://www.w3.org/1999/xhtml"">" & vbCrlf
	strPerform=strPerform & "<head>" & vbcrlf
	strPerform=strPerform & "<title>提示信息</title>" & vbcrlf
	strPerform=strPerform & "<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>" & vbcrlf
	strPerform=strPerform & "<style type='text/css'>" & vbcrlf
	strPerform=strPerform & "<!--" & vbcrlf
	strPerform=strPerform & "html, body, div, h1, h2, h3, h4, h5, h6, ul, ol, dl, li, dt, dd, p, blockquote, pre, form, fieldset, th, span{padding:0;margin:0;}body{font-size: 12px; font-family: Arial, ""SimSun"";background-color:#ffffff;}*html{background-image:url(about:blank);background-attachment:fixed;}a{text-decoration:none; color:#666666;outline:none;}a:active{star:expression(this.onfocus=this.blur());}a:hover{cursor:pointer; color:#515151}.message-wrap{width:50%;margin:20px auto;border:#dfdfdf 1px solid;overflow:hidden; padding:0;}.message-wrap h1{margin:0 0 5px 0;padding:0 0 5px 0; color:#000; font-size:12px; font-weight:lighter;padding:5px;background-color: #e8f3fd;border-bottom:#e8ebef 1px solid;}.message-wrap p{margin:5px;list-style:disc;}.message-wrap span{float:left;padding-top: 5px;}" & vbcrlf
	strPerform=strPerform & "-->" & vbcrlf
	strPerform=strPerform & "</style>" & vbcrlf
	strPerform=strPerform & "</head>" & vbcrlf
	strPerform=strPerform & "<body>" & vbcrlf
	strPerform=strPerform & "<div class=""message-wrap"">" & vbcrlf
	strPerform=strPerform & "<h1>提示信息</h1>" & vbcrlf
	strPerform=strPerform & "<p>" & Perform &"" & vbcrlf
    If BackUrl <> "" Then
		If BackUrl = "null" Then
			strPerform = strPerform & ""
		Else
			strPerform = strPerform & "<span><a href='" & BackUrl & "'>点击这里返回</a></span>"
		End if
    Else
		strPerform = strPerform & "<span><a href='" & Trim(Request.ServerVariables("HTTP_REFERER")) & "'>点击这里返回</a></span>"
    End if
	strPerform=strPerform & "</p>" & vbcrlf
	strPerform=strPerform & "</div>" & vbcrlf
	strPerform=strPerform & "</body>" & vbcrlf
	strPerform=strPerform & "</html>" & vbcrlf
	response.write strPerform
End Sub

'// <summary>
'// Textarea输入框
'// </summary>
Function GetTextarea(strForm,strDefine, strWidth, strHeight, strValue)
	strHTML=""
	strHTML = "<textarea name="""& strDefine &""" id="""& strDefine &""" rows="""& strHeight &""" style=""width:"& strWidth & "%"">"& strValue &"</textarea>"
	strHTML = strHTML & "<span onclick=""javascript:document."& strForm & "."& strDefine & ".rows+= " & strHeight & ";"" title=""点击向下拉长"" style=""cursor:hand"">"
	strHTML = strHTML & "<img src="""& defInstalldir &"global/images/length.gif"" border=""0""></span>"
	strHTML = strHTML & "<span onclick=""javascript:if(document."& strForm & "."& strDefine & ".rows != "& strHeight & "){document."& strForm & "."& strDefine & ".rows-="& strHeight &";}else{document."& strForm & "."& strDefine & ".rows="& strHeight &";}"" title=""点击向上缩短"" style=""cursor:hand"">"
	strHTML = strHTML & "<img src="""& defInstalldir &"global/images/short.gif"" border=""0""></span>"
	GetTextarea=strHTML
End Function

'// <summary>
'// 通用的实现<select>内容的函数
'// Commonselect("sex","男,女","男,女","男")
'// </summary>
Function CommonSelect(idname,liststr,valuestr,selectstr)
	dim arrlist
	dim arrvalue
	dim markstr
	arrlist=split(liststr,",")
	IF len(trim(valuestr))=0 Then valuestr=liststr
	IF selectstr="" Then selectstr=arrlist(0)
	arrvalue=split(valuestr,",")
	IF Ubound(arrlist)<>Ubound(arrvalue) Then
		Exit Function
	End if
	strHTML="<select name=""" & idname & """ id=""" & idname & """>"
	For i=0 to Ubound(arrlist)
	    IF Cstr(arrvalue(i)) = Cstr(selectstr) Then
	       markstr="selected"
	    Else   
	       markstr=""
	    End if
	    strHTML = strHTML & "<option value='" & arrvalue(i) &"' "&markstr&">" &  arrlist(i) & "</option>"
	Next
	CommonSelect = strHTML & "</select>"
End Function

'// <summary>
'// 通用单选框
'// CommonRadio("sex","男,女","男,女","男")
'// </summary>
Function CommonRadio(idname,liststr,valuestr,checkstr)
	dim arrlist
	dim arrvalue
	dim markstr
	arrlist=split(liststr,",")
	IF len(trim(valuestr))=0 Then valuestr=liststr
	IF selectstr="" Then selectstr=arrlist(0)
	arrvalue=split(valuestr,",")
	IF Ubound(arrlist)<>Ubound(arrvalue) Then
		Exit Function
	End IF
	marked=false
	For i=0 to Ubound(arrlist)
	    if checkstr=""  and Not marked Then
		     markstr=" checked "
		     marked=true
		  Else
		    IF Cstr(arrvalue(i)) = Cstr(checkstr)  Then
		       markstr="checked "
		    Else   
		       markstr=""
		    End IF
		 End if
	    strHTML= strHTML & "<input type=radio name='" & idname & "' id='" & idname & "' value='" & arrvalue(i) &"' "&markstr&">" & arrlist(i) & "&nbsp;"
	Next
	CommonRadio = strHTML
End Function

'// <summary>
'// 自动识别文件
'// </summary>
Function SelPlay(strUrl,strWidth,StrHeight)
	If strUrl <> "" Then
	   isExt = LCase(Mid(strUrl,InStrRev(strUrl, ".")+1))
	Else
	   isExt = ""
	End if
	If strWidth="" Then strWidth=640
	If StrHeight="" Then StrHeight=480
	Select Case isExt
		Case "avi","wmv","asf","mov","mpg","mpeg"
			strHTML=strHTML & "<div align=""center""><EMBED id=MediaPlayer src="&strUrl&" width="&strWidth&" height="&strHeight&" loop=""false"" autostart=""true""></EMBED></div>"
		Case "mov","rm","ra","ram"
			strHTML=strHTML & "<div align=""center""><OBJECT height="&strHeight&" width="&strWidth&" classid=clsid:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA>"
			strHTML=strHTML & "<PARAM NAME=""_ExtentX"" VALUE=""12700"">"
			strHTML=strHTML & "<PARAM NAME=""_ExtentY"" VALUE=""9525"">"
			strHTML=strHTML & "<PARAM NAME=""AUTOSTART"" VALUE=""-1"">"
			strHTML=strHTML & "<PARAM NAME=""SHUFFLE"" VALUE=""0"">"
			strHTML=strHTML & "<PARAM NAME=""PREFETCH"" VALUE=""0"">"
			strHTML=strHTML & "<PARAM NAME=""NOLABELS"" VALUE=""0"">"
			strHTML=strHTML & "<PARAM NAME=""SRC"" VALUE="""&strUrl&""">"
			strHTML=strHTML & "<PARAM NAME=""CONTROLS"" VALUE=""ImageWindow"">"
			strHTML=strHTML & "<PARAM NAME=""CONSOLE"" VALUE=""Clip"">"
			strHTML=strHTML & "<PARAM NAME=""LOOP"" VALUE=""0"">"
			strHTML=strHTML & "<PARAM NAME=""NUMLOOP"" VALUE=""0"">"
			strHTML=strHTML & "<PARAM NAME=""CENTER"" VALUE=""0"">"
			strHTML=strHTML & "<PARAM NAME=""MAINTAINASPECT"" VALUE=""0"">"
			strHTML=strHTML & "<PARAM NAME=""BACKGROUNDCOLOR"" VALUE=""#000000"">"
			strHTML=strHTML & "</OBJECT>"
			strHTML=strHTML & "<BR>"
			strHTML=strHTML & "<OBJECT height=32 width="&strWidth&" classid=clsid:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA>"
			strHTML=strHTML & "<PARAM NAME=""_ExtentX"" VALUE=""12700"">"
			strHTML=strHTML & "<PARAM NAME=""_ExtentY"" VALUE=""847"">"
			strHTML=strHTML & "<PARAM NAME=""AUTOSTART"" VALUE=""0"">"
			strHTML=strHTML & "<PARAM NAME=""SHUFFLE"" VALUE=""0"">"
			strHTML=strHTML & "<PARAM NAME=""PREFETCH"" VALUE=""0"">"
			strHTML=strHTML & "<PARAM NAME=""NOLABELS"" VALUE=""0"">"
			strHTML=strHTML & "<PARAM NAME=""CONTROLS"" VALUE=""ControlPanel,StatusBar"">"
			strHTML=strHTML & "<PARAM NAME=""CONSOLE"" VALUE=""Clip"">"
			strHTML=strHTML & "<PARAM NAME=""LOOP"" VALUE=""0"">"
			strHTML=strHTML & "<PARAM NAME=""NUMLOOP"" VALUE=""0"">"
			strHTML=strHTML & "<PARAM NAME=""CENTER"" VALUE=""0"">"
			strHTML=strHTML & "<PARAM NAME=""MAINTAINASPECT"" VALUE=""0"">"
			strHTML=strHTML & "<PARAM NAME=""BACKGROUNDCOLOR"" VALUE=""#000000"">"
			strHTML=strHTML & "</OBJECT></div>"
		Case "flv"
			strHTML=strHTML & "<div id=""player"" style=""margin: 5px;margin:0px auto;text-align:center !important;""><a href=""http://www.macromedia.com/go/getflashplayer"">Get Flash</a> to see this player.</div>" & vbCrlf
			strHTML=strHTML & "<script type=""text/javascript"">" & vbCrlf
			strHTML=strHTML & "var so = new SWFObject('"&defInstalldir&"global/images/player.swf','player','"&strWIDth&"','"&strHeight&"','7');" & vbCrlf
			strHTML=strHTML & "so.addParam(""allowfullscreen"",""true"");" & vbCrlf
			strHTML=strHTML & "so.addVariable(""file"","""&strUrl&""");" & vbCrlf
			strHTML=strHTML & "so.write('player');" & vbCrlf
			strHTML=strHTML & "</script>" & vbCrlf
		Case "mp3"
			strHTML=strHTML & "<object type=""application/x-shockwave-flash"" data="""&defInstalldir&"global/images/audioplayer.swf"" width=""290"" height=""25"" id=""audioplayer"">" & vbCrlf
			strHTML=strHTML & "<param name=""movie"" value="""&defInstalldir&"global/images/audioplayer.swf"" />" & vbCrlf
			strHTML=strHTML & "<param name=""flashvars"" value=""playerId="&md5(strUrl,2)&"&soundfile="&strUrl&""" />" & vbCrlf
			strHTML=strHTML & "<param name=""quality"" value=""high"" />" & vbCrlf
			strHTML=strHTML & "<param name=""menu"" value=""false"" />" & vbCrlf
			strHTML=strHTML & "<param name=""wmode"" value=""transparent"" />" & vbCrlf
			strHTML=strHTML & "</object>" & vbCrlf
		Case "rar","zip","pdf","ppt"
			strHTML=strHTML & ""&strUrl&""
	End Select
	SelPlay=strHTML
End Function

'// <summary>
'// 过滤字符
'// </summary>
Function GetLeachCharacter(Byval fString)
	GetLeachCharacter = LCase(fString) : GetLeachCharacter = Replace(GetLeachCharacter," ","") : GetLeachCharacter = Replace(GetLeachCharacter,"'","") : GetLeachCharacter = Replace(GetLeachCharacter,"""","") : GetLeachCharacter = Replace(GetLeachCharacter,"=","") : GetLeachCharacter = Replace(GetLeachCharacter,"*","")
End Function

'// <summary>
'// 正表达式替换,支持向后引用
'// </summary>
Function Replacex(byval html,byval patterns,byval replaceval)
	dim jRegExp : set jRegExp = new RegExp : jRegExp.ignorecase = true : jRegExp.global = true
	jRegExp.pattern = patterns
	dim newval : newval = replaceval
	replacex = jRegExp.replace(html, newval)
End Function

'// <summary>
'// 清除缓存
'// </summary>
function ClearCache()
	subClearCache:subClearCache
end function

function subClearCache()
	dim cacheobj
	application.lock
	For each cacheobj in application.contents
		if cstr(left(cacheobj, len(defCacheName))) = cstr(defCacheName) then application.contents.Remove (cacheobj)
	Next
	application.unlock
end function

'// <summary>
'// 设置缓存
'// </summary>
function SetCache(byval cachename,byval cachevalue)
	dim cachedata
	cachename = lcase(GetLeachCharacter(cachename))
	cachedata = application(defCacheName & cachename)
	if isarray(cachedata) then
		cachedata(0) = Cachevalue
		cachedata(1) = now()
	Else
		Redim cachedata(2)
		cachedata(0) = Cachevalue
		cachedata(1) = now()
	End if
	application.lock
	application(defCacheName & cachename) = cachedata
	application.unlock
end function

'// <summary>
'// 获取缓存
'// </summary>
function GetCache(byval cachename)
	dim cachedata
	cachename = lcase(GetLeachCharacter(cachename))
	cachedata = application(defCacheName & cachename)
	if isarray(cachedata) then GetCache = cachedata(0) Else GetCache = ""
end function

'// <summary>
'// 检测缓存
'// </summary>
function ChkCache(byval cachename)
	dim cachedata
	ChkCache = false
	cachename = lcase(GetLeachCharacter(cachename))
	cachedata = application(defCacheName & cachename)
	if not isarray(cachedata) then exit function
	if not IsDate(cachedata(1)) then exit function
	if DateDiff("s", CDate(cachedata(1)), now()) < 60 * defCacheTime then ChkCache = true
end function

'// <summary>
'// 取得当前Id所在树的路径
'// </summary>
Function GetCatalogPath(table,Id,Url)
	Counter=0
	StopRun=false
    If Instr(Url,"?")=0 Then
        Url=Url&"?"
    Else
        If Right(Url,1)<>"?" Then
            Url=Url&"&"
        End if
    End if
    do
        SQL="select * From "&table&" where catalogId="&Id
        set pRS=Conn.ExeCute(SQL)
        If Not(pRS.Eof and pRS.Bof) Then
            strHTML=" > <a href='"&Url&"Parent="&pRS("catalogId")&"'>"&pRS("CatalogName")&"</a>"&strHTML
            Id=CInt(pRS("ParentID"))
        Else
            StopRun=true    
        End if
		pRS.Close: set pRS = Nothing
    Loop Until(StopRun Or Id=0)
    strHTML="<a href='"&Url&"Parent=0'>根频道</a>" & strHTML    
    GetCatalogPath=strHTML
End Function

'// <summary>
'// 递归搜当前频道下所有的下级频道
'// </summary>
Function GetCatalog(Table,Parent)
	SQL = "select catalogId From "&Table&" Where ParentId="&Parent
    set pRS=Conn.ExeCute(SQL)
	While Not pRS.Eof
		GetCatalog=GetCatalog&","&pRS("catalogId")
		GetCatalog=GetCatalog&GetCatalog(Table,pRS("catalogId"))
	pRS.MoveNext
	Wend
	pRS.Close: set pRS = Nothing
End Function

'// <summary>
'// 递归搜当前目录下所有的下级目录
'// </summary>
Function GetDirectory(table,Id)
	Counter=0
	StopRun=false
    do
        SQL="select * From "&table&" where catalogId="&Id
        set pRS=Conn.ExeCute(SQL)
        If Not(pRS.Eof and pRS.Bof) Then
			strHTML=""&pRS("FolderName")&""& "/" & strHTML
            Id=CInt(pRS("ParentID"))
        Else
            StopRun=true    
        End if
		pRS.Close: set pRS = Nothing
    Loop Until(StopRun Or Id=0)
    GetDirectory=strHTML
End Function

'// <summary>
'// 取得当前Id所在树的当前位置
'// </summary>
Function GetLocation(table,Id)
	Counter=0
	StopRun=false
    do
        SQL="select * From "&table&" where catalogId="&Id
        set pRS=Conn.ExeCute(SQL)
        If Not(pRS.Eof and pRS.Bof) Then
			strHTML=" > <a href=""" & defInstalldir & "" & GetDirectory("tblCatalog",Id) & "" & pRS("FileName") & """ title=""" & pRS("CatalogName") & """>"&pRS("CatalogName")&"</a>"&strHTML
            Id=CInt(pRS("ParentID"))
        Else
            StopRun=true    
        End if
		pRS.Close: set pRS = Nothing
    Loop Until(StopRun Or Id=0)
    GetLocation=strHTML
End Function

'// <summary>
'// 站内链接
'// </summary>
Function GetLinks(Byval fString)
	strHTML = fString
	set pRS = db("select * From [tblExtend] Order By [id] Desc",1)
	If Not pRS.EOF Then
		deflinks = pRS("deflinks")
		strDefLinks = Split(deflinks, vbCrLf)
		For i = 0 To UBound(strDefLinks)
			txt = strDefLinks(i)
			If txt <> "" Then
				pDefLinks = Split(txt, "|")
				For ii = 0 To UBound(pDefLinks)
					Select Case ii
					Case 0
						deflinksTxt = pDefLinks(ii)
					Case 1
						deflinksUrl = pDefLinks(ii)
					End Select
				Next
				strHTML = Replace(strHTML, deflinksTxt, "<a href=""" & deflinksUrl & """ target=""_blank"" title=""" & deflinksTxt & """>" & deflinksTxt & "</a>")
			End If
		Next
	End If
	pRS.Close
	Set pRS = Nothing
	GetLinks = strHTML
End Function

'// <summary>
'// 粗口过滤
'// </summary>
Function GetPerk(fString)  
	set pRS = db("select * From [tblExtend] Order By [id] Desc",1)
	If Not pRS.EOF Then
		defperk = pRS("defperk")
		If Not(IsNull(defperk) or IsNull(fString)) Then  
			perk = Split(defperk, "|")  
			For i = 0 to UBound(perk)  
				fString = Replace(fString, perk(i), string(Len(perk(i)),"*"))  
			Next  
			GetPerk = fString  
		End If
	End If
	pRS.Close
	Set pRS = Nothing
End Function 

'// <summary>
'// 获得资源指定数据库字段的信息
'// </summary>
Function GetField(FieldName,table,where)
	SQL="Select "&FieldName&" From "&table&" Where "&where
    dim pRs
    Set pRs=Conn.ExeCute(SQL)
    If Not(pRs.Eof and pRs.Bof) Then
        GetField=pRs(FieldName)
    Else
        GetField=Null
    End If
    pRs.Close
    Set pRs=Nothing
End Function

'// <summary>
'// 统计记录数
'// </summary>
Function GetCount(ByVal FieldName,ByVal table,ByVal where)
	SQL="Select Count("&FieldName&") From "&table&" where "&where
    Set pRs=Conn.ExeCute(SQL)
	pCount=pRS(0)
	If pCount>0 Then
		pCount=""&pCount&""
	Else
		pCount=0
	End if
	GetCount=pCount
	pRS.Close
End Function

'// <summary>
'// 分页类
'// </summary>
Class cls_DataList
    dim Id ' 主键,默认为 Id
    dim Field ' 字段,默认为 *
    dim Table ' 数据表,不可为空
    dim Where ' 条件,不用带
    dim Order ' 排序,默认按主键排序
    dim Result ' 返回类型,0则Getrows,1则采指针,默认 0
    dim PageSize ' 每页记录数,默认15
    dim AbsolutePage ' 当前页,默认 1 [第一页]
    
    dim Data ' 返回记录集
    dim Eof ' 是否有记录
    dim RecordCount ' 总记录数
    dim PageCount ' 总页数
    
    Public Function List()
        dim Rs
        If Not IsNumeric(AbsolutePage) Or Len(AbsolutePage) = 0 Then AbsolutePage = 1 Else AbsolutePage = Int(AbsolutePage)
        If AbsolutePage < 1 Then AbsolutePage = 1
        If Len(Id) = 0 Then Id = "[Id]"
        If Len(Field) = 0 Then Field = "*"
        If Len(Where) > 0 Then Where = "Where " & Where
        If Len(Order) > 0 Then Order = "Order By " & Order Else Order = "Order By " & Id & " Desc"
        If Not IsNumeric(PageSize) Or Len(PageSize) = 0 Or PageSize < 1 Then PageSize = 15
        If Not IsNumeric(Result) Or Len(Result) = 0 Or Result = 0 Then Result = 0 Else Result = 1
        PageSize = Int(PageSize)
		Set Rs = db("Select " & Field & " From " & Table & " " & Where & " " & Order, 2)
		Rs.PageSize = PageSize
		If Not Rs.Eof Then Rs.AbsolutePosition = (AbsolutePage - 1) * PageSize + 1
		RecordCount = Rs.RecordCount: PageCount = Rs.PageCount
        If Result = 0 Then
            If Rs.Eof Then
                Eof = True
            Else
                Eof = False
                If RecordCount < PageSize Then Data = Rs.GetRows(RecordCount) Else Data = Rs.GetRows(PageSize)
                Rs.Close: Set Rs = Nothing
            End If
        Else
            If Rs.Eof Then Eof = True Else Eof = False
            Set Data = Rs
        End If
    End Function
End Class

'// <summary>
'// 获取上下篇文章
'// </summary>
Function GetPreNext(catalogId,Id,fString)
	dim pRS,SQL
	SQL = "select top 1 * from [tblPage] where catalogId="&catalogId&" and [State]=0"
	if lcase(fString) = "previous" then SQL = SQL & " and [Id]>" & Id & " order by [Id] asc"
	if lcase(fString) = "next" then SQL = SQL & " and [Id]<" & Id & " order by [Id] desc"
	set pRS = db(SQL,1)
	if pRS.eof then
		GetPreNext = ""
	Else
		GetPreNext = "<a href='"&defInstalldir&GetDirectory("tblCatalog",pRS("catalogId"))&pRS("Id")&pRS("ExtendName")&"' title='" & pRS("title") & "'>" & pRS("title") & "</a>"
	End if
	pRS.close
	set pRS = nothing
End Function

'// <summary>
'// 相册
'// </summary>
Function GetGallery(Byval fString)
	If IsBlank(fString)=False Then
		strHTML=""
		strDefgallery = Split(fString, "$$")
		For i = 0 To UBound(strDefgallery)
			txt = strDefgallery(i)
			If IsBlank(txt)=False Then
				pgallery = Split(txt, "$")
				For ii = 0 To UBound(pgallery)
					Select Case ii
					Case 0
						defgalleryTxt = pgallery(ii)
					Case 1
						defgalleryUrl = pgallery(ii)
					End Select
				Next
				If UBound(strDefgallery) = 0 Then
					IsExclusive = True
					strHTML = strHTML & "<div style=""margin:0px auto;text-align:center !important;""><img src="""&defgalleryUrl&""" alt="""&defgalleryTxt&"""></div>" & vbCrlf
				Else
					If i = 0 Then
						HTML = HTML & "<img src="""&defgalleryUrl&""" alt="""" id=""gallery-middle"" />"
						pHTML = pHTML & "<li><a href=""#"" class='cur' rel="""&defgalleryUrl&"""><img src="""&defgalleryUrl&""" alt="""" /></a></li>"
					Else
						pHTML = pHTML & "<li><a href=""#""  rel="""&defgalleryUrl&"""><img src="""&defgalleryUrl&""" alt="""" /></a></li>"
					End if
				End if
			End if
		Next
		If IsExclusive<>True Then
			strHTML = strHTML & "<div class=""gallery clearfix"">" & vbCrlf
			strHTML = strHTML & "<div class=""gallery-thumb"">" & vbCrlf
			strHTML = strHTML & "<div class=""prev""></div>" & vbCrlf
			strHTML = strHTML & "<div id=""item"">" & vbCrlf
			strHTML = strHTML & "<ul>" & vbCrlf
			strHTML = strHTML & ""&pHTML&"" & vbCrlf
			strHTML = strHTML & "</ul>" & vbCrlf
			strHTML = strHTML & "</div>" & vbCrlf
			strHTML = strHTML & "<div class=""next""></div>" & vbCrlf
			strHTML = strHTML & "</div>" & vbCrlf
			strHTML = strHTML & "<div class=""gallery-big"">" & vbCrlf
			strHTML = strHTML & ""&HTML&"" & vbCrlf
			strHTML = strHTML & "</div>" & vbCrlf
			strHTML = strHTML & "</div>" & vbCrlf
		End if
	End if
	GetGallery = strHTML
End Function

'// <summary>
'// 附件
'// </summary>
Function Getaffix(Byval fString)
	If IsBlank(fString)=False Then
		strHTML="<table border=""0"" cellspacing=""1"" cellpadding=""2"">"
		strDefaffix = Split(fString, "$$")
		For i = 0 To UBound(strDefaffix)
			txt = strDefaffix(i)
			If IsBlank(txt)=False Then
				paffix = Split(txt, "$")
				For ii = 0 To UBound(paffix)
					Select Case ii
					Case 0
						defaffixTxt = paffix(ii)
					Case 1
						defaffixUrl = paffix(ii)
					End Select
				Next
				strHTML=strHTML &"<tr><td><img src="""&defInstalldir&"global/images/file/"&GetFileExtended(defaffixUrl)&".gif""></td><td><a href="""&defaffixUrl&""" title="""&defaffixTxt&""">"&defaffixTxt&"</a>&nbsp;&nbsp;"&GetFormatFileSize(GetFileSize(defaffixUrl))&"</td></tr>"
			End if
		Next
		strHTML=strHTML & "</table>"
	End if
	Getaffix=strHTML
End Function

'// <summary>
'// 栏目列表树
'// </summary>
Function GetSelectCatalog(Byval Id,Byval style)
	set pRS = db("Select [catalogId],[ParentId],[DeepPath],[CatalogName],[ChildId] From [tblCatalog] Order By [weighted] Desc,[catalogId] Desc",1)
	If pRS.Eof Then
		GetSelectCatalog = "<select " & style & "><option value='0' selected='selected'>请先添加频道</option></select>" & Vbcrlf
	Else
		dim pRows
		pRows = pRS.Getrows()
		GetSelectCatalog = "<select " & style & ">"
		GetSelectCatalog = GetSelectCatalog & GetSelectSubCatalog(0,Id,pRows)
		GetSelectCatalog = GetSelectCatalog & "</select>" & Vbcrlf
	End If
	pRS.Close
	Set pRS = Nothing
End Function

Function GetSelectSubCatalog(Byval symbolic,Byval Id,Byval pRows)
	dim i,p
	For i = 0 To Ubound(pRows,2)
		If pRows(1,i) = symbolic Then
			If Len(pRows(4,i)) > 0 Then
				GetSelectSubCatalog = GetSelectSubCatalog & "<option value=""-1"""
			Else
				GetSelectSubCatalog = GetSelectSubCatalog & "<option value=""" & pRows(0,i) & """"
			End If
			If Len(Id) > 0 and Id = pRows(0,i) Then GetSelectSubCatalog = GetSelectSubCatalog & " selected"
			GetSelectSubCatalog = GetSelectSubCatalog & ">"
			For p = 1 To pRows(2,i)
				GetSelectSubCatalog = GetSelectSubCatalog & "　"
			Next
			If symbolic > 0 Then GetSelectSubCatalog = GetSelectSubCatalog & "∟ "
			GetSelectSubCatalog = GetSelectSubCatalog & pRows(3,i) & "</option>" & Vbcrlf 
			GetSelectSubCatalog = GetSelectSubCatalog & GetSelectSubCatalog(pRows(0,i),Id,pRows) '该Id下的分类
		End If
	Next
End Function

'// <summary>
'// 分页函数
'// </summary>
Function GetJumpPage(pPageCount, Page, fileName, filePath)
	dim strHTML,iPages,subiPages,i
		strHTML = "<div class=""paginate"">"
		If Page >= 10 Then
			subiPages = Page + 8
			iPages = Page - 1
			If subiPages > pPageCount Then
				subiPages = pPageCount
				iPages = pPageCount - 9
			End If
		Else
			If pPageCount > 10 Then
				subiPages = 10
			Else
				subiPages = pPageCount
			End If
			iPages = 1
		End If
		dim pFileName, pName, pExt, txt
		pName = Left(fileName, InStr(fileName, ".") - 1)
		pExt = mid(fileName, InStr(fileName, "."), Len(fileName))
		txt = ""
		For i = iPages To subiPages
			If i > 1 Then
				pFileName = pName & "_" & i
				pFileName = pFileName & pExt
			Else
				pFileName = fileName
			End If
			
			If i = Page Then
				txt = txt & "<span class=""current"">"
				txt = txt & (i)
				txt = txt & "</span>"
			Else
				txt = txt & "<a href=""" & filePath & pFileName & """>"
				txt = txt & (i)
				txt = txt & "</a>"
			End if
		Next
		strHTML = strHTML & txt
		If Page < 2 Then
			If pPageCount <= 1 Then
				pFileName = pName & "_" & Page + 1 & pExt
				strHTML = strHTML & "<span class=""disabled"">&lt;</span><span class=""disabled"">&gt;</span>"
			Else
				pFileName = pName & "_" & Page + 1 & pExt
				strHTML = strHTML & "<span class=""disabled"">&lt;</span><a href=""" & filePath & pFileName & """>&gt;</a>"
			End If
		ElseIf Page = pPageCount Then
			If Page - 1 = 1 Then
				strHTML = strHTML & ("<a href=""" & filePath & fileName & """>&lt;</a><span class=""disabled"">&gt;</span>")
			Else
				pFileName = pName & "_" & Page - 1
				pFileName = pFileName & pExt
				strHTML = strHTML & ("<a href=""" & filePath & pFileName & """>&lt;</a><span class=""disabled"">&gt;</span>")
			End If
		Else
			If Page - 1 = 1 Then
				strHTML = strHTML & ("<a href=""" & filePath & fileName & """>&lt;</a><a href=""" & filePath & pName & "_" & Page + 1 & pExt & """>&gt;</a>")
			Else
				strHTML = strHTML & ("<a href=""" & filePath & pName & "_" & Page - 1 & pExt & """>&lt;</a><a href=""" & filePath & pName & "_" & Page + 1 & pExt & """>&gt;</a>")
			End If
		End If
	strHTML = strHTML & "</div>"
	GetJumpPage = strHTML
End Function

'// <summary>
'// 分页函数(动态)
'// </summary>
Function GetJumpPageURL(pPageCount, Page, pURL) 
	dim strHTML
	if Page > 0 and pPageCount > 0 then
	dim pSubURL, iPages, iSubPages, txt, URL, i
	strHTML = strHTML & "<div class=""paginate"">"
	URL =  Request.Servervariables("url")
	URL = left(URL,instrrev(URL,"/",len(URL))-1)
	pSubURL = "http://" & Request.Servervariables("server_name") & URL 
	if Page>=10 then
		iSubPages=Page+8
		iPages=Page-1
		if iSubPages>pPageCount then 
			iSubPages=pPageCount
			iPages=pPageCount-9
		End if
	Else
		if pPageCount>10 then
			iSubPages=10
		else
			iSubPages=pPageCount
		End if
	iPages=1	
	End if
		For i=iPages to iSubPages
			txt = ""
			If i = cint(Page) Then
				txt = txt & "<span class=""current"">"
				txt = txt & (i) 
				txt = txt & "</span>"
			Else
				txt = txt & "<a href=" & pSubURL & pURL & "page="&i &">"
				txt = txt & (i) 
				txt = txt & "</a>"
			End if
			strHTML= strHTML & txt
		Next
		if int(Page)<=1 then
			strHTML= strHTML & "<span class=""disabled"">&lt;</span><a href=" & pSubURL & pURL & "page=2>&gt;</a>"
		Elseif int(Page) >= pPageCount then
			strHTML= strHTML & "<a href=" & pSubURL & pURL & "page="&(pPageCount-1)&">&lt;</a><span class=""disabled"">&gt;</span>"
		Else
			strHTML= strHTML & "<a href=" & pSubURL & pURL & "page="&(Page-1)&">&lt;</a><a href=" & pSubURL & pURL & "page="&Page+1&">&gt;</a>"
		End if
		strHTML= strHTML & "</div>"
	End if  	
	GetJumpPageURL=strHTML
End Function
%>