<%
Class Cls_Template

	dim pRegExp
	dim Page
	dim catalogId
	dim Rule
	dim pContent
	dim Template
	dim defCacheTimei
	
	Private Sub Class_Initialize()
		Set pRegExp = New RegExp
		pRegExp.Ignorecase = True
		pRegExp.Global = True
		Page = 0
		catalogId = 0
		Rule = ""
		pContent = ""
		Template = "" ' 模板路径
		defCacheTimei = -1 ' 标签缓存时间
	End Sub
	
	Private Sub Class_Terminate()
		'Set pRegExp = Nothing
	End Sub

	'// <summary>
	'// 载入模板
	'// </summary>
	Public Function Load(ByVal Templatefile)
		Template = Templatefile
		If defCacheTemplate = 1 Then
			If ChkCache("LoadTemplate_" & Server.Mappath(Template)) Then
				pContent = GetCache("LoadTemplate_" & Server.Mappath(Template))
			Else
				pContent = Loadfile(Template)
				Call SetCache("LoadTemplate_" & Server.Mappath(Template), pContent)
			End If
		Else
		pContent = Loadfile(Template)
		End If
	End Function
	
	'// <summary>
	'// 检测SQL缓存
	'// </summary>
	Function ChkCacheSQL(ByVal CacheName)
		If defCacheTimei <= 0 Then ChkCacheSQL = False: Exit Function
		dim CacheData
		ChkCacheSQL = False
		CacheName = LCase(GetLeachCharacter(CacheName))
		CacheData = Application(defCacheName & CacheName)
		If Not IsArray(CacheData) Then Exit Function
		If Not IsDate(CacheData(1)) Then Exit Function
		If DateDiff("s", CDate(CacheData(1)), Now()) < 60 * defCacheTime Then ChkCacheSQL = True
	End Function

	'// <summary>
	'// 标签分析,有缓存有效期判断
	'// </summary>
	Public Function Parser()
		If Not IsNumeric(Page) Then Page = 0 Else Page = Int(Page)
		Parser_Include(1)
		Parser_My ' 自定义标签
		Parser_Sys ' 系统标签
		Parser_Com ' 列表标签
		Parser_IF ' IF ELSE END
	End Function
	
	'// <summary>
	'// 分析嵌套
	'// </summary>
	Public Function Parser_Include(ByVal str)
		On Error Resume Next
		If Cint(str) <= 0 Then
			Exit Function
		ElseIf Cint(str) > 3 Then
			Response.Write "<font color=red>{include}最多只能嵌套3层.</font>": Response.End
		End if
		pRegExp.Pattern = "\{include(.+?)\}"
		set Matches = pRegExp.Execute(pContent)
		For Each Match in Matches
			If Len(Replace(Match.SubMatches(0), " ", "")) > 0 Then
				oContent = Loadfile(defInstalldir & defTemplatePath & Replace(GetAttr(Match.SubMatches(0),"file",True),"""", ""))
			Else 
				oContent = ""
			End if
			pContent = Replace(pContent, Match.Value, oContent) '替换
			If Err Then Err.Clear: Response.Write Err.Description & "<font color=red>{include}格式不合法.</font>": Response.End
		Next
		If RegExists("\{include(.+?)\}", pContent) Then Call Parser_Include(str - 1)'递归调用
	End Function

	'// <summary>
	'// 自定义标签
	'// </summary>
	Public Function Parser_My()
		On Error Resume Next
		If GetCache("pMyLable") = "No" Then pContent = RegReplace(pContent, "{my:([\s\S]*?)}", ""): Exit Function
		If Not ChkCache("MyLable") Then
			dim Rs
			Set Rs = db("Select [Title],[Content] From [tblLabel]", 1)
			If Not Rs.Eof Then
				Call SetCache("MyLable", Rs.Getrows())
				Call SetCache("pMyLable", "Yes")
				Rs.Close: Set Rs = Nothing
			Else
				Rs.Close: Set Rs = Nothing
				Call SetCache("pMyLable", "No")
				pContent = RegReplace(pContent, "{my:([\s\S]*?)}", ""): Exit Function
			End If
		End If
		dim pLable, i, j
		pLable = GetCache("MyLable")
		dim Matches, Match, MyValue
		pRegExp.Pattern = "{my:([\s\S]*?)}"
		Set Matches = pRegExp.Execute(pContent)
		For Each Match In Matches
			If Len(Replace(Match.SubMatches(0), " ", "")) > 0 Then
				MyValue ="自定义标签 <font color=red>" & Replace(Match.SubMatches(0), " ", "") & "</font> 未创建"
				For i = 0 To UBound(pLable, 2)
					If LCase(pLable(0, i)) = LCase(Replace(Match.SubMatches(0), " ", "")) Then
						MyValue = pLable(1, i)
						If InStr(MyValue, "＄＄＄") > 0 Then
							Randomize
							j = Round(UBound(Split(MyValue, "＄＄＄")) * Rnd) '随机值第一个到最后一个
							MyValue = Split(MyValue, "＄＄＄")(j)
						End If
						Exit For
					End If
				Next
			End If
			pContent = Replace(pContent, Match.Value, MyValue) ' 替换
			If Err Then Err.Clear: Response.Write "<font color=red>执行自定义标签失败[" & AspArr(i) & "]</font>": Response.End
		Next
	End Function
	
	'// <summary>
	'// 分析系统标签
	'// </summary>
	Public Function Parser_Sys()
		On Error Resume Next
		dim Matches, Match, SysValue
		pRegExp.Pattern = "{Sys:([\s\S]*?)}"
		Set Matches = pRegExp.Execute(pContent)
		For Each Match In Matches
			If InStr(LCase(Match.SubMatches(0)), "database") = 0 Then
				If Len(Replace(Match.SubMatches(0), " ", "")) > 0 Then Execute ("SysValue = " & Replace(Match.SubMatches(0), " ", "")) Else SysValue = ""
			Else
				SysValue = ""
			End If
			pContent = Replace(pContent, Match.Value, SysValue) ' 替换
			If Err Then Err.Clear: Response.Write "<font color=red>执行变量标签失败[" & AspArr(i) & "]</font>": Response.End
		Next
		pRegExp.pattern = "<(.*?)(src=|href=|value=|background=)""(images/|style/|script/)(.*?)""(.*?)>"
		pContent = pRegExp.replace(pContent, "<$1$2""" & defSiteURL & defInstalldir & defTemplatePath & "$3$4""$5>")
	End Function
	
	'// <summary>
	'// 列表标签
	'// </summary>
	Public Function Parser_Com()
		On Error Resume Next
		dim Matches, Match
		dim Rs, i, j
		dim Matche, BackValue
		dim TagLabs, Tagsstr, Loopstr
		dim Tag_Cache, Tag_Row
		dim Tag_Id, Tag_pid, Tag_Mode, Tag_Keyword, Tag_Order
		dim Tag_SQL, Tag_Table, Tag_Where, Tag_Field
		pRegExp.Pattern = "<!--(.+?):\{(.+?)\}-->([\s\S]*?)<!--\1-->"
		Set Matches = pRegExp.Execute(pContent)
		For Each Match In Matches
			TagLabs = Match.SubMatches(0)	  ' 标签
			Tagsstr = Match.SubMatches(1)	  ' 属性
			Loopstr = Match.SubMatches(2)	  ' innerText
			
			If LCase(TagLabs) <> "page" Then ' 分页标签
				' 共用属性
				Tag_Cache = GetAttr(Tagsstr, "cache", True)  '缓存时间 def:defcachetime
				Tag_Row = GetAttr(Tagsstr, "row", True)	' 行数量 def:10
				Tag_Field = GetAttr(Tagsstr, "field", True)  ' 所有字段
				If Len(Tag_Cache) = 0 Or Not IsNumeric(Tag_Cache) Then Tag_Cache = -1 ' 标签不用缓存
				If Len(Tag_Row) = 0 Or Not IsNumeric(Tag_Row) Then Tag_Row = 10
				If Int(Tag_Row) < 1 Then Tag_Row = 1
				If Len(Tag_Field) = 0 Then Tag_Field = "*"
				Tag_Cache = Int(Tag_Cache): Tag_Row = Int(Tag_Row)
				' 内容Content专用属性
				Tag_Id = GetAttr(Tagsstr, "id", True)	' 这个文章不显示出来
				Tag_pid = GetAttr(Tagsstr, "pid", True)	' 栏目Id,多用个,号分隔
				Tag_Mode = GetAttr(Tagsstr, "mode", True)   ' 类型(推荐(1),头条(2),相关(3),热点(4))
				Tag_Keyword = GetAttr(Tagsstr, "keyword", True)   ' 关键字
				Tag_Order = GetAttr(Tagsstr, "order", False)  ' 排序 def:[id] desc[组合查询可用]
				Tag_SQL = GetAttr(Tagsstr, "sql", False)	' 单独SQL查询
				Tag_Table = GetAttr(Tagsstr, "table", True)  ' 组合查询,表
				Tag_Where = GetAttr(Tagsstr, "where", False)  ' 组合查询,条件
				
				' 默认设置
				If LCase(Tag_Table) = "tblCatalog" and Len(Tag_Where) = 0 Then Tag_Where = "[ParentID]=0 and [State]=0"
				If LCase(Tag_Table) = "tblCatalog" and Len(Tag_Order) = 0 Then Tag_Order = "[weighted] Desc,[id] Desc"
						
				' SQL查询组合
				If Len(Tag_SQL) = 0 Then
					If Len(Tag_Table) > 0 Then
						If Len(Tag_Where) > 0 Then Tag_Where = " Where " & Tag_Where & " "
						If Len(Tag_Order) = 0 Then
							If LCase(Tag_Table) = "tblCatalog" Then
								Tag_Order = "[weighted] Desc,[id] Desc"
							Else
								Tag_Order = "[id] Desc"
							End If
						End If
						Tag_SQL = "Select Top " & Tag_Row & " " & Tag_Field & " From [" & Tag_Table & "] " & Tag_Where & " Order By " & Tag_Order ' 最终查询语句
					Else
						Tag_Where = ""
						If Len(Tag_Id) > 0 Then
							If InStr(Tag_Id, ",") > 0 Then
								Tag_Where = " [id] In (" & Tag_Id & ") "
							Else
								Tag_Where = " [id]<>" & Tag_Id & " "
							End If
						End If
						If Len(Tag_pid) > 0 Then
							If Len(Tag_Where) > 0 Then Tag_Where = Tag_Where & " and [catalogId] In (" & Tag_pid & ") " Else Tag_Where = " [catalogId] In (" & Tag_pid & ") "
						End If
						Select Case LCase(Tag_Mode)
						Case "1" '推荐
							If Len(Tag_Where) > 0 Then Tag_Where = Tag_Where & " and [Mode]=1 " Else Tag_Where = Tag_Where & " [Mode]=1 "
						Case "2" '头条
							If Len(Tag_Where) > 0 Then Tag_Where = Tag_Where & " and [Mode]=2 " Else Tag_Where = Tag_Where & " [Mode]=2 "
						Case "3" '相关
							If Len(Tag_Keyword) > 0 Then
								Tag_Cache = -1 ' 不缓存
								dim Tag_KeysLink
								Tag_Keyword = Split(Replace(Tag_Keyword, "'", ""), ",")
								j = UBound(Tag_Keyword): If j > 5 Then j = 5
								For i = 0 To j
									If Len(Tag_Keyword(i)) > 0 Then
										If Len(Tag_KeysLink) = 0 Then
											Tag_KeysLink = " [Keywords] Like '%" & Tag_Keyword(i) & "%'"
										Else
											Tag_KeysLink = Tag_KeysLink & " Or [Keywords] Like '%" & Tag_Keyword(i) & "%'"
										End If
									End If
								Next
								If Len(Tag_KeysLink) > 0 Then
									If Len(Tag_Where) > 0 Then Tag_Where = Tag_Where & " and (" & Tag_KeysLink & ") " Else Tag_Where = Tag_Where & " (" & Tag_KeysLink & ") "
								End If
							End If
						End Select
						If LCase(Tag_Mode) = "4" Then
							Tag_Order = "[Click] desc"
						Else
							If Len(Tag_Order) = 0 Then Tag_Order = "[Id] Desc"
						End If
						
						If Len(Tag_Where) > 0 Then Tag_Where = Tag_Where & " and [State]=0 " Else Tag_Where = " [State]=0"
						Tag_SQL = "Select Top " & Tag_Row & " " & Tag_Field & " From [tblPage] Where " & Tag_Where & " Order By " & Tag_Order ' 最终查询语句
					End If
				End If
				defCacheTimei = Tag_Cache ' 标签缓存
				If ChkCacheSQL(Template & Tag_SQL) Then
					BackValue = GetCache(Template & Tag_SQL)
				Else
					BackValue = ""
					Err.Clear
					Set Rs = db(Tag_SQL, 3)
					If Err Then Response.Write "<font color=red>执行列表标签失败[" & Tag_SQL & " => & " & Err.Description & "]</font>": Response.End
					Session(defCacheName & "_Parser_i") = 0
					For i = 1 To Tag_Row
						If Rs.Eof Then Exit For ' 不存在记录就退出
						If Len(TagLabs) = 0 Then TagLabs = "field"
						Session(defCacheName & "_Parser_i") = Session(defCacheName & "_Parser_i") + 1 ' 记数
						BackValue = BackValue & Parser_Tags("\[" & TagLabs & ":(.+?)\]", Loopstr, Rs) ' 替换
						Rs.MoveNext
					Next
					Rs.Close
					Call SetCache(Template & Tag_SQL, BackValue)
				End If
				pContent = Replace(pContent, Match.Value, BackValue)
			End If
		Next
		If RegExists("<!--(.+?):\{(.+?)\}-->([\s\S]*?)<!--\1-->", pContent) Then Call Parser_Com  ' 多次调用
	End Function
	
	'// <summary>
	'// 分页标签
	'// </summary>
	Public Function Parser_Page()
		dim Matches, Match
		dim Rs, i
		dim Matche, BackValue
		dim Tagsstr, Loopstr
		dim Tag_Size, Tag_Order, Tag_Field, Tag_Table, Tag_Style, Tag_SQL, Tag_Where,Tag_Mode
		dim Tag_RecordCount, Tag_PageCount
		pRegExp.Pattern = "<!--Page:\{(.+?)\}-->([\s\S]*?)<!--Page-->"
		Set Matches = pRegExp.Execute(pContent)
		For Each Match In Matches
			BackValue = ""
			Tagsstr = Match.SubMatches(0)	  ' 属性
			Loopstr = Match.SubMatches(1)	  ' innerText
			Tag_Size = GetAttr(Tagsstr, "size", True)
			Tag_Order = GetAttr(Tagsstr, "order", False)
			Tag_Table = GetAttr(Tagsstr, "table", True)
			Tag_Style = GetAttr(Tagsstr, "style", True)
			Tag_Field = GetAttr(Tagsstr, "field", True)  ' 所有字段
			Tag_Mode = GetAttr(Tagsstr, "mode", True)
			If Len(Tag_Size) = 0 Or Not IsNumeric(Tag_Size) Then Tag_Size = 10
			If Len(Tag_Order) = 0 Then Tag_Order = "[id] Desc"
			If Len(Tag_Table) = 0 Then Tag_Table = "tblPage"
			If Len(Tag_Style) = 0 Or Not IsNumeric(Tag_Style) Then Tag_Style = 1
			If Len(Tag_Field) = 0 Then Tag_Field = "*"
			Tag_Size = Int(Tag_Size): Tag_Table = " [" & Tag_Table & "] ": Tag_Style = Int(Tag_Style): Tag_Where = " [State]=0 "
			If Len(catalogId) > 0 and isnumeric(catalogId) Then Tag_Where = Tag_Where & " and [catalogId] in ("&catalogId & GetCatalog("tblCatalog",catalogId)&")"
			If LCase(Tag_Mode)="1" Then Tag_Where = Tag_Where & " and [Mode]=1"
			Set Rs = New cls_DataList
			Rs.Result = 1
			Rs.Field = Tag_Field
			Rs.Table = Tag_Table
			Rs.Where = Tag_Where
			Rs.Order = Tag_Order
			Rs.PageSize = Tag_Size
			Rs.AbsolutePage = Page
			Rs.List()
			Session(defCacheName & "_Parser_i") = 0
			For i = 1 To Tag_Size
				If Rs.Data.Eof Then Exit For
				Session(defCacheName & "_Parser_i") = Session(defCacheName & "_Parser_i") + 1 ' 记数
				BackValue = BackValue & Parser_Tags("\[Page:(.+?)\]", Loopstr, Rs.Data) ' 替换
				Rs.Data.MoveNext
			Next
			pContent = RegReplace(pContent, "{tag:page}", "{{tag:page_www.hi.com}}")
			pContent = Replace(pContent, Match.Value, BackValue)
			Tag_RecordCount = Rs.RecordCount: Tag_PageCount = Rs.PageCount: Rs.Data.Close
			If Tag_PageCount = 0 Then Tag_PageCount = 1
		Next
		dim GetPageList
		if matches.count >0 then
			GetPageList = GetJumpPage(Tag_PageCount, Page, GetField("FileName","tblCatalog"," catalogId="&catalogId&""),defInstalldir & GetDirectory("tblCatalog",catalogId))
		End if
		pContent = RegReplace(pContent, "{{tag:page_www.hi.com}}", GetPageList)
		Set Rs = Nothing
	End Function
	
	'// <summary>
	'// 字符替换
	'// </summary>
	Public Function Parser_Tags(ByVal Pattern, ByVal Temp, ByVal Dat)
		On Error Resume Next
		dim Matches, Match
		dim Tagsstr, Tagsval, Tagsvalt, TagTitle: TagTitle = False
		dim Tag_Len, Tag_Lenext, Tag_Format, Tag_Replace, Tag_Function
		dim pReplace, subReplace, jReplace
		dim i, c, l, t
		pRegExp.Pattern = Pattern
		Set Matches = pRegExp.Execute(Temp)
		For Each Match In Matches
			Tagsstr = Match.SubMatches(0)
			Tag_Len = GetAttr(Tagsstr, "len", True)
			Tag_Lenext = GetAttr(Tagsstr, "lenext", True)
			Tag_Format = GetAttr(Tagsstr, "format", False)
			Tag_Replace = GetAttr(Tagsstr, "replace", False)
			Tag_Function = GetAttr(Tagsstr, "function", True)
			Tag_Width = GetAttr(Tagsstr, "width", True)
			Tag_Height = GetAttr(Tagsstr, "height", True)
			Tagsval = Split(Tagsstr, " ")(0)
			Select Case LCase(Tagsval)
			Case "id"
				Tagsval = Dat("id")
				If Err Then Err.Clear: Tagsval = Dat("id")' Content
			Case "purl"
				Tagsval = Dat("id")' Content
				Tagsval = defInstalldir & GetDirectory("tblCatalog",Dat("catalogId")) & Dat("Id") & Dat("ExtendName")
			Case "urlcatalog"
				Tagsval = Dat("catalogId")
				Tagsval = defInstalldir & GetDirectory("tblCatalog",Dat("catalogId")) & Dat("FileName")
			Case "i"
				Tagsval = Session(defCacheName & "_Parser_i")
			Case Else
				Tagsval = Dat(Tagsval)
			End Select
			Tagsval = Replace(Replace(Replace(Replace(Tagsval, "&nbsp;", " "), "&quot;", Chr(34)), "&gt;", ">"), "&lt;", "<")
			If Len(Replace(Tag_Replace, " ", "")) > 0 Then
				pReplace = Split(Tag_Replace, "##")
				If UBound(pReplace) >= 0 Then subReplace = pReplace(0): jReplace = pReplace(1) Else subReplace = pReplace(0): jReplace = pReplace(0)
				Tagsval = Replace(Tagsval, subReplace, jReplace)
			End If
			If Len(Replace(Tag_Format, " ", "")) > 0 Then '格式化时间
				If IsDate(Tagsval) Then
					Tagsvalt = Tagsval : Tagsvalt = Lcase(Tag_Format)
					Tagsvalt = Replace(Tagsvalt,"yyyy",Year(Tagsval)) : Tagsvalt = Replace(Tagsvalt,"yy",Right(Year(Tagsval),2))
					Tagsvalt = Replace(Tagsvalt,"mm",Right("0" & Month(Tagsval),2)) : Tagsvalt = Replace(Tagsvalt,"m",Month(Tagsval))
					Tagsvalt = Replace(Tagsvalt,"dd",Right("0" & Day(Tagsval),2)) : Tagsvalt = Replace(Tagsvalt,"d",Day(Tagsval))
					Tagsvalt = Replace(Tagsvalt,"hh",Right("0" & Hour(Tagsval),2)) : Tagsvalt = Replace(Tagsvalt,"h",Hour(Tagsval))
					Tagsvalt = Replace(Tagsvalt,"nn",Right("0" & Minute(Tagsval),2)) : Tagsvalt = Replace(Tagsvalt,"n",Minute(Tagsval))
					Tagsvalt = Replace(Tagsvalt,"ss",Right("0" & Second(Tagsval),2)) : Tagsvalt = Replace(Tagsvalt,"s",Second(Tagsval))
					Tagsval  = Tagsvalt
				End If
			End If
			If Len(Tag_Len) > 0 Then
				If IsNumeric(Tag_Len) Then
					Tag_Len = Int(Tag_Len)
					For i = 1 To Len(Tagsval)
						c = Abs(Asc(Mid(Tagsval, i, 1)))
						If c > 255 Or c < 2 Then t = t + 2 Else t = t + 1
						If t >= Tag_Len Then Tagsval = Left(Tagsval, i) & Tag_Lenext: Exit For
					Next
				End If
			End If
			If Len(Tag_Function) > 0 Then
				Tag_Function = Split(Tag_Function, ",")
				For i = 0 To UBound(Tag_Function)
					Select Case LCase(Tag_Function(i))
					Case "urlencode": Tagsval = Server.UrlEnCode(Tagsval)
					Case "htmlencode": Tagsval = Server.HtmlEnCode(Tagsval)
					Case "abs": Tagsval = Abs(Tagsval)
					Case "trim": Tagsval = Trim(Tagsval)
					Case "ucase": Tagsval = UCase(Tagsval)
					Case "lcase": Tagsval = LCase(Tagsval)
					Case "clearhtml": Tagsval = RegReplace(Tagsval, "(\<.+?\>)", ""): Tagsval = Replace(Trim(Tagsval), vbCrLf, " ")
					Case "tags"
						t = Split(Tagsval, ","): Tagsval = ""
						For c = 0 To UBound(t)
							If Len(Tagsval) > 0 Then Tagsval = Tagsval & ","
							Tagsval = Tagsval & " <a href='" & defSiteURL & defInstalldir & "plus/search/?keyword=" & Server.UrlEnCode(t(c)) & "'>" & t(c) & "</a>"
						Next
					End Select
				Next
			End If
			If len(Tag_Width) > 0 or len(Tag_Height) > 0 Then
				Tagsval = Jpeg_Thumbnail(Tagsval,"",tag_Width, tag_height)
			End if
			If IsNull(Tagsval) Then Tagsval = ""
			If TagTitle Then
				TagTitle = False
				dim TitleStyle: TitleStyle = Split(Dat("Style") & ",", ",")
				If Len(TitleStyle(0)) > 0 Then Tagsval = "<" & TitleStyle(0) & ">" & Tagsval & "</" & TitleStyle(0) & ">"
				If Len(TitleStyle(1)) > 0 Then Tagsval = "<font color=""" & TitleStyle(1) & """>" & Tagsval & "</font>"
			End If
			Temp = Replace(Temp, Match.Value, Tagsval)
		Next
		Parser_Tags = Temp
	End Function
	
	'// <summary>
	'// 判断标签
	'// </summary>
	Public Function Parser_IF()
		dim fString
		fString = ""
		Parser_subIF(fString)
	End Function

	Public Function Parser_subIF(ByVal fString)
		On Error Resume Next
		dim Matches, Match,TestIF,TestVal,TestTrue,TestFalse
		dim NewfString
		pRegExp.Pattern = "{" & fString & "If:(.+?)}([\s\S]*?){" & fString & "End If}"
		Set Matches = pRegExp.Execute(pContent)
		For Each Match In Matches
			TestVal=Match.SubMatches(1)
			If Instr(LCase(TestVal), "{" & fString & "else}")>0 Then
				TestVal=Replace(TestVal, "{" & fString & "else}", "{" & fString & "else}",1,-1,1):TestTrue=Split(TestVal, "{" & fString & "else}")(0):TestFalse=Split(TestVal, "{" & fString & "else}")(1)
			Else
				TestTrue=TestVal:TestFalse=""
			End If
			Execute ("If " & replace(Match.SubMatches(0),"'","""") & " Then TestIf = True Else TestIf = False")
			If TestIF Then pContent = Replace(pContent, Match.Value, TestTrue) Else pContent = Replace(pContent, Match.Value, TestFalse)
			If Err Then Response.Write "<font color=red>执行IF标签失败[" & Match.SubMatches(0) & "]" & Err.Description & "</font>": Err.Clear: Response.End
		Next
		NewfString = fString & "-"
		If RegExists("{" & NewfString & "If:(.+?)}([\s\S]*?){" & NewfString & "End If}", pContent) Then Call Parser_subIF(NewfString)
	End Function
	
	'// <summary>
	'// 正表达式替换
	'// </summary>
	Public Function RegReplace(ByVal ReplaceContent, ByVal Pattern, ByVal ReplaceVal)
		pRegExp.Pattern = Pattern
		RegReplace = pRegExp.Replace(ReplaceContent, ReplaceVal)
	End Function
	
	'// <summary>
	'// 是否存在此类标签
	'// </summary>
	Public Function RegExists(ByVal Pattern, ByVal TestContent)
		pRegExp.Pattern = Pattern
		RegExists = pRegExp.Test(TestContent)
	End Function
	
	'// <summary>
	'// 获取指定标签属性的值
	'// </summary>
	Public Function GetAttr(ByVal Tagsstr, ByVal AttrName, ByVal ReplaceSpace)
		If Len(Tagsstr) <= 3 Or InStr(LCase(Tagsstr), "$" & LCase(AttrName) & "=") = 0 Then GetAttr = "": Exit Function
		dim Matches, Match
		pRegExp.Pattern = "\$" & AttrName & "=(.+?) \$"
		Set Matches = pRegExp.Execute(Tagsstr & " $")
		For Each Match In Matches
			GetAttr = Match.SubMatches(0)
		Next
		If ReplaceSpace Then
			GetAttr = Replace(GetAttr, " ", "")
			If Len(GetAttr) > 0 and IsNumeric(GetAttr) and InStr(GetAttr, ",") = 0 Then GetAttr = Int(GetAttr)
		End If
	End Function

	'// <summary>
	'// 载入模板
	'// </summary>
	Public Function Loadfile(str)
		dim Obj
		On Error Resume Next
		set Obj = Server.Createobject("adodb.stream")
		With Obj
		.Type = 2 : .Mode = 3 : .Open : .Charset = Response.charset : .Position = Obj.Size : .Loadfromfile Server.Mappath(str) : Loadfile = .ReadText : .Close
		End With
		set Obj = Nothing
		If Err Then Response.Write "<font color=red>无法加载模板[" & str & "]</font>" : Response.End
	End Function
End Class
%>