var Module = Module || {};
var module = function (moduleId, obt) {
    this.elmId = moduleId;
    this.tabsId = this.elmId + '_head';
    this.contentIdPreText = this.elmId + '_content_';
    if (obt) {
        this.mTab = new Module.Tabs(this.tabsId, this.contentIdPreText, obt);
    }
    else {
        this.mTab = new Module.Tabs(this.tabsId, this.contentIdPreText);
    }
};

module.prototype.initTabs = function () {
    this.mTab.init();
};
module.prototype.initTabsHover = function () {
    this.mTab.initHover();
};

Module.Tabs = function (nodeId, contentIdPreText, obt) {
    var tabs = $("#" + nodeId + " li"),
    tabCurI = null;
    var tabCons = [];
    var tabBtns = [],
tabBtn,
tabEvent = "click";
    function changeContent(targetIndex) {
        tabCons[tabCurI].css('display', 'none');
        tabCons[targetIndex].css('display', '');
        tabCurI = targetIndex;
    }
    function chgTab(targetIndex) {
        try {
            tabs[tabCurI].removeClass("active");
            tabs[targetIndex].addClass("active");
            changeContent(targetIndex);
        } catch (ex) { };
    }
    function initTabs() {
        tabs.each(function (i, _tab) {
            _tab = tabs[i] = $(_tab);
            tabBtn = tabBtns[i] = _tab.find("a:first");
            tabBtn[tabEvent](function (ev) {
                chgTab(i);
                return false;
            });
        });
        tabs.each(function (i) {
            if ($(this).hasClass("active")) {
                (tabCurI == null) && (tabCurI = i);
            }
        });

        tabs.each(function (i, _tab) {
            tabCons[i] = $("#" + contentIdPreText + (i + 1));
            if (i !== tabCurI) {
                tabCons[i].css('display', 'none');
            } else {
                tabCons[i].css('display', '');
            }
        });
    }
    this.init = function () {
        initTabs();
    };
    this.initHover = function () {
        tabEvent = "mouseover";
        initTabs();
    };

};