function LeftToRight(frm,from,to){
	simpleCopy(frm,from,to);
	removeOptions(frm,from);
}
function RightToLeft(frm,from,to){
	simpleCopy(frm,from,to);
	removeOptions(frm,from);
}
function AllToRight(frm,from,to){
	CopyAll(frm,from);
	simpleCopy(frm,from,to);
	removeOptions(frm,from);
}
function AllToLeft(frm,from,to){
	CopyAll(frm,from);
	simpleCopy(frm,from,to);
	removeOptions(frm,from);
}
function simpleCopy(frm,from,to){
    var objFrom = getFormElement(frm,from);
    var objTo = getFormElement(frm,to);
    if(objFrom.selectedIndex == -1){
        return;
    }
    var index;
    var notice = '';
    for(var i = 0;i < objFrom.options.length;i ++) {
        if(objFrom.options[i].selected) {
            if(optionExists(objTo,objFrom.options[i])) {
                continue;
            }
            index = objTo.options.length;
            objTo.options[index] = new Option(objFrom.options[i].text,objFrom.options[i].value);
        }
    }
}
function CopyAll(from,left,right){
    var objFrom = getFormElement(from,left);
    for(var i = 0;i < objFrom.options.length;i ++) {
        objFrom.options[i].selected = true;
    }
}
function removeOptions(frm,selectbox) {
    var obj = getFormElement(frm,selectbox);
    var leftBracket = '';
    for(var i = obj.options.length -1;i >= 0;i --) {
        var o = obj.options[i];
        if(!o.selected || o.text.substr(0,1) == leftBracket)
        continue;
        obj.options[i] = null;
    }
    var maxIndex = obj.options.length - 1;
    while(maxIndex >= 0 && obj.options[maxIndex].text.substr(0,1) == leftBracket) {
        obj.options[maxIndex] = null;
        maxIndex --;
    }
    flag = false;
    for(i = obj.options.length - 1;i >= 0;i --) {
        if(obj.options[i].text.substr(0,1) != leftBracket) {
            flag = false;
        } else {
            if(flag == true) {
                obj.options[i] = null;
            }
            flag = true;
        }
    }
    obj.selectedIndex = -1;
}
function optionExists(selectbox,option) {
    for(var i = 0;i < selectbox.options.length;i ++) {
        if(selectbox.options[i].value == option.value) {
            return true;
        }
    }
    return false;
}
function getFormElement(frm,name) {
    for(var i = 0;i < frm.elements.length;i ++) {
        if(frm.elements[i].name == name)
        return frm.elements[i];
    }
}
