<?xml version="1.0"  encoding="GB2312"?>           
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/TR/WD-xsl">           
<xsl:template match="/">
<xsl:apply-templates select="/xml/TreeNode"/>
<xsl:apply-templates select="/message"/>
</xsl:template>
<xsl:template match="TreeNode">
<xsl:for-each select=".">           
<div class="TreeNode" nowrap="true">
<xsl:attribute name="uid"><xsl:value-of select="@id"/></xsl:attribute>
<xsl:choose>
<xsl:when test="child[. &gt; 0]">
<xsl:attribute name="type">parent</xsl:attribute>
<xsl:attribute name="open">false</xsl:attribute>
</xsl:when>
<xsl:otherwise>
<xsl:attribute name="type">leaf</xsl:attribute>
</xsl:otherwise>
</xsl:choose>
<img type="img" align="absmiddle">
<xsl:attribute name="src">
<xsl:choose>
<xsl:when test="child[. &gt; 0]">images/folder.gif</xsl:when>
<xsl:otherwise>images/file.gif</xsl:otherwise></xsl:choose></xsl:attribute>
</img><span type="label">
<xsl:attribute name="title">
<xsl:choose>
<xsl:when test="title[. != '']"><xsl:value-of select="title"/></xsl:when>
<xsl:otherwise><xsl:value-of select="NodeText"/></xsl:otherwise></xsl:choose>
</xsl:attribute>
<xsl:choose>
<xsl:when test="NodeUrl[. != '']">
<xsl:attribute name="href"><xsl:value-of select="NodeUrl"/></xsl:attribute>
<xsl:attribute name="target">
<xsl:choose>
<xsl:when test="target[. != '']"><xsl:value-of select="target"/></xsl:when>
<xsl:otherwise>_blank</xsl:otherwise></xsl:choose>
</xsl:attribute>
<xsl:value-of select="NodeText"/>
</xsl:when>
<xsl:otherwise><xsl:value-of select="NodeText"/></xsl:otherwise>
</xsl:choose>
</span>
</div>
<xsl:if test="child[. &gt; 0]">
<div style="padding-left:14;display:none" send="false">
&#160;
</div>
</xsl:if>
</xsl:for-each>
</xsl:template>

<xsl:template match="message">
<div class="TreeNode" type="leaf" nowrap="true">
<img type="img" src="images/file.gif" align="absmiddle"/><span type="load" class="load"><xsl:value-of select="@txt"/></span>
</div>
</xsl:template>
</xsl:stylesheet>