<?php 
define('BASEPATH', '../System/');
require '../Lib/Config/Common.php';
?>
<!DOCTYPE html>
<html lang="zh-cn">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1.0, user-scalable=no">
    <title>QCMS2.0系统安装</title>
    <!-- Bootstrap -->
    <link href="../Static/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <script src="../Static/bootstrap/js/jquery.min.js"></script>
    <script src="../Static/bootstrap/js/bootstrap.min.js"></script>
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="http://cdn.bootcss.com/html5shiv/3.7.2/html5shiv.min.js"></script>
      <script src="http://cdn.bootcss.com/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->
	<style>
	
	</style>
  </head>
  <body style="margin-top:50px;margin-left:50px;width:800px;"> 
  <div class="btn-group dropup col-xs-6">
  <div id="legend" class="">
        <legend class=""><h1>QCMS 2.0 系统安装</h1></legend>
      </div>
  <?php
if(!empty($_POST)){
	if(empty($_POST['host'])){
		exec_script('alert("服务器IP不能为空");history.back();');exit ;
	}
	if(empty($_POST['db_name'])){
		exec_script('alert("数据库不能为空");history.back();');exit ;
	}
	if(empty($_POST['username'])){
		exec_script('alert("帐号不能为空");history.back();');exit ;
	}
	if(empty($_POST['password'])){
		exec_script('alert("密码不能为空");history.back();');exit ;
	}
	$dataPath = '../Static/template/'.$_POST['template'].'/database/qcms.sql';
	if(!file_exists($dataPath)){
		exec_script('alert("模版不存在，请检查模版是否正确");history.back();');exit ;
	}
	$configPath = '../Lib/Config/Config.php';
	$configPathTemp = '../Lib/Config/Config_bak.php';
	try{
	    new PDO('mysql:dbname='.$_POST['db_name'].';host='.$_POST['host'].'', $_POST['username'], $_POST['password'], 
	    		array(PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION));
	}catch (PDOException $e){
	    echo '数据库连接失败，请确认数据库帐号密码正确。<br>
		<a href="index.php">返回继续安装</a><br>';exit;
	}

	if(file_exists($configPath)){
		echo '数据库配置文件存在，请删除Lib/Config/Config.php。<br>
		<a href="index.php">返回继续安装</a><br>';exit;
	}
	

	$dataTemp = file_get_contents($configPathTemp);
	$configFileData = str_replace(array('{host}', '{db_name}', '{username}', '{password}'), array($_POST['host'], $_POST['db_name'], $_POST['username'], $_POST['password']), $dataTemp);
	$access = @file_put_contents($configPath, $configFileData);
	if(!$access){
		echo '请确保Lib/Config/目录有可写权限。<br>
		<a href="index.php">返回继续安装</a><br>';exit;
	}
	require '../Lib/Config/Config.php';
	$configResult = db_config();
	$configArr = $configResult['qcms'];
	try{
	    $dataObj = new PDO(''.$configArr['db_driver'].':dbname='.$configArr['db_name'].';host='.$configArr['host'].'', $configArr['username'], $configArr['password'], 
	    		array(PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION));
	}catch (PDOException $e){
	    echo 'Connection failed: ' . $e->getMessage();exit();
	}
	$dataObj->exec("SET NAMES ".$configArr['charset']);
	$result = importData($configArr, $_POST['template'], $dataObj, $dataPath);
	if($result){
		echo '成功安装QCMS 2.0系统，<br>
		<a href="../">立即登录网站首页</a><br>';exit;
	}
}else{
?><div class="alert alert-danger" id="alertMsg" role="alert" style="display:none"></div>
  <form role="form" method="post" id="installForm">
    <fieldset>      
	<div class="control-group">
	  <!-- Text input-->
	  <label class="control-label" for="input01">模版选择</label>	  
	  <div class="controls">
	  <select class="form-control" name="template">
		 <?php		
		$result = @opendir(BASEPATH.'view/template/');
		while (false !== ($file = readdir($result))){
			if($file != '.' && $file != '..'){
				echo '<option value="'.$file.'"> '.$file.' </option>';				
			}
		}
		
	  ?>
	  </select>
		<p class="help-block"></p>
	  </div>
	</div>
    <div class="control-group">
	  <!-- Text input-->
	  <label class="control-label" for="input01">服务器IP</label>
	  <div class="controls">
		<input type="text" placeholder="Host" name="host" id="host" class="form-control" value="127.0.0.1">
		<p class="help-block"></p>
	  </div>
	</div>

    <div class="control-group">

          <!-- Text input-->
          <label class="control-label" for="input01">数据库</label>
          <div class="controls">
            <input type="text" placeholder="Database" name="db_name" id="db_name" class="form-control">
            <p class="help-block"></p>
          </div>
        </div>

    <div class="control-group">

          <!-- Text input-->
          <label class="control-label" for="input01">帐号</label>
          <div class="controls">
            <input type="text" placeholder="User" name="username" id="username" class="form-control">
            <p class="help-block"></p>
          </div>
        </div>
        <div class="control-group">

          <!-- Text input-->
          <label class="control-label" for="input01">密码</label>
          <div class="controls">
            <input type="text" placeholder="Password" name="password" id="password" class="form-control">
            <p class="help-block"></p>
          </div>
        </div>

    <div class="control-group">
          <label class="control-label"></label>

          <!-- Button -->
          <div class="controls">
            <button type="button" class="btn btn-success submitBut">马上安装 QCMS 2.0</button>
          </div>
        </div>

    </fieldset>
  </form>
	<?php
}
	?>
  </div>
  <script type="text/javascript">
  $(function(){
  	$('.submitBut').click(function(){
  		if($('#host').val() == ""){
  			checkAlert('服务器IP不能为空');
  			$('#host').focus();
  			return false;
  		}
  		if($('#db_name').val() == ""){
  			checkAlert('数据库不能为空');
  			$('#db_name').focus();
  			return false;
  		}
  		if($('#username').val() == ""){
  			checkAlert('帐号不能为空');
  			$('#username').focus();
  			return false;
  		}
  		if($('#password').val() == ""){
  			checkAlert('密码不能为空');
  			$('#password').focus();
  			return false;
  		}
  		var isRewrite = checkSys('detect.php?act=1');
  		if(isRewrite == 0){
  			checkAlert('Lib/Config 目录不可写，请设置服务器权限');
  			return false;
  		}
  		var isHaveConfig = checkSys('detect.php?act=2');
  		if(isHaveConfig == 1){
  			checkAlert('配置文件 Lib/Config/Config.php 已经存在,请删除后重新安装.');
  			return false;
  		}
  		$('#installForm').submit();
  		return true;
  	})
  })

  var checkSys = function(path){
  	return $.ajax({
	   type: "GET",
	   url: path,
	   data: '',
	   async: false
	}).responseText;
  }

  var checkAlert = function(str){
  	$('#alertMsg').css('display', 'block');
  	$('#alertMsg').html(str);
  }
  </script>
  </body></html>

<?php 
	function importData($configArr, $template, $dataObj, $dataPath){
		//var_dump($template);exit;
		$result = file($dataPath);
		$query = '';
		foreach($result as $key => $value){
			$value=trim($value);
			if(!$value || $value[0]=='#' || $value[0]=='-') continue;
			if(preg_match("/\;$/i",$value)){
				$query.=$value;
				if(preg_match("/^CREATE/i",$query))
				{
					$extra = substr(strrchr($query,')'),1);
					$query = str_replace($extra,'',$query);
					$extra = "ENGINE=MyISAM DEFAULT CHARSET=utf8;";
					$query .= $extra;
				}
				elseif(preg_match("/^INSERT/i",$query)){
					$query='REPLACE '.substr($query,6);
				}
				$query = str_replace('{qcms}_', $configArr['db_prefix'], $query);
				//echo $query.'<br>';
				$rs = $dataObj->exec($query);
				$query='';
			}
			else
			{
				$query.= $value;
			}
		
		}
		$dataObj->exec('REPLACE INTO `qcms_template` (`id`, `name`, `info`, `status`, `addtime`) VALUES
(1, \''.$template.'\', \''.$template.'\', 0, '.time().');');
		return true;
	}
	

