<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
/*
 * Name   : Collection
 * Date	  : 20120107 
 * Author : Qesy 
 * QQ	  : 762264
 * Mail   : 762264@qq.com
 *
 *(̅_̅_̅(̲̅(̅_̅_̅_̅_̅_̅_̅_̅()ڪے 
 *
*/ 
abstract class Base{	
	private $_fileV = 5;
	public $pageNum = 20;
	public $temp_arr = array();
	public $m_id = '';
	public $cookieObj;
	public $web;
	protected $p_sysObj;
	public $cateALLArr = array();
	public $moduleArr = array(
		1 	=> 	'新闻',
		2 	=> 	'下载',
		3	=>	'相册',
		4 	=>	'产品',
		5	=> 	'留言',
		6	=> 	'单页',
	);
	public $moduleArrUrl = array(
			1 	=> 	'news',
			2 	=> 	'download',
			3	=>	'album',
			4 	=>	'product',
			5 	=>	'guest',
			6	=>	'other'
	);
	public $tempFileUrl;
	public $licenseArr = array('免费版', '共享版', '试用版', '演示版', '注册版', '破解版', '零售版', 'OEM版');
	public $softLanguageArr = array('英文', '简体中文', '繁体中文', '简繁中文', '多国语言', '其他语言');
	public $softType = array('国产软件', '国外软件', '汉化补丁', '程序源码', '其他');
	function __construct(){
		$this->cookieObj = $this->load_class('cookie');
		$this->p_sysObj = $this->load_model('QCMS_Sys');
		$tempObj = $this->load_model('QCMS_Template');
		$this->web = $this->p_sysObj->selectOne();
		$tempRs = $tempObj->selectOne(array('id' => $this->web['template_id']));
		$this->web['tempname'] = $tempRs['name'];
		$this->web['tempUrl'] = SITEPATH.'Static/template/'.$this->web['tempname'].'/';
	}
	
	/*
	 * Name : 生成编号
	*/
	public function create_sn(){
		$order_sn = 'QCMS-'.uniqid(rand(100,999), false);
		return $order_sn;
	}
	/*
	 * Name : 加载模版
	 */
	public function load_view($temp, $data = array()){
		if(!is_file(BASEPATH.'View/'.$temp.EXT)) die(BASEPATH.'View/'.$temp.EXT.' not found !');
			$this->temp_arr = empty($data) ? $this->temp_arr : $data;
			foreach($this->temp_arr as $key => $val){
				$$key = $val;
			}
		require BASEPATH.'View/'.$temp.EXT;
	}
	
	/*
	 * name:前台封装模版调用方法
	 */
	public function view($temp){
		self::load_view('template/'.$this->web['tempname'].'/'.$temp);
	}
	/*
	 * Name : 加载Model
	 */
	public function load_model($model, $dbname = 0){
		static $objects_m = array();
		$hash = sha1($model.$dbname);
		if(isset($objects_m[$hash])) return $objects_m[$hash];
		return self::__autoload($model, 'Model/', $dbname);
	}
	/*
	 * Name : 加载Helper类
	 */
	public function load_class($class){
		static $objects_m = array();
		if(isset($objects_m[$class])){
			return $objects_m[$class];
		}		
		return self::__autoload($class);
	}
	/*
	 * Name : 加载CSS
	 */
	public function load_css($str){
		if(is_array($str)){
			foreach($str as $key=>$val){				
				echo '<link href="'.CSS_PATH.$val.'.css?v='.$this->_fileV.'" rel="stylesheet" type="text/css" />';
			}
		}else{			
			echo '<link href="'.CSS_PATH.$str.'.css?v='.$this->_fileV.'" rel="stylesheet" type="text/css" />';
		}
	}
	/*
	 * Name : 加载JS
	 */
	public function load_js($str){
		if(is_array($str)){
			foreach($str as $key=>$val){
				echo '<script type="text/javascript" src="'.JS_PATH.$val.'.js?v='.$this->_fileV.'" charset="utf-8"></script>';
			}
		}else{
			echo '<script type="text/javascript" src="'.JS_PATH.$str.'.js?v='.$this->_fileV.'" charset="utf-8"></script>';
		}
	}
	
	//-- 分页 --
	public function page_bar($count, $size, $url = '', $num = 9, $pageNum = '1'){
		$pageNum = empty($pageNum) ? 1 : $pageNum;
		$toall = ceil($count/$size);
		$toall_str = '';
		if($pageNum > $toall)$pageNum = $toall;
		$str = '';
		$pre = ($pageNum <= 1) ? '<li><a href="'.str_replace('{page}', 1, $url).'">上一页</a></li>' : '<li><a href="'.str_replace('{page}', $pageNum-1, $url).'">上一页</a></li>';
		$next = ($pageNum >= $toall) ? '<li><a href="'.str_replace('{page}', $toall, $url).'">下一页</a></li>' : '<li><a href="'.str_replace('{page}', $pageNum+1, $url).'">下一页</a></li>';
		if($toall <= $num){
			for($i=1;$i<=$toall;$i++){
				if($pageNum == $i){
					$str .= '<li class="active"><a>'.$i.'</a></li>';
				}else{
					$str .= '<li><a href="'.str_replace('{page}', $i, $url).'">'.$i.'</a></li>';
				}
			}
			if($toall<=1){
				return;
			}else{
				return '<ul class="pagination">'.$pre.$str.$next.$toall_str.'</ul>';
			}
		}
		if(($toall - $pageNum) > ceil($num/2) && $pageNum < ceil($num/2)){
			for($i=1;$i<=$num;$i++){
				if($pageNum == $i){
					$str .= '<li class="active"><a>'.$i.'</a></li>';
				}else{
					$str .= '<li><a href="'.str_replace('{page}', $i, $url).'">'.$i.'</a></li>';
				}
			}
	
			if($toall<=1){
				return;
			}else{
				return '<ul class="pagination">'.$pre.$str.$next.$toall_str.'</ul>';
			}
		}
		if(($toall - $pageNum) < ceil($num/2)){
			for($i = ($toall - $num + 1);$i <= $toall;$i++){
				if($pageNum == $i){
					$str .= '<li class="active"><a >'.$i.'</a></li>';
				}else{
					$str .= '<li><a href="'.str_replace('{page}', $i, $url).'" >'.$i.'</a></li>';
				}
			}
			return '<ul class="pagination">'.$pre.$str.$next.$toall_str.'</ul>';
		}
		for($i = ($pageNum -  floor($num/2));$i <= ($pageNum + floor($num/2));$i++){
			if($pageNum == $i){
				$str .= '<li class="active"><a>'.$i.'</a></li>';
			}else{
				$str .= '<li><a href="'.str_replace('{page}', $i, $url).'">'.$i.'</a></li>';
			}
		}
		if($toall<=1){
			return;
		}else{
			return '<ul class="pagination">'.$pre.$str.$next.$toall_str.'</ul>';
		}
	}
	
	//-- 分页 --
	public function backend_page_bar($count, $size, $url = '', $num = 9, $pageNum = '1'){
		$pageNum = empty($pageNum) ? 1 : $pageNum;
		$toall = ceil($count/$size);
		$toall_str = '';
		if($pageNum > $toall)$pageNum = $toall;
		$str = '';
		$pre = ($pageNum <= 1) ? '<a href="'.str_replace('{page}', 1, $url).'"><span class="btn"> &lt; 上一页 </span></a>' : '<a href="'.str_replace('{page}', $pageNum-1, $url).'"><span class="btn"> &lt; 上一页 </span></a>';
		$next = ($pageNum >= $toall) ? '<a href="'.str_replace('{page}', $toall, $url).'"><span class="btn">下一页 &gt;</span></a>' : '<a href="'.str_replace('{page}', $pageNum+1, $url).'"><span class="btn">下一页 &gt;</span></a>';
		if($toall <= $num){
			for($i=1;$i<=$toall;$i++){
				if($pageNum == $i){
					$str .= '<span class="btn disabled">'.$i.'</span>';
				}else{
					$str .= '<a href="'.str_replace('{page}', $i, $url).'"><span class="btn">'.$i.'</span></a>';
				}
			}
			if($toall<=1){
				return;
			}else{
				return '<div class="fenye">'.$pre.$str.$next.$toall_str.'</div>';
			}
		}
		if(($toall - $pageNum) > ceil($num/2) && $pageNum < ceil($num/2)){
			for($i=1;$i<=$num;$i++){
				if($pageNum == $i){
					$str .= '<span class="btn disabled">'.$i.'</span>';
				}else{
					$str .= '<a href="'.str_replace('{page}', $i, $url).'"><span class="btn">'.$i.'</span></a>';
				}
			}
	
			if($toall<=1){
				return;
			}else{
				return '<div class="fenye">'.$pre.$str.$next.$toall_str.'</div>';
			}
		}
		if(($toall - $pageNum) < ceil($num/2)){
			for($i = ($toall - $num + 1);$i <= $toall;$i++){
				if($pageNum == $i){
					$str .= '<span class="btn disabled">'.$i.'</span>';
				}else{
					$str .= '<a href="'.str_replace('{page}', $i, $url).'"><span class="btn">'.$i.'</span></a>';
				}
			}
			return '<div class="fenye">'.$pre.$str.$next.$toall_str.'</div>';
		}
		for($i = ($pageNum -  floor($num/2));$i <= ($pageNum + floor($num/2));$i++){
			if($pageNum == $i){
				$str .= '<span class="btn disabled">'.$i.'</span>';
			}else{
				$str .= '<a href="'.str_replace('{page}', $i, $url).'"><span class="btn">'.$i.'</span></a>';
			}
		}
		if($toall<=1){
			return;
		}else{
			return '<div class="fenye">'.$pre.$str.$next.$toall_str.'</div>';
		}
	}
	
	/*
	 * Name : 回调函数
	 */
	public static function insert_func_array($controller_arr){
		$fun_arr = isset($controller_arr['fun_arr']) ? $controller_arr['fun_arr'] : array();
		$clss = new $controller_arr['name']();		
		call_user_func_array(array(& $clss, $controller_arr['method'].'_Action'), $fun_arr);
	}
	
	function __autoload($class_name, $type = 'Helper/', $dbname = 0) {
		if(file_exists(LIB.$type.$class_name.EXT)){
			require_once LIB.$type.$class_name.EXT;
			//$objects_m[$class_name] = ($type == 'Model/') ? $class_name::get_instance($dbname) : new $class_name();//new $class_name();//
			$objects_m[$class_name] = ($type == 'Model/') ? new $class_name($dbname) : new $class_name();//new $class_name();
			return $objects_m[$class_name];
		}else{
			return FALSE;
		}
	}
	
	
	public function s_send($address, $name, $title, $content, $replace_arr = array(), $type = 'default'){
		$temp = file_get_contents('static/mail/'.$type.'.html');
		$mailObj = $this->load_model('QCMS_Mail');
		$rs = $mailObj->selectOne();
		$mail = new PHPMailer();
		$mail->IsSMTP();					// 启用SMTP
		$mail->Host = $rs['smtp'];			//SMTP服务器
		$mail->SMTPAuth = true;				//开启SMTP认证
		$mail->Username = $rs['account'];		// SMTP用户名
		$mail->Password =  $rs['password'];			// SMTP密码
		$mail->From =  $rs['send'];			//发件人地址
		$mail->FromName = $rs['username'];		//发件人
		$mail->AddAddress($address, $name);
		$mail->AddReplyTo($mail->Username, $mail->FromName);	//回复地址
		$mail->WordWrap = 50;							//设置每行字符长度
		$mail->IsHTML(true);					// 是否HTML格式邮件
		$mail->CharSet = "utf-8";				// 这里指定字符集！
		$mail->Encoding = "base64";
	
		$search_sys = array('{title}', '{content}', '{date}', '{time}', '{webname}', '{host}', '{username}');
		$replace_sys = array($title, $content, date('Y-m-d'), date('Y-m-d H:i:s'), $this->web['webname'], 'http://'.WEB_DOMAIN, $name);
		foreach($replace_arr as $key => $val){
			$search_sys[] = '{'.$key.'}';
			$replace_sys[] = $val;
		}
		$str = str_replace($search_sys, $replace_sys, $temp);
		$mail->Subject = $title;			//邮件主题
		$mail->Body    = $str;				//邮件内容
		$mail->AltBody = $str;				//邮件正文不支持HTML的备用显示
		if(!$mail->Send()){
			return False;
		}
			return TRUE;

	}
	
	public function categoryArr($module_id = 0, $pid = 0){
		$cateObj = $this->load_model('QCMS_Category');
		$condArr = empty($module_id) ? array() : array('module_id' => $module_id);
		if(!empty($pid)){
			$condArr['pid'] = $pid;
		}
		$allRs = $cateObj->select($condArr, '*', 0, '', '', array('sort' => 'ASC'));
		$this->cateALLArr = array();
		foreach($allRs as $k => $v){
			if($v['pid'] == 0){
				$this->cateALLArr[$v['id']] = $v;
				$this->cateALLArr[$v['id']]['sub'] = self::_subCategoryArr($v['id'], $allRs);
			}
		}
		return;
	}
	
	private function _subCategoryArr($pid, $allRs = array()){
		$cateArr = array();
		foreach($allRs as $k => $v){
			if($v['pid'] == $pid){
				$cateArr[$v['id']] = $v;
				$cateArr[$v['id']]['sub'] = self::_subCategoryArr($v['id'], $allRs);
			}
		}
		return $cateArr;
	}
	
	/*
	 * name :: 以下是前台模版调用
	 */
	
	public function getClass($pid = 0, $module_id = 0){
		$cateObj = $this->load_model('QCMS_Category');
		$condArr = array('pid' => $pid, 'display' => 1);
		if(!empty($module_id)){
			$condArr['module_id'] = $module_id;
		}
		$rs = $cateObj->select($condArr, '*', 0, '', '', array('sort' => 'ASC'));
		$tempArr = array();
		foreach($rs as $k => $v){
			$tempArr[$k] = $v;
			$tempArr[$k]['module'] = $this->moduleArrUrl[$v['module_id']];
		}
		return $tempArr;
	}
	
	public function getNews($cid = 0, $row = 10, $module_id = 1, $page = 0, $url = '', &$pageHtml = ''){
		$newsObj = $this->load_model('QCMS_News');
		$productObj = $this->load_model('QCMS_Product');
		$downObj = $this->load_model('QCMS_Down');
		$albumObj = $this->load_model('QCMS_Album');
		$cateObj = $this->load_model('QCMS_Category');
		if(empty($cid) && empty($module_id)) return array();
		if(empty($module_id)){
			$cateRs = $cateObj->selectOne(array('id' => $cid), 'id, module_id, pid');
		}else{
			$cateRs = array('id' => $cid, 'module_id' => $module_id);
		}
		$count = 0;
		$offset = ($page <= 0) ? 0 : ($page - 1) * $row;
		$cidStr = self::getCateByModeule($cateRs['module_id'], $cateRs['id']);
		$cidArr = explode('|', $cidStr);
		$condArr = array('cid' => $cidArr);//-- 递归 --
		switch ($module_id){
			case 2:
				$newsArr = $downObj->selectAll(array($offset, $row), $count, $condArr,  '*');				
				break;
			case 3:
				$newsArr = $albumObj->selectAll(array($offset, $row), $count, $condArr,  '*');
				break;
			case 4:
				$newsArr = $productObj->selectAll(array($offset, $row), $count, $condArr,  '*');
				break;
			default:
				$newsArr = $newsObj->selectAll(array($offset, $row), $count, $condArr,  '*');
				break;
		}

		$pageHtml = $this->page_bar($count[0]['count'], $row, $url, 9, $page);
		return $newsArr;
	}
	
	public function getTag($name = ''){
		$tagObj = $this->load_model('QCMS_Tag');
		$rs = $tagObj->selectOne(array('tag_name' => $name));
		return $rs['content'];
	}
	
	public function getCateInfo($cid = 0, $module_id = 0){
		$cateObj = $this->load_model('QCMS_Category');
		if(empty($cid)){
			return $cateObj->selectOne(array('module_id' => $module_id, 'pid' => 0));
		}else{
			return $cateObj->selectOne(array('id' => $cid));
		}		
	}
	
	public function getMenu($sort = 'DESC'){
		$cateObj = $this->load_model('QCMS_Category');
		return $cateObj->select(array('pid' => 0), '*', 0, '', '', array('sort' => $sort));
	}
	
	public function getCateByModeule($module_id = 1, $pid = 0){
		$cateObj = $this->load_model('QCMS_Category');
		$cateRs = $cateObj->select(array('module_id' => $module_id), 'id, module_id, pid');
		$str = $pid.'|';
		foreach($cateRs as $k => $v){
			if($v['pid'] != $pid) continue;
			$str .= $v['id'].'|';
			$str .= self::_subCateByModeule($v['id'], $cateRs);
		}
		return $str;
	}
	
	public function getSlideshow(){
		$slideshowObj = $this->load_model('QCMS_Slideshow');
		return $slideshowObj->select('', '*', 0, '', '', array('sort' => 'ASC', 'id' => 'ASC'));
	}
	
	private function _subCateByModeule($pid = 0, $allRs = array()){
		$str = '';
		foreach($allRs as $k => $v){
			if($pid != $v['pid']) continue;
			$str .= $v['id'].'|';
			$str .= self::_subCateByModeule($v['id'], $allRs);
		}
		return $str;
	}
}
?>