//不允许输入中文
var engOnly=function(str){
	for(i=0;i<str.length;i++){
		var c = str.substr(i,1);
		var ts = escape(c);
		if(ts.substring(0,2) == "%u"){
			return false;
		} else {
			return true;
		}
	}
}

//电子邮件验证
var emailOnly=function(str){
	var regEmail=/^([a-z0-9]+[-_\.]?[a-z0-9]*)+@([a-z0-9]+[\.])+[a-z0-9]+$/;
	if (regEmail.test(str)){
		return true;
	} else {
		return false;
	}
}

//手机号码验证
var mobileOnly=function(str){
	var regMobile=/^0{0,1}(13[0-9]|14[0-9]|15[0-9]|18[0-9])[0-9]{8}$/;
	if (regMobile.test(str)){
		return true;
	} else {
		return false;
	}
}

//纯数字验证
var numOnly=function(str){
	var regNum=/^[0-9]{1,20}$/;
	if (regNum.test(str)){
		return true;
	} else {
		return false;
	}
}

//电话号码验证
var telOnly=function(str){
	var regTel=/^\({0,1}[0-9]{3}\){0,1}\-\({0,1}[0-9]{4}\){0,1}\-[0-9]{7,}$|^\({0,1}[0-9]{4}\){0,1}\-[0-9]{7,}$|^[0-9]{7,}$/;
	if (regTel.test(str))
		return true;
	else
		return false;
}

//日期的验证
var dateOnly=function(str){
	var date_array=str.split('-');
	if (date_array.length!=3) return false;
	var y=date_array[0];
	var m=date_array[1];
	var d=date_array[2];
	if (!numOnly(y)||!numOnly(m)||!numOnly(d)) return false;
	if (y.length!=4||m.length!=2||d.length!=2) return false;
	y=Number(y);
	m=Number(m);
	d=Number(d);
	if (y<1900||y>2050||m<1||m>12||d<1||d>31) return false;
	if ((m==4||m==6||m==9||m==11)&&d>30) return false;
	if ((y%100!=0&&y%4==0)||y%400==0){
		if (m==2&&d>29) return false;
	} else {
		if (m==2&&d>28) return false;
	}
	return true;
}

//密码强度检测
function passwordGrade(pwd) {
	var score = 0;
	var regexArr = ['[0-9]', '[a-z]', '[A-Z]', '[\\W_]'];
	var repeatCount = 0;
	var prevChar = '';
	//check length
	var len = pwd.length;
	score += len > 18 ? 18 : len;
	//check type
	for (var i = 0, num = regexArr.length; i < num; i++) { if (eval('/' + regexArr[i] + '/').test(pwd)) score += 4; }
	//bonus point
	for (var i = 0, num = regexArr.length; i < num; i++) {
		if (pwd.match(eval('/' + regexArr[i] + '/g')) && pwd.match(eval('/' + regexArr[i] + '/g')).length >= 2) score += 2;
		if (pwd.match(eval('/' + regexArr[i] + '/g')) && pwd.match(eval('/' + regexArr[i] + '/g')).length >= 5) score += 2;
	}
	//deduction
	for (var i = 0, num = pwd.length; i < num; i++) {
		if (pwd.charAt(i) == prevChar) repeatCount++;
		else prevChar = pwd.charAt(i);
	}
	score -= repeatCount * 1;
	return score;
 }
 
 
//表单提交
function formSubmit(){
	
	//密码安全问题
	if ($(this).is('#formSafety')){
		if ($('#selectSafety').find('option:selected').text()=='- 选择一个问题 -'){
			dialogError('safty', 'no', '请先选择一个问题', '', 'removeThis');
			return false;
		}
	}
	
	//检测是否所需表单均已填写
	var itemRequired=$(this).find('input.required,select.required,textarea.required');
	for (var i=0;i<itemRequired.length;i++){
		var theItem=itemRequired.eq(i);
		var value=$.trim(theItem.val());
		if (value==''||value==null){
			var row=theItem.parent().parent();
			var msg=row.find('div.msg');
			if (msg.find('p').length<1){
				msg.append('<p></p>');
			}
			msg.removeClass().addClass('msg msg-error').find('p').text('此项为必填项');
		}
	}
	//判断是否需要 check内容
	var itemChecked=$(this).find('input.needChecked');
	var cou = itemChecked.length;
	for(var i=0; i<cou; i++){
		var theItem=itemChecked.eq(i);
		var value=$.trim(theItem.val());
		if(theItem.attr("class").indexOf('v-mobile') != -1){//验证电话号码
			if(value && value!=null && !mobileOnly(value)){
				var row=theItem.parent().parent();
				var msg=row.find('div.msg');
				if (msg.find('p').length<1){
					msg.append('<p></p>');
				}
				msg.removeClass().addClass('msg msg-error').find('p').text('请输入13/14/15/18开头的手机号码');
			}
		}
		if(theItem.attr("class").indexOf('v-email') != -1){//验证email
			if(value && value!=null && !emailOnly(value)){
				var row=theItem.parent().parent();
				var msg=row.find('div.msg');
				if (msg.find('p').length<1){
					msg.append('<p></p>');
				}
				msg.removeClass().addClass('msg msg-error').find('p').text('电子邮箱格式不正确');
			}
		}
	}
	
	//密码安全问题
	if ($(this).is('#formSafety')){
		var custom=$('#rowSafetyCustom input');
		var answer=$(this).find('input[name="safety_a"]').val();
		if (custom.attr('disabled')==false){
			if (custom.val()==answer){
				dialogError('safty', 'no', '问题和答案的内容不能相同', '', 'removeThis');
				return false;
			}
		}
	}
	
	//检测是否有填写错误
	var msgError=$(this).find('div.msg-error');
	if (msgError.length>1||(msgError.length==1&&!msgError.parent().is('.row-submit'))){
		return false;
	}
	
	//ajax提交
	if ($(this).is('.form-ajax')){
		if ($(this).is('.form-disabled')) return false;
		var arr=[];
		var i=0;
		$(this).find('input[name!=""]').each(function (){
			if (this.disabled || (this.checked==false && (this.type=="checkbox" || this.type=="radio"))){
			}else{
				arr[i++] = this.name+'='+$(this).val();
			}
		});
		$(this).find('select[name!=""]').each(function (){
			arr[i++] = this.name+'='+$(this).val();
		});
		$(this).find('textarea[name!=""]').each(function (){
			arr[i++] = this.name+'='+$(this).val();
		});
		var str = arr.join('&');
		var method=$(this).attr('method');
		var url=$(this).attr('action');
		var theButton=$(this).find('button[type="submit"]');
		if (theButton.length<1){
			theButton=$(this).parents('div.dialog1').find('div.ft button').eq(0);
		}
		theButton.attr('disabled', true);
		$(this).addClass('form-disabled');
		var theForm=$(this);
		$('#dialog-error-form1').remove();
		$.ajax({
			type: method,
			url: url,
			data: str+'&data[ajaxsubmit]=1',
			dataType: 'json',
			error: function(){
				theButton.removeAttr('disabled');
				theForm.removeClass('form-disabled');
				dialogError('form1', 'no', '操作失败', '服务器连接失败，请重试', 'removeSelf');
				var imgCaptcha=theForm.find('img.img-captcha');
				imgCaptcha.attr('src', imgCaptcha.attr('rel')+Math.random());
			},
			success: function(callback){
				if (callback.status=='success'){
					if (callback.dowhat=='direct'){
						location.href=callback.url;
					}
				} else if (callback.status=='failed'){
					theButton.removeAttr('disabled');
					theForm.removeClass('form-disabled');
					var imgCaptcha=theForm.find('img.img-captcha');
					imgCaptcha.attr('src', imgCaptcha.attr('rel')+Math.random());
					if (document.getElementById('callback-reg-email')){
						$('#callback-reg-email').removeClass().addClass('msg msg-error').html('<span class="icon">.</span><p>'+callback.msg+'</p>');
					} else {
						dialogError('form1', 'no', '操作失败', callback.msg, 'removeSelf');
					}
				}
			}
		});
		return false;
	}

	//邮箱的email找回密码提交
	if ($(this).is('#email_form_id')){
		var step = 1;
		var email = $("#ipt-email").val();
		var code = $("#for-verity").val();
		$.ajax({
			type: 'post',
			url:  '/users/RecoverPassword_n/byemail/step:1',
			data: 'data[email]='+email+"&data[code]="+code,
			dataType: 'json',
			error: function(){
				alert('服务器发送错误, 请稍后再提交!');
			} ,
			success: function (data){
				//alert(data);
				if(data.status == 'failed_1'){//email 错误
					var row=$("#ipt-email").parent().parent();
					var msg=row.find('div.msg');
					if (msg.find('p').length<1){
						msg.append('<p></p>');
					}
					msg.removeClass().addClass('msg msg-error').find('p').text(data.msg);
				} else if(data.status == 'failed_2'){//验证码 错误
					var row=$("#for-verity").parent().parent();
					var msg=row.find('div.msg');
					if (msg.find('p').length<1){
						msg.append('<p></p>');
					}
					msg.removeClass().addClass('msg msg-error').find('p').text(data.msg);
				} else {//成功
					location.href="/users/emailSuccess";
				}
			}
		});
		return false;
	}
}


//表单验证与输入提示
function iptBlur(which){
	if (which.is('.v-captcha')) return false;
	var value=which.val();
	var valueTrim=$.trim(value);
	var row=which.parent().parent();
	var msg=row.find('div.msg');
	if (msg.find('p').length<1){
		msg.append('<p></p>');
	}
	var tips=row.find('div.tips').text();
	var msgError=msg.attr('rev');
	if(msgError==''||!msgError) msgError=msg.attr('title');
	if(msgError==''||!msgError) msgError=msg.find('p').text();
	if(msgError==''||!msgError) msgError=tips;
	if(msgError==''||!msgError) msgError='';
	var textReg=which.attr('rec');
	if(textReg==''||!textReg) textReg='';
	if(value=='可不填'||value==''||which.is('.v-verity')){
		msg.removeClass().addClass('msg').find('p').html('');
		/*
		if (which.is('.js-verity')){
			$('#'+which.attr('rev')).addClass('btndisabled');
		}
		*/
	} else if(which.is('.v-length')&&textReg!=''&&(valueTrim.length<Number(textReg.split(',')[0])||valueTrim.length>Number(textReg.split(',')[1]))){
		msg.removeClass().addClass('msg msg-error').find('p').html(msgError);
	} else if(which.is('.v-username')&&(valueTrim.length<5||valueTrim.length>20)){
		msg.removeClass().addClass('msg msg-error').find('p').html(msgError);
	} else if(which.is('.v-clone')&&$('#'+which.attr('rev')).val()!=value){
		msg.removeClass().addClass('msg msg-error').find('p').text('两次输入不一致');
	} else if(which.is('.v-email')&&value!=''&&value!=null&&!emailOnly(value)){
		msg.removeClass().addClass('msg msg-error').find('p').text('电子邮箱格式不正确');
		if (which.is('.js-verity')){
			$('#'+which.attr('rev')).addClass('btndisabled');
		}
	} else if(which.is('.v-number')&&!numOnly(value)){
		msg.removeClass().addClass('msg msg-error').find('p').html(msgError);
	} else if(which.is('.v-tel')&&!telOnly(value)){
		msg.removeClass().addClass('msg msg-error').find('p').html(msgError);
	} else if(which.is('#js-verity-v2') && document.getElementById("btn-verity-v2")){
		if (mobileOnly(value)){
			$('#btn-verity-v2').removeClass('btn-disabled');
			msg.removeClass().addClass('msg').find('p').remove();
		} else {
			$('#btn-verity-v2').addClass('btn-disabled');
			msg.removeClass().addClass('msg msg-error').find('p').html('请输入13/14/15/18开头的手机号码');
		}
	} else if(which.is('.v-mobile')&&!mobileOnly(value)){
		msg.removeClass().addClass('msg msg-error').find('p').html('请输入13/14/15/18开头的手机号码');
	} else if(which.is('.v-date')&&!dateOnly(value)){
		msg.removeClass().addClass('msg msg-error').find('p').html(msgError);
	} else if(which.is('.v-ajax')){
		var url=which.attr('rel')+value;
		msg.removeClass().addClass('msg msg-loading').find('p').text('检测中...');
		which.attr('readonly', true);
		$.ajax({
			url: url,
			dataType: 'json',
			cache: false,
			error: function(){
				which.attr('readonly', false);
				msg.removeClass().addClass('msg msg-error').find('p').html('检测失败，请重试');
			},
			success: function(data){
				which.attr('readonly', false);
				if (data.status=='failed'){
					msg.removeClass().addClass('msg msg-error').find('p').html(data.msg);
				}
				if (data.status=='success'){
					msg.removeClass().addClass('msg msg-ok').find('p').html(data.msg);
				}
			}
		});
	} else {
		msg.removeClass().addClass('msg msg-ok').find('p').html('');
		if(which.is('.v-clone2')&&$('#'+which.attr('rev')).val()!=''&&$('#'+which.attr('rev')).val()!=value){
			$('#'+which.attr('rev')).parent().next().removeClass().addClass('msg msg-error').find('p').text('两次输入不一致');
		}
	}
}


$(function(){
	
	
	//密码安全问题：自定义问题
	$('#selectSafety').change(function(){
		var which=$(this).find('option:selected');
		var customContainer=$('#rowSafetyCustom');
		var inputAnswer=$(this).parents('form').find('input[name="safety_a"]');
		if (which.text()=='- 选择一个问题 -'){
			inputAnswer.attr('disabled', true);
		} else {
			inputAnswer.attr('disabled', false);
		}
		if (which.is('.custom')){
			customContainer.show().addClass('required');
			customContainer.find('input').attr('disabled', false).addClass('required');
		} else {
			customContainer.hide().removeClass('required').find('div.msg').removeClass('msg-error').find('p').text('');
			customContainer.find('input').attr('disabled', true).removeClass('required');
		}
	});

	
	
	//刷新验证码
	$('#captcha img, #captcha a').click(function(){
		$('#captcha img').attr('src', $('#captcha img').attr('rel')+'?'+Math.random());
		$(this).parent().prev().find('input').val('').focus();
		return false;
	});
	
	//验证码大写
	$("#for-verity").keyup(function(a){$(this).val($(this).val().toUpperCase())});

	//表单验证与输入提示
	$('form.form-v input.text,form.form-v textarea').blur(function(){
		var thisInput=$(this);
		setTimeout(function(){iptBlur(thisInput);}, 10);
	});
	$('form.form-v input.text,form.form-v textarea').focus(function(){
		var row=$(this).parent().parent();
		var msg=row.find('div.msg');
		if (msg.find('p').length<1){
			msg.append('<p></p>');
		}
		var msgAttention=msg.attr('title');
		if(msgAttention&&msgAttention!=''){
			msg.removeClass().addClass('msg msg-attention').find('p').html(msgAttention);
		}
	});
	//表单提交
	
	$('form.form-v').submit(formSubmit);
	
	//发送验证码
	var veritySend=function(){
		if (!document.getElementById('btn-verity-send')) return false;
		$('#btn-verity-send').click(function(){
			if ($(this).is('.btndisabled')||$(this).is('.btnloading')) return false;
			if (!$(this).next().is('.callback')){
				$(this).after('<span class="callback"></span>');
			}
			var msgBox=$(this).next();
			var ipt=$(this).parent().parent().parent().find('input');
			var value=ipt.val();
			$(this).addClass('btndisabled btnloading');
			$(this).prev().remove();
			msgBox.text('正在发送...');
			var theBtn=$(this);
			$.ajax({
				url: $(this).attr('rel')+value,
				dataType: 'json',
				cache: false,
				error: function(s, msg){
					msgBox.text('检测失败，请重试');
					theBtn.removeClass('btndisabled btnloading').find('.btn').text('发送验证码');
				},
				success: function(data){
					msgBox.text('');
					if (data.status=='failed'){
						msgBox.html('<div class="msg-error" style="width: 350px;float:left;"><span class="red">'+data.msg+'</span></div>');
						theBtn.removeClass('btndisabled btnloading').find('.btn').text('发送验证码');
					}
					if (data.status=='success'){
						theBtn.removeClass('btnloading').find('.btn').html('<span id="btn-verity-send-timer">60</span> 秒后可重新发送');
						theBtn.before(data.msg);
						var timerVerity;
						timerVerity=setInterval(function(){
							var box=$('#btn-verity-send-timer');
							var num=Number(box.text());
							if (num<1){
								clearInterval(timerVerity);
								theBtn.removeClass('btndisabled btnloading').find('.btn').text('重新发送验证码');
								//theBtn.prev().remove();
							} else {
								box.text(num-1);
							}
						}, 1000);
					}
				}
			});
			return false;
		});
	}
	veritySend();
	
	$('#js-verity').keyup(function(){
		var theBtn=$('#btn-verity-send');
		var txt=theBtn.find('.btn').text();
		if (txt=='发送验证码'||txt=='重新发送验证码'){
			var value=$(this).val();
			if (($(this).is('.v-mobile')&&mobileOnly(value)) || ($(this).is('.v-email')&&emailOnly(value))){
				theBtn.removeClass('btndisabled');
			} else {
				theBtn.addClass('btndisabled');
			}
		}
	});
	$('#js-verity').keyup();
	
	//密码强度检测
	if (document.getElementById('js-pwd-strength')){
		$('#ipt-pwd').keyup(function(){
			var value=$(this).val();
			var box=$('#js-pwd-strength');
			if (value==''||value==null){
				box.removeClass().addClass('strength').text('请输入');
				return false;
			} else if (value.length<6){
				box.removeClass().addClass('strength').text('密码过短');
			} else {
				var score=passwordGrade(value);
				if (score<11){
					box.removeClass().addClass('strength').text('不安全');
				} else if (score<21){
					box.removeClass().addClass('strength strength-weak').text('安全程度：低');
				} else if (score<31){
					box.removeClass().addClass('strength strength-ok').text('安全程度：中');
				} else if (score>30){
					box.removeClass().addClass('strength strength-strong').text('安全程度：高');
				}
			}
		}).focus(function(){
			$('#js-pwd-strength').show();
		}).blur(function(){
			$('#js-pwd-strength').hide();
		});
	}
	
	//字符数检测
	var txtLengthDetectReset=function(){
		var fields=$('form.form-v textarea.v-length-detect, form.form-v input.v-length-detect');
		for (var i=0;i<fields.length;i++){
			var _field=fields.eq(i);
			var _num=_field.val().length;
			_field.parents('div.row').find('strong.length-detect').text(_num);
		}
	}
	txtLengthDetectReset();
	$('form.form-v textarea.v-length-detect, form.form-v input.v-length-detect').keyup(function(){
		var _num=$(this).val().length;
		$(this).parents('div.row').find('strong.length-detect').text(_num);
	});
	
	
	
});