(function(){var html5_tag='section,article,aside,header,footer,nav,dialog,figure,mark',arr=html5_tag.split(',');for(var i=arr.length;i--;){document.createElement(arr[i]);}})();

/**
 * Cookie plugin
 *
 * Copyright (c) 2006 Klaus Hartl (stilbuero.de)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 */

/**
 * Create a cookie with the given name and value and other optional parameters.
 *
 * @example $.cookie('the_cookie', 'the_value');
 * @desc Set the value of a cookie.
 * @example $.cookie('the_cookie', 'the_value', { expires: 7, path: '/', domain: 'jquery.com', secure: true });
 * @desc Create a cookie with all available options.
 * @example $.cookie('the_cookie', 'the_value');
 * @desc Create a session cookie.
 * @example $.cookie('the_cookie', null);
 * @desc Delete a cookie by passing null as value. Keep in mind that you have to use the same path and domain
 *       used when the cookie was set.
 *
 * @param String name The name of the cookie.
 * @param String value The value of the cookie.
 * @param Object options An object literal containing key/value pairs to provide optional cookie attributes.
 * @option Number|Date expires Either an integer specifying the expiration date from now on in days or a Date object.
 *                             If a negative value is specified (e.g. a date in the past), the cookie will be deleted.
 *                             If set to null or omitted, the cookie will be a session cookie and will not be retained
 *                             when the the browser exits.
 * @option String path The value of the path atribute of the cookie (default: path of page that created the cookie).
 * @option String domain The value of the domain attribute of the cookie (default: domain of page that created the cookie).
 * @option Boolean secure If true, the secure attribute of the cookie will be set and the cookie transmission will
 *                        require a secure protocol (like HTTPS).
 * @type undefined
 *
 * @name $.cookie
 * @cat Plugins/Cookie
 * @author Klaus Hartl/klaus.hartl@stilbuero.de
 */

/**
 * Get the value of a cookie with the given name.
 *
 * @example $.cookie('the_cookie');
 * @desc Get the value of a cookie.
 *
 * @param String name The name of the cookie.
 * @return The value of the cookie.
 * @type String
 *
 * @name $.cookie
 * @cat Plugins/Cookie
 * @author Klaus Hartl/klaus.hartl@stilbuero.de
 */
jQuery.cookie = function(name, value, options) {
    if (typeof value != 'undefined') { // name and value given, set cookie
        options = options || {};
        if (value === null) {
            value = '';
            options.expires = -1;
        }
        var expires = '';
        if (options.expires && (typeof options.expires == 'number' || options.expires.toUTCString)) {
            var date;
            if (typeof options.expires == 'number') {
                date = new Date();
                date.setTime(date.getTime() + (options.expires * 24 * 60 * 60 * 1000));
            } else {
                date = options.expires;
            }
            expires = '; expires=' + date.toUTCString(); // use expires attribute, max-age is not supported by IE
        }
        // CAUTION: Needed to parenthesize options.path and options.domain
        // in the following expressions, otherwise they evaluate to undefined
        // in the packed version for some reason...
        var path = options.path ? '; path=' + (options.path) : '';
        var domain = options.domain ? '; domain=' + (options.domain) : '';
        var secure = options.secure ? '; secure' : '';
        document.cookie = [name, '=', encodeURIComponent(value), expires, path, domain, secure].join('');
    } else { // only name given, get cookie
        var cookieValue = null;
        if (document.cookie && document.cookie != '') {
            var cookies = document.cookie.split(';');
            for (var i = 0; i < cookies.length; i++) {
                var cookie = jQuery.trim(cookies[i]);
                // Does this cookie string begin with the name we want?
                if (cookie.substring(0, name.length + 1) == (name + '=')) {
                    cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                    break;
                }
            }
        }
        return cookieValue;
    }
};

//灰色背景
(function($){
    $.extend({
        documentMask: function(options){
            var op = $.extend({
                opacity: 0.7,
                z: 50,
                bgcolor: '#fff'
            }, options);
            $('<div id="jquery_addmask" class="jquery_addmask">&nbsp;</div>').appendTo(document.body).css({
                position: 'absolute',
                top: '0px',
                left: '0px',
                'z-index': op.z,
                width: document.documentElement.clientWidth,
                height: $(document).height(),
                'background-color': op.bgcolor,
                opacity: 0
            }).fadeIn('fast', function(){
                $(this).fadeTo('fast', op.opacity);
            }).click(function(){
            });

            return this;
        }
    });
})(jQuery);

//是否支持placeholder属性
function supports_input_placeholder(){ 
	var i = document.createElement('input'); 
	return 'placeholder' in i; 
}

//表单序列化
function formSerialize(which){
	var arr=[];
	var i=0;
	which.find('input[name!=""]').each(function (){
		if (this.disabled || (this.checked==false && (this.type=="checkbox" || this.type=="radio"))){
		}else{
			arr[i++] = this.name+'='+encodeURIComponent($(this).val());
		}
	});
	which.find('select[name!=""]').each(function (){
		arr[i++] = this.name+'='+encodeURIComponent($(this).val());
	});
	which.find('textarea[name!=""]').each(function (){
		arr[i++] = this.name+'='+encodeURIComponent($(this).val());
	});
	var str = arr.join('&');
	return str;
}


/*=====================================
 * Global
 *=====================================*/

//警告确认框
function overlayC(hook, mask, msg, width, confirmTxt, cancelTxt, doCancel){
	$('#overlay-c-'+hook).remove();
	if (mask=='yes'&&!document.getElementById('jquery_addmask')){
		$.documentMask();
	}
	if (!width||width=='') var width=285;
	if (!mask||mask=='') var mask='';
	if (!confirmTxt||confirmTxt=='') var confirmTxt='确定';
	if (!cancelTxt||cancelTxt=='') var cancelTxt='取消';
	if (!doCancel||doCancel=='') var doCancel='removeSelf';
	width=Number(width);
	var _top=($(window).height()-150)/2+document.documentElement.scrollTop+document.body.scrollTop;
	if (_top<0) _top=0;
	var _left=(width+10)/2;
	$('<div id="overlay-c-'+hook+'" class="ol-operatetips overlay-c" style="width:'+width+'px;margin-left:-'+_left+'px;top:'+_top+'px;"><a id="overlay-c-close-'+hook+'" class="close" href="javascript:void(0);" title="'+cancelTxt+'">'+cancelTxt+'</a><div class="box"><div class="content"><div id="overlay-c-msg-'+hook+'" class="msg-s">'+msg+'</div></div><div class="footer"><a title="'+confirmTxt+'" href="javascript:void(0);" class="btn btn-positive" id="overlay-c-confirm-'+hook+'">'+confirmTxt+'</a> <a title="'+cancelTxt+'" href="javascript:void(0);" class="btn" id="overlay-c-cancel-'+hook+'">'+cancelTxt+'</a></div></div></div>').appendTo(document.body);
	//$('#overlay-c-'+hook).bgiframe();
	if (doCancel=='removeThis'){
		$('#overlay-c-close-'+hook).click(function(){
			$('#jquery_addmask, #overlay-c-'+hook).remove();
			return false;
		});
	}
	if (doCancel=='removeSelf'){
		$('#overlay-c-close-'+hook).click(function(){
			$('#overlay-c-'+hook).remove();
			return false;
		});
	}
	$('#overlay-c-cancel-'+hook).click(function(){
		$('#overlay-c-close-'+hook).click();
		return false;
	});
}



//登录弹出框
function dialogLogin(dowhat, checkurl){
	if (document.getElementById('jquery_addmask')) return false;
	$.documentMask();
	var _dowhat=dowhat;
	var showLogin=function(){
		var _top=($(window).height()-($('#dialog-login').height()+2))/2+document.documentElement.scrollTop+document.body.scrollTop;
		if (_top<0) _top=0;
		$('#dialog-login').css({
			'top': _top+'px',
			'visibility': 'visible'
		});
		$('#dialog-login-cancel').click(function(){
			$('#dialog-login, #jquery_addmask').remove();
			$('#btn-fav').removeClass('fav-loading');
			return false;
		});
		//js-focus元素	
		if (!supports_input_placeholder()){
			var iptId=$('#ipt-login-id');
			iptId.addClass('grey').attr('value', iptId.attr('placeholder'));
			iptId.focus(function(){
				var _txt=$(this).attr('placeholder');
				if ($(this).val()==_txt){
					$(this).removeClass('grey').val('');
				}
			});
			iptId.blur(function(){
				var _txt=$(this).attr('placeholder');
				if ($(this).val()==''){
					$(this).addClass('grey').val(_txt);
				}
			});
		}
		$('#captcha img, #captcha a').click(function(){
			$('#captcha img').attr('src', $('#captcha img').attr('rel')+'?'+Math.random());
			$(this).parent().prev().find('input').val('').focus();
			return false;
		});
		$('#dialog-login-form').submit(function(){
			
			$(this).prev().remove();
			var iptId=$('#ipt-login-id');
			var iptPwd=$('#ipt-login-pwd');
			var _id=iptId.val();
			var pwd=iptPwd.val();
			if (!_id||$.trim(_id)==''||_id==iptId.attr('placeholder')){
				$(this).before('<div class="w-msg w-msg-error"><span class="icon">.</span><p>请输入账号！</p></div>');
				iptId.focus();
				return false;
			}
			if (!pwd||$.trim(pwd)==''){
				$(this).before('<div class="w-msg w-msg-error"><span class="icon">.</span><p>请输入密码！</p></div>');
				iptPwd.focus();
				return false;
			}
			var _data='data[username]='+_id+'&data[password]='+pwd;
			var iptCaptcha=$('#ipt-captcha');
			if (iptCaptcha.length>0){
				var captcha=iptCaptcha.val();
				if (!captcha||$.trim(captcha)==''){
					$(this).before('<div class="w-msg w-msg-error"><span class="icon">.</span><p>请输入验证码！</p></div>');
					iptCaptcha.focus();
					return false;
				} else {
					_data+=('&data[code]='+captcha);
				}
			}
			var _action = $(this).attr('action');
			var url = (typeof _action === 'string') ? $.trim(_action) : '';
			url = url || window.location.href || '';
			if (url) {
				// clean url (don't include hash vaue)
				url = (url.match(/^([^#]+)/)||[])[1];
			}
			$.ajax({
				url: url,
				type: 'post',
				data: _data,
				dataType: 'text',
				cache: false,
				success: function(data){
					if (data=='logged already'){
						_dowhat();
					} else {
						$('#dialog-login').replaceWith(data);
						showLogin();
					}
				}
			});
			return false;
		});
	}
	$.ajax({
		url: checkurl,
		//url: 'data/dialog-login.html',
		dataType: 'text',
		cache: false,
		success: function(data){
			if (data=='logged already'){
				_dowhat();
			} else {
				$('body').prepend(data);
				showLogin();
			}
		}
	});
}

function listHover(){
	$(this).addClass('hover').siblings().removeClass('hover');
}
$(function(){
	//按钮的hover效果
	/*
	$('button').hover(function(){
		$(this).addClass('hover');
	}, function(){
		$(this).removeClass('hover');
	});
	*/
	//简介收缩展开
	$('#bd a.indent-show').click(function(){
		$(this).parent().hide().next().show();
	});
	$('#bd a.indent-hide').click(function(){
		$(this).parent().hide().prev().show();
	});
	
	//输入元素的placeholder属性	
	if (!supports_input_placeholder()){
		var iptFocusReset=function(){
			var ipt=$('input.placeholder, textarea.placeholder');
			for (var i=0;i<ipt.length;i++){
				var placeholder=ipt.eq(i).attr('placeholder');
				if (placeholder&&placeholder!=''){
					ipt.eq(i).addClass('grey').attr('value', placeholder);
				}
			}
		}
		iptFocusReset();
		$('input.placeholder, textarea.placeholder').focus(function(){
			var _txt=$(this).attr('placeholder');
			if ($(this).val()==_txt){
				$(this).removeClass('grey').val('');
			}
		});
		$('input.placeholder, textarea.placeholder').blur(function(){
			var _txt=$(this).attr('placeholder');
			if ($(this).val()==''){
				$(this).addClass('grey').val(_txt);
			}
		});
	}
	
	//翻页
	(function(){
		if (!document.getElementById('js-page-jump')) return false;
		$('#js-page-jump').click(function(){
			var page=$.trim($(this).parent().find('input').val());
			if (!page||page==''){
				alert('请输入页码');
				return false;
			}
			var _reg=/^[0-9]{1,20}$/;
			if (!_reg.test(page)||Number(page)<1){
				alert('页码必须为正整数');
				return false;
			}
			window.location.href=$(this).attr('rel')+':'+page+$(this).attr('rev');
		});
	})();
	
	//在线客服
	(function(){
		if (!document.getElementById('float-contact')) return false;
		var floatContact=$('#float-contact');
		var floatContactMini=$('#float-contact-mini').parent();
		if ($.cookie('float-contact')=='open'){
			floatContact.show();
			floatContactMini.hide();
		}
		if(!window.XMLHttpRequest){
			$(window).scroll(function(){
				floatContact.css({'top': document.documentElement.scrollTop+document.body.scrollTop+200+'px'});
				floatContactMini.css({'top': document.documentElement.scrollTop+document.body.scrollTop+200+'px'});
			});
		} else {
			floatContact.css({
				'position': 'fixed',
				'top': '200',
				'right': '1px'
			});
			var setPosition=function(){
				//var _right=($(window).width()-980)/2-107;
				//floatContact.css('right', _right+'px');
			}
			setPosition();
			$(window).resize(setPosition);
			floatContactMini.css({
				'position': 'fixed',
				'right': '1px'
			});
		}
		var _date=Date().split(' ');
		_date[2]=Number(_date[2])+7;
		_date=_date.join(' ');
		$('#float-contact-mini').click(function(){
			floatContact.show();
			floatContactMini.hide();
			$.cookie('float-contact', 'open', {expires: _date, path: '/'});
			return false;
		});
		$('#float-contact-close').click(function(){
			floatContact.hide();
			floatContactMini.show();
			$.cookie('float-contact', 'close', {expires: _date, path: '/'});
			return false;
		});
	})();
	
	//banner
	(function(){
		if (!document.getElementById('j-slider-list')) return false;
		$('#j-slider-close').click(function(){
			if (timerBanner) clearTimeout(timerBanner);
			$(this).parent().remove();
		});
		$('#j-slider-ctrl em').fadeTo('fast', 0.8);
		var theSlider=$('#j-slider-list');
		var itemWidth=theSlider.parent().height();
		var timerBanner=null;
		$('#j-slider-ctrl li').mouseenter(function(){
			if (timerBanner) clearTimeout(timerBanner);
			if ($(this).is('.current')) return false;
			var itemSerial=$(this).prevAll().length;
			theSlider.animate({
				top: -itemSerial*itemWidth+'px'
			}, 200);
			$(this).addClass('current').siblings().removeClass('current');
			timerBanner=setTimeout(bannerSlide1Auto, 5000);
			return false;
		});
		var bannerSlide1Auto=function(){
			var itemNow=$('#j-slider-ctrl li.current');
			if (itemNow.nextAll().length<1){
				$('#j-slider-ctrl li').eq(0).mouseenter();
			} else {
				itemNow.next().mouseenter();
			}
		}
		$('#j-slider-ctrl li').eq(0).mouseenter();
	})();
	
	//回到顶部
	(function(){
		if (!document.getElementById('j-roll-btn')) return false;
		$('#j-roll-btn').hide();
		$(window).scroll(function() {
			var st = $(document).scrollTop(),winh = $(window).height();
			if($(window).scrollTop() >= 200){
				$('#j-roll-btn').fadeIn(300);
			}
			else{
				$('#j-roll-btn').fadeOut(200);
			}
			if (!window.XMLHttpRequest) {
				$('#j-roll-btn').css("top", st + winh - 105);    
			}
	 	});
	  	$('#j-roll-btn a').click(function(){$('html,body').animate({scrollTop: '0px'}, 100);});
	})();
	
	//搜索下拉菜单
	(function(){
		if (!document.getElementById('j-search-select')) return false;
		$('#j-search-select p').click(function(){
			$(this).next().show();
		});
		$('#j-search-select').mouseleave(function(){
			$(this).find('ul').hide();
		});
		$('#j-search-select a').click(function(){
			var _box=$(this).parent();
			var _list=_box.parent();
			var _val=$(this).attr('j_val');
			if (_box.is('.current')){
				_list.hide();
				return false;
			}
			_box.addClass('current').siblings().removeClass('current');
			_list.hide().prev().text($(this).text());
			$(this).parents('#j-search-form').attr('action', _val);
			return false;			
		});
	})();
});

/*=====================================
 * Index
 *=====================================*/
$(function(){
	//Tab切换
	$('#j-tabview-1 a').mouseenter(function(){
		var n=Number($(this).attr('rel'));
		var list=$(this).parent().parent().parent().next().find('ul');
		list.eq(n).show().siblings().hide();
		$(this).parent().addClass('current').siblings().removeClass('current');
	});
	
	//右侧边栏热度排行的相关效果
	$('#j-charts-designers li, #j-charts-apps li, #j-charts-case li').mouseenter(listHover);
	
	//实时载入交易动态
	(function(){
		if (!document.getElementById('j-trade-record')) return false;
		var _record=$('#j-trade-record');
		setInterval(function(){
			$.ajax({
				url: _record.attr('j_load'),
				data: 'latest='+_record.attr('j_latest'),
				dataType: 'json',
				success: function(data){
					if (data.status=='success'){
						_record.attr('j_latest', data.latest);
						_record.find('tr').removeClass('update');
						for (var i=0;i<data.data.length;i++){
							_record.prepend('<tr class="update"><td class="amount">'+data.data[i].amount+'</td><td class="subject">'+data.data[i].subject+'</td><td class="type">'+data.data[i].type+'</td></tr>');
						}
						//_record.find('tr.update').fadeIn('normal');
					}
				}
			});
		}, 3000);
	})();
	
	//帮我挑选
	(function(){
		if (!document.getElementById('j-start-tab')) return false;
		//下拉菜单去除边框
		$('#j-start-ind-1, #j-start-ind-2').find('li').last().addClass('last');
		//切换
		$('#j-start-tab li').mouseenter(function(){
			if ($(this).is('.current')) return false;
			var _t=$(this).find('span');
			var _box=$('#j-start-box');
			var _rel=$(this).attr('rel').split('|');
/*			if (_t.is('.pack-1')){
				_box.removeClass().addClass('box box-1');
			} else if (_t.is('.pack-2')){
				_box.removeClass().addClass('box box-2');
			} else if (_t.is('.pack-3')){
				_box.removeClass().addClass('box box-3');
			}
*/			$('#j-start-slogan').text($(this).attr('title'));
			$('#j-start-sales').text(_rel[2]);
			$('#j-start-price').text(_rel[1]);
			$('#ipt-start-pack').val(_rel[0]);
			$(this).addClass('current').siblings().removeClass('current');
			if (!document.getElementById('j-tplpreview-msg')){
				$('#j-start-submit').after('<div id="j-tplpreview-msg" class="msg"></div>');
			}
			var _msg=$(this).attr('j_msg');
			var _msgUrl=$(this).attr('j_link');
			if (_msg && _msg!=''){
				if (_msgUrl && _msgUrl!=''){
					$('#j-tplpreview-msg').html('<a class="orange" href="'+_msgUrl+'" title="'+_msg+'" target="_blank">'+_msg+'</a>');
				} else {
					$('#j-tplpreview-msg').html('<span class="orange">'+_msg+'</span>');
				}
			} else {
				$('#j-tplpreview-msg').empty();
			}
		});
		

		$('#j-start-ind-2 p').click(function(){
			if ($(this).is('.grey')) return false;
			$(this).next().show();
		});
		$('#j-start-ind-2').mouseleave(function(){
			$(this).find('ul').hide();
		});
		$('#j-start-ind-2 ul li a').click(function(){
			$('#j-start-ind-2').find('ul').hide();
			$('#j-start-ind-2 p').text($(this).attr('title'));
			$('#ipt-start-ind').attr("value" , $(this).attr('j_val'));
		});

		
		//颜色
		$('#j-start-color li').hover(function(){
			$(this).children('span').addClass('hover');
		},function(){
			$(this).children('span').removeClass('hover');	
		});
		$('#j-start-color li').click(function(){
			$(this).parent().next().val($(this).attr('j_val'));
			$(this).children('span').addClass('current').parent().siblings().children('span').removeClass('current');
		});
		
		//提交
		$('#j-start-submit').click(function(){
			$(this).parent().parent().submit();
			return false;
		});
	})();
	
	//滚动动态
	/*
	(function(){
		if (!document.getElementById('j-rolling-ctrl')) return false;
		var intRolling;
		intRolling=setInterval(function(){
			$('#j-rolling-ctrl a').eq(1).click();
		}, 3000);
		var box=$('#j-rolling-list');
		var list=box.find('li');
		box.prepend(list.eq(-1)).css('top', '-29px');
		list=box.find('li');
		$('#j-rolling-ctrl a').click(function(){
			var _ctrl=$(this).parent();
			if (_ctrl.attr('j_active')=='yes') return false;
			_ctrl.attr('j_active', 'yes');
			if ($(this).is('.down')){
				list.eq(0).animate({
					'margin-top': '-29px'
				}, 'slow', '', function(){
					box.append(list.eq(0));
					list=box.find('li');
					list.eq(-1).show().css('margin-top', '0');
					_ctrl.attr('j_active', 'no');
				});
			} else if ($(this).is('.up')){
				list.eq(-1).hide();
				box.prepend(list.eq(-1));
				list=box.find('li');
				list.eq(0).slideDown('slow', function(){
					_ctrl.attr('j_active', 'no');
				});
			}
			return false;
			clearInterval(intRolling);
			intRolling=setInterval(function(){
				$('#j-rolling-ctrl a').eq(1).click();
			}, 3000);
		});
	})();
	*/
	
	//滚动公告
	(function(){
		if (!document.getElementById('j-rollingnews')) return false;
		var box=$('#j-rollingnews');
		var list=box.find('li');
		box.prepend(list.eq(-1)).css('top', '-36px');
		list=box.find('li');
		
		var intRolling;
		intRolling=setInterval(function(){
			list.eq(0).animate({
				'margin-top': '-36px'
			}, 'slow', '', function(){
				box.append(list.eq(0));
				list=box.find('li');
				list.eq(-1).show().css('margin-top', '0');
			});
		}, 3000);
	})();
	
	//滚动友情链接
	(function(){
		if (!document.getElementById('j-friendlylink')) return false;
		var box=$('#j-friendlylink');
		var list=box.find('li');
		box.prepend(list.eq(-1)).css('top', '-38px');
		list=box.find('li');
		
		var intRolling;
		intRolling=setInterval(function(){
			list.eq(0).animate({
				'margin-top': '-38px'
			}, 'slow', '', function(){
				box.append(list.eq(0));
				list=box.find('li');
				list.eq(-1).show().css('margin-top', '0');
			});
		}, 3000);
	})();
});

/*=====================================
 * Trade
 *=====================================*/

$(function(){
	//确认订单信息
	(function(){
		if (!document.getElementById('f-trade-detail')) return false;
		var iptCoupon=$('#ipt-coupon');
		var iptAgree=$('#ipt-agreement');
		
		$('#j-form-callback a.close').click(function(){
			$('#j-form-callback').hide();
		});
		$('#f-trade-detail').submit(function(){

			var _callbackBox=$('#j-form-callback');
			_callbackBox.hide();
		});
		
		iptAgree.click(function(){
			if ($(this).attr('checked')){
				$(this).prev().remove();
			}
		});
		
		var count_num = 0;
		iptCoupon.click(function(){
			count_num = count_num+1;
			if (count_num == 1){
				$(this).val('');
			}
			
		});
		
		//域名的选择
		var timerDomain=null;
		$('#j-trade-item-domain').hover(function(){
			if (timerDomain) clearTimeout(timerDomain);
			$(this).addClass('box-domain-hover');
		}, function(){
			var this1=$(this);
			timerDomain=setTimeout(function(){
				this1.removeClass('box-domain-hover');
			}, 1000);
		});
		
		var loadPrice=function(){
			var _url=$('#f-trade-detail').attr('j_url');
			var _data=formSerialize($('#f-trade-detail'));
			$.ajax({
				url: _url,
				data: _data,
				dataType: 'json',
				success: function(data){
					if (data.status=='success'){
						$('#j-trade-total').text(data.total);						
						$('#j-trade-amount').text(data.amount);
					}
				}
			});
		}
		
		//获取2,3年与1年的价格差
		var getDomainPrice = function(year){
			var j_year_1 = $("li[j_year='1']").attr('j_price');//获取第一年的价格
			var j_year_2 = $("li[j_year='2']").attr('j_price');//获取第一年的价格
			var j_year_3 = $("li[j_year='3']").attr('j_price');//获取第一年的价格
			if(year == 2){
				return Number(j_year_2) - Number(j_year_1);
			} else if(year == 3){
				return Number(j_year_3) - Number(j_year_1);
			} else {
				return 0;
			}
		}
		
		//套餐模板的价格
		var getPackagePrice = function(template_id,package_limit,package_id){
			httpPrice=$.ajax({
				url: '/demo/get_price_new/'+template_id+'/'+package_limit+'/'+package_id,
				dataType: 'json',
				cache: false,
				error: function(){
					return 0;
				},
				success: function(data){
					//以下计算域名的价格
					$('#f-trade-detail').attr('action','/packages/do_buy/?data[Template][id]='+template_id+'&data[Package][id]='+package_id+'&data[years]='+package_limit);
					$('#j-btn-checkcoupon').attr('j_check','/packages/check_coupon/'+template_id+'/'+package_id+'/'+package_limit);
					$('#package_one_price').text(data.package.one_price);
					$('#package_price').text(data.package.price);
					if(data.package.pmt_price == 0){
						$('#package_years').text('');
						$('#package_pmt_price').text('');
						$('#pmt').text('');
					}else{
						$('#package_years').text(data.package.period+'年优惠');
						$('#package_pmt_price').text(data.package.pmt_price+'元');
					}
					var trade_amount = 0;//原来实付款
					var memc_code_val = $("input[name='memc_code']").val();
					if($('#ipt-domain').attr('checked')){//有选择
						var domain_price = Number($('#j-domain-price').text());//当前域名价格
						if(memc_code_val && memc_code_val.length > 0){//有优惠码,则只是增加域名费用,第一年免费
							//取原来实付款
							trade_amount = Number($("#j-trade-amount").text());
							if(now_year != 1){//原来的不是1, 则需要减去域名价格差
								var old_trade_amount = trade_amount - getDomainPrice(now_year);
								trade_amount = getDomainPrice(new_year) + old_trade_amount;
							} else {
								trade_amount = getDomainPrice(new_year) + trade_amount;
							}
						}
					} else {
						var domain_price = 0;
					}
					if(memc_code_val){//有优惠码
						$('#j-trade-amount').text(trade_amount);
					} else {
						var total_price = Number(data.package.price) + Number(data.template.pay_price) + domain_price;
						total_price = $.FormatMoney(total_price);
						$('#j-trade-total').text(total_price);					
						$('#j-trade-amount').text(total_price);
					}
				}
			});
		}
		
		/**
		 * 货币格式化
		 */
		$.FormatMoney = function($cell) {  
			 var reg = /[\$,%]/g;  
			 var key = parseFloat( String($cell).replace(reg, '')).toFixed(2); // toFixed小数点后两位  
			 return isNaN(key) ? 0.00 : key;  
		};  

		
		var loadPrice_new=function(now_year,new_year){//统计总价
			//套餐模板的价格
			var package_id = $('#j-opt-package li.current').attr('j_val');
			var package_limit = $('#j-tplpreview-limit li.current').attr('j_val');
			var template_id = $('#j-tplpreview-showname').attr('j_id');
			getPackagePrice(template_id,package_limit,package_id);
		}
		
 		var totalprice=function(){
			var domain_price = $('#j-domain-price').text();
			var package_price = $('#package_price').text();
			var temp_price = $('#template_price').text();
			var total = 0;
			if ($('#ipt-domain').attr('checked')){
				total = Number(domain_price) + Number(package_price) + Number(temp_price);
			}
			else{
				total = Number(package_price) + Number(temp_price);
			}
			$('#j-trade-amount').text($.FormatMoney(total));
		}

		//初始加载总数
		$(function(){
			totalprice();
		});

		$('#ipt-domain').click(function(){		
			if ($(this).attr('checked')){
				$('#j-opt-year').find('p.grey').removeClass('grey');
				$('#j-opt-year').find('input').attr('disabled', false);
				$("#hidden_domain").val('on');
			} else {
				$('#j-opt-year').find('p').addClass('grey');
				$('#j-opt-year').find('input').attr('disabled', true);
				$("#hidden_domain").val('');
			}
			var now_year = parseInt($("#j-opt-year p").html());//取当前是第几年
			totalprice();
			//loadPrice_new(now_year,0);//优惠码需要重新输入
		});
		
		//周期的选择
		$('#j-opt-year p').click(function(){
			if( $(this).is('.grey') ){
				return false;	
			}
			$(this).next().show();
		});
		$('#j-opt-year').mouseleave(function(){
			$(this).find('ul').hide();
		});
		$('#j-opt-year a').click(function(){
			var now_year = parseInt($("#j-opt-year p").html());//取当前是第几年
			var _box=$(this).parent();
			var _list=_box.parent();
			var _year=_box.attr('j_year');
			var _price=_box.attr('j_price');
			_box.addClass('current').siblings().removeClass('current');
			_list.hide().prev().text($(this).text());
			$(this).parents('div.fakeselect').find('input').val(_year);
			$('#j-domain-price').text(_price);
			totalprice();
			//loadPrice_new(now_year,_year);
			return false;
		});
		
		//套餐的选择		
		// $('#j-opt-package p').click(function(){
		// 	if( $(this).is('.grey')){
		// 		return false;	
		// 	}
		// 	$(this).next().show();
		// });
		// $('#j-opt-package').mouseleave(function(){
		// 	$(this).find('ul').hide();
		// });
		// $('#j-opt-package a').click(function(){
		// 	var _box=$(this).parent();
		// 	var _list=_box.parent();
		// 	_box.addClass('current').siblings().removeClass('current');
		// 	_list.hide().prev().text($(this).text());
		// 	var now_year = parseInt($("#j-opt-year p").html());//取当前是第几年
		// 	var _year=_box.attr('j_year');
		// 	var _price=_box.attr('j_price');
		// 	$('#package_price').text(_price);
		// 	//loadPrice_new(now_year,_year);
		// 	return false;
		// });
		
		//套餐的年数选择
		$('#j-tplpreview-limit p').click(function(){
			if( $(this).is('.grey') ){
				return false;	
			}
			$(this).next().show();
		});
		$('#j-tplpreview-limit').mouseleave(function(){
			$(this).find('ul').hide();
		});
		$('#j-tplpreview-limit a').click(function(){
			var _box=$(this).parent();
			var _list=_box.parent();
			_box.addClass('current').siblings().removeClass('current');
			_list.hide().prev().text($(this).text());
			var now_year = parseInt($("#j-opt-year p").html());//取当前是第几年
			var _year=_box.attr('j_year');
			var _price=_box.attr('j_price');
			$(this).parents('div.fakeselect').find('input').val(_year);
			$('#package_price').text(_price);
			totalprice();
			return false;
		});
		
		//选择网站
		if (document.getElementById('j-trade-choosesite')){
			$('#j-trade-choosesite p').click(function(){
				$('#tip-trade-choosesite').remove();
				$(this).next().show();
			});
			$('#j-trade-choosesite').mouseleave(function(){
				$(this).find('ul').hide();
			});
			$('#j-trade-choosesite a').click(function(){
				var _box=$(this).parent();
				var _list=_box.parent();
				$('#ipt-site').val(_box.attr('j_val'));
				_box.addClass('current').siblings().removeClass('current');
				_list.hide().prev().text($(this).text());
				return false;
			});
		}
		
	})();
	
	//订单详情
	(function(){
		if (!document.getElementById('j-order-view')) return false;
		$('#j-order-view').click(function(){
			$('#j-order-tips').parent().fadeIn();	
		});
		$('#j-order-tips').click(function(){
			$(this).parent().hide();	
		});
	})();
	
	//在线付款
	(function(){
		if (!document.getElementById('f-trade-onlinepay')) return false;
		//选择银行
		$('#j-bank-choose').click(function(){
			$(this).next().show();
		}).parent().mouseleave(function(){
			$(this).children().eq(-1).hide();
		});
		$('#j-bank-opt a').click(function(){
			var _value=$(this).attr('j_val');
			var _bank=$(this).text();
			$('#ipt-bank').val(_value);
			$('#j-bank-choose').html('<p class="bank-'+_value+'">'+_bank+'</p>');
			$('#j-bank-opt').hide();
			$('#j-bank-limit').empty();
			$.ajax({
				url: '/finances/payment_quota/'+_value,
				dataType: 'text',
				success: function(data){
					$('#j-bank-limit').html(data);
				}
			});
			return false;
		});
		$('#f-trade-onlinepay').submit(function(){
			
			if (document.getElementById('jquery_addmask')) return false;
			
			var need_verified = $("#ipt-need-verified").val();//是否需要手机验证
			if (document.getElementById('ol-mobilevalidate') && need_verified == '1'){
				var _top=($(window).height()-238)/2+document.documentElement.scrollTop+document.body.scrollTop;
				$('#ol-mobilevalidate').css({
					'top': _top+'px',
					'visibility': 'visible'
				});
				return false;
			}
			$.documentMask();

			var bankname=$('#j-bank-choose p').text();
			var bankabbr=$('#ipt-bank').val();
			var amount=$('#j-txt-amount').text();
			if (!document.getElementById('ol-onlinepay')){
				$('body').append('<div id="ol-onlinepay" class="overlay ol-onlinepay"><div class="clearfix o-hd"><h2>登录网上银行付款</h2><a id="ol-onlinepay-close" class="close" href="javascript:void(0);" title="关闭">关闭</a></div><div class="o-bd"><div class="note"><span class="large">请您在新打开的网上银行页面上完成充值。</span><a id="ol-onlinepay-return" class="hlight underline" href="javascript:void(0);" title="返回重新选择">重新选择充值方式</a></div><ul class="info"><li class="clearfix">充值金额： <strong class="larger orange">'+amount+'</strong>元</li><li class="clearfix"><span class="item">选择支付方式：</span><span class="bank bank-'+bankabbr+'">'+bankname+'</span></li></ul><div class="operate">您可以选择： <a class="hlight underline" href="/member/trades" title="">已完成付款</a> <a class="hlight underline" href="/helps/lists/166" title="">付款遇到问题</a></div></div></div>');
				var _top=($(window).height()-244)/2+document.documentElement.scrollTop+document.body.scrollTop;
				if (_top<0) _top=0;
				$('#ol-onlinepay').css({
					'top': _top+'px',
					'visibility': 'visible'
				});
				$('#ol-onlinepay-close, #ol-onlinepay-return').click(function(){
					$('#ol-onlinepay, #jquery_addmask').remove();
					return false;
				});
			}
		});
	})();
	
	//检测手机
	(function(){
		if (!document.getElementById('ol-mobilevalidate')) return false;
		var _http1=null;
		var _http2=null;
		var _int=null;
		$('#ol-mobilevalidate-close').click(function(){
			if (_http1) _http1.abort();
			if (_http2) _http2.abort();
			if (_int) clearInterval(_int);
			$('#ipt-mobilevalidate-mobile, #ipt-mobilevalidate-verify').val('');
			$('#btn-mobilevalidate-send').addClass('btn-disabled').attr('title', '点击发送验证码').text('点击发送验证码');
			$(this).parent().parent().css('visibility', 'hidden').find('blockquote').remove();
			$('#jquery_addmask').remove();
			return false;
		});
		
		var iptMobile=$('#ipt-mobilevalidate-mobile');
		var btnSend=$('#btn-mobilevalidate-send');
		
		var regMobile=/^0{0,1}(13[0-9]|14[0-9]|15[0-9]|18[0-9])[0-9]{8}$/;
		if (!regMobile.test(iptMobile.val())){
			btnSend.addClass('btn-disabled');
		}
		
		iptMobile.focus(function(){
			if ($(this).parent().next().is('blockquote')){
				$(this).parent().next().remove();
			}
			$(this).parent().after('<blockquote class="helper">请输入验证手机号码</blockquote>');
		}).blur(function(){
			var container=$(this).parent();
			if (container.next().is('blockquote')){
				container.next().remove();
			}
			var value=$(this).val();
			var txt=btnSend.text();
			if ($.trim(value)==''){
				btnSend.addClass('btn-disabled');
			} else if (!regMobile.test(value)){
				container.after('<blockquote class="error">手机号码格式不对</blockquote>');
				btnSend.addClass('btn-disabled');
			} else if(txt=='重新发送验证码' || txt=='点击发送验证码') {
				btnSend.removeClass('btn-disabled');
			}
		}).keyup(function(){
			var value=$(this).val();
			var txt=btnSend.text();
			if (regMobile.test(value) && (txt=='重新发送验证码' || txt=='点击发送验证码')){
				btnSend.removeClass('btn-disabled');
			} else {
				btnSend.addClass('btn-disabled');
			}
		});
		
		$('#ipt-mobilevalidate-verify').focus(function(){
			if ($(this).parent().next().is('blockquote')){
				$(this).parent().next().remove();
			}
			$(this).parent().after('<blockquote class="helper">请输入6位数字验证码</blockquote>');
		}).blur(function(){
			var container=$(this).parent();
			if (container.next().is('blockquote')){
				container.next().remove();
			}
			var value=$(this).val();
			var _reg=/^[0-9]{1,20}$/;
			if ((!_reg.test(value) || value.length!=6) && $.trim(value)!=''){
				container.after('<blockquote class="error">验证码只能是六位数字</blockquote>');
			}
		});
		
		//发送验证码
		btnSend.click(function(){
			if ($(this).is('.btn-disabled')) return false;
			var mobile=iptMobile.val();
			$(this).addClass('btn-disabled').attr('title', '发送中...').text('发送中...');
			_http1=$.ajax({
				url: $(this).attr('j_url'),
				data: 'mobilenumber='+mobile,
				dataType: 'json',
				cache: false,
				error: function(){
					
				},
				success: function(data){
					if (data.status=='failed'){
						
						alert(data.msg.replace(/<.*?>/g,""));
						if (regMobile.test(iptMobile.val())){
							btnSend.removeClass('btn-disabled');
						}
						btnSend.attr('title', '重新发送验证码').text('重新发送验证码');
					}
					if (data.status=='success'){
						alert(data.msg.replace(/<.*?>/g,""));
						btnSend.attr('title', '').html('<span>60</span>秒后可重新发送');
						
						_int=setInterval(function(){
							var _countdown=btnSend.find('span');
							var s=Number(_countdown.text());
							s--;
							if (s>0){
								_countdown.text(s);
							} else {
								if (regMobile.test(iptMobile.val())){
									btnSend.removeClass('btn-disabled');
								}
								btnSend.attr('title', '重新发送验证码').text('重新发送验证码');
							}
						}, 1000);
					}
				}
			});
			return false;
		});
		
		//确认付款
		$('#btn-mobilevalidate-confirm').click(function(){
			$('#ol-mobilevalidate-form').submit();
			return false;
		});
		
		$('#ol-mobilevalidate-form').submit(function(){
			if (_http2) _http2.abort();
			if ($(this).find('blockquote').length>0) return false;
			var ipt=$(this).find('input[type="text"]');
			for (var i=0;i<ipt.length;i++){
				if ($.trim(ipt.eq(i).val())==''){
					ipt.eq(i).focus();
					return false;
				}
			}
			var mobile=ipt.eq(0).val();
			var verify=ipt.eq(1).val();
			
			var method=$(this).attr('method');
			if (!method || method=='') method='get';
			var _action = $(this).attr('action');
			var url = (typeof _action === 'string') ? $.trim(_action) : '';
			url = url || window.location.href || '';
			if (url) {
				// clean url (don't include hash vaue)
				url = (url.match(/^([^#]+)/)||[])[1];
			}
			
			_http2=$.ajax({
				type: method,
				url: url,
				data: 'data[mobilenumber]='+mobile+'&data[smsvalidate]='+verify+'&data[type]=json',
				dataType: 'json',
				error: function(){
					
				},
				success: function(data){
					if (data.status=='failed'){
						var _div=$('#ipt-mobilevalidate-verify').parent();
						if (!_div.next().is('blockquote')){
							_div.after('<blockquote class="error"></div>');
						}
						_div.next().html(data.msg);
					}
					if (data.status=='success'){
						$('#ol-mobilevalidate, #jquery_addmask').remove();
						$('#f-trade-onlinepay button[type="submit"]').before('<div class="red">手机验证成功，请继续付款！</div>');
					}
				}
			});
			return false;
		});
	})();
	
	//创建账号
	(function(){
		if (!document.getElementById('f-trade-newbie')) return false;
		$('#ipt-username').parent().next().html('<div id="j-username-check" class="hide msg msg-loading">正在检测，请稍候</div><div id="j-username-callback" class="hide msg-error"><em>.</em><p></p></div><div id="j-username-ok" class="hide msg msg-ok"></div>');
		$('#ipt-password').parent().next().html('<div id="j-password-tip" class="hide msg">由6-16个非连续性的数字/字母/下划线组成</div><div id="j-password-error" class="hide msg-error"><em>.</em><p>由6-16个非连续性的数字/字母/下划线组成</p></div>');
		var _http=null;
		$('#ipt-username').blur(function(){
			var value=$(this).val();
			if (value && $.trim(value)!=''){
				$('#j-username-check').removeClass('hide');
				if (_http) _http.abort();
				_http=$.ajax({
					url: $(this).attr('j_check'),
					data: 'username='+value,
					dataType: 'json',
					cache: false,
					success: function(data){
						if (data.status=='success'){
							$('#j-username-check').addClass('hide');
							$('#j-username-ok').removeClass('hide').html(data.msg);
						}
						if (data.status=='failed'){
							$('#j-username-check').addClass('hide');
							$('#j-username-callback').removeClass('hide').find('p').html(data.msg);
						}
					}
				});
			}
		});
		$('#ipt-username').focus(function(){
			$('#j-username-callback, #j-username-ok, #j-username-check').addClass('hide');
			if (_http) _http.abort();
		});
		$('#ipt-password').focus(function(){
			$('#j-password-error').addClass('hide');
			$('#j-password-tip').removeClass('hide');
		}).blur(function(){
			$('#j-password-tip').addClass('hide');
			if ($(this).val().length<6){
				$('#j-password-error').removeClass('hide');
			}
		});
		$('#f-trade-newbie').submit(function(){
			if (!$('#j-username-callback').is('.hide') || !$('#j-username-check').is('.hide')) return false;
			var username=$('#ipt-username');
			if (!username.val() || $.trim(username.val())==''){
				username.focus();
				return false;
			}
			if (!$('#j-password-error').is('.hide')) return false;
			var password=$('#ipt-password');
			if (!password.val() || $.trim(password.val())==''){
				password.focus();
				return false;
			}
		});
	})();
	
	//评价
	(function(){
		if (!document.getElementById('f-trade-rate')) return false;
		$('#f-trade-rate ul.rate-star input').val('');
		$('#f-trade-rate ul.rate-star a').hover(function(){
			var _serial=Number($(this).text());
			if (!$(this).parent().next().is('.des')){
				$(this).parent().after('<span class="des"></span');
			}
			var _des=$(this).parent().next();
			var _list=$(this).parent().find('a');
			_list.removeClass('selected');
			for (var i=0;i<_serial;i++){
				_list.eq(i).addClass('selected');
			}
			_des.html('<span class="orange">'+_serial+'.0</span> '+$(this).attr('title'));
		}, function(){
			var _current=Number($(this).parent().find('input').val());
			var _list=$(this).parent().find('a');
			_list.removeClass('selected');
			var _des=$(this).parent().next();
			if (!_current || _current==0){
				_des.empty();
			} else {
				for (var i=0;i<_current;i++){
					_list.eq(i).addClass('selected');
				}
				_des.html('<span class="orange">'+_current+'.0</span> '+_list.eq(_current-1).attr('title'));
			}
		}).click(function(){
			$(this).parent().find('input').val($(this).text());
			$(this).blur();
			return false;
		});
		
		//评价列表
		if (document.getElementById('j-l-trade-rate')){
			$('#j-l-trade-rate td.score').hover(function(){
				$(this).find('div.overlay-tip').show();
				$(this).find('div.box-score').css('z-index', '10');
			}, function(){
				$(this).find('div.overlay-tip').hide();
				$(this).find('div.box-score').css('z-index', '0');
			});
			$('#j-l-trade-rate tr:even').addClass('odd');
		}
	})();
	
	//倒计时
	(function(){
		if (!document.getElementById('j-trade-countdown')) return false;
		setInterval(function(){
			var sec=$('#j-trade-countdown span.sec');
			var minute=$('#j-trade-countdown span.minute');
			var hour=$('#j-trade-countdown span.hour');
			var day=$('#j-trade-countdown span.day');
			var s=Number(sec.text());
			var m=Number(minute.text());
			var h=Number(hour.text());
			var d=Number(day.text());
			if (s==0&&m==0&&h==0&&d==0) return false;
			if (s<1){
				s=59;
				if (m<1){
					m=59;
					if (h<1){
						if (d<1){
							
						} else {
							h=23;
							d--;
						}
					} else {
						h--;
					}
				} else {
					m--;
				}
			} else {
				s--;
			}
			if (s<10) s='0'+s;
			if (m<10) m='0'+m;
			if (h<10) h='0'+h;
			sec.text(s);
			minute.text(m);
			hour.text(h);
			day.text(d);
		}, 1000);
	})();
	
	//确认订单
	$('#btn-trade-confirm').click(function(){
		overlayC('trade-confirm', 'yes', '确认交易完成后资金将自动转入服务商账户。您确定要付款吗？', '360', '', '', 'removeThis');
		$('#overlay-c-confirm-trade-confirm').click(function(){
			$('#f-trade-confirm').submit();
			return false;
		});
		return false;
	});
});


/*=====================================
 * Product
 *=====================================*/

//翻页
var proPager1=function(which){
	var this1=which;
	var _url=$(this1).parent().parent().parent().attr('j_load').split(' ');
	$.ajax({
		url: _url[0]+$(this1).attr('j_page')+_url[1],
		dataType: 'text',
		cache: false,
		success: function(data){
			$(this1).parent().parent().parent().parent().parent().html(data);
		}
	});
	return false;
}

var proPager2=function(which){
	var this1=which;
	var _url=$(this1).parent().attr('j_load').split(' ');
	var page=$.trim($(this1).find('input').val());
	if (!page||page==''){
		alert('请输入页码');
		return false;
	}
	var _reg=/^[0-9]{1,20}$/;
	if (!_reg.test(page)||Number(page)<1){
		alert('页码必须为正整数');
		return false;
	}
	var source=_url[0]+page+_url[1];
	$.ajax({
		url: source,
		dataType: 'text',
		cache: false,
		success: function(data){
			$(this1).parent().parent().parent().html(data);
		}
	});
	return false;
}

$(function(){
	//详细信息的tab切换
	(function(){
		if (!document.getElementById('j-proview-tag')) return false;
		$('#j-proview-tag a').click(function(){
			var _tab=$(this).parent();
			if (_tab.is('.current')) return false;
			var s=_tab.prevAll().length;
			var container=$('#j-proview-loader-'+s);
			container.show().siblings().hide();
			if (container.find('div.loading').length>0){
				var url=$(this).attr('j_load');
				$.ajax({
					url: url,
					dataType: 'text',
					cache: false,
					success: function(data){
						container.html(data);
					}
				});
			}
			
			_tab.addClass('current').siblings().removeClass('current');

			return false;
		});
	})();
	
	//购买模板的相关选项与价格变化
	(function(){
		if (!document.getElementById('j-tpl-price')) return false;
		$('#j-opt-limit a').click(function(){
			if ($(this).is('.current')) return false;
			var _data=$(this).attr('j_price').split(',');
			var priceOrigin;
			var priceNow;
			var priceSave;
			if (_data.length==1){
				priceOrigin=0;
				priceNow=_data[0];
				priceSave=0;
			} else if (_data.length==2){
				priceOrigin=0;
				priceNow=_data[0];
				priceSave=_data[1];
			} else if (_data.length==3){
				priceOrigin=_data[0];
				priceNow=_data[1];
				priceSave=_data[2];
			}
			if (priceOrigin==0&&priceSave==0){
				$('#j-tpl-price').html('<tr class="price"><th>价　　格：</th><td><div class="clearfix box"><span class="amount"><strong class="larger2">'+priceNow+'</strong> 元</span></div></td></tr>');
			} else if (priceOrigin==0){
				$('#j-tpl-price').html('<tr class="price"><th>价　　格：</th><td><div class="clearfix box"><span class="amount"><strong class="larger2">'+priceNow+'</strong> 元</span> <span class="greenarrow"><span class="inner">节省'+priceSave+'元</span></span></div></td></tr>');
			} else {
				$('#j-tpl-price').html('<tr><th>价　　格：</th><td><span class="linethrough">'+priceOrigin+'</span> 元</td></tr><tr class="price"><th>促　　销：</th><td><div class="clearfix box"><span class="amount"><strong class="larger2">'+priceNow+'</strong> 元</span> <span class="greenarrow"><span class="inner">节省'+priceSave+'元</span></span></div></td></tr>');
			}
			$('#j-tpl-order').attr('j_data', '&data[Package][id]='+$('#j-opt-package li.current').attr('j_val')+'&data[years]='+$(this).attr('j_val'));
			$(this).addClass('current').siblings().removeClass('current');
			return false;
		});
		$('#j-opt-package p').click(function(){
			$(this).next().show();
		});
		$('#j-opt-package').mouseleave(function(){
			$(this).find('ul').hide();
		});
		$('#j-opt-package a').click(function(){
			var _box=$(this).parent();
			var _list=_box.parent();
			if (_box.is('.current')){
				_list.hide();
				return false;
			}
			var _data=_box.attr('j_data').split('|');
			for (var i=0;i<_data.length;i++){
				$('#j-opt-limit a').eq(i).attr('j_price', _data[i]);
			}
			_box.addClass('current').siblings().removeClass('current');
			_list.hide().prev().text($(this).text());
			$('#j-opt-limit a.current').removeClass('current').click();
			return false;
		});
		$('#j-tpl-order').click(function(){
			var _url=$(this).attr('j_url')+$(this).attr('j_data');
			/*
			var _do=function(){
				location.href=_url;
			}
			dialogLogin(_do, 'data/dialog-login.html');
			*/
			location.href=_url;
			return false;
		});
		
		//略缩图相关
		$('#j-tpl-picholder').hover(function(){
			$(this).addClass('hover');
		}, function(){
			$(this).removeClass('hover');
		}).click(function(){
			var package=$('#j-opt-package li.current').attr('j_val');
			var url=$(this).attr('href')+package;
			window.open(url, 'preview');
			return false;
		});
		
		$('#j-tpl-thumbs li').click(function(){
			var _data=$(this).attr('j_img').split('|');
			$('#j-tpl-picholder img').attr({
				'src': _data[0],
				'alt': _data[1]
			});
			$(this).addClass('current').siblings().removeClass('current');
		});
	})();
	
	//购买应用的相关选项与价格变化
	(function(){
		if (!document.getElementById('j-app-price')) return false;
		var _amount=$('#j-app-price');
		var _price=Number(_amount.attr('j_price'));
		$('#j-app-opt-limit p').click(function(){
			$(this).next().show();
		});
		$('#j-app-opt-limit').mouseleave(function(){
			$(this).find('ul').hide();
		});
		$('#j-app-opt-limit a').click(function(){
			var _box=$(this).parent();
			var _list=_box.parent();
			var _input=_list.parents('tr').next();
			if (_box.is('.current')){
				_list.hide();
				return false;
			}
			var _unit=_box.attr('j_unit');
			if (_unit=='free'){
				_input.hide();
				_amount.html('<span class="amount"><strong class="larger2">'+_price+'</strong> 元/月（试用免费）</span>');
			} else if (_unit=='m'){
				_input.show().find('input').val(1);
				_amount.html('<span class="amount"><strong class="larger2">'+_price+'</strong> 元</span>');
			} else {
				_input.hide();
				var _cost=_box.attr('j_cost').split('|');
				if (_cost.length==2){
					_amount.html('<span class="amount"><strong class="larger2">'+_cost[0]+'</strong> 元</span> <span class="greenarrow"><span class="inner">节省'+_cost[1]+'元</span></span>');
				}
			}
			_box.addClass('current').siblings().removeClass('current');
			_list.hide().prev().text($(this).text());
			$('#j-opt-limit a.current').removeClass('current').click();
			return false;
		});
		
		var numIpt=$('#j-app-opt-limit2 input');
		var numHandler=$('#j-app-opt-limit2 a');
		numIpt.keyup(function(){
			var _value=$(this).val();
			$(this).val(_value.replace(/[^0-9]/g,''));
			if (Number(_value)<1 || $.trim(_value)==''){
				$(this).val(1);
			} else if (Number(_value)>11){
				$(this).val(11);
			}
		}).blur(function(){
			var _value=Number($(this).val());
			 _amount.html('<span class="amount"><strong class="larger2">'+_price*_value+'</strong> 元</span>');
		});
		numHandler.click(function(){
			var _value=Number(numIpt.val());
			if ($(this).is('.up')){
				_value++;
			} else {
				_value--;
			}
			if (_value<1) _value=1;
			if (_value>11) _value=11;
			numIpt.val(_value).blur();
		});
		
		//立即购买
		$('#j-app-order').click(function(){
			var _option=$('#j-app-opt-limit li.current');
			var _unit=_option.attr('j_unit');
			var _limit='';
			if (_unit=='m' && _option.attr('j_limit')=='1'){
				_limit=$('#j-app-opt-limit2 input').val();
			} else {
				_limit=_option.attr('j_limit');
			}
			var _data='unit='+_unit+'&limit='+_limit;
			var _url=$(this).attr('j_url')+_data;
			var _checksite=$(this).attr('j_check');
			var _do=function(){
				$.ajax({
					url: _checksite,
					dataType: 'text',
					cache: false,
					success: function(data){
						if (data=='success'){
							location.href=_url;
						} else {
							$('#dialog-login').remove();
							$('body').append(data);
							var _top=($(window).height()-($('#ol-checksite').height()+2))/2+document.documentElement.scrollTop+document.body.scrollTop;
							if (_top<0) _top=0;
							$('#ol-checksite').css({
								'top': _top+'px',
								'visibility': 'visible'
							});
							$('#ol-checksite-close').click(function(){
								$(this).parent().parent().remove();
								$('#jquery_addmask').remove();
								return false;
							});
						}
					}
				});
			}
			dialogLogin(_do, '/packages/dialog_login');
			return false;
		});
	})();
	
	//部分链接的处理
	$('#j-cl-proview-3').click(function(){
		$('#j-proview-tag a').eq(2).click();
	});
	$('#j-cl-proview-2').click(function(){
		$('#j-proview-tag a').eq(1).click();
	});
	$('#j-cl-proview-4').click(function(){
		$('#j-proview-tag a').eq(3).click();
	});
});



/*=====================================
 * SP
 *=====================================*/
$(function(){
	//表格条纹背景
	$('#j-table-sp tr:odd').addClass('even');
	$('#j-table-movement tr:even').addClass('odd');
	//下拉菜单显示隐藏
	(function(){
		if (!document.getElementById('j-select-jump')) return false;
		$('#j-select-jump p').click(function(){
			$(this).next().show();
		});
		$('#j-select-jump div.fakeselect').mouseleave(function(){
			$(this).find('ul').hide();
		});
		$('#j-select-jump div.fakeselect a').click(function(){
			var _box=$(this).parent();
			var _list=_box.parent();
			if (_box.is('.current')){
				return false;
			}
			_list.hide();
		});
	})();
	
	(function(){
		if (!document.getElementById('j-table-mkt') && !document.getElementById('j-table-mkt2') && !document.getElementById('j-table-sp')) return false;
		$('#j-table-mkt tr:even').addClass('odd');
		$('#j-table-mkt2 table tr:even').addClass('odd');
		$('#j-table-mkt a.buy-btn,#j-table-mkt2 a.buy-btn,#j-table-sp a.buy-btn').click(function(){
			var _checksite=$(this).attr('j_check');
			var _url=$(this).attr('href');
			var _do=function(){
				$.ajax({
					url: _checksite,
					dataType: 'text',
					cache: false,
					success: function(data){
						if (data=='success'){
							location.href=_url;
						} else {
							$('#dialog-login').remove();
							$('body').append(data);
							var _top=($(window).height()-($('#ol-checksite').height()+2))/2+document.documentElement.scrollTop+document.body.scrollTop;
							if (_top<0) _top=0;
							$('#ol-checksite').css({
								'top': _top+'px',
								'visibility': 'visible'
							});
							$('#ol-checksite-close').click(function(){
								$(this).parent().parent().remove();
								$('#jquery_addmask').remove();
								return false;  
							});
						}
					}
				});
			}
			dialogLogin(_do, '/packages/dialog_login');
			return false;
		});
		$('#j-table-mkt a.service-btn,#j-table-sp a.service-btn').click(function(){
			var _url=$(this).attr('href');
			var _do=function(){
				location.href=_url;
			}
			dialogLogin(_do, '/packages/dialog_login');
			return false;
		});
	})();
});


/*=====================================
 * Market
 *=====================================*/
$(function(){
	//网站分类下拉菜单
	(function(){
		if (!document.getElementById('j-select-menu')) return false;
		$('#j-select-menu p').click(function(){
			$(this).addClass('hover')
			$(this).next().show();
		});
		$('#j-select-menu div.select').mouseleave(function(){
			$(this).find('p').removeClass('hover')
			$(this).find('div.option-wrap').hide();	
		})
		$('#j-select-menu div.select a').click(function(){
			var _box=$(this).parent();
			var _list=_box.parent().parent();
			if (_box.is('.current')){
				return false;
			}
			_list.hide();
		});
		$('#j-select-layer p').click(function(){
			if (document.getElementById('j-category-layer')){
				$('#j-category-layer').fadeIn('slow');
			} else {
				$.ajax({
					url: '/templates/industry_list/',
					//url: 'data/industry-list.html',
					dataType: 'text',
					cache: false,
					success: function(data){
						$('#j-select-layer').append(data);
						$('#j-category-layer').show();
						$('#j-category-parent li a').click(function(){
							var i = $(this).parent().prevAll().length;	
							$('#j-category-parent').find('a.current').removeClass('current');
							$(this).addClass('current');
							$('#j-category-child div').eq(i).show().siblings().hide();
							$('#j-category-child').prev().hide();
							return false;
						})
						$('#j-select-layer').mouseleave(function(){
							$('#j-category-layer').hide();
						});
						return false;
					}
				});
			}

			return false;
		});
	})();
	
	//应用分类筛选
	(function(){
		if (!document.getElementById('j-category-parent')) return false;
			$('#j-category-parent li a').click(function(){
			var i = $(this).parent().prevAll().length;	
			$('#j-category-parent').find('a.current').removeClass('current');
			$(this).addClass('current');
			if(i!=0){
				$('#j-category-child div').eq(i-1).show().siblings().hide();
				return false;
			}
		});
	})();
})



/*=====================================
 * Report
 *=====================================*/
$(function(){
	//下拉菜单显示隐藏
	(function(){
		if (!document.getElementById('j-report-select')) return false;
		$('#j-report-select p').click(function(){
			$(this).next().show();
		});
		$('#j-report-select div.fakeselect').mouseleave(function(){
			$(this).find('ul').hide();
		});
		$('#j-report-select div.fakeselect a').click(function(){
			var _box=$(this).parent();
			var _list=_box.parent();
			if (_box.is('.current')){
				_list.hide();
				return false;
			}
			_box.addClass('current').siblings().removeClass('current');
			_list.hide().prev().text($(this).text());
			$(this).parents('div.fakeselect').find('input').val($(this).text());
			return false;			
		});
	})();
	
	//表单验证
	(function(){
		if (!document.getElementById('j-report')) return false;
		$('#j-report-link, #j-report-explain').blur(function(){
			var $parent = $(this).parents('div.row');
			$parent.find(".error").remove();
			//网址验证
			var regUrl=/^((https?|ftp|news):\/\/)?([a-z]([a-z0-9\-]*[\.。])+([a-z]{2}|aero|arpa|biz|com|coop|edu|gov|info|int|jobs|mil|museum|name|nato|net|org|pro|travel)|(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))(\/[a-z0-9_\-\.~]+)*(\/([a-z0-9_\-\.]*)(\?[a-z0-9+_\-\.%=&]*)?)?(#[a-z][a-z0-9_]*)?$/;					
			if( $(this).is('#j-report-link') ){
				if( ( this.value!="" && !regUrl.test(this.value) ) ){
					var errorMsg = '请输入正确的凭证链接。';
					$parent.append('<p class="error"><em>.</em>'+errorMsg+'</p>');
				}
			}
			if( $(this).is('#j-report-explain') ){
				if( this.value=="" ){
					var errorMsg = '请输入举报说明。';
      				$parent.append('<p class="error"><em>.</em>'+errorMsg+'</p>');
				}
			}
		}).keyup(function(){
			$(this).triggerHandler("blur");
		});
		$('#j-report-btn').click(function(){
			$('#j-report-link, #j-report-explain').trigger('blur');
			var numError = $('form .error').length;
			if(numError){
				return false;
			} 
		 });
	})();
});





/*=====================================
 * Refund
 *=====================================*/
$(function(){
	//下拉菜单显示隐藏
	(function(){
		if (!document.getElementById('j-refund')) return false;
		$('#j-refund div.fakeselect p').click(function(){
			$(this).next().show();
		});
		$('#j-refund div.fakeselect').mouseleave(function(){
			$(this).find('ul').hide();
		});
		$('#j-refund div.fakeselect a').click(function(){
			var $parent=$(this).parents('div.row');
			var _box=$(this).parent();
			var _list=_box.parent();
			$parent.find(".error").remove();
			if (_box.is('.current')){
				_list.hide();
				return false;
			}
			if(_box.is('.j-tips')){
				$parent.find('p.part-tips').show();
			}
			else{
				$parent.find('p.part-tips').hide();	
			}
			if(_box.is('.j-amount')){
				$parent.find('div.refund-amount').show();
				$parent.find('input.text').attr('disabled', false);
			}
			else{
				$parent.find('div.refund-amount').hide();
				$parent.find('input.text').val('').attr('disabled', true);
			}
			_box.addClass('current').siblings().removeClass('current');
			_list.hide().prev().text($(this).text());
			$(this).parents('div.fakeselect').find('input').val($(this).text());
			return false;			
		});
	})();
	
	//表单验证
	(function(){
		if (!document.getElementById('j-refund')) return false;
		var txtLengthDetectReset=function(){
			var fields=$('textarea.j-length-detect');
			for (var i=0;i<fields.length;i++){
				var _field=fields.eq(i);
				var _num=Number(_field.attr('maxlength')) - _field.val().length;
				var _txt='';
				if (_num==0||_num>0){
					_txt='<span>'+_num+'</span>';
				} else {
					_txt='<span class="orange">-'+(0-_num)+'</span>';
				}
				_field.parents('div.enter').append('<div class="words j-length-detect">'+_txt+'</div>');
			}
		}
		txtLengthDetectReset();
		$('textarea.j-length-detect').keyup(function(){
			var _num=Number($(this).attr('maxlength')) - $(this).val().length;
			var _txt='';
			if (_num==0||_num>0){
				_txt='<span>'+_num+'</span>';
			} else {
				_txt='<span class="orange">-'+(0-_num)+'</span>';
			}
			var theRow=$(this).parents('div.enter');
			if (theRow.find('div.j-length-detect').length==0){
				theRow.append('<div class="words j-length-detect">'+_txt+'</div>');
			} else {
				theRow.find('div.j-length-detect').html(_txt);
			}
			if (_num<0) return false;
		});
		
		$('#j-refund-choice, #j-refund-explain').blur(function(){
			var $parent = $(this).parents('div.row');
			$parent.find(".error").remove();
			if( $(this).is('#j-refund-choice') ){
				if(this.value==""){
					var errorMsg = '请选择您的退款原因。';
					$parent.append('<p class="error"><em>.</em>'+errorMsg+'</p>');
				}
			}
			if( $(this).is('#j-refund-explain') ){
				if( this.value!="" && this.value.length > 150 ){
					var errorMsg = '请精简退款说明，不得超过150个字符。';
      				$parent.append('<p class="error"><em>.</em>'+errorMsg+'</p>');
				}
			}
		}).keyup(function(){
			$(this).triggerHandler("blur");
		});
		$('#j-refund-btn').click(function(){
			$('#j-refund-choice, #j-refund-explain').trigger('blur');
			var numError = $('form .error').length;
			if(numError){
				return false;
			} 
		});
		$('#j-complaints-amount, #j-complaints-phone, #j-complaints-explain').blur(function(){
			var $parent = $(this).parents('div.row');
			var value = $(this).val();
			var numOnly=function(str){
				var regNum=/^[+\-]?\d+(.\d+)?$/;
				if (regNum.test(str)){
					return true;
				} else {
					return false;
				}
			}
			var mobileOnly=function(str){
				var regMobile=/^0{0,1}(13[0-9]|14[0-9]|15[0-9]|18[0-9])[0-9]{8}$/;
				if (regMobile.test(str)){
					return true;
				} else {
					return false;
				}
			}
			$parent.find(".error").remove();
			if( $(this).is('#j-complaints-amount') ){
				var money=$(this).attr('j-money');
				
				if( !$(this).attr('disabled') && (value=="" || !numOnly(value)) ){
					var errorMsg = '请输入您要退款的金额。';
					$parent.append('<p class="error error-right"><em>.</em>'+errorMsg+'</p>');
				}
				else if( Number(value) >= money ){
					var errorMsg = '您只能退款部分金额。';
					$parent.append('<p class="error error-right"><em>.</em>'+errorMsg+'</p>');	
				}
			}
			if( $(this).is('#j-complaints-phone') ){
				if(value!="" && !mobileOnly(value) ){
					var errorMsg = '请输入正确的联系电话。';
					$parent.append('<p class="error"><em>.</em>'+errorMsg+'</p>');
				}
			}
			if( $(this).is('#j-complaints-explain') ){
				if( value=="" || value.length < 10 ){
					var errorMsg = '请输入10-500个字来描述您的投诉理由，以便客服及时作出判断';
      				$parent.append('<p class="error"><em>.</em>'+errorMsg+'</p>');
				}
			}
		}).keyup(function(){
			$(this).triggerHandler("blur");
		});
		$('#j-complaints-btn').click(function(){
			$('#j-complaints-amount, #j-complaints-phone, #j-complaints-explain').trigger('blur');
			var numError = $('form .error').length;
			if(numError){
				return false;
			} 
		});	
	})();
	//撤销维权
	(function(){
		if (!document.getElementById('j-revocation-link')) return false;
		$('#j-revocation-link').click(function(){
			var _url = $(this).attr('href');
			overlayC('revocation', 'yes', '是否确定撤销维权？', '300', '', '', 'removeThis');
			$('#overlay-c-confirm-revocation').click(function(){
				location.href=_url;
				return false;
			});
			return false;
		});
	})();
	
	//51建站啦介入处理
	(function(){
		if (!document.getElementById('j-refund-assist')) return false; 
		$('#j-refund-assist').click(function(){
			if (document.getElementById('jquery_addmask')) return false;
			$.documentMask();
			var _top=($(window).height()-150)/2+document.documentElement.scrollTop+document.body.scrollTop;
			if (_top<0) _top=0;
			$('<div id="overlay-refund" class="overlay-refund" style="margin-left:-161px;top:'+_top+'px;"><a id="overlay-close-refund" class="close" href="javascript:void(0);" title="关闭">关闭</a><div class="box"><div class="content"><div id="overlay-msg-refund" class="msg-s">确定要求51建站啦客服介入处理？</div></div><div class="footer"><a title="确定" href="javascript:void(0);" class="btn-1" id="overlay-confirm-refund">确定</a> <a title="取消" href="javascript:void(0);" class="btn-2" id="overlay-cancel-refund">取消</a></div></div></div>').appendTo(document.body);
			$('#overlay-close-refund').click(function(){
				$('#jquery_addmask, #overlay-refund').remove();
				return false;
			});
			$('#overlay-cancel-refund').click(function(){
				$('#overlay-close-refund').click();
				return false;
			});
			var source=$(this).attr('j_url');
			$('#overlay-confirm-refund').click(function(){
				$('#overlay-refund').html('<div class="loading-msg">正在提交您的申请...</div>');
				$.ajax({
					url: source,
					dataType: 'json',
					cache: false,
					success: function(data){
						$('#overlay-refund').remove();
						if (data.status=='success'){
							var _top=($(window).height()-150)/2+document.documentElement.scrollTop+document.body.scrollTop;
							if (_top<0) _top=0;
							$('<div id="overlay-refund" class="overlay-refund" style="margin-left:-161px;top:'+_top+'px;"><a id="overlay-close-refund" class="close" href="javascript:void(0);" title="关闭">关闭</a><div class="box"><div class="content"><div id="overlay-msg-refund" class="msg-s">'+data.msg+'</div></div><div class="footer"><a title="完成" href="javascript:void(0);" class="btn-2" id="overlay-complete-refund">完成</a></div></div></div>').appendTo(document.body);
							$('#overlay-close-refund').click(function(){
								$('#jquery_addmask, #overlay-refund').remove();
								return false;
							});
							$('#overlay-complete-refund').click(function(){
								$('#overlay-close-refund').click();
								return false;
							});
						}
						if (data.status=='failed'){
							var _top=($(window).height()-150)/2+document.documentElement.scrollTop+document.body.scrollTop;
							if (_top<0) _top=0;
							$('<div id="overlay-refund" class="overlay-refund" style="margin-left:-161px;top:'+_top+'px;"><a id="overlay-close-refund" class="close" href="javascript:void(0);" title="关闭">关闭</a><div class="box"><div class="content"><div id="overlay-msg-refund" class="msg-s">'+data.msg+'</div></div><div class="footer"><a title="确定" href="javascript:void(0);" class="btn-2" id="overlay-confirm-refund">确定</a></div></div></div>').appendTo(document.body);
							$('#overlay-close-refund').click(function(){
								$('#jquery_addmask, #overlay-refund').remove();
								return false;
							});
							$('#overlay-confirm-refund').click(function(){
								$('#overlay-close-refund').click();
								return false;
							});
						}
					}
				});
				return false;
			});
			return false;
		});
	})();
});


/*=====================================
 * Login
 *=====================================*/
$(function(){
	//刷新验证码
	$('#captcha img, #captcha a').click(function(){
		$('#captcha img').attr('src',$('#captcha img').attr('rel')+Math.random());
		$(this).parent().prev().find('input').val('').focus();
		return false;
	});
	//登录判断
	$('#form-login').submit(function(){
		var _id=$('#ipt-id').val();
		var pwd=$('#ipt-pwd').val();
		var captcha=$('#ipt-captcha').val();
		if (!_id||_id==''||_id=='用户名 / 手机号码 / 电子邮箱'){
			alert('请输入用户名');
			return false;
		}
		if (!pwd||pwd==''){
			alert('请输入密码');
			return false;
		}
		if ($('#ipt-captcha').length>0&&(!captcha||captcha=='')){
			alert('请输入验证码');
			return false;
		}
	});
});



/*=====================================
 * Agent
 *=====================================*/
$(function(){
	//分销加盟选项卡
	if (!document.getElementById('j-agent-tabview')) return false; 
	$('#j-agent-tabview a').click(function(){
		var n=Number($(this).attr('rel'));
		var list=$(this).parent().parent().parent().next().find('div.agent-tab');
		list.eq(n).show().siblings().hide();
		$(this).parent().addClass('current').siblings().removeClass('current');
		return false;
	});
}); 



/*=====================================
 * Help
 *=====================================*/
$(function(){
	//帮助中心
	$('#flow-agent a, #flow-sitebuilding a').mouseenter(function(){
		$(this).addClass('hover');
		var container=$(this).parent();
		container.prevAll().find('a').addClass('hover');
		container.nextAll().find('a').removeClass('hover');
	});
	$('#flow-agent, #flow-sitebuilding').mouseleave(function(){
		$(this).find('a').removeClass('hover');
	});
	
	//左侧导航收缩展开
	(function(){
		$('ul.menu-wrap div.item').click(function(){
			var _parent=$(this).parent();
			if (_parent.is('.open')){
				_parent.removeClass('open').addClass('close');
			} else if (_parent.is('.close')){
				_parent.removeClass('close').addClass('open');
			}
		});
	})();
});



/*=====================================
 * Activity
 *=====================================*/
$(function(){
	//活动广告关闭
	if (!document.getElementById('j-activity-close')) return false; 
	$('#j-activity-close').click(function(){
		$(this).parent().remove();
	});
}); 



/*=====================================
 * Process
 *=====================================*/
$(function(){
	//略缩图
	var picThumb=$('ul.thumb-gallery a');
	try {
		picThumb.lightBox();			
	} catch(e){
	}
	picThumb.hover(function(){
		$(this).addClass('hover');	
	},function(){
		$(this).removeClass('hover');	
	});
	//确认设计稿
	(function(){
		if (!document.getElementById('j-design-btn')) return false;
		$('#j-design-btn').click(function(){
			var _url = $(this).attr('href');
			overlayC('revocation', 'yes', '确认设计稿：满意并确认该设计稿', '300', '', '', 'removeThis');
			$('#overlay-c-confirm-revocation').click(function(){
				location.href=_url;
				return false;
			});
			return false;
		});
	})();
	//确认服务完成
	(function(){
		if (!document.getElementById('j-service-btn')) return false;
		$('#j-service-btn').click(function(){
			var _url = $(this).attr('href');
			overlayC('revocation', 'yes', '确认服务完成并付款给服务商', '300', '', '', 'removeThis');
			$('#overlay-c-confirm-revocation').click(function(){
				location.href=_url;
				return false;
			});
			return false;
		});
	})();
}); 


/*=====================================
 * fileupload delete
 *=====================================*/
function fileUploadItemDel(which){
	var $this1=$(which);
	$this1.parent().remove();
}


/*=====================================
 * Activity
 *=====================================*/
 $(function(){
	//问卷调查
	/*if (!document.getElementById('j-float-activity')) return false;
	var floatActivity=$('#j-float-activity');
	floatActivity.css({'right': (document.body.offsetWidth-970)/2-26+'px'});
	if(!window.XMLHttpRequest){
		$(window).scroll(function(){
			floatActivity.css({'top': document.documentElement.scrollTop+document.body.scrollTop+244+'px'});
			floatActivity.css({'right': (document.body.offsetWidth-970)/2-26+'px'});
		});
	} else {
		floatActivity.css({
			'position': 'fixed'
		});
	}*/
	
	if (!document.getElementById('j-float-activity')) return false;
		var floatActivity=$('#j-float-activity');
		if(!window.XMLHttpRequest){
			$(window).scroll(function(){
				floatActivity.css({'top': document.documentElement.scrollTop+document.body.scrollTop+60+'px'});
			});
		} else {
			floatActivity.css({
				'position': 'fixed',
				'top': '60',
				'right': '1px'
			});
			var setPosition=function(){
				//var _right=($(window).width()-980)/2-107;
				//floatContact.css('right', _right+'px');
			}
		}
}); 
 
 
  