<!DOCTYPE html>
<html lang="zh">
<head>
<title><?=$this->web['webname']?> - 后台管理</title>
<?php
$this->load_view('backend/meta');
?>
</head>
<body>

<!--Header-part-->
<?php
$this->load_view('backend/header');
?>
<!--sidebar-menu-->
<?php
$this->load_view('backend/lefter');
?>
<!--sidebar-menu-->

<!--main-container-part-->
<div id="content">
<!--breadcrumbs-->
  <div id="content-header">
    <div id="breadcrumb"> <a href="<?=url(array('backend', 'index'))?>" title="返回后台首页" class="tip-bottom"><i class="icon-home"></i> 后台首页</a>
    <a href="<?=url(array('backend', Router::$s_controller))?>" class="current">分类管理</a>
    <a href="#" class="current">分类添加</a></div>
    <h1>分类添加</h1>
  </div>
<!--End-breadcrumbs-->

<!--Action boxes-->
  <div class="container-fluid">
<hr>
<div class="row-fluid">
    <div >
      <div class="widget-box">
        <div class="widget-title"> <span class="icon"> <i class="icon-align-justify"></i> </span>
          <h5>分类信息</h5>
        </div>
        <div class="widget-content nopadding">
          <form method="post" class="form-horizontal">
            <div class="control-group">
              <label class="control-label">模型选择 :</label>
              <div class="controls">
                <select name="module_id" id="module_id">
                  <?php
                  foreach($this->moduleArr as $k => $v){
                    $selected = ($module_id == $k) ? 'selected' : '';
                    echo '<option value="'.$k.'" '.$selected.'>'.$v.'</option>';
                  }
                  ?>
                </select>
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">上级分类 :</label>
              <div class="controls">
                <select name="pid">
                  <?php
                  echo '<option value="0">顶级分类</option>';
                  foreach($this->cateALLArr as $k => $v){
                    echo '<option value="'.$v['id'].'" >├&nbsp;&nbsp;'.$v['name'].'</option>';
                    if(!empty($v['sub'])){
                      $this->cateHtml($v['sub']);
                    }
                  }
                  ?>
                </select>
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">分类名称 :</label>
              <div class="controls">
                <input type="text" name="name" class="span6" value="">
                <input type="checkbox" name="islink" value="1" class="islink">&nbsp;是否外链&nbsp;&nbsp;&nbsp;&nbsp;
                <input type="checkbox" name="display" value="1">&nbsp;是否显示&nbsp;&nbsp;&nbsp;&nbsp;
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">SEO关键字 :</label>
              <div class="controls">
                <input type="text" name="keywords" class="span6" value="">
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">SEO描述 :</label>
              <div class="controls">
                <input type="text" name="description" class="span6" value="">
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">缩略图 :</label>
              <div class="controls">
                <input type="text" name="img" class="span6" value="">
              </div>
            </div>
            <div class="control-group islinkV" style="display:none">
              <label class="control-label">外链地址 :</label>
              <div class="controls">
                <input type="text" name="link" class="span6" value="">
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">简介</label>
              <div class="controls">
                <textarea class="span11" name="info" style="height:400px"></textarea>
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">分类模版</label>
              <div class="controls">
              <input type="text" name="cate_temp" id="cate_temp" class="span2" value="">
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">内容模版</label>
              <div class="controls">
              <input type="text" name="detail_temp" id="detail_temp" class="span2" value="">
              </div>
            </div>


            
            <div class="control-group">
              <label class="control-label">权重 :</label>
              <div class="controls">
                <input type="text" name="sort" class="span1" value="99">&nbsp;&nbsp;越小的排越前
              </div>
            </div>
            <div class="form-actions">
              <button type="submit" class="btn btn-success">添加分类</button>
            </div>
          </form>
        </div>
      </div>


    </div>

  </div>
    
  </div>
</div>

<!--end-main-container-part-->

<!--Footer-part-->

<div class="row-fluid">
<?php
  $this->load_view('backend/js');
  $this->load_view('backend/footer');
  ?>
</div>
<script type="text/javascript">
var tempList = <?=json_encode($this->moduleArrUrl)?>;
  $(function(){
    $('.islink').click(function(){
      if($(this).attr("checked") == 'checked'){
        $('.onlink').css('display', 'none');
        $('.islinkV').css('display', '');
      }else{
        $('.onlink').css('display', '');
        $('.islinkV').css('display', 'none');
      }      
    })
    $('#cate_temp').val(tempList[1]);
        $('#detail_temp').val(tempList[1]+'_detail');
    $('#module_id').change(function(){
      var module_id = $(this).val();
        $('#cate_temp').val(tempList[module_id]);
        $('#detail_temp').val(tempList[module_id]+'_detail');
    })
    var editor;
    KindEditor.ready(function(K) {
      editor = K.create('textarea[name="info"]', {
        allowFileManager : true,
        themeType : 'simple',
        urlType : 'absolute',
        uploadJson : '<?=url(array('backend', 'index', 'ajaxuploadediter'))?>',
        items : [
              'source','code','fontname', 'fontsize', '|', 'forecolor', 'hilitecolor', 'bold', 'italic', 'underline',
              'removeformat', '|', 'justifyleft', 'justifycenter', 'justifyright', 'insertorderedlist',
              'insertunorderedlist', '|', 'image', 'flash', 'media','insertfile','link','unlink','|','table','fullscreen']

      })
    })
  })
</script>
<!--end-Footer-part-->
</body>
</html>
