<!DOCTYPE html>
<html lang="zh">
<head>
<title><?=$this->web['webname']?> - 后台管理</title>
<?php
$this->load_view('backend/meta');
?>
</head>
<body>

<!--Header-part-->
<?php
$this->load_view('backend/header');
?>
<!--sidebar-menu-->
<?php
$this->load_view('backend/lefter');
?>
<!--sidebar-menu-->

<!--main-container-part-->
<div id="content">
<!--breadcrumbs-->
  <div id="content-header">
    <div id="breadcrumb"> <a href="<?=url(array('backend', 'index'))?>" title="返回后台首页" class="tip-bottom"><i class="icon-home"></i> 后台首页</a>
    <a href="<?=url(array('backend', Router::$s_controller))?>" class="current">分类管理</a>
    <a href="#" class="current">下载修改</a></div>
    <h1>下载修改</h1>
  </div>
<!--End-breadcrumbs-->

<!--Action boxes-->
  <div class="container-fluid">
<hr>
<div class="row-fluid">
    <div >
      <div class="widget-box">
        <div class="widget-title"> <span class="icon"> <i class="icon-align-justify"></i> </span>
          <h5>下载信息</h5>
        </div>
        <div class="widget-content nopadding">
          <form method="post" class="form-horizontal">
            <div class="control-group">
              <label class="control-label">选择分类 :</label>
              <div class="controls">
                <select name="cid">
                  <?php
                  foreach($this->cateALLArr as $k => $v){
                    $selected = ($v['id'] == $cid) ? 'selected' : '';
                    echo '<option value="'.$v['id'].'" '.$selected.'>├&nbsp;&nbsp;'.$v['name'].'</option>';
                    if(!empty($v['sub'])){
                      $this->cateHtml($v['sub'], '&nbsp;&nbsp;├ &nbsp;&nbsp;', $cid);
                    }
                  }
                  ?>
                </select>
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">新闻标题 :</label>
              <div class="controls">
                <input type="text" name="title" class="span6" value="<?=$rs['title']?>">
                <input type="checkbox" name="islink" value="1" class="islink" <?=empty($rs['islink']) ? '' : 'checked'?>>&nbsp;是否外链
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">新闻来源 :</label>
              <div class="controls">
                <input type="text" name="source" class="span6" value="<?=$rs['source']?>">
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">SEO关键字 :</label>
              <div class="controls">
                <input type="text" name="keywords" class="span6" value="<?=$rs['keywords']?>">
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">SEO描述 :</label>
              <div class="controls">
                <input type="text" name="description" class="span6" value="<?=$rs['description']?>">
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">缩略图 :</label>
              <div class="controls">
                <input type="text" name="img" class="span6" value="<?=$rs['img']?>" id="img">
                <button type="button" id="uploadImg">上传</button>
              </div>
            </div>
            <div class="control-group islinkV" style="display:none">
              <label class="control-label">外链地址 :</label>
              <div class="controls">
                <input type="text" name="link" class="span6" value="<?=$rs['link']?>">
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">摘要</label>
              <div class="controls">
                <textarea class="span11" name="info"><?=$rs['info']?></textarea>
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">内容</label>
              <div class="controls">
                <textarea class="span11" name="content" style="height:400px"><?=$rs['content']?></textarea>
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">软件大小</label>
              <div class="controls">
              <input type="text" name="size" class="span2" value="<?=$rs['size']?>" placeholder="0 k"> 
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">软件授权</label>
              <div class="controls">
              <select name="license">
                <?php
                foreach($this->licenseArr as $k => $v){
                  $selected = ($rs['license'] == $v) ? 'selected' : '';
                  echo '<option value="'.$v.'" '.$selected.'>'.$v.'</option>';
                }
                ?>
              </select>
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">软件语言</label>
              <div class="controls">
              <select name="language">
                <?php
                foreach($this->softLanguageArr as $k => $v){
                  $selected = ($rs['language'] == $v) ? 'selected' : '';
                  echo '<option value="'.$v.'" '.$selected.'>'.$v.'</option>';
                }
                ?>
              </select>
              </div>
            </div>
             <div class="control-group onlink">
              <label class="control-label">软件平台</label>
              <div class="controls">
              <input type="text" name="platform" class="span6" value="<?=$rs['platform']?>" > 
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">软件类型</label>
              <div class="controls">
              <select name="type">
                <?php
                foreach($this->softType as $k => $v){
                  $selected = ($rs['type'] == $v) ? 'selected' : '';
                  echo '<option value="'.$v.'" '.$selected.'>'.$v.'</option>';
                }
                ?>
              </select>
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">软件评级</label>
              <div class="controls">
              <select name="score">
                <?php
                $i = 1;
                while($i <= 5){
                  $selected = ($rs['score'] == $i) ? 'selected' : '';
                  echo '<option value="'.$i.'" '.$selected.'>'.$i.'颗星</option>';
                  $i++;
                }
                  
                ?>
              </select>
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">软件地址</label>
              <div class="controls">
              <ul style="list-style-type: none;" id="softAddress">
              <?php
              $softAddressArr = json_decode($rs['downfiles']);
              foreach ($softAddressArr as $key => $value) {
                echo '<li><input type="text" name="downfiles[]" class="span6" value="'.$value.'"><button type="button" class="delAddress">删除</button></li>';
              }
              ?>
              
              </ul>
              <button type="button" id="addSoft">添加</button>
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">阅读收费</label>
              <div class="controls">
              <input type="text" name="fee" class="span2" value="<?=$rs['fee']?>"> 元
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">允许评论</label>
              <div class="controls">
              <select name="allow_comments">
                <?php
                $allow_commentsArr = array(0 => '是', -1 => '否');
                foreach($allow_commentsArr as $k => $v){
                  $selected = ($k == $rs['allow_comments']) ? 'selected' : '';
                  echo '<option value="'.$k.'" '.$selected.'>'.$v.'</option>';
                }
                ?>
              </select>
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">阅读权限</label>
              <div class="controls">
              <?php
              $purviewArr = explode('|', $rs['purview']);
              foreach($userGroupRs as $k => $v){
                $selected = in_array($v['id'], $purviewArr) ? 'checked' : '';
                echo '<input type="checkbox" name="purview[]" value="'.$v['id'].'" '.$selected.'>&nbsp;'.$v['name'].'&nbsp;&nbsp;';
              }
              ?>
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">发布状态</label>
              <div class="controls">
              <select name="status">
                <?php
                $statusArr = array(0 => '发布', -1 => '未发布');
                foreach($statusArr as $k => $v){
                  $selected = ($k == $rs['status']) ? 'selected' : '';
                  echo '<option value="'.$k.'" '.$selected.'>'.$v.'</option>';
                }
                ?>
              </select>
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">发布时间</label>
              <div class="controls">
              <input type="text" name="addtime" class="span3" value="<?=date('Y-m-d H:i:s', $rs['addtime'])?>"> 
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">增加投票</label>
              <div class="controls">
              <input type="text" name="vote_id" class="span3" value="<?=$rs['vote_id']?>"> 
              </div>
            </div>
            <div class="control-group onlink">
              <label class="control-label">推荐位</label>
              <div class="controls">
              <?php
              foreach($locatRs as $k => $v){
                $selected = in_array($v['id'], $locatArr) ? 'checked' : '';
                echo '<input type="checkbox" name="location[]" value="'.$v['id'].'" '.$selected.'>&nbsp;'.$v['name'].'&nbsp;&nbsp;';
              }
              ?>
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">权重 :</label>
              <div class="controls">
                <input type="text" name="sort" class="span1" value="<?=$rs['sort']?>">&nbsp;&nbsp;越小的排越前
              </div>
            </div>
            <div class="form-actions">
              <button type="submit" class="btn btn-success">确定修改</button>
            </div>
          </form>
        </div>
      </div>


    </div>

  </div>
    
  </div>
</div>

<!--end-main-container-part-->

<!--Footer-part-->

<div class="row-fluid">
<?php
  $this->load_view('backend/js');
  $this->load_view('backend/footer');
  ?>
</div>
<script type="text/javascript">
  $(function(){
    $('#addSoft').click(function(){
      $('#softAddress').append('<li><input type="text" name="downfiles[]" class="span6" value=""><button type="button" class="delAddress">删除</button></li>');
    })
    $('.delAddress').live('click', function() {
      $(this).parent('li').remove()
    });
    
    var button = $('#uploadImg'), interval;      
      new AjaxUpload(button, {
        action: '<?=url(array('backend', 'index', 'ajaxupload'))?>', 
        name: 'filedata',
        onSubmit : function(file, ext){
          this.disable();     
        },      
        onComplete: function(file, response){ 
          var json_str = eval("(" + response + ")");
          if(json_str.error != 0){
            this.enable();
            alert(json_str.msg);return;
          }
          window.clearInterval(interval);
          this.enable();      
          $('#img').val(json_str.url);
        }
    });
    $('.islink').click(function(){
      if($(this).attr("checked") == 'checked'){
        $('.onlink').css('display', 'none');
        $('.islinkV').css('display', '');
      }else{
        $('.onlink').css('display', '');
        $('.islinkV').css('display', 'none');
      }      
    })
    var editor;
    KindEditor.ready(function(K) {
      editor = K.create('textarea[name="content"]', {
        allowFileManager : true,
        themeType : 'simple',
        urlType : 'absolute',
        uploadJson : '<?=url(array('backend', 'index', 'ajaxuploadediter'))?>',
        items : [
              'source','code','fontname', 'fontsize', '|', 'forecolor', 'hilitecolor', 'bold', 'italic', 'underline',
              'removeformat', '|', 'justifyleft', 'justifycenter', 'justifyright', 'insertorderedlist',
              'insertunorderedlist', '|', 'image', 'flash', 'media','insertfile','link','unlink','|','table','fullscreen']

      })
    })
  })

</script>
<!--end-Footer-part-->
</body>
</html>
