<!DOCTYPE html>
<html lang="zh">
<head>
<title><?=$this->web['webname']?> - 后台管理</title>
<?
$this->load_view('backend/meta');
?>
</head>
<body>

<!--Header-part-->
<?
$this->load_view('backend/header');
?>
<!--sidebar-menu-->
<?
$this->load_view('backend/lefter');
?>
<!--sidebar-menu-->

<!--main-container-part-->
<div id="content">
<!--breadcrumbs-->
  <div id="content-header">
    <div id="breadcrumb"> <a href="<?=url(array('backend', 'index'))?>" title="返回后台首页" class="tip-bottom"><i class="icon-home"></i> 后台首页</a>
    <a href="<?=url(array('backend', Router::$s_controller))?>" class="current">用户管理</a>
    <a href="#" class="current">用户添加</a></div>
    <h1>用户添加</h1>
  </div>
<!--End-breadcrumbs-->

<!--Action boxes-->
  <div class="container-fluid">
<hr>
<div class="row-fluid">
    <div >
      <div class="widget-box">
        <div class="widget-title"> <span class="icon"> <i class="icon-align-justify"></i> </span>
          <h5>用户信息</h5>
        </div>
        <div class="widget-content nopadding">
          <form method="post" class="form-horizontal">
            <div class="control-group">
              <label class="control-label">用户名 :</label>
              <div class="controls">
                <input type="text" name="username" class="span6" placeholder="User name">
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">密码 :</label>
              <div class="controls">
                <input type="password" name="password" class="span6" placeholder="Password">
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">用户组 :</label>
              <div class="controls">
                <select name="group_id">
                  <?
                  foreach($groupRs as $k => $v){
                    echo '<option value="'.$v['id'].'">'.$v['name'].'</option>';
                  }
                  ?>
                </select>
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">手机 :</label>
              <div class="controls">
                <input type="text" name="mobile" class="span6" placeholder="Mobile">&nbsp;
                <input type="checkbox" name="verimobile" value="1">&nbsp;验证手机
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">邮箱 :</label>
              <div class="controls">
                <input type="text" name="email" class="span6" placeholder="Email">&nbsp;
                <input type="checkbox" name="verimail" value="1">&nbsp;验证邮箱
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">说明 :</label>
              <div class="controls">
                <input type="text" name="info" class="span11">
                <span class="help-block">仅后台使用，如：此客户钱比较多，好好伺候...</span> </div>
            </div>
            <div class="control-group">
              <label class="control-label">真实姓名 :</label>
              <div class="controls">
                <input type="text" name="realname" class="span6" placeholder="Real name">
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">公司名字 :</label>
              <div class="controls">
                <input type="text" name="compay" class="span6" placeholder="Compay name">
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">邮编 :</label>
              <div class="controls">
                <input type="text" name="zip" class="span6" placeholder="Zip code">
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">地区 :</label>
              <div class="controls">
                <select name="province" id="province"></select>
                <select name="city" id="city"></select>
                <select name="district" id="district"></select>
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">详细地址 :</label>
              <div class="controls">
                <input type="text" name="address" class="span6" placeholder="Address">
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">电话 :</label>
              <div class="controls">
                <input type="text" name="tel" class="span6" placeholder="Tel">
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">传真 :</label>
              <div class="controls">
                <input type="text" name="fax" class="span6" placeholder="Fax">
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">金钱 :</label>
              <div class="controls">
                <input type="text" name="money" class="span6" placeholder="0.00">
              </div>
            </div>
            <div class="form-actions">
              <button type="submit" class="btn btn-success">添加用户</button>
            </div>
          </form>
        </div>
      </div>


    </div>

  </div>
    
  </div>
</div>

<!--end-main-container-part-->

<!--Footer-part-->

<div class="row-fluid">
<?
  $this->load_view('backend/js');
  $this->load_view('backend/footer');
  ?>
</div>

<!--end-Footer-part-->
<script type="text/javascript">
var pid = 1;
var areaType = 'province';
$(function(){
  getArea();
  $('#province').change(function(){
    pid = $(this).val();
    areaType = 'city';
    getArea();
  })
  $('#city').change(function(){
    pid = $(this).val();
    areaType = 'district';
    getArea();
  })
})
var getArea = function(){
  if(areaType == 'city') $('#district').html('');
  $('#'+areaType).html('');
  $.ajax({
    url : '/index/area/'+pid,
    cache : false,
    dataType : 'json',
    success: function(json){
      $('#'+areaType).append('<option value="0">请选择</option>')
      $.each(json, function(k, v){
        $('#'+areaType).append('<option value="'+v['id']+'">'+v['name']+'</option>')
      })
    }
  })
}
</script>
</body>
</html>
