<!DOCTYPE html>
<html lang="zh-cn">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?=$this->web['webname']?></title>

    <!-- Bootstrap -->
    <link href="<?=BOOT_PATH?>css/bootstrap.min.css" rel="stylesheet">
    <link href="<?=$this->web['tempUrl']?>styles/default.css" rel="stylesheet">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="http://cdn.bootcss.com/html5shiv/3.7.2/html5shiv.min.js"></script>
      <script src="http://cdn.bootcss.com/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->
  </head>
  <body> 
    <?php  
    $this->view('header');
    ?>
    <div class="container-fluid banner">
      
<div id="carousel-example-captions" class="carousel slide" data-ride="carousel">
      <ol class="carousel-indicators">
      <?php
      $slideshowRs = $this->getSlideshow();
      foreach($slideshowRs as $k => $v){
        $selected = ($k == 0) ? 'active' : '';
        echo '<li data-target="#carousel-example-captions" data-slide-to="'.$k.'" class="'.$selected.'"></li>';
      }
      ?>
      </ol>
      <div class="carousel-inner" role="listbox">
      <?php
      foreach($slideshowRs as $k => $v){
        $selected = ($k == 0) ? 'active' : '';
        echo '<div class="item '.$selected.'">
          <img src="'.$v['path'].'" width="100%" >
        </div>';
      }
      ?>
      </div>
      <a class="left carousel-control" href="#carousel-example-captions" role="button" data-slide="prev">
        <span class="glyphicon glyphicon-chevron-left"></span>
        <span class="sr-only">Previous</span>
      </a>
      <a class="right carousel-control" href="#carousel-example-captions" role="button" data-slide="next">
        <span class="glyphicon glyphicon-chevron-right"></span>
        <span class="sr-only">Next</span>
      </a>
    </div>

    </div>
    <div class="container news" style="padding-top:20px">
      <div class="row">
        <div class="col-md-4"><h3>公司新闻</h3>
        <ul>
        <?php
          foreach($this->getNews(1, 6) as $k => $v){
            echo '<li><a href="'.url(array('news', 'detail', $v['id'])).'"><i class="icons-dian"></i>'.$v['title'].'</a></li>';
          }
        ?>
        </ul>
        </div>
        <div class="col-md-4"><h3>行业动态</h3>
        <ul>
          <?php
          foreach($this->getNews(15, 6) as $k => $v){
            echo '<li><a href="'.url(array('news', 'detail', $v['id'])).'"><i class="icons-dian"></i>'.$v['title'].'</a></li>';
          }
        ?>
        </ul>
        </div>
        <div class="col-md-4"><h3>软件下载</h3>
        <ul>
          <?php
          foreach($this->getNews(0, 6, 2) as $k => $v){
            $downListArr = json_decode($v['downfiles'], true);
            echo '<li><a href="'.$downListArr[0].'" target="_blank" class="btn btn-success pull-right btn-xs"><span class="whiteColor">下载</span></a><a href="'.url(array('download', 'detail', $v['id'])).'"><i class="icons-dian"></i>'.$v['title'].'</a> &nbsp;&nbsp;&nbsp;&nbsp;<span class="greyColor">星级：'.$v['score'].'颗星</span></li>';
          }
        ?>
        </ul>
        </div>
      </div>
    </div>
    <div class="container albums" style="padding-top:20px">
    <h3 style="padding-bottom:10px;">相册展示</h3>
    <div class="row">
 <?php
          foreach($this->getNews(0, 8, 3) as $k => $v){
            
        ?>
      <div class="col-md-3 col-xs-6"><a href="<?=url(array('album', 'detail', $v['id']))?>" class="thumbnail"><img src="<?=$v['img']?>" class="img-rounded ">
        <?=utf8Substr($v['title'], 0, 16)?>
      </a>
        </div>
        <?php
      }
        ?>
    </div>
    </div>

    <?php
    $this->view('footer');
    ?>
    <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
    <script src="http://cdn.bootcss.com/jquery/1.11.1/jquery.min.js"></script>
    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <script src="<?=BOOT_PATH?>js/bootstrap.min.js"></script>
  </body>
</html>