<?php
 if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
 
 class Database extends MY_Controller{
  function __construct() 
  {
    parent::__construct();
		// Load required CI libraries and helpers.
		$this->load->model("db_m");
		$this->_backup_path = APPPATH . 'backup/';
	}
	
    public function index()
    {
		$this->user_m->check_quan('database','index');
        $status = $this->db_m->get_folder_status();
	 
        if ($status !== TRUE)
        {
			show_error($status,'500','提醒');
            return;
        }
		 
        $data['tables'] = $this->db_m->get_all_tables();
		//P($data);
		$this->load->view('database_index.html', $data);
        return;
    }

	public function export()
    {
		header("Content-type:text/html;charset=utf-8");
		$this->user_m->check_quan('database','export');
        foreach (array(
                     'export_type',
                     'tables',
                     'table_id',
                     'filename',
                     'is_compress',
                     'is_extend_insert',
                     'volume_size',
                     'start',
                     'volume') as $arg)
        {
            $$arg = $this->input->get($arg, TRUE);
        }

        if ( ! in_array($export_type, array('all', 'custom')))
        {
			show_error('参数错误');
            return;
        }
        $valid_tables = $this->db_m->get_all_tables();
        if ($export_type == 'custom')
        {
            ! is_array($tables) AND $tables = array($tables);
            foreach ($tables as $key => $table)
            {
                if ( ! in_array($table, $valid_tables))
                {
                    unset($tables[$key]);
                }
            }
            if ( ! $tables)
            {
				show_error('请选择要备份的数据库表');
                return;
            }
        }
        else
        {
            $tables = $valid_tables;
        }
        //设置默认值
        $volume_size = intval($volume_size);
        ! $volume AND $volume = 0;
        ! $start AND $start = 0;
        ! $table_id AND $table_id = 0;
        // 开始备份
        $status = $this->db_m->export($filename, $tables, $table_id, $is_compress, $volume_size, $start, $is_extend_insert, $volume);
        if ($status !== TRUE)
        {
            $status['export_type'] = $export_type;
            $status['tables'] = $this->input->get('tables');
            $message = '数据库第 '.++$volume.' 卷备份成功，页面自动跳转！';
			$data['msg'] = $message; 	
			$data['tiao'] = 0; 	
			$data['title'] = lang("notice");
			$data['url'] = site_url($this->uri->segment(1)."/database/export").'?'.http_build_query($status); ;				
			$this->load->show_message($data);  
		    return;
        }

        //备份成功完成，转到还原页面
        //$this->_message('数据表备份成功', 'database/recover');
		//show_error('数据表备份成功',500,'提醒');
		
		echo '数据表备份成功';
        return;
    }
	
    public function recover()
    {
		$this->user_m->check_quan('database','recover');
        $data['files'] = $this->db_m->get_backup_files();
		$this->load->view('database_recover.html', $data);
        return;
    }	

	public function files($operation, $file)
    {
		$this->user_m->check_quan('database','files');
        if( ! in_array($operation, array('delete', 'download', 'import')))
        {
			
            redirect($this->uri->segment(1).'database');
        }

        // 删除指定 sql 文件
        if($operation == 'delete')
        {
            // do somthing here
            $this->db_m->delete_backup_files($file);
			show_error('备份删除成功',500,'提醒');
            return;
        }

        // 下载指定 sql 文件
        if($operation == 'download')
        {
            $file_data = $this->db_m->get_backup_file_content($file);
            if ($file_data === FALSE)
            {
				show_error('要下载的文件不存在',500,'提醒');
                return;
            }
            $this->load->helper('download');
            force_download($file, $file_data);
            return;
        }

        // 导入指定 sql 文件
        if($operation == 'import')
        {
            // do somthing here
			//echo $file;
			$files_a = explode('-',$file);
			$i = $files_a[1]; 
			$file_tmp =  $files_a[0]; 
 
            $this->db_m->import($file);
			
			$i = $i+1;
			 
			if (file_exists($this->_backup_path .$file_tmp . '-'.$i .'.sql'))
			{
				redirect($this->uri->segment(1).'/database/files/import/'.$file_tmp . '-'.$i .'.sql'); 
			}else{
				show_error('备份还原成功',500,'提醒');
			}			
            return;
        }
    }

   public function optimize()
    {
         $this->user_m->check_quan('database','optimize');
        $optimize_data = $this->db_m->get_unoptimized_tables();
		$this->load->view('database_optimize.html', $optimize_data);
        return;
    }
	
    public function optimize_post()
    {
        
        if($this->db_m->optimize() !== FALSE)
        {
			show_error('数据库优化成功',500,'提醒');
            return;
        }
		show_error('数据库优化失败',500,'提醒');
    }	
 }	