
<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Native Session using Memcached
 *
 *      Another session library extension that uses Native PHP session
 *       instead of the original Codeigniter cookie-based way.
 *      It also takes memcached as the session data storage, which will
 *      boost the performance of your app.
 
 *
 * @package    CodeIgniter
 * @subpackage Libraries
 * @category    Libraries
 * @author              Situo Dev Team <hello@situos.com>
 * @license    The MIT license
 
 * @filesource
 */
 
// ------------------------------------------------------------------------
 
// Set session configs...
//new Cache_Session_Handler;#ע˸д룬Ϊд޷ȡsession
session_start();
 
 
class MY_Session extends CI_Session {
        
        /**
         * Session Constructor
         * session캯
         * 
         * The constructor runs the session routines automatically
         * whenever the class is instantiated.
         * 
         * @access      public
         * @return      void
         */
        public function __construct($params = array())
        {
                parent::__construct($params);
        }
 
        // --------------------------------------------------------------------
 
        /**
         * Fetch the current session data if it exists
         * ȡǰsession,ȡsession
         * 
         * @access      public
         * @return      bool
         */
        public function sess_read()
        {
                // Fetch the cookie
                //ȡCookieϢ
                $session = $_SESSION;
 
                // Is the session data we unserialized an array with the correct format?
                // δлsessionǷΪ鲢Ҹʽȷ
                if ( ! is_array($session) OR ! isset($session['session_id']) OR ! isset($session['ip_address']) OR ! isset($session['user_agent']) OR ! isset($session['last_activity']))
                {       //ûsessionʱ򷵻Falsesession
                        log_message('debug', 'A session was not found.');
                        $this->sess_destroy(FALSE);
                        return FALSE;
                }
 
                // Is the session current?
                // ǷΪǰsession
                if (($session['last_activity'] + $this->sess_expiration) < $this->now)
                {       //sessionЧѹsession
                        $this->sess_destroy(FALSE);
                        return FALSE;
                }
 
                // Does the IP Match?
                // ƥIPַǷȷ
                if ($this->sess_match_ip == TRUE AND $session['ip_address'] != $this->CI->input->ip_address())
                {       //IPַƥsession
                        $this->sess_destroy(FALSE);
                        return FALSE;
                }
 
                // Does the User Agent Match?
                // Ƿƥ
                if ($this->sess_match_useragent == TRUE AND trim($session['user_agent']) != trim(substr($this->CI->input->user_agent(), 0, 120)))
                {       //ǵǰsession
                        $this->sess_destroy(FALSE);
                        return FALSE;
                }
                
                // Is there a corresponding session in the DB?
                // Ƿݿsession
                if ($this->sess_use_database === TRUE)
                {
                        $this->CI->db->where('session_id', $session['session_id']);
 
                        if ($this->sess_match_ip == TRUE)
                        {
                                $this->CI->db->where('ip_address', $session['ip_address']);
                        }
 
                        if ($this->sess_match_useragent == TRUE)
                        {
                                $this->CI->db->where('user_agent', $session['user_agent']);
                        }
 
                        $query = $this->CI->db->get($this->sess_table_name);
 
                        // No result?  Kill it!
                        // ûsession
                        if ($query->num_rows() == 0)
                        {
                                $this->sess_destroy(FALSE);
                                return FALSE;
                        }
 
                        // Is there custom data?  If so, add it to the main session array
                        $row = $query->row();
                        if (isset($row->user_data) AND $row->user_data != '')
                        {
                                $custom_data = $this->_unserialize($row->user_data);
 
                                if (is_array($custom_data))
                                {
                                        foreach ($custom_data as $key => $val)
                                        {
                                                $session[$key] = $val;
                                        }
                                }
                        }
                }               
                
                // Session is valid!
                // Чsession
                $this->userdata = $session;
                unset($session);
 
                return TRUE;
        }
 
        // --------------------------------------------------------------------
 
        /**
         * Write the session data
         * дsession
         * 
         * @access      public
         * @return      void
         */
        public function sess_write()
        {
                // set the custom userdata, the session data we will set in a second
                // sessionд뵽ԭsessionȫֱ
                $_SESSION = array();
                foreach($this->userdata as $key => $val)
                {
                        $_SESSION[$key] = $val;
                }
                
                //жǷҪݿ
                if($this->sess_use_database === TRUE)
                {
                        $custom_userdata = $this->userdata;
                        foreach( array('session_id','ip_address','user_agent','last_activity') as $value )
                        {
                                unset($custom_userdata[$value]);
                        }
                        
                        // Did we find any custom data?  If not, we turn the empty array into a string
                        // since there's no reason to serialize and store an empty array in the DB
                        if(count($custom_userdata) === 0)
                        {
                                $custom_userdata = '';
                        }
                        else
                        {
                                // Serialize the custom data array so we can store it
                                $custom_userdata = $this->_serialize($custom_userdata);
                        }
                        
                        // Run the update query
                        $this->CI->db->where('session_id', $this->userdata['session_id']);
                        
                        // Update data
                        $data = array(
                                'last_activity'         => $this->userdata['last_activity'],
                                'user_data'                     => $custom_userdata
                        );
                        $this->CI->db->update($this->sess_table_name, $data);
                        
                }
        }
 
        // --------------------------------------------------------------------
 
        /**
         * Create a new session
         * session
         * 
         * @access      public
         * @return      void
         */
        public function sess_create()
        {
                if(session_id() == '')
                {
                        session_start();
                }
 
                $_SESSION['session_id']         = session_id();
                $_SESSION['ip_address']         = $this->CI->input->ip_address();
                $_SESSION['user_agent']         = substr($this->CI->input->user_agent(), 0, 120);
                $_SESSION['last_activity']      = $this->now;
 
                $this->userdata = $_SESSION;
                
                // Save the data to the DB if needed
                if ($this->sess_use_database === TRUE)
                {
                        //session
                        $this->CI->db->query($this->CI->db->insert_string($this->sess_table_name, $this->userdata));
                }
        }
 
        // --------------------------------------------------------------------
 
        /**
         * Update an existing session
         * Ѵڵsession
         * 
         * @access      public
         * @return      void
         */
        public function sess_update()
        {
                // We only update the session every five minutes by default
                // ĬsessionӸһ
                if(($this->userdata['last_activity'] + $this->sess_time_to_update) >= $this->now)
                {
                        return;
                }
                
                // Save the old session id so we know which record to
                // update in the database if we need it
                $old_sessid = $this->userdata['session_id'];
                
                // Regenerate session id
                // ظעsessionID
                session_regenerate_id();
 
                // Update the session data in the session data array
                // sessionеsession
               // $this->userdata['session_id'] = session_id();
                $this->userdata['session_id'] = $old_sessid;
                $this->userdata['last_activity'] = $this->now;
                
                // Update the session ID and last_activity field in the DB if needed
                if ($this->sess_use_database === TRUE)
                {
                        //$this->CI->db->query($this->CI->db->update_string($this->sess_table_name, array('last_activity' => $this->now, 'session_id' => $this->userdata['session_id']), array('session_id' => $old_sessid)));
						$this->CI->db->query($this->CI->db->update_string($this->sess_table_name, array('last_activity' => $this->now), array('session_id' => $old_sessid))); 
				}               
        }
 
        // --------------------------------------------------------------------
 
        /**
         * Destroy the current session
         * յǰsession
         * 
         * @access      public
         * @param       bool    Ƿɾsession
         * @return      void
         */
        public function sess_destroy($destroy = TRUE)
        {
                // Kill the session DB row
                if ($this->sess_use_database === TRUE AND isset($this->userdata['session_id']))
                {
                        $this->CI->db->where('session_id', $this->userdata['session_id']);
                        $this->CI->db->delete($this->sess_table_name);
                }
                
                session_unset();
                session_regenerate_id();
 
                if($destroy)
                {
                        session_destroy();
                }
        }
 
        // --------------------------------------------------------------------
 
        /**
         * Does nothing for native sessions
         * ԭsession
         * 
         * @access public
         * @return void
         */
        //public function _sess_gc(){}
        
        // --------------------------------------------------------------------
}
 
 
// Customize the PHP Session handler
// @see http://php.net/manual/en/function.session-set-save-handler.php
class Cache_Session_Handler
{
	private $_lifetime = 0;
	private $_CI;

	public function __construct()
	{
		session_name(config_item('sess_cookie_name'));

		session_set_save_handler(
			array($this, "open"),
			array($this, "close"),
			array($this, "read"),
			array($this, "write"),
			array($this, "destroy"),
			array($this, "gc")
		);

		// Ref the 'CI' super global object
		$this->_CI = & get_instance();

		if( ! $this->_CI->load->is_loaded('cache'))
		{
			// Make sure your 2.0+ CI Cache driver library is loaded
			// and set as the primary cache solution
			$this->_CI->load->driver(
				'cache',
				array('adapter' => 'memcache', 'backup' => 'file'
			));
		}
	}

	public function open()
	{
		$this->_lifetime = ini_get('session.gc_maxlifetime');
		if($this->_lifetime <= config_item('sess_expiration'))
		{
			$this->_lifetime = config_item('sess_expiration');
		}

		return TRUE;
	}

	public function read($id)
	{
		return $this->_CI->cache->get("sess_{$id}");
	}

	public function write($id, $data)
	{
		return $this->_CI->cache->replace("sess_{$id}", $data, $this->_lifetime);
	}

	public function destroy($id)
	{
		return $this->_CI->cache->delete("sess_{$id}");
	}

	public function gc()
	{
		return TRUE;
	}

	public function close()
	{
		return TRUE;
	}

	public function __destruct()
	{
		session_write_close();
	}
}