<?php
/**
	 * 安全过滤类-获取GET或者POST的参数值，经过过滤
	 * 如果不指定$type类型，则获取同名的，POST优先
	 * $isfilter 默认开启，强制转换请求的数据
	 * 该方法在Controller层中，获取所有GET或者POST数据，都需要走这个接口
	 *  Controller中使用方法：$this->controller->get_gp($value, $type = null,  $isfilter = true)
	 * @param  string|array $value 参数
	 * @param  string|array $type 获取GET或者POST参数，P - POST ， G - GET, U - PUT , D -DEL
	 * @param  bool         $isfilter 变量是否过滤
	 * @return string|array
	 */
class Filters {
	public function getPost($value, $type = null,  $isfilter = false) {
		if ($type == 'U' || $type == 'D') {
			parse_str(file_get_contents('php://input'), $requestData);
		}
		if (!is_array($value)) {
			if ($type === null) {
				if (isset($_GET[$value])) $temp = $_GET[$value];
				if (isset($_POST[$value])) $temp = $_POST[$value];
			} elseif ($type == 'U' || $type == 'D') { //PUT 和 DEL
				$temp = $requestData[$value];
			} else {
				$temp = (strtoupper($type) == 'G') ? $_GET[$value] : $_POST[$value];
			}
			$temp = ($isfilter === true) ? $this->filterEscape($temp) : $temp;
			return $temp;
		} else {
			$temp = array();
			foreach ($value as $val) {
				if ($type === null) {
					if (isset($_GET[$val])) $temp[$val] = $_GET[$val];
					if (isset($_POST[$val])) $temp[$val] = $_POST[$val];
				} elseif ($type == 'U' || $type == 'D') {
					$temp[$val] = $requestData[$val];
				} else {
					$temp[$val] = (strtoupper($type) == 'G') ? $_GET[$val] : $_POST[$val];
				}
				$temp[$val] = ($isfilter === true) ? $this->filterEscape($temp[$val]) : $temp[$val];
			}
			return $temp;
		}
	}
	/**
	 * 安全过滤类-全局变量过滤
	 * 在Controller初始化的时候已经运行过该变量，对全局变量进行处理
     *  Controller中使用方法：$this->controller->filter()
	 * @return
	 */
	public function filter() {
		if (is_array($_SERVER)) {
			foreach ($_SERVER as $k => $v) {
				if (isset($_SERVER[$k])) {
					$_SERVER[$k] = str_replace(array('<','>','"',"'",'%3C','%3E','%22','%27','%3c','%3e'), '', $v);
				}
			}
		}
		unset($_ENV, $HTTP_GET_VARS, $HTTP_POST_VARS, $HTTP_COOKIE_VARS, $HTTP_SERVER_VARS, $HTTP_ENV_VARS);
		self::filterSlashes($_GET);
		self::filterSlashes($_POST);
		self::filterSlashes($_COOKIE);
		self::filterSlashes($_FILES);
		self::filterSlashes($_REQUEST);
	}
	/**
	 * 安全过滤类-加反斜杠，放置SQL注入
	 *  Controller中使用方法：$this->controller->filterSlashes(&$value)
	 * @param  string $value 需要过滤的值
	 * @return string
	 */
	public static function filterSlashes(&$value) {
		if (get_magic_quotes_gpc()) return false; //开启魔术变量
		$value = (array) $value;
		foreach ($value as $key => $val) {
			if (is_array($val)) {
				self::filterSlashes($value[$key]);
			} else {
				$value[$key] = addslashes($val);
			}
		}
	}
	/**
	 * 安全过滤类-过滤javascript,css,iframes,object等不安全参数 过滤级别高
	 *  Controller中使用方法：$this->controller->filterScript($value)
	 * @param  string $value 需要过滤的值
	 * @return string
	 */
	public function filterScript($value) {
		$value = preg_replace("/(javascript:)?on(click|load|key|mouse|error|abort|move|unload|change|dblclick|move|reset|resize|submit)/i","&111n\\2",$value);
		$value = preg_replace("/<script(.*?)>(.*?)<\/script>/si","",$value);
		$value = preg_replace("/<iframe(.*?)>(.*?)<\/iframe>/si","",$value);
		$value = preg_replace ("/<object.+<\/object>/iesU", '', $value);
		return $value;
	}
	/**
	 * 安全过滤类-过滤HTML标签
	 *  Controller中使用方法：$this->controller->filterHtml($value)
	 * @param  string $value 需要过滤的值
	 * @return string
	 */
	public function filterHtml($value) {
		if (function_exists('htmlspecialchars')) return htmlspecialchars($value);
		return str_replace(array("&", '"', "'", "<", ">"), array("", "", "", "", ""), $value);
	}
	/**
	 * 安全过滤类-对进入的数据加下划线 防止SQL注入
	 *  Controller中使用方法：$this->controller->filterSql($value)
	 * @param  string $value 需要过滤的值
	 * @return string
	 */
	public 	function filterSql($value) {
		$sql = array("select", 'insert', "update", "delete", "\'", "\/\*", "//","\\",
						"\.\.\/", "\.\/", "union", "into", "load_file", "outfile");
		$sql_re = array("","","","","","","","","","","","");
		return str_replace($sql, $sql_re, $value);
	}
	/**
	 * 安全过滤类-通用数据过滤
	 *  Controller中使用方法：$this->controller->filterEscape($value)
	 * @param string $value 需要过滤的变量
	 * @return string|array
	 */
	public function filterEscape($value) {
		if (is_array($value)) {
			foreach ($value as $k => $v) {
				$value[$k] = self::filterStr($v);
			}
		} else {
			$value = self::filterStr($value);
		}
		return $value;
	}
	/**
	 * 安全过滤类-字符串过滤 过滤特殊有危害字符
	 *  Controller中使用方法：$this->controller->filterStr($value)
	 * @param  string $value 需要过滤的值
	 * @return string
	 */
	public function filterStr($value) {
		$value = str_replace(array("\0","%00","\r"), '', $value); 
		$value = preg_replace(array('/[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]/','/&(?!(#[0-9]+|[a-z]+);)/is'), array('', '&amp;'), $value);
		$value = str_replace(array("%3C",'<'), '', $value);
		$value = str_replace(array("%3E",'>'), '', $value);
		$value = str_replace(' ', '', $value);
		$value = str_replace(array('"',"'","\t",'  '), array('&quot;','&#39;','    ','&nbsp;&nbsp;'), $value);
		return $value;
	}
	/**
	 * 私有路径安全转化
	 *  Controller中使用方法：$this->controller->filterDir($fileName)
	 * @param string $fileName
	 * @return string
	 */
	public function filterDir($fileName) {
		$tmpname = strtolower($fileName);
		$temp = array('://',"\0", "..");
		if (str_replace($temp, '', $tmpname) !== $tmpname) {
			return false;
		}
		return $fileName;
	}
	/**
	 * 过滤目录
	 *  Controller中使用方法：$this->controller->filterPath($path)
	 * @param string $path
	 * @return array
	 */
	public function filterPath($path) {
		$path = str_replace(array("'",'#','=','`','$','%','&',';'), '', $path);
		return rtrim(preg_replace('/(\/){2,}|(\\\){1,}/', '/', $path), '/');
	}
	/**
	 * 过滤PHP标签
	 *  Controller中使用方法：$this->controller->filterPhpTag($string)
	 * @param string $string
	 * @return string
	 */
	public function filterPhpTag($string) {
		return str_replace(array('<?', '?>'), array('&lt;?', '?&gt;'), $string);
	}
	/**
	 * 安全过滤类-返回函数
	 *  Controller中使用方法：$this->controller->strOut($value)
	 * @param  string $value 需要过滤的值
	 * @return string
	 */
	public function strOut($value) {
		$badstr = array("&", '"', "'", "<", ">", "%3C", "%3E");
		$newstr = array("&amp;", "&quot;", "&#039;", "&lt;", "&gt;", "&lt;", "&gt;");
		$value  = str_replace($newstr, $badstr, $value);
		return stripslashes($value); //下划线
	}
	/**
	* @desc   安全体检公共方法
	* @access public
	* @param  string $value 需要过滤的值
	* @return $value
	*/
	public  function filterAll($value)
	{
		if (is_array($value))
		{
			foreach ($value as $key => $var)
			{
				$var = $this->filterSql($var);
				$var = $this->filterScript($var);
				$var = $this->filterStr($var);						
				$row[$key] = $var;				
			}
			return $row;
		}
		else 
		{
			$value = $this->filterSql($value);
			$value = $this->filterScript($value);
			$value = $this->filterStr($value);
			
			return $value;
		} 
	}
}