<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Data_m extends CI_Model
{
	var $table;
	function __construct(){
  		parent::__construct();
	}

	function setTable($table){
		$this->table = $table;
	}

	function setWhere($getwhere){
		if(is_array($getwhere)){
			foreach($getwhere as $key=>$where){
				if($key=='findinset'){
					$this->db->where("1","1 AND FIND_IN_SET($where)",FALSE);
					continue;
				}
				if($key=='like'){
					$this->db->like($where);
					continue;
				}
				if($key=='orlike'){
					$this->db->or_like($where);
					continue;
				}
				if($key=='or'){
					$this->db->or_where($where);
					continue;
				}				
				if(is_array($where)){
					$this->db->where_in($key, $where);
				}else{
					$this->db->where($key,$where);
				}
			}
		}else{
			$this->db->where($getwhere);
		}
	}

	function addData($data,$table=''){
		$table = $table==''?$this->table:$table;
		if($data){
			$this->db->insert($table,$data);
			return $this->db->insert_id();
		}else{
			return false;
		}
	}

	function editData($datawhere,$data,$table=''){
		$table = $table==''?$this->table:$table;
		if(!empty($datawhere))
		{
			$this->db->where($datawhere);
		}
		$this->db->update($table,$data);
    return $this->db->affected_rows() > 0 ? true:false;
	}

	function delData($ids,$table=''){
		$table = $table==''?$this->table:$table;
		if(is_array($ids)){
			$this->db->where_in('id',$ids);
		}else{
			$this->db->where('id',$ids);
		}
		$this->db->delete($table);
		return $this->db->affected_rows() > 0 ? true:false;
	}

	function getData($getwhere="",$order='',$pagenum="0",$exnum="0",$table='',$select = '*'){
		$table = $table==''?$this->table:$table;
		if($getwhere){
			$this->setWhere($getwhere);
		}
		$this->db->select($select);
		if($order == "rand()"){
  			$pagenum_r = intval($pagenum) * 10 ;
			$this->db->limit($pagenum_r,$exnum);
			$data = $this->db->get($table)->result_array();
			shuffle($data);
		    array_splice($data , intval($pagenum));
			return $data;
/* 			$data_nums = $this->getDataNum($getwhere,$table);
			$exnum = mt_rand(0,$data_nums - 10 - $pagenum);
			$this->db->select($select);		 */
		}else if($order == "rand_x()"){
			//$this->db->select("MAX(id) as a,MIN(id) as b");
  			$data = $this->db->get($table)->result_array();
			$max_id = $data[0]['a'];
			$min_id = $data[0]['b'];
			$exnum = mt_rand($min_id,$max_id - 200);
/* 			$data_nums = $this->getDataNum($getwhere,$table);
			//
			$exnum = mt_rand(0,$data_nums - 10);
			$this->db->select($select); */
		}else if($order){
			$this->db->order_by($order);
		}
		//die;

		if($pagenum>0){
			$this->db->limit($pagenum,$exnum);
		}
		$data = $this->db->get($table)->result_array();
		return $data;
	}

	function getSingle($getwhere="",$table=''){
		$table = $table==''?$this->table:$table;
		if($getwhere){
			$this->setWhere($getwhere);
		}
		$row = $this->db->get($table)->row_array();
		return $row;
	}

	function getDataNum($getwhere='',$table=''){
		$table = $table==''?$this->table:$table;
		if($getwhere){
			$this->setWhere($getwhere);
		}
		return $this->db->count_all_results($table);
	}

	function setHits($id,$table=''){
		$table = $table==''?$this->table:$table;
		$this->db->where('id',$id);
		$this->db->set('hits', 'hits+1',FALSE);
		$this->db->set('realhits', 'realhits+1',FALSE);
		$this->db->update($table);
	}

	function listOrder($ids,$res,$order='',$table=''){
		$table = $table==''?$this->table:$table;
		$num = count($ids);
		$data = array();
		for($i=0;$i<$num;$i++){
			$data[] = array('id'=>$ids[$i],'listorder'=>$res[$i]);
		}
		$this->db->update_batch($table,$data,'id');

		return $this->db->affected_rows() > 0 ? true:false;
	}
}