<?php namespace Phpcmf\Controllers\Admin;

class Update extends \Phpcmf\Common
{

	public function __construct(...$params) {
		parent::__construct(...$params);
		\Phpcmf\Service::V()->assign('menu', \Phpcmf\Service::M('auth')->_admin_menu(
			[
				'程序升级' => ['update/index', 'fa fa-cloud'],
			]
		));
	}

	public function index() {

        $cms = require MYPATH.'Config/Version.php';

		\Phpcmf\Service::V()->assign([
            'cms_version' => $cms['version'],
		]);
		\Phpcmf\Service::V()->display('update.html');
	}

    public function version() {

        $data = dr_catcher_data('http://www.php7cms.com/version.php');

        if (!$data) {
            exit('<p style="color:red;"> 暂时无法获取到服务器端版本信息 </p>');
        }

        if (strlen($data) > 20) {
            exit('<p style="color:red;"> 返回数据不规范，请联系官方！ </p>');
        }

        $cms = require MYPATH.'Config/Version.php';

        $fwq = (string)($data);
        $azb = (string)($cms['version']);
        if ($fwq != $azb) {
            $data.= '，'.'<span style="color:red">有新版本可更新</span>';

        }


        echo('<p> 本网站程序更新时间为： '.$cms['version'].'</a></p>');
        exit('<p> <a href="https://gitee.com/wchunjie/PHP7CMS" style="color:green;" target="_blank">服务器程序更新时间为： '.$data.'</a></p>');

    }


}
