
--
-- Database: `php7cms`
--

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_block`
--

DROP TABLE IF EXISTS `dr_1_block`;
CREATE TABLE IF NOT EXISTS `dr_1_block` (
  `id` smallint(5) unsigned NOT NULL,
  `name` varchar(100) NOT NULL COMMENT '资料块名称',
  `content` text NOT NULL COMMENT '内容',
  `code` varchar(100) NOT NULL
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='资料块表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_navigator`
--

DROP TABLE IF EXISTS `dr_1_navigator`;
CREATE TABLE IF NOT EXISTS `dr_1_navigator` (
  `id` smallint(5) unsigned NOT NULL,
  `pid` smallint(5) unsigned NOT NULL COMMENT '上级id',
  `pids` text COMMENT '所有上级id数据项',
  `type` tinyint(1) unsigned NOT NULL COMMENT '导航类型',
  `name` varchar(255) NOT NULL COMMENT '导航名称',
  `title` varchar(255) NOT NULL COMMENT 'seo标题',
  `url` varchar(255) NOT NULL COMMENT '导航地址',
  `thumb` varchar(255) NOT NULL COMMENT '图片标示',
  `show` tinyint(1) unsigned NOT NULL COMMENT '显示',
  `mark` varchar(255) DEFAULT NULL COMMENT '类型标示',
  `extend` tinyint(1) unsigned DEFAULT NULL COMMENT '是否继承下级',
  `child` tinyint(1) unsigned NOT NULL COMMENT '是否有下级',
  `childids` text COMMENT '所有下级数据项',
  `target` tinyint(1) unsigned NOT NULL COMMENT '是否站外链接',
  `displayorder` smallint(5) NOT NULL COMMENT '显示顺序'
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='网站导航表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_news`
--

DROP TABLE IF EXISTS `dr_1_news`;
CREATE TABLE IF NOT EXISTS `dr_1_news` (
  `id` int(10) unsigned NOT NULL,
  `catid` smallint(5) unsigned NOT NULL COMMENT '栏目id',
  `title` varchar(255) DEFAULT NULL COMMENT '主题',
  `thumb` varchar(255) DEFAULT NULL COMMENT '缩略图',
  `keywords` varchar(255) DEFAULT NULL COMMENT '关键字',
  `description` text COMMENT '描述',
  `hits` int(10) unsigned DEFAULT NULL COMMENT '浏览数',
  `uid` int(10) unsigned NOT NULL COMMENT '作者id',
  `author` varchar(50) NOT NULL COMMENT '作者名称',
  `status` tinyint(2) NOT NULL COMMENT '状态',
  `url` varchar(255) DEFAULT NULL COMMENT '地址',
  `link_id` int(10) NOT NULL DEFAULT '0' COMMENT '同步id',
  `tableid` smallint(5) unsigned NOT NULL COMMENT '附表id',
  `inputip` varchar(15) DEFAULT NULL COMMENT '录入者ip',
  `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间',
  `updatetime` int(10) unsigned NOT NULL COMMENT '更新时间',
  `comments` int(10) unsigned DEFAULT '0' COMMENT '评论数量',
  `favorites` int(10) unsigned DEFAULT '0' COMMENT '收藏数量',
  `avgsort` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '平均点评分数',
  `support` int(10) unsigned DEFAULT '0' COMMENT '支持数',
  `oppose` int(10) unsigned DEFAULT '0' COMMENT '反对数',
  `donation` decimal(8,2) unsigned NOT NULL COMMENT '捐赠金额',
  `displayorder` int(10) DEFAULT '0' COMMENT '排序值'
) ENGINE=MyISAM AUTO_INCREMENT=661 DEFAULT CHARSET=utf8 COMMENT='内容主表';

--
-- 转存表中的数据 `dr_1_news`
--

REPLACE INTO `dr_1_news` (`id`, `catid`, `title`, `thumb`, `keywords`, `description`, `hits`, `uid`, `author`, `status`, `url`, `link_id`, `tableid`, `inputip`, `inputtime`, `updatetime`, `comments`, `favorites`, `avgsort`, `support`, `oppose`, `donation`, `displayorder`) VALUES
(637, 9, '大文件上传支持环境', '', '程序支持环境,程序支持', '1、打开php.ini（打开方式就不用说了，百度一大堆）2、查找post_max_size表单提交最大数值,此项不是限制上传单个文件的大小,而是针对整个表单的提交数据进行限制的默认为8M，设置为自己需要的值，此参数建议要设置比...', 1, 1, 'admin', 9, '/index.php?c=show&id=637', 0, 0, '127.0.0.1', 1534896412, 1534896696, 0, 0, '0.00', 0, 0, '0.00', 0),
(639, 9, '程序支持环境', '', '程序支持环境,程序支持', '一、硬件环境1、入门级：CPU内存1核1G、硬盘40GB、带宽1M2、普通级：CPU内存1核2G、硬盘40GB、带宽2M3、增强级：CPU内存2核4G、硬盘40GB、带宽4M4、数据级：CPU内存4核16G、硬盘100GB、带宽4M二、操作系统1、推荐环...', 0, 1, 'admin', 9, '/index.php?c=show&id=639', 0, 0, '127.0.0.1', 1534896412, 1534896412, 0, 0, '0.00', 0, 0, '0.00', 0),
(640, 9, '制作网站模板', '', '模板,网站模板,制作', 'CMS主要任务是后台的数据管理，前端界面可以由开发者设计出各种各样的展示界面来显示后台的数据。1、了解CMS模板目录结构http://help.phpcmf.net/369.html2、创建自己的模板新建模板目录：/template/pc/test_html/ ...', 1, 1, 'admin', 9, '/index.php?c=show&id=640', 0, 0, '127.0.0.1', 1534896751, 1534896751, 0, 0, '0.00', 0, 1, '0.00', 0),
(641, 9, '固定变量介绍', '', '变量,固定,介绍', '页面SEO信息变量：{$meta_title}引用css风格目录：常量对照目录表：{HOME_THEME_PATH}：/static/风格目录/{THEME_PATH}：/static/', 0, 1, 'admin', 9, '/index.php?c=show&id=641', 0, 0, '127.0.0.1', 1534896770, 1534896770, 0, 0, '0.00', 0, 0, '0.00', 0),
(642, 10, 'SE 与微软展开合作的基础是满足客户不', '', '微软,内核', 'SUSE 今天宣布推出首个针对微软 Azure 定制的企业版 Linux 内核。SUSE Linux Enterprise Server15 现可在定制调校版内核上运行，为微软Azure工作负荷带来更强的性能、更快的启动速度和更小的内存占用。Azure 调校版...', 1, 1, 'admin', 9, '/index.php?c=show&id=642', 0, 0, '127.0.0.1', 1534896875, 1534896938, 0, 0, '0.00', 0, 0, '0.00', 0),
(643, 10, '新增和未来Azure 功能的访问速度，帮助', '', '微软,内核', 'SUSE 今天宣布推出首个针对微软 Azure 定制的企业版 Linux 内核。SUSE Linux Enterprise Server15 现可在定制调校版内核上运行，为微软Azure工作负荷带来更强的性能、更快的启动速度和更小的内存占用。Azure 调校版...', 1, 1, 'admin', 9, '/index.php?c=show&id=643', 0, 0, '127.0.0.1', 1534896875, 1534896955, 0, 0, '0.00', 0, 0, '0.00', 0),
(644, 10, '调校版内核能够提高新增和未来Azure', '', '微软,内核', 'SUSE 今天宣布推出首个针对微软 Azure 定制的企业版 Linux 内核。SUSE Linux Enterprise Server15 现可在定制调校版内核上运行，为微软Azure工作负荷带来更强的性能、更快的启动速度和更小的内存占用。Azure 调校版...', 1, 1, 'admin', 9, '/index.php?c=show&id=644', 0, 0, '127.0.0.1', 1534896875, 1534896966, 0, 0, '0.00', 0, 0, '0.00', 0),
(645, 10, '公司企业开源小组总经理KY Srinivasan ', '', '微软,内核', 'SUSE 今天宣布推出首个针对微软 Azure 定制的企业版 Linux 内核。SUSE Linux Enterprise Server15 现可在定制调校版内核上运行，为微软Azure工作负荷带来更强的性能、更快的启动速度和更小的内存占用。Azure 调校版...', 1, 1, 'admin', 9, '/index.php?c=show&id=645', 0, 0, '127.0.0.1', 1534896875, 1534896976, 0, 0, '0.00', 0, 0, '0.00', 0),
(646, 10, '微软展开合作的基础是满足客户不断发展的', '', '微软,内核', 'SUSE 今天宣布推出首个针对微软 Azure 定制的企业版 Linux 内核。SUSE Linux Enterprise Server15 现可在定制调校版内核上运行，为微软Azure工作负荷带来更强的性能、更快的启动速度和更小的内存占用。Azure 调校版...', 6, 1, 'admin', 9, '/index.php?c=show&id=646', 0, 0, '127.0.0.1', 1534896875, 1534896989, 0, 0, '0.00', 1, 1, '0.00', 0),
(647, 10, 'SUSE 合作微软推出 Azure 优化的企业版 Linux 内核', '', '微软,内核', 'SUSE 今天宣布推出首个针对微软 Azure 定制的企业版 Linux 内核。SUSE Linux Enterprise Server15 现可在定制调校版内核上运行，为微软Azure工作负荷带来更强的性能、更快的启动速度和更小的内存占用。Azure 调校版...', 0, 1, 'admin', 9, '/index.php?c=show&id=647', 0, 0, '127.0.0.1', 1534896875, 1534896875, 0, 0, '0.00', 0, 0, '0.00', 0),
(648, 3, '服务或应用程序上，然后通过反序列将字符', '', '序列化,WordPress,远程攻击', '并指出该漏洞影响了所有接受用户资料的 PHP 应用程序和库，包括 WordPress 等内容管理系统（CMS），并将允许远程程序攻击。序列化（Serialization）与反序列化（Deserialization）是所有编程语言都具备的功能，序列...', 1, 1, 'admin', 9, '/index.php?c=show&id=648', 0, 0, '127.0.0.1', 1534897027, 1534897063, 0, 0, '0.00', 0, 0, '0.00', 0),
(649, 3, '过去外界认为 XXE 漏洞带来的最大问题是信息外', '', '序列化,WordPress,远程攻击', '并指出该漏洞影响了所有接受用户资料的 PHP 应用程序和库，包括 WordPress 等内容管理系统（CMS），并将允许远程程序攻击。序列化（Serialization）与反序列化（Deserialization）是所有编程语言都具备的功能，序列...', 1, 1, 'admin', 9, '/index.php?c=show&id=649', 0, 0, '127.0.0.1', 1534897027, 1534897085, 0, 0, '0.00', 0, 0, '0.00', 0),
(650, 3, '漏洞或服务器端伪造请求（SSFR）漏洞等', '', '序列化,WordPress,远程攻击', '并指出该漏洞影响了所有接受用户资料的 PHP 应用程序和库，包括 WordPress 等内容管理系统（CMS），并将允许远程程序攻击。序列化（Serialization）与反序列化（Deserialization）是所有编程语言都具备的功能，序列...', 1, 1, 'admin', 9, '/index.php?c=show&id=650', 0, 0, '127.0.0.1', 1534897027, 1534897074, 0, 0, '0.00', 0, 0, '0.00', 0),
(651, 3, '过去外界认为 XXE 漏洞带来的最大问题是信息外泄，但现在可出', '', '序列化,WordPress,远程攻击', '并指出该漏洞影响了所有接受用户资料的 PHP 应用程序和库，包括 WordPress 等内容管理系统（CMS），并将允许远程程序攻击。序列化（Serialization）与反序列化（Deserialization）是所有编程语言都具备的功能，序列...', 1, 1, 'admin', 9, '/index.php?c=show&id=651', 0, 0, '127.0.0.1', 1534897027, 1534897096, 0, 0, '0.00', 0, 0, '0.00', 0),
(652, 3, '现反序列化漏洞，或使 WordPress 遭远程攻击', '', '序列化,WordPress,远程攻击', '并指出该漏洞影响了所有接受用户资料的 PHP 应用程序和库，包括 WordPress 等内容管理系统（CMS），并将允许远程程序攻击。序列化（Serialization）与反序列化（Deserialization）是所有编程语言都具备的功能，序列...', 0, 1, 'admin', 9, '/index.php?c=show&id=652', 0, 0, '127.0.0.1', 1534897027, 1534897027, 0, 0, '0.00', 0, 0, '0.00', 0),
(653, 3, '所有编程语言都具备的功能，序列化将对', '', '序列化,WordPress,远程攻击', '并指出该漏洞影响了所有接受用户资料的 PHP 应用程序和库，包括 WordPress 等内容管理系统（CMS），并将允许远程程序攻击。序列化（Serialization）与反序列化（Deserialization）是所有编程语言都具备的功能，序列...', 1, 1, 'admin', 9, '/index.php?c=show&id=653', 0, 0, '127.0.0.1', 1534897027, 1534897053, 0, 0, '0.00', 0, 0, '0.00', 0),
(654, 4, 'PHPCMS的优点并提供PHP7语言强大稳定的技术架构', '', 'PHP7CMS,授权,发布', 'PHP7CMS由春杰工作室采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。核心框...', 2, 1, 'admin', 9, '/index.php?c=show&id=654', 0, 0, '127.0.0.1', 1534897110, 1534897158, 0, 0, '0.00', 0, 0, '0.00', 0),
(655, 4, '使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到', '', 'PHP7CMS,授权,发布', 'PHP7CMS由春杰工作室采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。核心框...', 1, 1, 'admin', 9, '/index.php?c=show&id=655', 0, 0, '127.0.0.1', 1534897110, 1534897168, 0, 0, '0.00', 0, 0, '0.00', 0),
(656, 4, '还是想让网站在不断壮大后仍能得到随意扩', '', 'PHP7CMS,授权,发布', 'PHP7CMS由春杰工作室采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。核心框...', 1, 1, 'admin', 9, '/index.php?c=show&id=656', 0, 0, '127.0.0.1', 1534897110, 1534897177, 0, 0, '0.00', 0, 0, '0.00', 0),
(657, 4, 'HP7CMS由春杰工作室采用PHP7技术全新研发的内容管理', '', 'PHP7CMS,授权,发布', 'PHP7CMS由春杰工作室采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。核心框...', 1, 1, 'admin', 9, '/index.php?c=show&id=657', 0, 0, '127.0.0.1', 1534897110, 1534897186, 0, 0, '0.00', 0, 0, '0.00', 0),
(658, 4, 'PHP7CMS授权版发布介绍', '', 'PHP7CMS,授权,发布', 'PHP7CMS由春杰工作室采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。核心框...', 0, 1, 'admin', 9, '/index.php?c=show&id=658', 0, 0, '127.0.0.1', 1534897110, 1534897110, 0, 0, '0.00', 0, 0, '0.00', 0),
(659, 4, '春杰工作室采用PHP7技术全新研发的', '', 'PHP7CMS,授权,发布', 'PHP7CMS由春杰工作室采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。核心框...', 1, 1, 'admin', 9, '/index.php?c=show&id=659', 0, 0, '127.0.0.1', 1534897110, 1534897147, 0, 0, '0.00', 0, 0, '0.00', 0),
(660, 4, 'PHP7CMS授权版发布介绍', '', 'PHP7CMS,授权,发布', 'PHP7CMS由春杰工作室采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。核心框...', 0, 1, 'admin', 9, '/index.php?c=show&id=660', 0, 0, '127.0.0.1', 1534897110, 1534897110, 0, 0, '0.00', 0, 0, '0.00', 0);

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_news_data_0`
--

DROP TABLE IF EXISTS `dr_1_news_data_0`;
CREATE TABLE IF NOT EXISTS `dr_1_news_data_0` (
  `id` int(10) unsigned NOT NULL,
  `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
  `catid` smallint(5) unsigned NOT NULL COMMENT '栏目id',
  `content` mediumtext COMMENT '内容',
  `yanseceshi` varchar(30) DEFAULT NULL COMMENT '颜色测试'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='内容附表';

--
-- 转存表中的数据 `dr_1_news_data_0`
--

REPLACE INTO `dr_1_news_data_0` (`id`, `uid`, `catid`, `content`, `yanseceshi`) VALUES
(639, 1, 9, '&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;&lt;strong style=&quot;word-wrap: break-word;&quot;&gt;&lt;span style=&quot;word-wrap: break-word; font-size: 16px; font-style: italic; line-height: 18px;&quot;&gt;一、硬件环境&lt;/span&gt;&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;1、入门级：&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;CPU内存1核1G、硬盘40GB、带宽1M&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;2、普通级：&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;CPU内存1核2G、硬盘40GB、带宽2M&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;&lt;span style=&quot;word-wrap: break-word; font-size: 16px; font-style: italic; font-weight: bold; line-height: 18px;&quot;&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;3、增强级：&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;CPU内存2核4G、硬盘40GB、带宽4M&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;4、数据级：&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;CPU内存4核16G、硬盘100GB、带宽4M&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;&lt;br style=&quot;word-wrap: break-word;&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;&lt;strong style=&quot;word-wrap: break-word; font-size: 16px; font-style: italic;&quot;&gt;二、操作系统&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;1、推荐环境：&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;Linux CentOS 7.0 x64以上&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;&lt;br style=&quot;word-wrap: break-word;&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;2、其他环境：&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;Windows 不推荐，PHP程序不推荐Win系统&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;&lt;br style=&quot;word-wrap: break-word;&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;&lt;span style=&quot;word-wrap: break-word; font-size: 16px; font-style: italic; font-weight: bold; line-height: 18px;&quot;&gt;&lt;strong style=&quot;word-wrap: break-word;&quot;&gt;&lt;br style=&quot;word-wrap: break-word;&quot;/&gt;&lt;/strong&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;&lt;span style=&quot;word-wrap: break-word; font-size: 16px; font-style: italic; font-weight: bold; line-height: 18px;&quot;&gt;&lt;strong style=&quot;word-wrap: break-word;&quot;&gt;三、软件环境&lt;/strong&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;&lt;strong style=&quot;word-wrap: break-word;&quot;&gt;&lt;br style=&quot;word-wrap: break-word;&quot;/&gt;&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;&lt;strong style=&quot;word-wrap: break-word;&quot;&gt;程序支持环境：&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;PHP7.1+&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; font-size: 14px; white-space: normal;&quot;&gt;Mysql5+&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(640, 1, 9, '&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;CMS主要任务是后台的数据管理，前端界面可以由开发者设计出各种各样的展示界面来显示后台的数据。&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;br/&gt;&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;1、了解CMS模板目录结构&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;a target=&quot;_blank&quot; href=&quot;http://help.phpcmf.net/369.html&quot; style=&quot;word-wrap: break-word; outline: 0px; text-decoration-line: none; cursor: pointer; color: rgb(51, 51, 51);&quot;&gt;http://help.phpcmf.net/369.html&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;br/&gt;&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;2、创建自己的模板&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;新建模板目录：/template/pc/test_html/ （如果创建移动端模板，就建站mobile目录下即可）&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;test_html目录就是新的模板目录，用于存放html界面的解析文件&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;br/&gt;&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;新建风格目录：/static/test_css/&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;test_css目录用于存放css和图片资源的&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;br/&gt;&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;img src=&quot;http://cdn-vipfile.dayrui.com/ueditor/image/201803/1520315214870246.png&quot; title=&quot;image&quot; alt=&quot;image.png&quot; width=&quot;414&quot; height=&quot;189&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(641, 1, 9, '&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;页面SEO信息变量：&lt;br/&gt;&lt;/p&gt;&lt;pre class=&quot;brush:html;toolbar:false&quot; style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 9.5px; font-family: Monaco, Menlo, Consolas, &amp;quot;Courier New&amp;quot;, monospace; font-size: 12px; white-space: pre-wrap; line-height: 20px; word-break: break-all; background-color: rgb(245, 245, 245); border: 1px solid rgb(204, 204, 204); border-radius: 4px; color: rgb(51, 51, 51);&quot;&gt;&amp;lt;title&amp;gt;{$meta_title}&amp;lt;/title&amp;gt;\r\n&amp;lt;meta&amp;nbsp;content=&amp;quot;{$meta_keywords}&amp;quot;&amp;nbsp;name=&amp;quot;keywords&amp;quot;&amp;nbsp;/&amp;gt;\r\n&amp;lt;meta&amp;nbsp;content=&amp;quot;{$meta_description}&amp;quot;&amp;nbsp;name=&amp;quot;description&amp;quot;&amp;nbsp;/&amp;gt;&lt;/pre&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;br/&gt;&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;引用css风格目录：&lt;/p&gt;&lt;pre class=&quot;brush:html;toolbar:false&quot; style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 9.5px; font-family: Monaco, Menlo, Consolas, &amp;quot;Courier New&amp;quot;, monospace; font-size: 12px; white-space: pre-wrap; line-height: 20px; word-break: break-all; background-color: rgb(245, 245, 245); border: 1px solid rgb(204, 204, 204); border-radius: 4px; color: rgb(51, 51, 51);&quot;&gt;&amp;lt;link&amp;nbsp;href=&amp;quot;{HOME_THEME_PATH}xxxxx.css&amp;quot;&amp;nbsp;rel=&amp;quot;stylesheet&amp;quot;&amp;nbsp;type=&amp;quot;text/css&amp;quot;&amp;nbsp;/&amp;gt;&lt;/pre&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;br/&gt;&lt;/p&gt;&lt;p style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Helvetica Neue&amp;quot;, Helvetica, tahoma, arial, &amp;quot;WenQuanYi Micro Hei&amp;quot;, Verdana, sans-serif, 宋体; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;常量对照目录表：&lt;/p&gt;&lt;pre class=&quot;brush:html;toolbar:false&quot; style=&quot;word-wrap: break-word; margin-top: 0px; margin-bottom: 10px; padding: 9.5px; font-family: Monaco, Menlo, Consolas, &amp;quot;Courier New&amp;quot;, monospace; font-size: 12px; white-space: pre-wrap; line-height: 20px; word-break: break-all; background-color: rgb(245, 245, 245); border: 1px solid rgb(204, 204, 204); border-radius: 4px; color: rgb(51, 51, 51);&quot;&gt;{HOME_THEME_PATH}&amp;nbsp;：/static/风格目录/\r\n{THEME_PATH}&amp;nbsp;：/static/&lt;/pre&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(642, 1, 10, '&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;SUSE 今天宣布推出首个针对微软 Azure 定制的企业版 Linux 内核。SUSE Linux Enterprise Server15 现可在定制调校版内核上运行，为微软Azure工作负荷带来更强的性能、更快的启动速度和更小的内存占用。Azure 调校版内核能够提高新增和未来Azure 功能的访问速度，帮助客户提高灵活性。SUSE 目前正与微软和其他合作伙伴合作改造和巩固开源解决方案，目的是让客户能够管理复杂性、降低成本并交付推动数字化转型的业务关键服务。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;SUSE 产品与技术项目副总裁Gerald Pfeifer 表示：“SUSE 与微软展开合作的基础是满足客户不断发展的需求、推动创新以及尽量减少业务中断的情况。针对Azure 公有云用户优化的SUSE Linux Enterprise Server 是SUSE 以公开、开源方法解决现实世界客户挑战的直接成果。”&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;微软公司企业开源小组总经理KY Srinivasan 表示：“我们和SUSE 密切合作，确保使用SUSE Linux Enterprise Server 的客户能够获得一流的微软Azure 体验。新的Azure 调校版内核可以让这些客户尽快享受到新增Azure 服务带来的好处，例如加速与SR-IOV 组网、写入加速器和其他功能&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(643, 1, 10, '&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;SUSE 今天宣布推出首个针对微软 Azure 定制的企业版 Linux 内核。SUSE Linux Enterprise Server15 现可在定制调校版内核上运行，为微软Azure工作负荷带来更强的性能、更快的启动速度和更小的内存占用。Azure 调校版内核能够提高新增和未来Azure 功能的访问速度，帮助客户提高灵活性。SUSE 目前正与微软和其他合作伙伴合作改造和巩固开源解决方案，目的是让客户能够管理复杂性、降低成本并交付推动数字化转型的业务关键服务。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;SUSE 产品与技术项目副总裁Gerald Pfeifer 表示：“SUSE 与微软展开合作的基础是满足客户不断发展的需求、推动创新以及尽量减少业务中断的情况。针对Azure 公有云用户优化的SUSE Linux Enterprise Server 是SUSE 以公开、开源方法解决现实世界客户挑战的直接成果。”&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;微软公司企业开源小组总经理KY Srinivasan 表示：“我们和SUSE 密切合作，确保使用SUSE Linux Enterprise Server 的客户能够获得一流的微软Azure 体验。新的Azure 调校版内核可以让这些客户尽快享受到新增Azure 服务带来的好处，例如加速与SR-IOV 组网、写入加速器和其他功能&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(644, 1, 10, '&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;SUSE 今天宣布推出首个针对微软 Azure 定制的企业版 Linux 内核。SUSE Linux Enterprise Server15 现可在定制调校版内核上运行，为微软Azure工作负荷带来更强的性能、更快的启动速度和更小的内存占用。Azure 调校版内核能够提高新增和未来Azure 功能的访问速度，帮助客户提高灵活性。SUSE 目前正与微软和其他合作伙伴合作改造和巩固开源解决方案，目的是让客户能够管理复杂性、降低成本并交付推动数字化转型的业务关键服务。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;SUSE 产品与技术项目副总裁Gerald Pfeifer 表示：“SUSE 与微软展开合作的基础是满足客户不断发展的需求、推动创新以及尽量减少业务中断的情况。针对Azure 公有云用户优化的SUSE Linux Enterprise Server 是SUSE 以公开、开源方法解决现实世界客户挑战的直接成果。”&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;微软公司企业开源小组总经理KY Srinivasan 表示：“我们和SUSE 密切合作，确保使用SUSE Linux Enterprise Server 的客户能够获得一流的微软Azure 体验。新的Azure 调校版内核可以让这些客户尽快享受到新增Azure 服务带来的好处，例如加速与SR-IOV 组网、写入加速器和其他功能&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(645, 1, 10, '&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;SUSE 今天宣布推出首个针对微软 Azure 定制的企业版 Linux 内核。SUSE Linux Enterprise Server15 现可在定制调校版内核上运行，为微软Azure工作负荷带来更强的性能、更快的启动速度和更小的内存占用。Azure 调校版内核能够提高新增和未来Azure 功能的访问速度，帮助客户提高灵活性。SUSE 目前正与微软和其他合作伙伴合作改造和巩固开源解决方案，目的是让客户能够管理复杂性、降低成本并交付推动数字化转型的业务关键服务。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;SUSE 产品与技术项目副总裁Gerald Pfeifer 表示：“SUSE 与微软展开合作的基础是满足客户不断发展的需求、推动创新以及尽量减少业务中断的情况。针对Azure 公有云用户优化的SUSE Linux Enterprise Server 是SUSE 以公开、开源方法解决现实世界客户挑战的直接成果。”&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;微软公司企业开源小组总经理KY Srinivasan 表示：“我们和SUSE 密切合作，确保使用SUSE Linux Enterprise Server 的客户能够获得一流的微软Azure 体验。新的Azure 调校版内核可以让这些客户尽快享受到新增Azure 服务带来的好处，例如加速与SR-IOV 组网、写入加速器和其他功能&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(646, 1, 10, '&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;SUSE 今天宣布推出首个针对微软 Azure 定制的企业版 Linux 内核。SUSE Linux Enterprise Server15 现可在定制调校版内核上运行，为微软Azure工作负荷带来更强的性能、更快的启动速度和更小的内存占用。Azure 调校版内核能够提高新增和未来Azure 功能的访问速度，帮助客户提高灵活性。SUSE 目前正与微软和其他合作伙伴合作改造和巩固开源解决方案，目的是让客户能够管理复杂性、降低成本并交付推动数字化转型的业务关键服务。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;SUSE 产品与技术项目副总裁Gerald Pfeifer 表示：“SUSE 与微软展开合作的基础是满足客户不断发展的需求、推动创新以及尽量减少业务中断的情况。针对Azure 公有云用户优化的SUSE Linux Enterprise Server 是SUSE 以公开、开源方法解决现实世界客户挑战的直接成果。”&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;微软公司企业开源小组总经理KY Srinivasan 表示：“我们和SUSE 密切合作，确保使用SUSE Linux Enterprise Server 的客户能够获得一流的微软Azure 体验。新的Azure 调校版内核可以让这些客户尽快享受到新增Azure 服务带来的好处，例如加速与SR-IOV 组网、写入加速器和其他功能&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(647, 1, 10, '&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;SUSE 今天宣布推出首个针对微软 Azure 定制的企业版 Linux 内核。SUSE Linux Enterprise Server15 现可在定制调校版内核上运行，为微软Azure工作负荷带来更强的性能、更快的启动速度和更小的内存占用。Azure 调校版内核能够提高新增和未来Azure 功能的访问速度，帮助客户提高灵活性。SUSE 目前正与微软和其他合作伙伴合作改造和巩固开源解决方案，目的是让客户能够管理复杂性、降低成本并交付推动数字化转型的业务关键服务。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;SUSE 产品与技术项目副总裁Gerald Pfeifer 表示：“SUSE 与微软展开合作的基础是满足客户不断发展的需求、推动创新以及尽量减少业务中断的情况。针对Azure 公有云用户优化的SUSE Linux Enterprise Server 是SUSE 以公开、开源方法解决现实世界客户挑战的直接成果。”&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;微软公司企业开源小组总经理KY Srinivasan 表示：“我们和SUSE 密切合作，确保使用SUSE Linux Enterprise Server 的客户能够获得一流的微软Azure 体验。新的Azure 调校版内核可以让这些客户尽快享受到新增Azure 服务带来的好处，例如加速与SR-IOV 组网、写入加速器和其他功能&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(648, 1, 3, '&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;并指出该漏洞影响了所有接受用户资料的 PHP 应用程序和库，包括 WordPress 等内容管理系统（CMS），并将允许远程程序攻击。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;序列化（Serialization）与反序列化（Deserialization）是所有编程语言都具备的功能，序列化将对象转换为字符串，以将数据迁移到不同服务器，服务或应用程序上，然后通过反序列将字符串还原到对象。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;安全研究员 Stefan Essar 在 2009 年就透露了 PHP 中反序列化黑客控制的数据带来的风险，而相关的漏洞不仅存在于 PHP 中，还存在于其他编程语言中。 Thomas 公布的是 PHP 的新攻击技术，可用于各种场景，例如 XML External Entity（XEE）漏洞或服务器端伪造请求（SSFR）漏洞等。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;Thomas 表示，过去外界认为&amp;nbsp;XXE 漏洞带来的最大问题是信息外泄，但现在可出发程序执行。相关攻击分为两个阶段。 首先，将包含恶意对象的 Phar 存档上传到攻击目标的本地文件系统，然后触发一个基于 phar:// 的文件操作，就可能导致恶意程序执行。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;Thomas 已利用 PHP 的反序列化程序成功攻击了 WordPress 与 Typo3 内容管理平台，以及 Contao 所采用的 TCPDF 库。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(649, 1, 3, '&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;并指出该漏洞影响了所有接受用户资料的 PHP 应用程序和库，包括 WordPress 等内容管理系统（CMS），并将允许远程程序攻击。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;序列化（Serialization）与反序列化（Deserialization）是所有编程语言都具备的功能，序列化将对象转换为字符串，以将数据迁移到不同服务器，服务或应用程序上，然后通过反序列将字符串还原到对象。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;安全研究员 Stefan Essar 在 2009 年就透露了 PHP 中反序列化黑客控制的数据带来的风险，而相关的漏洞不仅存在于 PHP 中，还存在于其他编程语言中。 Thomas 公布的是 PHP 的新攻击技术，可用于各种场景，例如 XML External Entity（XEE）漏洞或服务器端伪造请求（SSFR）漏洞等。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;Thomas 表示，过去外界认为&amp;nbsp;XXE 漏洞带来的最大问题是信息外泄，但现在可出发程序执行。相关攻击分为两个阶段。 首先，将包含恶意对象的 Phar 存档上传到攻击目标的本地文件系统，然后触发一个基于 phar:// 的文件操作，就可能导致恶意程序执行。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;Thomas 已利用 PHP 的反序列化程序成功攻击了 WordPress 与 Typo3 内容管理平台，以及 Contao 所采用的 TCPDF 库。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(650, 1, 3, '&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;并指出该漏洞影响了所有接受用户资料的 PHP 应用程序和库，包括 WordPress 等内容管理系统（CMS），并将允许远程程序攻击。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;序列化（Serialization）与反序列化（Deserialization）是所有编程语言都具备的功能，序列化将对象转换为字符串，以将数据迁移到不同服务器，服务或应用程序上，然后通过反序列将字符串还原到对象。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;安全研究员 Stefan Essar 在 2009 年就透露了 PHP 中反序列化黑客控制的数据带来的风险，而相关的漏洞不仅存在于 PHP 中，还存在于其他编程语言中。 Thomas 公布的是 PHP 的新攻击技术，可用于各种场景，例如 XML External Entity（XEE）漏洞或服务器端伪造请求（SSFR）漏洞等。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;Thomas 表示，过去外界认为&amp;nbsp;XXE 漏洞带来的最大问题是信息外泄，但现在可出发程序执行。相关攻击分为两个阶段。 首先，将包含恶意对象的 Phar 存档上传到攻击目标的本地文件系统，然后触发一个基于 phar:// 的文件操作，就可能导致恶意程序执行。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;Thomas 已利用 PHP 的反序列化程序成功攻击了 WordPress 与 Typo3 内容管理平台，以及 Contao 所采用的 TCPDF 库。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(651, 1, 3, '&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;并指出该漏洞影响了所有接受用户资料的 PHP 应用程序和库，包括 WordPress 等内容管理系统（CMS），并将允许远程程序攻击。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;序列化（Serialization）与反序列化（Deserialization）是所有编程语言都具备的功能，序列化将对象转换为字符串，以将数据迁移到不同服务器，服务或应用程序上，然后通过反序列将字符串还原到对象。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;安全研究员 Stefan Essar 在 2009 年就透露了 PHP 中反序列化黑客控制的数据带来的风险，而相关的漏洞不仅存在于 PHP 中，还存在于其他编程语言中。 Thomas 公布的是 PHP 的新攻击技术，可用于各种场景，例如 XML External Entity（XEE）漏洞或服务器端伪造请求（SSFR）漏洞等。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;Thomas 表示，过去外界认为&amp;nbsp;XXE 漏洞带来的最大问题是信息外泄，但现在可出发程序执行。相关攻击分为两个阶段。 首先，将包含恶意对象的 Phar 存档上传到攻击目标的本地文件系统，然后触发一个基于 phar:// 的文件操作，就可能导致恶意程序执行。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;Thomas 已利用 PHP 的反序列化程序成功攻击了 WordPress 与 Typo3 内容管理平台，以及 Contao 所采用的 TCPDF 库。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(652, 1, 3, '&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;并指出该漏洞影响了所有接受用户资料的 PHP 应用程序和库，包括 WordPress 等内容管理系统（CMS），并将允许远程程序攻击。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;序列化（Serialization）与反序列化（Deserialization）是所有编程语言都具备的功能，序列化将对象转换为字符串，以将数据迁移到不同服务器，服务或应用程序上，然后通过反序列将字符串还原到对象。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;安全研究员 Stefan Essar 在 2009 年就透露了 PHP 中反序列化黑客控制的数据带来的风险，而相关的漏洞不仅存在于 PHP 中，还存在于其他编程语言中。 Thomas 公布的是 PHP 的新攻击技术，可用于各种场景，例如 XML External Entity（XEE）漏洞或服务器端伪造请求（SSFR）漏洞等。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;Thomas 表示，过去外界认为&amp;nbsp;XXE 漏洞带来的最大问题是信息外泄，但现在可出发程序执行。相关攻击分为两个阶段。 首先，将包含恶意对象的 Phar 存档上传到攻击目标的本地文件系统，然后触发一个基于 phar:// 的文件操作，就可能导致恶意程序执行。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;Thomas 已利用 PHP 的反序列化程序成功攻击了 WordPress 与 Typo3 内容管理平台，以及 Contao 所采用的 TCPDF 库。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL);
REPLACE INTO `dr_1_news_data_0` (`id`, `uid`, `catid`, `content`, `yanseceshi`) VALUES
(653, 1, 3, '&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;并指出该漏洞影响了所有接受用户资料的 PHP 应用程序和库，包括 WordPress 等内容管理系统（CMS），并将允许远程程序攻击。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;序列化（Serialization）与反序列化（Deserialization）是所有编程语言都具备的功能，序列化将对象转换为字符串，以将数据迁移到不同服务器，服务或应用程序上，然后通过反序列将字符串还原到对象。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;安全研究员 Stefan Essar 在 2009 年就透露了 PHP 中反序列化黑客控制的数据带来的风险，而相关的漏洞不仅存在于 PHP 中，还存在于其他编程语言中。 Thomas 公布的是 PHP 的新攻击技术，可用于各种场景，例如 XML External Entity（XEE）漏洞或服务器端伪造请求（SSFR）漏洞等。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;Thomas 表示，过去外界认为&amp;nbsp;XXE 漏洞带来的最大问题是信息外泄，但现在可出发程序执行。相关攻击分为两个阶段。 首先，将包含恶意对象的 Phar 存档上传到攻击目标的本地文件系统，然后触发一个基于 phar:// 的文件操作，就可能导致恶意程序执行。&lt;/p&gt;&lt;p style=&quot;box-sizing: inherit; margin-top: 16px; margin-bottom: 14px; line-height: 28px; color: rgb(51, 51, 51); font-family: &amp;quot;Pingfang SC&amp;quot;, STHeiti, &amp;quot;Lantinghei SC&amp;quot;, &amp;quot;Open Sans&amp;quot;, Arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, SimSun, sans-serif; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;Thomas 已利用 PHP 的反序列化程序成功攻击了 WordPress 与 Typo3 内容管理平台，以及 Contao 所采用的 TCPDF 库。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(654, 1, 4, '&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;PHP7CMS由&lt;/span&gt;&lt;span class=&quot;author-p-14477230 bold:true color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;春杰工作室&lt;/span&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 bold:true&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;&quot;&gt;核心框架：&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;PHPCMF最新版（支持同步更新）&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;授权版代码加密量占3.5%，&lt;span style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(255, 0, 0);&quot;&gt;不影响二次开发！！！&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 bold:true&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;&quot;&gt;功能介绍：&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;动态静态分离，自定义URL结果&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;多终端模式，一个站点多个模板展示，适合手机端，平板端，mip等页面&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义栏目，可以对栏目字段定义&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;多网站模式，一个后台管理多个网站&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义内容模块&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义字段&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义页面&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义表单&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义内容表单&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;内容评论，点评，点赞，打赏，收藏，阅读统计&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;会员系统，分组注册，自定义字段，会员组，等级&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;支付系统，微信，支付宝&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;微信公众号，微网站&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;小程序接口，APP接口&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;等等。&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;适合大部分内容网站&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(655, 1, 4, '&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;PHP7CMS由&lt;/span&gt;&lt;span class=&quot;author-p-14477230 bold:true color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;春杰工作室&lt;/span&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 bold:true&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;&quot;&gt;核心框架：&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;PHPCMF最新版（支持同步更新）&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;授权版代码加密量占3.5%，&lt;span style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(255, 0, 0);&quot;&gt;不影响二次开发！！！&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 bold:true&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;&quot;&gt;功能介绍：&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;动态静态分离，自定义URL结果&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;多终端模式，一个站点多个模板展示，适合手机端，平板端，mip等页面&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义栏目，可以对栏目字段定义&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;多网站模式，一个后台管理多个网站&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义内容模块&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义字段&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义页面&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义表单&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义内容表单&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;内容评论，点评，点赞，打赏，收藏，阅读统计&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;会员系统，分组注册，自定义字段，会员组，等级&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;支付系统，微信，支付宝&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;微信公众号，微网站&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;小程序接口，APP接口&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;等等。&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;适合大部分内容网站&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(656, 1, 4, '&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;PHP7CMS由&lt;/span&gt;&lt;span class=&quot;author-p-14477230 bold:true color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;春杰工作室&lt;/span&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 bold:true&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;&quot;&gt;核心框架：&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;PHPCMF最新版（支持同步更新）&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;授权版代码加密量占3.5%，&lt;span style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(255, 0, 0);&quot;&gt;不影响二次开发！！！&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 bold:true&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;&quot;&gt;功能介绍：&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;动态静态分离，自定义URL结果&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;多终端模式，一个站点多个模板展示，适合手机端，平板端，mip等页面&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义栏目，可以对栏目字段定义&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;多网站模式，一个后台管理多个网站&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义内容模块&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义字段&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义页面&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义表单&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义内容表单&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;内容评论，点评，点赞，打赏，收藏，阅读统计&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;会员系统，分组注册，自定义字段，会员组，等级&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;支付系统，微信，支付宝&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;微信公众号，微网站&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;小程序接口，APP接口&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;等等。&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;适合大部分内容网站&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(657, 1, 4, '&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;PHP7CMS由&lt;/span&gt;&lt;span class=&quot;author-p-14477230 bold:true color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;春杰工作室&lt;/span&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 bold:true&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;&quot;&gt;核心框架：&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;PHPCMF最新版（支持同步更新）&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;授权版代码加密量占3.5%，&lt;span style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(255, 0, 0);&quot;&gt;不影响二次开发！！！&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 bold:true&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;&quot;&gt;功能介绍：&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;动态静态分离，自定义URL结果&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;多终端模式，一个站点多个模板展示，适合手机端，平板端，mip等页面&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义栏目，可以对栏目字段定义&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;多网站模式，一个后台管理多个网站&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义内容模块&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义字段&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义页面&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义表单&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义内容表单&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;内容评论，点评，点赞，打赏，收藏，阅读统计&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;会员系统，分组注册，自定义字段，会员组，等级&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;支付系统，微信，支付宝&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;微信公众号，微网站&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;小程序接口，APP接口&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;等等。&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;适合大部分内容网站&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL);
REPLACE INTO `dr_1_news_data_0` (`id`, `uid`, `catid`, `content`, `yanseceshi`) VALUES
(658, 1, 4, '&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;PHP7CMS由&lt;/span&gt;&lt;span class=&quot;author-p-14477230 bold:true color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;春杰工作室&lt;/span&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 bold:true&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;&quot;&gt;核心框架：&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;PHPCMF最新版（支持同步更新）&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;授权版代码加密量占3.5%，&lt;span style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(255, 0, 0);&quot;&gt;不影响二次开发！！！&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 bold:true&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;&quot;&gt;功能介绍：&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;动态静态分离，自定义URL结果&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;多终端模式，一个站点多个模板展示，适合手机端，平板端，mip等页面&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义栏目，可以对栏目字段定义&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;多网站模式，一个后台管理多个网站&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义内容模块&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义字段&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义页面&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义表单&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义内容表单&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;内容评论，点评，点赞，打赏，收藏，阅读统计&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;会员系统，分组注册，自定义字段，会员组，等级&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;支付系统，微信，支付宝&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;微信公众号，微网站&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;小程序接口，APP接口&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;等等。&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;适合大部分内容网站&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(659, 1, 4, '&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;PHP7CMS由&lt;/span&gt;&lt;span class=&quot;author-p-14477230 bold:true color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;春杰工作室&lt;/span&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 bold:true&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;&quot;&gt;核心框架：&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;PHPCMF最新版（支持同步更新）&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;授权版代码加密量占3.5%，&lt;span style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(255, 0, 0);&quot;&gt;不影响二次开发！！！&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 bold:true&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;&quot;&gt;功能介绍：&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;动态静态分离，自定义URL结果&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;多终端模式，一个站点多个模板展示，适合手机端，平板端，mip等页面&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义栏目，可以对栏目字段定义&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;多网站模式，一个后台管理多个网站&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义内容模块&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义字段&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义页面&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义表单&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义内容表单&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;内容评论，点评，点赞，打赏，收藏，阅读统计&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;会员系统，分组注册，自定义字段，会员组，等级&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;支付系统，微信，支付宝&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;微信公众号，微网站&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;小程序接口，APP接口&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;等等。&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;适合大部分内容网站&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL),
(660, 1, 4, '&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;PHP7CMS由&lt;/span&gt;&lt;span class=&quot;author-p-14477230 bold:true color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;春杰工作室&lt;/span&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &amp;quot;Open Sans&amp;quot;, sans-serif;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 bold:true&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;&quot;&gt;核心框架：&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;PHPCMF最新版（支持同步更新）&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;授权版代码加密量占3.5%，&lt;span style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(255, 0, 0);&quot;&gt;不影响二次开发！！！&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230 bold:true&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;&quot;&gt;功能介绍：&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;动态静态分离，自定义URL结果&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;多终端模式，一个站点多个模板展示，适合手机端，平板端，mip等页面&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义栏目，可以对栏目字段定义&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;多网站模式，一个后台管理多个网站&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义内容模块&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义字段&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义页面&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义表单&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;自定义内容表单&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;内容评论，点评，点赞，打赏，收藏，阅读统计&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;会员系统，分组注册，自定义字段，会员组，等级&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;支付系统，微信，支付宝&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;微信公众号，微网站&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;小程序接口，APP接口&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;等等。&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;box-sizing: border-box; margin-top: 0px; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;适合大部分内容网站&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span class=&quot;author-p-14477230&quot; style=&quot;box-sizing: border-box; -webkit-font-smoothing: antialiased;&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', NULL);

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_news_donation`
--

DROP TABLE IF EXISTS `dr_1_news_donation`;
CREATE TABLE IF NOT EXISTS `dr_1_news_donation` (
  `id` int(10) unsigned NOT NULL,
  `cid` int(10) unsigned NOT NULL COMMENT '文档id',
  `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
  `value` decimal(8,2) unsigned NOT NULL COMMENT '捐赠金额',
  `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间'
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COMMENT='捐赠操作记录表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_news_draft`
--

DROP TABLE IF EXISTS `dr_1_news_draft`;
CREATE TABLE IF NOT EXISTS `dr_1_news_draft` (
  `id` int(10) unsigned NOT NULL,
  `cid` int(10) unsigned NOT NULL COMMENT '内容id',
  `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
  `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
  `content` mediumtext NOT NULL COMMENT '具体内容',
  `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='内容草稿表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_news_favorite`
--

DROP TABLE IF EXISTS `dr_1_news_favorite`;
CREATE TABLE IF NOT EXISTS `dr_1_news_favorite` (
  `id` int(10) unsigned NOT NULL COMMENT 'id',
  `cid` int(10) unsigned NOT NULL COMMENT '文档id',
  `uid` mediumint(8) unsigned NOT NULL COMMENT 'uid'
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='收藏夹表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_news_flag`
--

DROP TABLE IF EXISTS `dr_1_news_flag`;
CREATE TABLE IF NOT EXISTS `dr_1_news_flag` (
  `flag` tinyint(2) unsigned NOT NULL DEFAULT '1' COMMENT '文档标记id',
  `id` int(10) unsigned NOT NULL COMMENT '文档内容id',
  `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
  `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='标记表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_news_hits`
--

DROP TABLE IF EXISTS `dr_1_news_hits`;
CREATE TABLE IF NOT EXISTS `dr_1_news_hits` (
  `id` int(10) unsigned NOT NULL COMMENT '文章id',
  `hits` int(10) unsigned NOT NULL COMMENT '总点击数',
  `day_hits` int(10) unsigned NOT NULL COMMENT '本日点击',
  `week_hits` int(10) unsigned NOT NULL COMMENT '本周点击',
  `month_hits` int(10) unsigned NOT NULL COMMENT '本月点击',
  `year_hits` int(10) unsigned NOT NULL COMMENT '年点击量'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='时段点击量统计';

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_news_index`
--

DROP TABLE IF EXISTS `dr_1_news_index`;
CREATE TABLE IF NOT EXISTS `dr_1_news_index` (
  `id` int(10) unsigned NOT NULL,
  `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
  `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
  `status` tinyint(2) NOT NULL COMMENT '审核状态',
  `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间'
) ENGINE=MyISAM AUTO_INCREMENT=661 DEFAULT CHARSET=utf8 COMMENT='内容索引表';

--
-- 转存表中的数据 `dr_1_news_index`
--

REPLACE INTO `dr_1_news_index` (`id`, `uid`, `catid`, `status`, `inputtime`) VALUES
(637, 1, 9, 9, 1534896412),
(639, 1, 9, 9, 1534896412),
(640, 1, 9, 9, 1534896751),
(641, 1, 9, 9, 1534896770),
(642, 1, 10, 9, 1534896875),
(643, 1, 10, 9, 1534896875),
(644, 1, 10, 9, 1534896875),
(645, 1, 10, 9, 1534896875),
(646, 1, 10, 9, 1534896875),
(647, 1, 10, 9, 1534896875),
(648, 1, 3, 9, 1534897027),
(649, 1, 3, 9, 1534897027),
(650, 1, 3, 9, 1534897027),
(651, 1, 3, 9, 1534897027),
(652, 1, 3, 9, 1534897027),
(653, 1, 3, 9, 1534897027),
(654, 1, 4, 9, 1534897110),
(655, 1, 4, 9, 1534897110),
(656, 1, 4, 9, 1534897110),
(657, 1, 4, 9, 1534897110),
(658, 1, 4, 9, 1534897110),
(659, 1, 4, 9, 1534897110),
(660, 1, 4, 9, 1534897110);

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_news_oppose`
--

DROP TABLE IF EXISTS `dr_1_news_oppose`;
CREATE TABLE IF NOT EXISTS `dr_1_news_oppose` (
  `id` int(10) unsigned NOT NULL,
  `cid` int(10) unsigned NOT NULL COMMENT '文档id',
  `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid'
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='反对操作记录表';

--
-- 转存表中的数据 `dr_1_news_oppose`
--

REPLACE INTO `dr_1_news_oppose` (`id`, `cid`, `uid`) VALUES
(9, 640, 1),
(10, 646, 1);

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_news_recycle`
--

DROP TABLE IF EXISTS `dr_1_news_recycle`;
CREATE TABLE IF NOT EXISTS `dr_1_news_recycle` (
  `id` int(10) unsigned NOT NULL,
  `cid` int(10) unsigned NOT NULL COMMENT '内容id',
  `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
  `catid` tinyint(3) unsigned NOT NULL COMMENT '栏目id',
  `content` mediumtext NOT NULL COMMENT '具体内容',
  `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间'
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='内容回收站表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_news_search`
--

DROP TABLE IF EXISTS `dr_1_news_search`;
CREATE TABLE IF NOT EXISTS `dr_1_news_search` (
  `id` varchar(32) NOT NULL,
  `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
  `params` text NOT NULL COMMENT '参数数组',
  `keyword` varchar(255) NOT NULL COMMENT '关键字',
  `contentid` mediumtext NOT NULL COMMENT 'id集合',
  `inputtime` int(10) unsigned NOT NULL COMMENT '搜索时间'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='搜索表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_news_search_index`
--

DROP TABLE IF EXISTS `dr_1_news_search_index`;
CREATE TABLE IF NOT EXISTS `dr_1_news_search_index` (
  `id` varchar(32) NOT NULL,
  `cid` int(10) unsigned NOT NULL COMMENT '文档Id',
  `inputtime` int(10) unsigned NOT NULL COMMENT '搜索时间'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='搜索索引表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_news_support`
--

DROP TABLE IF EXISTS `dr_1_news_support`;
CREATE TABLE IF NOT EXISTS `dr_1_news_support` (
  `id` int(10) unsigned NOT NULL,
  `cid` int(10) unsigned NOT NULL COMMENT '文档id',
  `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid'
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COMMENT='支持操作记录表';

--
-- 转存表中的数据 `dr_1_news_support`
--

REPLACE INTO `dr_1_news_support` (`id`, `cid`, `uid`) VALUES
(17, 646, 1);

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_news_time`
--

DROP TABLE IF EXISTS `dr_1_news_time`;
CREATE TABLE IF NOT EXISTS `dr_1_news_time` (
  `id` int(10) unsigned NOT NULL,
  `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
  `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
  `content` mediumtext NOT NULL COMMENT '具体内容',
  `result` text NOT NULL COMMENT '处理结果',
  `posttime` int(10) unsigned NOT NULL COMMENT '定时发布时间',
  `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间'
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='内容定时发布表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_news_verify`
--

DROP TABLE IF EXISTS `dr_1_news_verify`;
CREATE TABLE IF NOT EXISTS `dr_1_news_verify` (
  `id` int(10) unsigned NOT NULL,
  `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
  `isnew` tinyint(1) unsigned NOT NULL COMMENT '是否新增',
  `author` varchar(50) NOT NULL COMMENT '作者',
  `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
  `status` tinyint(2) NOT NULL COMMENT '审核状态',
  `content` mediumtext NOT NULL COMMENT '具体内容',
  `backuid` mediumint(8) unsigned NOT NULL COMMENT '操作人uid',
  `backinfo` text NOT NULL COMMENT '操作退回信息',
  `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='内容审核表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_page`
--

DROP TABLE IF EXISTS `dr_1_page`;
CREATE TABLE IF NOT EXISTS `dr_1_page` (
  `id` smallint(5) unsigned NOT NULL,
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '上级id',
  `pids` varchar(255) NOT NULL COMMENT '所有上级id',
  `name` varchar(255) NOT NULL COMMENT '单页名称',
  `dirname` varchar(30) NOT NULL COMMENT '栏目目录',
  `pdirname` varchar(100) NOT NULL COMMENT '上级目录',
  `child` tinyint(1) unsigned NOT NULL COMMENT '是否有子类',
  `childids` varchar(255) NOT NULL COMMENT '下级所有id',
  `thumb` varchar(255) NOT NULL COMMENT '缩略图',
  `content` mediumtext COMMENT '单页内容',
  `attachment` text COMMENT '附件信息',
  `show` tinyint(1) unsigned NOT NULL COMMENT '是否显示在菜单',
  `url` varchar(255) NOT NULL COMMENT 'url地址',
  `setting` mediumtext NOT NULL COMMENT '自定义内容',
  `displayorder` smallint(5) NOT NULL
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='单页表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_share_category`
--

DROP TABLE IF EXISTS `dr_1_share_category`;
CREATE TABLE IF NOT EXISTS `dr_1_share_category` (
  `id` smallint(5) unsigned NOT NULL,
  `tid` tinyint(1) NOT NULL COMMENT '栏目类型，0单页，1模块，2外链',
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '上级id',
  `mid` varchar(20) NOT NULL COMMENT '模块目录',
  `pids` varchar(255) NOT NULL COMMENT '所有上级id',
  `name` varchar(30) NOT NULL COMMENT '栏目名称',
  `dirname` varchar(30) NOT NULL COMMENT '栏目目录',
  `pdirname` varchar(100) NOT NULL COMMENT '上级目录',
  `child` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否有下级',
  `childids` text NOT NULL COMMENT '下级所有id',
  `domain` varchar(50) DEFAULT NULL COMMENT '绑定电脑域名',
  `mobile_domain` varchar(50) DEFAULT NULL COMMENT '绑定手机域名',
  `thumb` varchar(255) NOT NULL COMMENT '栏目图片',
  `show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示',
  `content` mediumtext NOT NULL COMMENT '单页内容',
  `setting` text NOT NULL COMMENT '属性配置',
  `displayorder` smallint(5) NOT NULL DEFAULT '0'
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='共享模块栏目表';

--
-- 转存表中的数据 `dr_1_share_category`
--

REPLACE INTO `dr_1_share_category` (`id`, `tid`, `pid`, `mid`, `pids`, `name`, `dirname`, `pdirname`, `child`, `childids`, `domain`, `mobile_domain`, `thumb`, `show`, `content`, `setting`, `displayorder`) VALUES
(1, 0, 0, 'news', '0', '关于我们', 'guanyuwomen', '', 1, '1,6,7,8', '', '', '', 1, '', '{"linkurl":"","getchild":"1","urlrule":"0","seo":{"list_title":"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}","list_keywords":"","list_description":""},"template":{"pagesize":"20","page":"","list":"page.html","category":"category.html","search":"search.html","show":"show.html"}}', 0),
(2, 1, 0, 'news', '0', '新闻动态', 'xinwendongtai', '', 1, '2,9,10', NULL, NULL, '', 1, '', '{"edit":1,"template":{"list":"list.html","show":"show.html","category":"category.html","search":"search.html","pagesize":20},"seo":{"list_title":"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}","show_title":"[\\u7b2c{page}\\u9875{join}]{title}{join}{catname}{join}{modname}{join}{SITE_NAME}"}}', 0),
(3, 1, 0, 'news', '0', '产品展示', 'chanpinzhanshi', '', 0, '3', NULL, NULL, '', 1, '', '{"edit":1,"template":{"list":"list.html","show":"show.html","category":"category.html","search":"search.html","pagesize":20},"seo":{"list_title":"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}","show_title":"[\\u7b2c{page}\\u9875{join}]{title}{join}{catname}{join}{modname}{join}{SITE_NAME}"}}', 0),
(4, 1, 0, 'news', '0', '客户案例', 'kehuanli', '', 0, '4', NULL, NULL, '', 1, '', '{"edit":1,"template":{"list":"list.html","show":"show.html","category":"category.html","search":"search.html","pagesize":20},"seo":{"list_title":"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}","show_title":"[\\u7b2c{page}\\u9875{join}]{title}{join}{catname}{join}{modname}{join}{SITE_NAME}"}}', 0),
(5, 0, 0, 'news', '0', '联系我们', 'lianxiwomen', '', 0, '5', '', '', '', 1, '<p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &quot;Open Sans&quot;, sans-serif;">PHP7CMS由</span><span class="author-p-14477230 bold:true color:#333333 font-family:Open Sans, sans-serif font-size:15px" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold; color: rgb(51, 51, 51); font-family: &quot;Open Sans&quot;, sans-serif;">春杰工作室</span><span class="author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &quot;Open Sans&quot;, sans-serif;">采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &quot;Open Sans&quot;, sans-serif;"><br/></span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230 bold:true" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;">核心框架：</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">PHPCMF最新版（支持同步更新）</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">授权版代码加密量占3.5%，<span style="box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(255, 0, 0);">不影响二次开发！！！</span></span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;"><br/></span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230 bold:true" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;">功能介绍：</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">动态静态分离，自定义URL结果</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">多终端模式，一个站点多个模板展示，适合手机端，平板端，mip等页面</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义栏目，可以对栏目字段定义</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">多网站模式，一个后台管理多个网站</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义内容模块</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义字段</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义页面</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义表单</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义内容表单</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">内容评论，点评，点赞，打赏，收藏，阅读统计</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">会员系统，分组注册，自定义字段，会员组，等级</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">支付系统，微信，支付宝</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">微信公众号，微网站</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">小程序接口，APP接口</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">等等。</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">适合大部分内容网站</span></p><p><br/></p>', '{"linkurl":"","urlrule":"0","seo":{"list_title":"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}","list_keywords":"","list_description":""},"template":{"pagesize":"20","page":"","list":"page.html","category":"category.html","search":"search.html","show":"show.html"}}', 0),
(6, 0, 1, 'news', '0,1', '公司介绍', 'gongsijieshao', 'guanyuwomen/', 0, '6', NULL, NULL, '', 1, '<p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &quot;Open Sans&quot;, sans-serif;">PHP7CMS由</span><span class="author-p-14477230 bold:true color:#333333 font-family:Open Sans, sans-serif font-size:15px" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold; color: rgb(51, 51, 51); font-family: &quot;Open Sans&quot;, sans-serif;">春杰工作室</span><span class="author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &quot;Open Sans&quot;, sans-serif;">采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &quot;Open Sans&quot;, sans-serif;"><br/></span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230 bold:true" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;">核心框架：</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">PHPCMF最新版（支持同步更新）</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">授权版代码加密量占3.5%，<span style="box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(255, 0, 0);">不影响二次开发！！！</span></span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;"><br/></span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230 bold:true" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;">功能介绍：</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">动态静态分离，自定义URL结果</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">多终端模式，一个站点多个模板展示，适合手机端，平板端，mip等页面</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义栏目，可以对栏目字段定义</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">多网站模式，一个后台管理多个网站</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义内容模块</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义字段</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义页面</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义表单</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义内容表单</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">内容评论，点评，点赞，打赏，收藏，阅读统计</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">会员系统，分组注册，自定义字段，会员组，等级</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">支付系统，微信，支付宝</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">微信公众号，微网站</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">小程序接口，APP接口</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">等等。</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">适合大部分内容网站</span></p><p><br/></p>', '{"edit":1,"template":{"list":"list.html","show":"show.html","category":"category.html","search":"search.html","pagesize":20},"seo":{"list_title":"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}","show_title":"[\\u7b2c{page}\\u9875{join}]{title}{join}{catname}{join}{modname}{join}{SITE_NAME}"}}', 0),
(7, 0, 1, 'news', '0,1', '资质证书', 'zizhizhengshu', 'guanyuwomen/', 0, '7', NULL, NULL, '', 1, '<p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &quot;Open Sans&quot;, sans-serif;">PHP7CMS由</span><span class="author-p-14477230 bold:true color:#333333 font-family:Open Sans, sans-serif font-size:15px" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold; color: rgb(51, 51, 51); font-family: &quot;Open Sans&quot;, sans-serif;">春杰工作室</span><span class="author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &quot;Open Sans&quot;, sans-serif;">采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &quot;Open Sans&quot;, sans-serif;"><br/></span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230 bold:true" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;">核心框架：</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">PHPCMF最新版（支持同步更新）</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">授权版代码加密量占3.5%，<span style="box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(255, 0, 0);">不影响二次开发！！！</span></span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;"><br/></span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230 bold:true" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;">功能介绍：</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">动态静态分离，自定义URL结果</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">多终端模式，一个站点多个模板展示，适合手机端，平板端，mip等页面</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义栏目，可以对栏目字段定义</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">多网站模式，一个后台管理多个网站</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义内容模块</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义字段</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义页面</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义表单</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义内容表单</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">内容评论，点评，点赞，打赏，收藏，阅读统计</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">会员系统，分组注册，自定义字段，会员组，等级</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">支付系统，微信，支付宝</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">微信公众号，微网站</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">小程序接口，APP接口</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">等等。</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">适合大部分内容网站</span></p><p><br/></p>', '{"edit":1,"template":{"list":"list.html","show":"show.html","category":"category.html","search":"search.html","pagesize":20},"seo":{"list_title":"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}","show_title":"[\\u7b2c{page}\\u9875{join}]{title}{join}{catname}{join}{modname}{join}{SITE_NAME}"}}', 0);
REPLACE INTO `dr_1_share_category` (`id`, `tid`, `pid`, `mid`, `pids`, `name`, `dirname`, `pdirname`, `child`, `childids`, `domain`, `mobile_domain`, `thumb`, `show`, `content`, `setting`, `displayorder`) VALUES
(8, 0, 1, 'news', '0,1', '团队风采', 'tuanduifengcai', 'guanyuwomen/', 0, '8', NULL, NULL, '', 1, '<p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &quot;Open Sans&quot;, sans-serif;">PHP7CMS由</span><span class="author-p-14477230 bold:true color:#333333 font-family:Open Sans, sans-serif font-size:15px" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold; color: rgb(51, 51, 51); font-family: &quot;Open Sans&quot;, sans-serif;">春杰工作室</span><span class="author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &quot;Open Sans&quot;, sans-serif;">采用PHP7技术全新研发的内容管理程序，汲取PHPCMS的优点并提供PHP7语言强大稳定的技术架构，使你无论是目前打算做个小型网站，还是想让网站在不断壮大后仍能得到随意扩充都有充分的保证。</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230 color:#333333 font-family:Open Sans, sans-serif font-size:15px" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(51, 51, 51); font-family: &quot;Open Sans&quot;, sans-serif;"><br/></span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230 bold:true" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;">核心框架：</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">PHPCMF最新版（支持同步更新）</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">授权版代码加密量占3.5%，<span style="box-sizing: border-box; -webkit-font-smoothing: antialiased; color: rgb(255, 0, 0);">不影响二次开发！！！</span></span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;"><br/></span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230 bold:true" style="box-sizing: border-box; -webkit-font-smoothing: antialiased; font-weight: bold;">功能介绍：</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">动态静态分离，自定义URL结果</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">多终端模式，一个站点多个模板展示，适合手机端，平板端，mip等页面</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义栏目，可以对栏目字段定义</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">多网站模式，一个后台管理多个网站</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义内容模块</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义字段</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义页面</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义表单</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">自定义内容表单</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">内容评论，点评，点赞，打赏，收藏，阅读统计</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">会员系统，分组注册，自定义字段，会员组，等级</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">支付系统，微信，支付宝</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">微信公众号，微网站</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">小程序接口，APP接口</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">等等。</span></p><p style="box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); white-space: normal; -webkit-font-smoothing: antialiased; color: rgb(34, 34, 34); font-family: 微软雅黑, sans-serif; font-size: 15px; letter-spacing: 0.5px; line-height: 25px; background-color: rgb(255, 255, 255);"><span class="author-p-14477230" style="box-sizing: border-box; -webkit-font-smoothing: antialiased;">适合大部分内容网站</span></p><p><br/></p>', '{"edit":1,"template":{"list":"list.html","show":"show.html","category":"category.html","search":"search.html","pagesize":20},"seo":{"list_title":"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}","show_title":"[\\u7b2c{page}\\u9875{join}]{title}{join}{catname}{join}{modname}{join}{SITE_NAME}"}}', 0),
(9, 1, 2, 'news', '0,2', '企业资讯', 'qiyezixun', 'xinwendongtai/', 0, '9', NULL, NULL, '', 1, '', '{"edit":1,"template":{"list":"list.html","show":"show.html","category":"category.html","search":"search.html","pagesize":20},"seo":{"list_title":"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}","show_title":"[\\u7b2c{page}\\u9875{join}]{title}{join}{catname}{join}{modname}{join}{SITE_NAME}"}}', 0),
(10, 1, 2, 'news', '0,2', '媒体报道', 'meitibaodao', 'xinwendongtai/', 0, '10', NULL, NULL, '', 1, '', '{"edit":1,"template":{"list":"list.html","show":"show.html","category":"category.html","search":"search.html","pagesize":20},"seo":{"list_title":"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}","show_title":"[\\u7b2c{page}\\u9875{join}]{title}{join}{catname}{join}{modname}{join}{SITE_NAME}"}}', 0);

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_share_index`
--

DROP TABLE IF EXISTS `dr_1_share_index`;
CREATE TABLE IF NOT EXISTS `dr_1_share_index` (
  `id` int(10) unsigned NOT NULL,
  `mid` varchar(20) NOT NULL COMMENT '模块目录'
) ENGINE=MyISAM AUTO_INCREMENT=661 DEFAULT CHARSET=utf8 COMMENT='共享模块内容索引表';

--
-- 转存表中的数据 `dr_1_share_index`
--

REPLACE INTO `dr_1_share_index` (`id`, `mid`) VALUES
(637, 'news'),
(638, 'news'),
(639, 'news'),
(640, 'news'),
(641, 'news'),
(642, 'news'),
(643, 'news'),
(644, 'news'),
(645, 'news'),
(646, 'news'),
(647, 'news'),
(648, 'news'),
(649, 'news'),
(650, 'news'),
(651, 'news'),
(652, 'news'),
(653, 'news'),
(654, 'news'),
(655, 'news'),
(656, 'news'),
(657, 'news'),
(658, 'news'),
(659, 'news'),
(660, 'news');

-- --------------------------------------------------------

--
-- 表的结构 `dr_1_tag`
--

DROP TABLE IF EXISTS `dr_1_tag`;
CREATE TABLE IF NOT EXISTS `dr_1_tag` (
  `id` int(10) unsigned NOT NULL,
  `pid` int(10) DEFAULT '0' COMMENT '父级id',
  `name` varchar(200) NOT NULL COMMENT 'tag名称',
  `code` varchar(200) NOT NULL COMMENT 'tag代码（拼音）',
  `pcode` varchar(255) DEFAULT NULL,
  `hits` mediumint(8) unsigned NOT NULL COMMENT '点击量',
  `url` varchar(255) DEFAULT NULL COMMENT 'tag url',
  `childids` varchar(255) NOT NULL COMMENT '子类集合',
  `content` text NOT NULL COMMENT 'tag描述',
  `total` int(10) NOT NULL COMMENT '点击数量',
  `displayorder` int(10) NOT NULL COMMENT '排序值'
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='Tag标签表';

--
-- 转存表中的数据 `dr_1_tag`
--

REPLACE INTO `dr_1_tag` (`id`, `pid`, `name`, `code`, `pcode`, `hits`, `url`, `childids`, `content`, `total`, `displayorder`) VALUES
(1, 0, '中国', 'zhongguo', 'zhongguo', 1, '/index.php?c=tag&name=zhongguo', '', '', 4, 0),
(2, 0, '中国人', 'zhongguoren', 'zhongguoren', 0, '/index.php?c=tag&name=zhongguoren', '', '', 0, 0),
(3, 1, '中国语言', 'zhongguoyuyan', 'zhongguo/zhongguoyuyan', 1, '/index.php?c=tag&name=zhongguo/zhongguoyuyan', '', '', 0, 0),
(4, 1, '汉语', 'hanyu', 'zhongguo/hanyu', 3, '/index.php?c=tag&name=zhongguo/hanyu', '', '', 0, 0),
(5, 1, '华夏', 'huaxia', 'zhongguo/huaxia', 2, '/index.php?c=tag&name=zhongguo/huaxia', '', '', 0, 0),
(6, 1, '大陆', 'dalu', 'zhongguo/dalu', 2, '/index.php?c=tag&name=zhongguo/dalu', '', '', 0, 0);

-- --------------------------------------------------------

--
-- 表的结构 `dr_admin`
--

DROP TABLE IF EXISTS `dr_admin`;
CREATE TABLE IF NOT EXISTS `dr_admin` (
  `id` smallint(5) unsigned NOT NULL,
  `uid` int(10) unsigned NOT NULL COMMENT '管理员uid',
  `setting` varchar(50) DEFAULT NULL COMMENT '后台主题',
  `usermenu` text COMMENT '自定义面板菜单，序列化数组格式'
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='管理员表';

--
-- 转存表中的数据 `dr_admin`
--

REPLACE INTO `dr_admin` (`id`, `uid`, `setting`, `usermenu`) VALUES
(1, 1, 'grey', '');

-- --------------------------------------------------------

--
-- 表的结构 `dr_admin_login`
--

DROP TABLE IF EXISTS `dr_admin_login`;
CREATE TABLE IF NOT EXISTS `dr_admin_login` (
  `id` int(10) unsigned NOT NULL,
  `uid` mediumint(8) unsigned DEFAULT NULL COMMENT '会员uid',
  `loginip` varchar(50) NOT NULL COMMENT '登录Ip',
  `logintime` int(10) unsigned NOT NULL COMMENT '登录时间',
  `useragent` varchar(255) NOT NULL COMMENT '客户端信息'
) ENGINE=MyISAM AUTO_INCREMENT=68 DEFAULT CHARSET=utf8 COMMENT='登录日志记录';

--
-- 转存表中的数据 `dr_admin_login`
--

REPLACE INTO `dr_admin_login` (`id`, `uid`, `loginip`, `logintime`, `useragent`) VALUES
(66, 1, '127.0.0.1', 1534865025, 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36'),
(67, 1, '127.0.0.1', 1534896403, 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36');

-- --------------------------------------------------------

--
-- 表的结构 `dr_admin_menu`
--

DROP TABLE IF EXISTS `dr_admin_menu`;
CREATE TABLE IF NOT EXISTS `dr_admin_menu` (
  `id` smallint(5) unsigned NOT NULL,
  `pid` smallint(5) unsigned NOT NULL COMMENT '上级菜单id',
  `name` text NOT NULL COMMENT '菜单语言名称',
  `uri` varchar(255) DEFAULT NULL COMMENT 'uri字符串',
  `url` varchar(255) DEFAULT NULL COMMENT '外链地址',
  `mark` varchar(50) DEFAULT NULL COMMENT '菜单标识',
  `hidden` tinyint(1) unsigned DEFAULT NULL COMMENT '是否隐藏',
  `icon` varchar(255) DEFAULT NULL COMMENT '图标标示',
  `displayorder` int(5) DEFAULT NULL COMMENT '排序值'
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8 COMMENT='后台菜单表';

--
-- 转存表中的数据 `dr_admin_menu`
--

REPLACE INTO `dr_admin_menu` (`id`, `pid`, `name`, `uri`, `url`, `mark`, `hidden`, `icon`, `displayorder`) VALUES
(1, 0, '首页', '', '', 'home', 0, 'fa fa-home', 0),
(2, 1, '我的面板', '', '', 'home-my', 0, 'fa fa-home', 0),
(3, 2, '后台首页', 'home/main', '', '', 0, 'fa fa-home', 0),
(4, 2, '资料修改', 'api/my', '', '', 0, 'fa fa-user', 0),
(5, 2, '系统更新', 'cache/index', '', '', 0, 'fa fa-refresh', 0),
(6, 2, '程序升级', 'update/index', '', '', 0, 'fa fa-cloud', 0),
(7, 0, '系统', '', '', 'system', 0, 'fa fa-globe', 0),
(8, 7, '系统维护', '', '', 'system-wh', 0, 'fa fa-cog', 0),
(9, 8, '系统环境', 'system/index', '', '', 0, 'fa fa-cog', 0),
(10, 8, '系统缓存', 'system_cache/index', '', '', 0, 'fa fa-clock-o', 0),
(11, 8, '系统提醒', 'notice/index', '', '', 0, 'fa fa-bell', 0),
(12, 8, '数据字典', 'db/index', '', '', 0, 'fa fa-database', 0),
(13, 8, '系统体检', 'check/index', '', '', 0, 'fa fa-wrench', 0),
(14, 7, '日志管理', '', '', 'system-log', 0, 'fa fa-calendar', 0),
(15, 14, 'PHP错误', 'error_php/index', '', '', 0, 'fa fa-bug', 0),
(16, 14, '系统错误', 'error/index', '', '', 0, 'fa fa-shield', 0),
(17, 14, '操作日志', 'system_log/index', '', '', 0, 'fa fa-calendar', 0),
(18, 0, '设置', '', '', 'config', 0, 'fa fa-cogs', 0),
(19, 18, '网站设置', '', '', 'config-web', 0, 'fa fa-cog', 0),
(20, 19, '网站设置', 'site_config/index', '', '', 0, 'fa fa-cog', 0),
(21, 19, '手机设置', 'site_mobile/index', '', '', 0, 'fa fa-mobile', 0),
(22, 19, '域名绑定', 'site_domain/index', '', '', 0, 'fa fa-globe', 0),
(23, 19, '水印设置', 'site_watermark/index', '', '', 0, 'fa fa-photo', 0),
(24, 18, '内容设置', '', '', 'config-content', 0, 'fa fa-navicon', 0),
(25, 24, '创建模块', 'module_create/index', '', '', 0, 'fa fa-plus', 0),
(26, 24, '模块管理', 'module/index', '', '', 0, 'fa fa-gears', 0),
(27, 24, '模块搜索', 'module_search/index', '', '', 0, 'fa fa-search', 0),
(28, 24, '网站表单', 'form/index', '', '', 0, 'fa fa-table', 0),
(29, 18, 'SEO设置', '', '', 'config-seo', 0, 'fa fa-internet-explorer', 0),
(30, 29, '站点SEO', 'seo_site/index', '', '', 0, 'fa fa-cog', 0),
(31, 29, '模块SEO', 'seo_module/index', '', '', 0, 'fa fa-gears', 0),
(32, 29, '内容SEO', 'seo_content/index', '', '', 0, 'fa fa-th-large', 0),
(33, 29, '栏目SEO', 'seo_category/index', '', '', 0, 'fa fa-reorder', 0),
(34, 29, '搜索SEO', 'seo_search/index', '', '', 0, 'fa fa-search', 0),
(35, 29, 'URL规则', 'urlrule/index', '', '', 0, 'fa fa-link', 0),
(36, 0, '内容', '', '', 'content', 0, 'fa fa-th-large', 0),
(37, 36, '内容管理', '', '', 'content-module', 0, 'fa fa-th-large', 0),
(38, 37, '栏目管理', 'module_category/index', '', '', 0, 'fa fa-reorder', 0),
(39, 36, '网站表单', '', '', 'content-form', 0, 'fa fa-table', 0),
(40, 36, '内容审核', '', '', 'content-verify', 0, 'fa fa-edit', 0),
(41, 0, '扩展', '', '', 'code', 0, 'fa fa-code', 0),
(42, 41, '内容扩展', '', '', 'code-html', 0, 'fa fa-home', 0),
(43, 42, '关键词库', 'tag/index', '', '', 0, 'fa fa-tags', 0),
(44, 42, '联动菜单', 'linkage/index', '', '', 0, 'fa fa-columns', 0),
(45, 42, '自定义链接', 'navigator/index', '', '', 0, 'fa fa-link', 0),
(46, 42, '自定义资料', 'block/index', '', '', 0, 'fa fa-th-large', 0),
(47, 42, '自定义变量', 'myvar/index', '', '', 0, 'fa fa-code', 0),
(48, 37, '文章管理', 'news/home/index', '', 'module-news', 0, 'fa fa-code', -1);

-- --------------------------------------------------------

--
-- 表的结构 `dr_admin_notice`
--

DROP TABLE IF EXISTS `dr_admin_notice`;
CREATE TABLE IF NOT EXISTS `dr_admin_notice` (
  `id` int(10) NOT NULL COMMENT 'id',
  `site` int(5) NOT NULL COMMENT '站点id',
  `type` varchar(20) NOT NULL COMMENT '提醒类型：系统、内容、会员、应用',
  `msg` text NOT NULL COMMENT '提醒内容说明',
  `uri` varchar(100) NOT NULL COMMENT '对应的URI',
  `to_rid` smallint(5) NOT NULL COMMENT '指定角色组',
  `to_uid` int(10) NOT NULL COMMENT '指定管理员',
  `status` tinyint(1) NOT NULL COMMENT '未处理0，1已查看，2处理中，3处理完成',
  `uid` int(10) NOT NULL COMMENT '申请人',
  `username` varchar(100) NOT NULL COMMENT '申请人',
  `op_uid` int(10) NOT NULL COMMENT '处理人',
  `op_username` varchar(100) NOT NULL COMMENT '处理人',
  `updatetime` int(10) NOT NULL COMMENT '处理时间',
  `inputtime` int(10) NOT NULL COMMENT '提醒时间'
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8 COMMENT='后台提醒表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_admin_role`
--

DROP TABLE IF EXISTS `dr_admin_role`;
CREATE TABLE IF NOT EXISTS `dr_admin_role` (
  `id` smallint(5) NOT NULL,
  `site` text NOT NULL COMMENT '允许管理的站点，序列化数组格式',
  `name` text NOT NULL COMMENT '角色组语言名称',
  `system` text NOT NULL COMMENT '系统权限',
  `module` text NOT NULL COMMENT '模块权限',
  `application` text NOT NULL COMMENT '应用权限'
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='后台角色权限表';

--
-- 转存表中的数据 `dr_admin_role`
--

REPLACE INTO `dr_admin_role` (`id`, `site`, `name`, `system`, `module`, `application`) VALUES
(1, '', '超级管理员', '', '', ''),
(2, '', '网站编辑员', 'a:2:{s:4:"mark";a:19:{i:0;s:4:"home";i:1;s:7:"home-my";i:2;s:9:"home/main";i:3;s:6:"api/my";i:4;s:6:"config";i:5;s:14:"config-content";i:6;s:17:"module/home/index";i:7;s:19:"module/search/index";i:8;s:20:"module/comment/index";i:9;s:15:"form/home/index";i:10;s:13:"urlrule/index";i:11;s:11:"myvar/index";i:12;s:9:"config-db";i:13;s:12:"notice/index";i:14;s:16:"system_log/index";i:15;s:11:"error/index";i:16;s:11:"check/index";i:17;s:8:"db/index";i:18;s:10:"plug/index";}s:4:"auth";a:14:{s:9:"home/main";a:3:{i:0;s:3:"add";i:1;s:4:"edit";i:2;s:3:"del";}s:6:"api/my";a:3:{i:0;s:3:"add";i:1;s:4:"edit";i:2;s:3:"del";}s:17:"module/home/index";a:3:{i:0;s:3:"add";i:1;s:4:"edit";i:2;s:3:"del";}s:19:"module/search/index";a:3:{i:0;s:3:"add";i:1;s:4:"edit";i:2;s:3:"del";}s:20:"module/comment/index";a:3:{i:0;s:3:"add";i:1;s:4:"edit";i:2;s:3:"del";}s:15:"form/home/index";a:3:{i:0;s:3:"add";i:1;s:4:"edit";i:2;s:3:"del";}s:13:"urlrule/index";a:3:{i:0;s:3:"add";i:1;s:4:"edit";i:2;s:3:"del";}s:11:"myvar/index";a:3:{i:0;s:3:"add";i:1;s:4:"edit";i:2;s:3:"del";}s:12:"notice/index";a:3:{i:0;s:3:"add";i:1;s:4:"edit";i:2;s:3:"del";}s:16:"system_log/index";a:3:{i:0;s:3:"add";i:1;s:4:"edit";i:2;s:3:"del";}s:11:"error/index";a:3:{i:0;s:3:"add";i:1;s:4:"edit";i:2;s:3:"del";}s:11:"check/index";a:3:{i:0;s:3:"add";i:1;s:4:"edit";i:2;s:3:"del";}s:8:"db/index";a:3:{i:0;s:3:"add";i:1;s:4:"edit";i:2;s:3:"del";}s:10:"plug/index";a:3:{i:0;s:3:"add";i:1;s:4:"edit";i:2;s:3:"del";}}}', '', ''),
(3, '', '网站编辑员', '', '', '');

-- --------------------------------------------------------

--
-- 表的结构 `dr_admin_role_index`
--

DROP TABLE IF EXISTS `dr_admin_role_index`;
CREATE TABLE IF NOT EXISTS `dr_admin_role_index` (
  `id` smallint(5) NOT NULL,
  `uid` mediumint(8) unsigned DEFAULT NULL COMMENT '会员uid',
  `roleid` mediumint(8) unsigned DEFAULT NULL COMMENT '角色组id'
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='后台角色组分配表';

--
-- 转存表中的数据 `dr_admin_role_index`
--

REPLACE INTO `dr_admin_role_index` (`id`, `uid`, `roleid`) VALUES
(2, 1, 1),
(3, 1, 2);

-- --------------------------------------------------------

--
-- 表的结构 `dr_admin_verify`
--

DROP TABLE IF EXISTS `dr_admin_verify`;
CREATE TABLE IF NOT EXISTS `dr_admin_verify` (
  `id` smallint(5) unsigned NOT NULL,
  `name` text NOT NULL COMMENT '名称',
  `verify` text NOT NULL COMMENT '审核部署'
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='审核管理表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_api_auth`
--

DROP TABLE IF EXISTS `dr_api_auth`;
CREATE TABLE IF NOT EXISTS `dr_api_auth` (
  `id` int(10) NOT NULL COMMENT 'Id',
  `name` varchar(100) NOT NULL COMMENT '名称',
  `secret` varchar(100) NOT NULL COMMENT '密钥',
  `disabled` tinyint(1) unsigned NOT NULL COMMENT '禁用',
  `inputtime` int(10) unsigned NOT NULL COMMENT '创建时间'
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='api接口认证表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_api_http`
--

DROP TABLE IF EXISTS `dr_api_http`;
CREATE TABLE IF NOT EXISTS `dr_api_http` (
  `id` int(10) NOT NULL COMMENT 'Id',
  `name` varchar(100) NOT NULL COMMENT '名称',
  `content` text NOT NULL COMMENT '数据格式',
  `disabled` tinyint(1) unsigned NOT NULL COMMENT '禁用',
  `inputtime` int(10) unsigned NOT NULL COMMENT '创建时间'
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='api接口http数据表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_application`
--

DROP TABLE IF EXISTS `dr_application`;
CREATE TABLE IF NOT EXISTS `dr_application` (
  `id` smallint(5) unsigned NOT NULL,
  `dirname` varchar(50) NOT NULL COMMENT '目录名称',
  `disabled` tinyint(1) DEFAULT '0' COMMENT '是否禁用',
  `setting` text COMMENT '配置信息'
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='应用表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_attachment`
--

DROP TABLE IF EXISTS `dr_attachment`;
CREATE TABLE IF NOT EXISTS `dr_attachment` (
  `id` mediumint(8) unsigned NOT NULL,
  `uid` mediumint(8) unsigned NOT NULL COMMENT '会员id',
  `author` varchar(50) NOT NULL COMMENT '会员',
  `siteid` mediumint(5) unsigned NOT NULL COMMENT '站点id',
  `related` varchar(50) NOT NULL COMMENT '相关表标识',
  `tableid` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '附件副表id',
  `download` mediumint(8) NOT NULL DEFAULT '0' COMMENT '下载次数',
  `filesize` int(10) unsigned NOT NULL COMMENT '文件大小',
  `fileext` varchar(20) NOT NULL COMMENT '文件扩展名',
  `filemd5` varchar(50) NOT NULL COMMENT '文件md5值'
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COMMENT='附件表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_attachment_data`
--

DROP TABLE IF EXISTS `dr_attachment_data`;
CREATE TABLE IF NOT EXISTS `dr_attachment_data` (
  `id` mediumint(8) unsigned NOT NULL COMMENT '附件id',
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `author` varchar(50) NOT NULL COMMENT '会员',
  `related` varchar(50) NOT NULL COMMENT '相关表标识',
  `filename` varchar(255) NOT NULL DEFAULT '' COMMENT '原文件名',
  `fileext` varchar(20) NOT NULL COMMENT '文件扩展名',
  `filesize` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文件大小',
  `attachment` varchar(255) NOT NULL DEFAULT '' COMMENT '服务器路径',
  `remote` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '远程附件id',
  `attachinfo` text NOT NULL COMMENT '附件信息',
  `inputtime` int(10) unsigned NOT NULL COMMENT '入库时间'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='附件已归档表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_attachment_remote`
--

DROP TABLE IF EXISTS `dr_attachment_remote`;
CREATE TABLE IF NOT EXISTS `dr_attachment_remote` (
  `id` tinyint(2) unsigned NOT NULL,
  `type` tinyint(2) NOT NULL COMMENT '类型',
  `name` varchar(50) NOT NULL COMMENT '名称',
  `url` varchar(255) NOT NULL COMMENT '访问地址',
  `value` text NOT NULL COMMENT '参数值'
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='远程附件表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_attachment_unused`
--

DROP TABLE IF EXISTS `dr_attachment_unused`;
CREATE TABLE IF NOT EXISTS `dr_attachment_unused` (
  `id` mediumint(8) unsigned NOT NULL COMMENT '附件id',
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `author` varchar(50) NOT NULL COMMENT '会员',
  `siteid` mediumint(5) unsigned NOT NULL COMMENT '站点id',
  `filename` varchar(255) NOT NULL DEFAULT '' COMMENT '原文件名',
  `fileext` varchar(20) NOT NULL COMMENT '文件扩展名',
  `filesize` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文件大小',
  `attachment` varchar(255) NOT NULL DEFAULT '' COMMENT '服务器路径',
  `remote` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '远程附件id',
  `attachinfo` text NOT NULL COMMENT '附件信息',
  `inputtime` int(10) unsigned NOT NULL COMMENT '入库时间'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='未使用的附件表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_cron`
--

DROP TABLE IF EXISTS `dr_cron`;
CREATE TABLE IF NOT EXISTS `dr_cron` (
  `id` int(10) NOT NULL,
  `type` varchar(20) NOT NULL COMMENT '类型',
  `value` text NOT NULL COMMENT '参数值',
  `status` tinyint(1) unsigned NOT NULL COMMENT '状态',
  `error` varchar(255) NOT NULL COMMENT '错误信息',
  `updatetime` int(10) unsigned NOT NULL COMMENT '执行时间',
  `inputtime` int(10) unsigned NOT NULL COMMENT '写入时间',
  `site` int(10) NOT NULL COMMENT '站点'
) ENGINE=MyISAM AUTO_INCREMENT=79 DEFAULT CHARSET=utf8 COMMENT='任务管理';

-- --------------------------------------------------------

--
-- 表的结构 `dr_export`
--

DROP TABLE IF EXISTS `dr_export`;
CREATE TABLE IF NOT EXISTS `dr_export` (
  `id` int(10) NOT NULL COMMENT 'Id',
  `name` varchar(100) NOT NULL COMMENT '表名称',
  `value` text NOT NULL COMMENT '字段配置项目'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='导出数据字段配置';

-- --------------------------------------------------------

--
-- 表的结构 `dr_field`
--

DROP TABLE IF EXISTS `dr_field`;
CREATE TABLE IF NOT EXISTS `dr_field` (
  `id` smallint(5) unsigned NOT NULL,
  `name` text NOT NULL COMMENT '字段别名语言',
  `fieldname` varchar(50) NOT NULL COMMENT '字段名称',
  `fieldtype` varchar(50) NOT NULL COMMENT '字段类型',
  `relatedid` smallint(5) unsigned NOT NULL COMMENT '相关id',
  `relatedname` varchar(50) NOT NULL COMMENT '相关表',
  `isedit` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否可修改',
  `ismain` tinyint(1) unsigned NOT NULL COMMENT '是否主表',
  `issystem` tinyint(1) unsigned NOT NULL COMMENT '是否系统表',
  `ismember` tinyint(1) unsigned NOT NULL COMMENT '是否会员可见',
  `issearch` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否可搜索',
  `disabled` tinyint(1) unsigned NOT NULL COMMENT '禁用？',
  `setting` text NOT NULL COMMENT '配置信息',
  `displayorder` int(5) NOT NULL COMMENT '排序'
) ENGINE=MyISAM AUTO_INCREMENT=94 DEFAULT CHARSET=utf8 COMMENT='字段表';

--
-- 转存表中的数据 `dr_field`
--

REPLACE INTO `dr_field` (`id`, `name`, `fieldname`, `fieldtype`, `relatedid`, `relatedname`, `isedit`, `ismain`, `issystem`, `ismember`, `issearch`, `disabled`, `setting`, `displayorder`) VALUES
(1, '相关附件', 'attachment', 'Files', 1, 'page', 1, 1, 1, 1, 0, 0, 'a:2:{s:6:"option";a:5:{s:5:"width";s:3:"80%";s:4:"size";s:1:"2";s:5:"count";s:2:"10";s:3:"ext";s:31:"jpg,gif,png,ppt,doc,xls,rar,zip";s:10:"uploadpath";s:0:"";}s:8:"validate";a:9:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:6:"isedit";s:1:"0";s:3:"xss";s:1:"0";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:4:"tips";s:0:"";s:8:"formattr";s:0:"";}}', 0),
(2, '单页内容', 'content', 'Ueditor', 1, 'page', 1, 1, 1, 1, 0, 0, 'a:2:{s:6:"option";a:7:{s:5:"width";s:3:"90%";s:6:"height";s:3:"400";s:4:"mode";s:1:"1";s:4:"tool";s:0:"";s:5:"mode2";s:1:"1";s:5:"tool2";s:0:"";s:5:"value";s:0:"";}s:8:"validate";a:9:{s:8:"required";s:1:"1";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:6:"isedit";s:1:"0";s:3:"xss";s:1:"1";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:4:"tips";s:0:"";s:8:"formattr";s:0:"";}}', 0),
(3, '主题', 'title', 'Text', 1, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:3:{s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:3:{s:3:"xss";i:1;s:8:"required";i:1;s:8:"formattr";s:48:"onblur="check_title();get_keywords(''keywords'');"";}}', 1),
(4, '缩略图', 'thumb', 'File', 1, 'module', 1, 1, 1, 1, 1, 0, 'a:1:{s:6:"option";a:5:{s:3:"ext";s:11:"jpg,gif,png";s:4:"size";i:10;s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}}', 0),
(5, '关键字', 'keywords', 'Text', 1, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:3:{s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:2:{s:3:"xss";i:1;s:8:"formattr";s:22:" data-role="tagsinput"";}}', 2),
(6, '描述', 'description', 'Textarea', 1, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:4:{s:5:"width";i:500;s:6:"height";i:60;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:2:{s:3:"xss";i:1;s:6:"filter";s:12:"dr_clearhtml";}}', 0),
(7, '内容', 'content', 'Ueditor', 1, 'module', 1, 0, 1, 1, 0, 0, 'a:3:{s:6:"option";a:15:{s:9:"watermark";s:1:"0";s:9:"autofloat";s:1:"0";s:10:"autoheight";s:1:"0";s:4:"page";s:1:"1";s:4:"mode";s:1:"1";s:4:"tool";s:29:"''bold'', ''italic'', ''underline''";s:5:"mode2";s:1:"1";s:5:"tool2";s:29:"''bold'', ''italic'', ''underline''";s:5:"mode3";s:1:"1";s:5:"tool3";s:29:"''bold'', ''italic'', ''underline''";s:10:"attachment";s:1:"0";s:5:"value";s:0:"";s:5:"width";s:4:"100%";s:6:"height";s:3:"400";s:3:"css";s:0:"";}s:8:"validate";a:8:{s:8:"required";s:1:"1";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:3:"xss";s:1:"1";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 5),
(8, '主题', 'title', 'Text', 2, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:3:{s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:3:{s:3:"xss";i:1;s:8:"required";i:1;s:8:"formattr";s:48:"onblur="check_title();get_keywords(''keywords'');"";}}', 0),
(9, '缩略图', 'thumb', 'File', 2, 'module', 1, 1, 1, 1, 1, 0, 'a:1:{s:6:"option";a:5:{s:3:"ext";s:11:"jpg,gif,png";s:4:"size";i:10;s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}}', 0),
(10, '关键字', 'keywords', 'Text', 2, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:3:{s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:2:{s:3:"xss";i:1;s:8:"formattr";s:22:" data-role="tagsinput"";}}', 0),
(11, '描述', 'description', 'Textarea', 2, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:4:{s:5:"width";i:500;s:6:"height";i:60;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:2:{s:3:"xss";i:1;s:6:"filter";s:12:"dr_clearhtml";}}', 0),
(12, '详细内容', 'content', 'Ueditor', 2, 'module', 1, 0, 1, 1, 0, 0, 'a:3:{s:6:"option";a:15:{s:9:"watermark";s:1:"0";s:9:"autofloat";s:1:"0";s:10:"autoheight";s:1:"0";s:4:"page";s:1:"0";s:4:"mode";s:1:"1";s:4:"tool";s:29:"''bold'', ''italic'', ''underline''";s:5:"mode2";s:1:"1";s:5:"tool2";s:29:"''bold'', ''italic'', ''underline''";s:5:"mode3";s:1:"1";s:5:"tool3";s:29:"''bold'', ''italic'', ''underline''";s:10:"attachment";s:1:"0";s:5:"value";s:0:"";s:5:"width";s:4:"100%";s:6:"height";s:3:"400";s:3:"css";s:0:"";}s:8:"validate";a:8:{s:8:"required";s:1:"1";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:3:"xss";s:1:"1";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 9),
(13, '主题', 'title', 'Text', 3, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:3:{s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:3:{s:3:"xss";i:1;s:8:"required";i:1;s:8:"formattr";s:48:"onblur="check_title();get_keywords(''keywords'');"";}}', 0),
(14, '缩略图', 'thumb', 'File', 3, 'module', 1, 1, 1, 1, 1, 0, 'a:1:{s:6:"option";a:5:{s:3:"ext";s:11:"jpg,gif,png";s:4:"size";i:10;s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}}', 0),
(15, '关键字', 'keywords', 'Text', 3, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:3:{s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:2:{s:3:"xss";i:1;s:8:"formattr";s:22:" data-role="tagsinput"";}}', 0),
(16, '描述', 'description', 'Textarea', 3, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:4:{s:5:"width";i:500;s:6:"height";i:60;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:2:{s:3:"xss";i:1;s:6:"filter";s:12:"dr_clearhtml";}}', 0),
(17, '内容', 'content', 'Ueditor', 3, 'module', 1, 0, 1, 1, 1, 0, 'a:2:{s:6:"option";a:3:{s:4:"mode";i:1;s:5:"width";s:4:"100%";s:6:"height";i:400;}s:8:"validate";a:2:{s:3:"xss";i:1;s:8:"required";i:1;}}', 9),
(18, '主题', 'title', 'Text', 4, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:3:{s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:3:{s:3:"xss";i:1;s:8:"required";i:1;s:8:"formattr";s:48:"onblur="check_title();get_keywords(''keywords'');"";}}', 0),
(19, '缩略图', 'thumb', 'File', 4, 'module', 1, 1, 1, 1, 1, 0, 'a:1:{s:6:"option";a:5:{s:3:"ext";s:11:"jpg,gif,png";s:4:"size";i:10;s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}}', 0),
(20, '关键字', 'keywords', 'Text', 4, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:3:{s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:2:{s:3:"xss";i:1;s:8:"formattr";s:22:" data-role="tagsinput"";}}', 0),
(21, '描述', 'description', 'Textarea', 4, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:4:{s:5:"width";i:500;s:6:"height";i:60;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:2:{s:3:"xss";i:1;s:6:"filter";s:12:"dr_clearhtml";}}', 0),
(22, '内容', 'content', 'Ueditor', 4, 'module', 1, 0, 1, 1, 0, 0, '{"option":{"watermark":"0","show_bottom_boot":"0","mini":"0","mobile_mini":"0","autofloat":"0","autoheight":"0","page":"1","mode":"1","tool":"''bold'', ''italic'', ''underline''","mode2":"1","tool2":"''bold'', ''italic'', ''underline''","mode3":"1","tool3":"''bold'', ''italic'', ''underline''","attachment":"0","value":"","width":"100%","height":"400","css":""},"validate":{"required":"1","pattern":"","errortips":"","xss":"1","check":"","filter":"","formattr":"","tips":""},"is_right":"0"}', 99),
(23, '主题', 'title', 'Text', 5, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:3:{s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:3:{s:3:"xss";i:1;s:8:"required";i:1;s:8:"formattr";s:48:"onblur="check_title();get_keywords(''keywords'');"";}}', 0),
(24, '缩略图', 'thumb', 'File', 5, 'module', 1, 1, 1, 1, 1, 0, 'a:1:{s:6:"option";a:5:{s:3:"ext";s:11:"jpg,gif,png";s:4:"size";i:10;s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}}', 0),
(25, '关键字', 'keywords', 'Text', 5, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:3:{s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:2:{s:3:"xss";i:1;s:8:"formattr";s:22:" data-role="tagsinput"";}}', 0),
(26, '描述', 'description', 'Textarea', 5, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:4:{s:5:"width";i:500;s:6:"height";i:60;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:2:{s:3:"xss";i:1;s:6:"filter";s:12:"dr_clearhtml";}}', 0),
(27, '内容', 'content', 'Ueditor', 5, 'module', 1, 0, 1, 1, 1, 0, 'a:2:{s:6:"option";a:3:{s:4:"mode";i:1;s:5:"width";s:4:"100%";s:6:"height";i:400;}s:8:"validate";a:2:{s:3:"xss";i:1;s:8:"required";i:1;}}', 9),
(28, '主题', 'title', 'Text', 6, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:3:{s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:3:{s:3:"xss";i:1;s:8:"required";i:1;s:8:"formattr";s:48:"onblur="check_title();get_keywords(''keywords'');"";}}', 0),
(29, '缩略图', 'thumb', 'File', 6, 'module', 1, 1, 1, 1, 1, 0, 'a:1:{s:6:"option";a:5:{s:3:"ext";s:11:"jpg,gif,png";s:4:"size";i:10;s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}}', 0),
(30, '关键字', 'keywords', 'Text', 6, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:3:{s:5:"width";i:400;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:2:{s:3:"xss";i:1;s:8:"formattr";s:22:" data-role="tagsinput"";}}', 0),
(31, '描述', 'description', 'Textarea', 6, 'module', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:4:{s:5:"width";i:500;s:6:"height";i:60;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:2:{s:3:"xss";i:1;s:6:"filter";s:12:"dr_clearhtml";}}', 0),
(32, '专题内容', 'content', 'Ueditor', 6, 'module', 1, 0, 1, 1, 0, 0, 'a:3:{s:6:"option";a:15:{s:9:"watermark";s:1:"0";s:9:"autofloat";s:1:"0";s:10:"autoheight";s:1:"0";s:4:"page";s:1:"0";s:4:"mode";s:1:"1";s:4:"tool";s:29:"''bold'', ''italic'', ''underline''";s:5:"mode2";s:1:"1";s:5:"tool2";s:29:"''bold'', ''italic'', ''underline''";s:5:"mode3";s:1:"1";s:5:"tool3";s:29:"''bold'', ''italic'', ''underline''";s:10:"attachment";s:1:"0";s:5:"value";s:0:"";s:5:"width";s:4:"100%";s:6:"height";s:3:"400";s:3:"css";s:0:"";}s:8:"validate";a:8:{s:8:"required";s:1:"1";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:3:"xss";s:1:"1";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 99),
(33, '图片上传', 'image', 'Files', 3, 'module', 1, 0, 0, 0, 0, 0, 'a:3:{s:6:"option";a:5:{s:4:"size";s:2:"10";s:5:"count";s:2:"10";s:3:"ext";s:11:"jpg,gif,png";s:10:"attachment";s:1:"0";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(34, '附件上传', 'file', 'File', 2, 'module', 1, 0, 0, 0, 0, 0, 'a:3:{s:6:"option";a:4:{s:3:"ext";s:7:"rar,zip";s:4:"size";s:3:"100";s:10:"attachment";s:1:"0";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(35, '界面截图', 'image', 'Files', 2, 'module', 1, 0, 0, 0, 0, 0, 'a:3:{s:6:"option";a:5:{s:4:"size";s:2:"10";s:5:"count";s:2:"10";s:3:"ext";s:11:"jpg,gif,png";s:10:"attachment";s:1:"0";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(36, '开发商', 'kfs', 'Text', 2, 'module', 1, 1, 0, 0, 0, 0, 'a:3:{s:6:"option";a:5:{s:9:"fieldtype";s:0:"";s:11:"fieldlength";s:0:"";s:5:"value";s:0:"";s:5:"width";s:3:"300";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(37, '演示地址', 'demo', 'Text', 2, 'module', 1, 1, 0, 0, 0, 0, 'a:3:{s:6:"option";a:5:{s:9:"fieldtype";s:0:"";s:11:"fieldlength";s:0:"";s:5:"value";s:0:"";s:5:"width";s:4:"100%";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(38, '商品价格', 'price', 'Pays', 5, 'module', 1, 1, 0, 1, 0, 0, '{"option":{"payfile":"buys.html","is_finecms":"1","field":["price","quantity","sn"],"width":"buy.html","css":""},"validate":{"required":"0","pattern":"","errortips":"","check":"","filter":"","formattr":"","tips":""},"is_right":"0"}', 0),
(39, '关联新闻', 'xinwen', 'Related', 1, 'special-1', 1, 1, 0, 0, 0, 0, 'a:3:{s:6:"option";a:3:{s:6:"module";s:4:"news";s:5:"limit";s:0:"";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(66, '选择分组', 'xuanzefenzu', 'Merge', 1, 'module', 1, 0, 0, 1, 0, 0, 'a:3:{s:6:"option";a:2:{s:5:"value";s:52:"{danxuananniu}\r\n{fuxuankuang}\r\n{xialaxuanze}\r\n{csxz}";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 6),
(41, '所在地', 'city', 'Linkage', 5, 'module', 1, 1, 0, 0, 0, 0, 'a:3:{s:6:"option";a:3:{s:7:"linkage";s:7:"address";s:5:"value";s:0:"";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(42, '商品图片', 'image', 'Files', 5, 'module', 1, 0, 0, 0, 0, 0, 'a:3:{s:6:"option";a:5:{s:4:"size";s:2:"10";s:5:"count";s:1:"8";s:3:"ext";s:11:"jpg,gif,png";s:10:"attachment";s:1:"0";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(43, '商品参数', 'spcs', 'Property', 5, 'module', 1, 0, 0, 0, 0, 0, 'a:3:{s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:6:"option";a:1:{s:3:"css";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(44, '主题', 'title', 'Text', 1, 'mform-demo', 1, 1, 1, 1, 1, 0, 'a:2:{s:6:"option";a:3:{s:5:"width";i:300;s:9:"fieldtype";s:7:"VARCHAR";s:11:"fieldlength";s:3:"255";}s:8:"validate";a:2:{s:3:"xss";i:1;s:8:"required";i:1;}}', 0),
(90, '测试内容', 'ceshineirong', 'Ueditor', 3, 'form-1', 1, 0, 0, 0, 0, 0, '{"option":{"watermark":"0","show_bottom_boot":"0","mini":"0","mobile_mini":"0","autofloat":"0","autoheight":"0","page":"0","mode":"1","tool":"''bold'', ''italic'', ''underline''","mode2":"1","tool2":"''bold'', ''italic'', ''underline''","mode3":"1","tool3":"''bold'', ''italic'', ''underline''","attachment":"0","value":"","width":"100%","height":"300","css":""},"validate":{"required":"0","pattern":"","errortips":"","check":"","filter":"","formattr":"","tips":"","xss":1},"is_right":"0"}', 0),
(46, '文本事件', 'wbsj', 'Textbtn', 1, 'module', 1, 1, 0, 1, 0, 0, 'a:3:{s:6:"option";a:9:{s:9:"fieldtype";s:0:"";s:11:"fieldlength";s:0:"";s:5:"value";s:0:"";s:5:"width";s:0:"";s:5:"color";s:0:"";s:4:"icon";s:0:"";s:4:"name";s:0:"";s:4:"func";s:0:"";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(47, '多行文本', 'dxwb', 'Textarea', 1, 'module', 1, 1, 0, 1, 0, 0, 'a:3:{s:6:"option";a:4:{s:5:"value";s:0:"";s:5:"width";s:0:"";s:6:"height";s:0:"";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(48, '百度地图', 'baiduditu', 'Baidumap', 1, 'module', 1, 1, 0, 1, 0, 0, 'a:3:{s:6:"option";a:4:{s:5:"level";s:2:"15";s:5:"width";s:0:"";s:6:"height";s:0:"";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 4),
(49, '单选按钮', 'danxuananniu', 'Radio', 1, 'module', 1, 1, 0, 1, 0, 0, 'a:3:{s:6:"option";a:6:{s:7:"options";s:66:"选项名称1|1\r\n选项名称2|2\r\n选项名称3|3\r\n选项名称4|4";s:5:"value";s:0:"";s:9:"fieldtype";s:0:"";s:11:"fieldlength";s:0:"";s:9:"show_type";s:1:"0";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(50, '复选框', 'fuxuankuang', 'Checkbox', 1, 'module', 1, 1, 0, 1, 0, 0, 'a:3:{s:6:"option";a:4:{s:7:"options";s:66:"选项名称1|1\r\n选项名称2|2\r\n选项名称3|3\r\n选项名称4|4";s:5:"value";s:0:"";s:9:"show_type";s:1:"0";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(57, '单单个文件上传', 'dgwjsc', 'File', 1, 'module', 1, 1, 0, 1, 0, 0, 'a:3:{s:6:"option";a:4:{s:3:"ext";s:3:"zip";s:4:"size";s:2:"10";s:10:"attachment";s:1:"0";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(67, '颜色放右边', 'ysfyb', 'Color', 1, 'module', 1, 1, 0, 1, 0, 0, 'a:3:{s:6:"option";a:4:{s:5:"field";s:5:"title";s:5:"value";s:0:"";s:5:"width";s:0:"";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"1";}', 0),
(53, '日期时间格式', 'rqsjgs', 'Date', 1, 'module', 1, 1, 0, 1, 0, 0, 'a:3:{s:6:"option";a:5:{s:7:"format2";s:1:"0";s:5:"value";s:0:"";s:5:"width";s:0:"";s:5:"color";s:0:"";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(54, '年月日格式', 'nyrgs', 'Date', 1, 'module', 1, 1, 0, 1, 0, 0, 'a:3:{s:6:"option";a:5:{s:7:"format2";s:1:"1";s:5:"value";s:0:"";s:5:"width";s:0:"";s:5:"color";s:0:"";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(56, '下拉选择', 'xialaxuanze', 'Select', 1, 'module', 1, 1, 0, 1, 0, 0, 'a:3:{s:6:"option";a:6:{s:7:"options";s:66:"选项名称1|1\r\n选项名称2|2\r\n选项名称3|3\r\n选项名称4|4";s:5:"value";s:0:"";s:9:"fieldtype";s:0:"";s:11:"fieldlength";s:0:"";s:9:"show_type";s:1:"0";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(59, '多个图片上传', 'dgtpsc', 'Files', 1, 'module', 1, 1, 0, 1, 0, 0, 'a:3:{s:6:"option";a:5:{s:4:"size";s:2:"10";s:5:"count";s:2:"10";s:3:"ext";s:11:"jpg,gif,png";s:10:"attachment";s:1:"0";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(60, '城市联动选择', 'csxz', 'Linkage', 1, 'module', 1, 1, 0, 1, 0, 0, 'a:3:{s:6:"option";a:3:{s:7:"linkage";s:7:"address";s:5:"value";s:0:"";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(61, '参数属性', 'cssx', 'Property', 1, 'module', 1, 1, 0, 1, 0, 0, 'a:3:{s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:6:"option";a:1:{s:3:"css";s:0:"";}s:8:"is_right";s:1:"0";}', 3),
(62, '关联选择新闻内容', 'glxzxwnr', 'Related', 1, 'module', 1, 1, 0, 1, 0, 0, 'a:3:{s:6:"option";a:3:{s:6:"module";s:4:"news";s:5:"limit";s:2:"20";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 2),
(63, '文本组', 'wenbenzu', 'Merge', 1, 'module', 1, 0, 0, 1, 0, 0, 'a:3:{s:6:"option";a:2:{s:5:"value";s:39:"{wbsj}\r\n{dxzhcs}\r\n{dxwb}\r\n{description}";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 9),
(64, '日期组', 'riqizu', 'Merge', 1, 'module', 1, 0, 0, 1, 0, 0, 'a:3:{s:6:"option";a:2:{s:5:"value";s:19:"\r\n{rqsjgs}\r\n{nyrgs}";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 8),
(65, '文件上传组', 'wjscz', 'Merge', 1, 'module', 1, 1, 0, 1, 0, 0, 'a:3:{s:6:"option";a:2:{s:5:"value";s:27:"{dgwjsc}\r\n{thumb}\r\n{dgtpsc}";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 7),
(89, '主题', 'title', 'Text', 3, 'form-1', 1, 1, 1, 1, 1, 0, '{"option":{"width":300,"fieldtype":"VARCHAR","fieldlength":"255"},"validate":{"xss":1,"required":1}}', 0),
(71, '文本1', 'wenben1', 'Text', 1, 'module', 1, 1, 0, 1, 0, 0, 'a:3:{s:6:"option";a:5:{s:9:"fieldtype";s:0:"";s:11:"fieldlength";s:0:"";s:5:"value";s:0:"";s:5:"width";s:0:"";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(72, '文本2', 'wenben2', 'Text', 1, 'module', 1, 1, 0, 1, 0, 0, 'a:3:{s:6:"option";a:5:{s:9:"fieldtype";s:0:"";s:11:"fieldlength";s:0:"";s:5:"value";s:0:"";s:5:"width";s:0:"";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(73, '单行组合测试', 'dxzhcs', 'Group', 1, 'module', 1, 0, 0, 1, 0, 0, 'a:3:{s:6:"option";a:2:{s:5:"value";s:112:" <label> 文本1:</label>\r\n <label>  {wenben1} </label>\r\n  <label> 文本2: </label>  \r\n<label>{wenben2}</label>";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(74, '关联图片', 'tupian', 'Related', 2, 'special-1', 1, 1, 0, 0, 0, 0, 'a:3:{s:6:"option";a:3:{s:6:"module";s:5:"image";s:5:"limit";s:2:"20";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(75, '关联下载', 'xiazai', 'Related', 3, 'special-1', 1, 1, 0, 0, 0, 0, 'a:3:{s:6:"option";a:3:{s:6:"module";s:4:"down";s:5:"limit";s:0:"";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(76, '关联商品', 'shangpin', 'Related', 4, 'special-1', 1, 1, 0, 0, 0, 0, 'a:3:{s:6:"option";a:3:{s:6:"module";s:4:"shop";s:5:"limit";s:0:"";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(91, '表单可购买', 'bdkgm', 'Pays', 3, 'form-1', 1, 0, 0, 0, 0, 0, '{"option":{"payfile":"buy.html","is_finecms":"1","field":["price","quantity","sn"],"width":"","css":""},"validate":{"required":"0","pattern":"","errortips":"","check":"","filter":"","formattr":"","tips":""},"is_right":"0"}', 0),
(81, '测试扩展', 'csgxlm', 'Text', 1, 'news-1', 1, 0, 0, 0, 0, 0, 'a:3:{s:6:"option";a:5:{s:9:"fieldtype";s:0:"";s:11:"fieldlength";s:0:"";s:5:"value";s:0:"";s:5:"width";s:0:"";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(82, 'aaa', 'aaa', 'Text', 1, 'share-1', 1, 0, 0, 0, 0, 0, 'a:3:{s:6:"option";a:5:{s:9:"fieldtype";s:0:"";s:11:"fieldlength";s:0:"";s:5:"value";s:0:"";s:5:"width";s:0:"";s:3:"css";s:0:"";}s:8:"validate";a:7:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:8:"formattr";s:0:"";s:4:"tips";s:0:"";}s:8:"is_right";s:1:"0";}', 0),
(87, '单页内容', 'content', 'Ueditor', 2, 'page', 1, 1, 1, 1, 0, 0, 'a:2:{s:6:"option";a:7:{s:5:"width";s:3:"90%";s:6:"height";s:3:"400";s:4:"mode";s:1:"1";s:4:"tool";s:0:"";s:5:"mode2";s:1:"1";s:5:"tool2";s:0:"";s:5:"value";s:0:"";}s:8:"validate";a:9:{s:8:"required";s:1:"1";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:6:"isedit";s:1:"0";s:3:"xss";s:1:"1";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:4:"tips";s:0:"";s:8:"formattr";s:0:"";}}', 0),
(88, 'test', 'test', 'Text', 0, 'table-app_gathering', 1, 1, 0, 0, 0, 0, '{"option":{"fieldtype":"","fieldlength":"","value":"","width":"","css":""},"validate":{"required":"0","pattern":"","errortips":"","check":"","filter":"","formattr":"","tips":""},"is_right":"0"}', 0),
(86, '相关附件', 'attachment', 'Files', 2, 'page', 1, 1, 1, 1, 0, 0, 'a:2:{s:6:"option";a:5:{s:5:"width";s:3:"80%";s:4:"size";s:1:"2";s:5:"count";s:2:"10";s:3:"ext";s:31:"jpg,gif,png,ppt,doc,xls,rar,zip";s:10:"uploadpath";s:0:"";}s:8:"validate";a:9:{s:8:"required";s:1:"0";s:7:"pattern";s:0:"";s:9:"errortips";s:0:"";s:6:"isedit";s:1:"0";s:3:"xss";s:1:"0";s:5:"check";s:0:"";s:6:"filter";s:0:"";s:4:"tips";s:0:"";s:8:"formattr";s:0:"";}}', 0),
(92, '留言主题', 'title', 'Text', 1, 'form-1', 1, 1, 1, 1, 0, 0, '{"option":{"fieldtype":"VARCHAR","fieldlength":"255","value":"","width":"300","css":""},"validate":{"required":"1","pattern":"","errortips":"","xss":"1","check":"","filter":"","formattr":"","tips":""},"is_right":"0"}', 0),
(93, '留言内容', 'lynr', 'Ueditor', 1, 'form-1', 1, 0, 0, 1, 0, 0, '{"option":{"watermark":"0","show_bottom_boot":"0","mini":"0","mobile_mini":"0","autofloat":"0","autoheight":"0","page":"0","mode":"1","tool":"''bold'', ''italic'', ''underline''","mode2":"1","tool2":"''bold'', ''italic'', ''underline''","mode3":"1","tool3":"''bold'', ''italic'', ''underline''","attachment":"0","value":"","width":"100%","height":"300","css":""},"validate":{"required":"1","pattern":"","errortips":"","xss":"1","check":"","filter":"","formattr":"","tips":""},"is_right":"0"}', 0);

-- --------------------------------------------------------

--
-- 表的结构 `dr_linkage`
--

DROP TABLE IF EXISTS `dr_linkage`;
CREATE TABLE IF NOT EXISTS `dr_linkage` (
  `id` smallint(5) unsigned NOT NULL,
  `name` varchar(255) NOT NULL COMMENT '菜单名称',
  `type` tinyint(1) unsigned NOT NULL,
  `code` char(20) NOT NULL
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='联动菜单表';

--
-- 转存表中的数据 `dr_linkage`
--

REPLACE INTO `dr_linkage` (`id`, `name`, `type`, `code`) VALUES
(1, '中国地区', 0, 'address');

-- --------------------------------------------------------

--
-- 表的结构 `dr_linkage_data_1`
--

DROP TABLE IF EXISTS `dr_linkage_data_1`;
CREATE TABLE IF NOT EXISTS `dr_linkage_data_1` (
  `id` mediumint(8) unsigned NOT NULL,
  `site` mediumint(5) unsigned NOT NULL COMMENT '站点id',
  `pid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '上级id',
  `pids` varchar(255) DEFAULT NULL COMMENT '所有上级id',
  `name` varchar(30) NOT NULL COMMENT '栏目名称',
  `cname` varchar(30) NOT NULL COMMENT '别名',
  `child` tinyint(1) unsigned DEFAULT '0' COMMENT '是否有下级',
  `hidden` tinyint(1) unsigned DEFAULT '0' COMMENT '前端隐藏',
  `childids` text COMMENT '下级所有id',
  `displayorder` mediumint(8) DEFAULT '0'
) ENGINE=MyISAM AUTO_INCREMENT=3251 DEFAULT CHARSET=utf8 COMMENT='联动菜单数据表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_mail_smtp`
--

DROP TABLE IF EXISTS `dr_mail_smtp`;
CREATE TABLE IF NOT EXISTS `dr_mail_smtp` (
  `id` smallint(5) unsigned NOT NULL,
  `host` varchar(255) NOT NULL,
  `user` varchar(255) NOT NULL,
  `pass` varchar(255) NOT NULL,
  `port` mediumint(8) unsigned NOT NULL,
  `displayorder` smallint(5) DEFAULT NULL
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='邮件账户表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_member`
--

DROP TABLE IF EXISTS `dr_member`;
CREATE TABLE IF NOT EXISTS `dr_member` (
  `id` int(10) unsigned NOT NULL,
  `email` char(50) NOT NULL DEFAULT '' COMMENT '邮箱地址',
  `phone` char(20) NOT NULL COMMENT '手机号码',
  `username` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `password` char(32) NOT NULL DEFAULT '' COMMENT '加密密码',
  `salt` char(10) NOT NULL COMMENT '随机加密码',
  `name` varchar(50) NOT NULL COMMENT '姓名',
  `money` decimal(10,2) unsigned NOT NULL COMMENT 'RMB',
  `freeze` decimal(10,2) unsigned NOT NULL COMMENT '冻结RMB',
  `spend` decimal(10,2) unsigned NOT NULL COMMENT '消费RMB总额',
  `score` int(10) unsigned NOT NULL COMMENT '虚拟币',
  `experience` int(10) unsigned NOT NULL COMMENT '经验值',
  `regip` varchar(15) NOT NULL COMMENT '注册ip',
  `regtime` int(10) unsigned NOT NULL COMMENT '注册时间',
  `randcode` mediumint(6) unsigned NOT NULL COMMENT '随机验证码'
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='会员表';

--
-- 转存表中的数据 `dr_member`
--

REPLACE INTO `dr_member` (`id`, `email`, `phone`, `username`, `password`, `salt`, `name`, `money`, `freeze`, `spend`, `score`, `experience`, `regip`, `regtime`, `randcode`) VALUES
(1, 'abcd@qq.com', '2222', 'admin', '62e69b828c74c50a1f6e93227cdf7e77', '8d6dc35e50', '创始人', '1039379.89', '100.00', '2075.00', 1000013, 1000001, '', 1478757255, 0),
(2, 'admin@22.com', '', 'admin2', 'de5f1c0c20af0a2315452593ffdf4675', 'd7a728a67d', '测试', '1984387.22', '0.00', '15612.78', 0, 0, '127.0.0.1', 1478835762, 544979),
(3, '2222@163.com', '33333333', 'qq7761', 'aa90b6d3e249fc9e2d5f17471ca2cf9a', 'cedebb6e87', '', '81089.89', '0.00', '18910.11', 0, 0, '192.168.0.9', 1479093142, 160071),
(4, '222@qq.com', '22222', '马云', '76f5ec6d255f7c465b32518060ceaaf5', '2050e03ca1', '', '992968.00', '0.00', '7032.00', 0, 0, '192.168.0.5', 1479093171, 296733),
(5, '333@163.com2', '22222', 'test', '483ce55a9119afef52dfde92dc524f82', '9de6d14fff', '', '0.00', '0.00', '0.00', 0, 0, '127.0.0.1', 1479377440, 657243);

-- --------------------------------------------------------

--
-- 表的结构 `dr_member_data`
--

DROP TABLE IF EXISTS `dr_member_data`;
CREATE TABLE IF NOT EXISTS `dr_member_data` (
  `id` int(10) unsigned NOT NULL,
  `is_admin` tinyint(1) unsigned DEFAULT '0' COMMENT '是否是管理员',
  `is_lock` tinyint(1) unsigned DEFAULT '0' COMMENT '账号锁定标识',
  `is_auth` tinyint(1) unsigned DEFAULT '0' COMMENT '实名认证标识',
  `is_verify` tinyint(1) unsigned DEFAULT '0' COMMENT '审核标识',
  `is_mobile` tinyint(1) unsigned DEFAULT '0' COMMENT '手机认证标识',
  `is_avatar` tinyint(1) unsigned DEFAULT '0' COMMENT '头像上传标识',
  `is_complete` tinyint(1) unsigned DEFAULT '0' COMMENT '完善资料标识'
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='会员表';

--
-- 转存表中的数据 `dr_member_data`
--

REPLACE INTO `dr_member_data` (`id`, `is_admin`, `is_lock`, `is_auth`, `is_verify`, `is_mobile`, `is_avatar`, `is_complete`) VALUES
(1, 1, 0, 1, 1, 1, 1, 1),
(2, 0, 0, 0, 1, 0, 0, 0),
(3, 0, 0, 0, 1, 0, 0, 0),
(4, 0, 0, 0, 1, 0, 1, 0),
(5, 0, 0, 0, 1, 0, 1, 0);

-- --------------------------------------------------------

--
-- 表的结构 `dr_module`
--

DROP TABLE IF EXISTS `dr_module`;
CREATE TABLE IF NOT EXISTS `dr_module` (
  `id` smallint(5) unsigned NOT NULL,
  `site` text COMMENT '站点划分',
  `dirname` varchar(50) NOT NULL COMMENT '目录名称',
  `share` tinyint(1) unsigned DEFAULT NULL COMMENT '是否共享模块',
  `setting` text COMMENT '配置信息',
  `comment` text COMMENT '评论信息',
  `disabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT '禁用？',
  `displayorder` smallint(5) DEFAULT '0'
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='模块表';

--
-- 转存表中的数据 `dr_module`
--

REPLACE INTO `dr_module` (`id`, `site`, `dirname`, `share`, `setting`, `comment`, `disabled`, `displayorder`) VALUES
(4, '{"1":{"title":"\\u65b0\\u95fb","urlrule":"3","module_title":"","module_keywords":"","module_description":"","use":1}}', 'news', 1, '{"order":"displayorder DESC,updatetime DESC","list_field":{"title":{"use":"1","order":"1","name":"\\u4e3b\\u9898","width":"0","func":"title"},"catid":{"use":"1","order":"2","name":"\\u680f\\u76ee","width":"120","func":"catid"},"author":{"use":"1","order":"3","name":"\\u4f5c\\u8005","width":"100","func":"author"},"updatetime":{"use":"1","order":"4","name":"\\u66f4\\u65b0\\u65f6\\u95f4","width":"150","func":"datetime"}},"comment_list_field":{"content":{"use":"1","order":"1","name":"\\u8bc4\\u8bba","width":"0","func":"comment"},"author":{"use":"1","order":"3","name":"\\u4f5c\\u8005","width":"100","func":"author"},"inputtime":{"use":"1","order":"4","name":"\\u8bc4\\u8bba\\u65f6\\u95f4","width":"150","func":"datetime"}},"flag":{"1":{"name":"\\u63a8\\u8350\\u6211111","icon":""}},"search":{"use":"1","field":"title,keywords","total":"500","length":"4","param_join":"-","param_field":"title|t\\r\\nkeyword|k"},"module_index_html":null}', 'a:7:{s:3:"use";s:1:"1";s:3:"num";s:1:"0";s:2:"my";s:1:"0";s:3:"buy";s:1:"0";s:5:"reply";s:1:"0";s:8:"pagesize";s:0:"";s:6:"review";a:4:{s:5:"score";s:2:"10";s:5:"point";s:1:"0";s:5:"value";a:5:{i:1;a:1:{s:4:"name";s:10:"1星评价";}i:2;a:1:{s:4:"name";s:10:"2星评价";}i:3;a:1:{s:4:"name";s:10:"3星评价";}i:4;a:1:{s:4:"name";s:10:"4星评价";}i:5;a:1:{s:4:"name";s:10:"5星评价";}}s:6:"option";a:9:{i:1;a:1:{s:4:"name";s:7:"选项1";}i:2;a:1:{s:4:"name";s:7:"选项2";}i:3;a:1:{s:4:"name";s:7:"选项3";}i:4;a:1:{s:4:"name";s:7:"选项4";}i:5;a:1:{s:4:"name";s:7:"选项5";}i:6;a:1:{s:4:"name";s:7:"选项6";}i:7;a:1:{s:4:"name";s:7:"选项7";}i:8;a:1:{s:4:"name";s:7:"选项8";}i:9;a:1:{s:4:"name";s:7:"选项9";}}}}', 0, 0);

-- --------------------------------------------------------

--
-- 表的结构 `dr_module_form`
--

DROP TABLE IF EXISTS `dr_module_form`;
CREATE TABLE IF NOT EXISTS `dr_module_form` (
  `id` smallint(5) unsigned NOT NULL,
  `name` varchar(50) NOT NULL COMMENT '表单名称',
  `table` varchar(50) NOT NULL COMMENT '表单表名称',
  `module` varchar(50) NOT NULL COMMENT '模块目录',
  `disabled` tinyint(1) unsigned NOT NULL COMMENT '是否禁用',
  `setting` text NOT NULL COMMENT '表单配置'
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='模块表单表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_site`
--

DROP TABLE IF EXISTS `dr_site`;
CREATE TABLE IF NOT EXISTS `dr_site` (
  `id` smallint(5) unsigned NOT NULL,
  `name` varchar(50) NOT NULL COMMENT '站点名称',
  `domain` varchar(50) NOT NULL COMMENT '站点域名',
  `setting` text NOT NULL COMMENT '站点配置',
  `disabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT '禁用？'
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='站点表';

--
-- 转存表中的数据 `dr_site`
--

REPLACE INTO `dr_site` (`id`, `name`, `domain`, `setting`, `disabled`) VALUES
(1, 'PHP7CMS免费版', '{site_url}', '{"config":{"SITE_CLOSE":"0","SITE_CLOSE_MSG":"\\u7f51\\u7ad9\\u5347\\u7ea7\\u4e2d....","logo":"","SITE_NAME":"PHP7CMS\\u6f14\\u793a","SITE_ICP":"\\u5317\\u4eacICP\\u59079999999","SITE_TONGJI":"","SITE_LANGUAGE":"zh-cn","SITE_TIME_FORMAT":"Y-m-d H:i:s","SITE_THEME":"default","SITE_TEMPLATE":"default","SITE_TIMEZONE":"8","SITE_DOMAIN":"www.p7mf.com","SITE_DOMAINS":"","SITE_INDEX_HTML":0},"mobile":{"auto":"1","domain":""},"watermark":{"width":"","height":"","ueditor":"0","locate":"center-middle","type":"0","wm_font_path":"1.ttf","wm_text":"","wm_font_size":"","wm_font_color":"","wm_overlay_path":"default.png","wm_opacity":"48","quality":"67","wm_padding":"","wm_hor_offset":"","wm_vrt_offset":""},"weibo":{"share":"1","key":"1284529813","secret":"123123123123\\u5567\\u5567\\u5567","module":{"demo":{"image":"","content":""},"down":{"image":"","content":""},"image":{"image":"","content":""},"news":{"use":"1","open":"1","image":"thumb","content":"description"},"shop":{"image":"","content":""},"special":{"image":"","content":""}}},"navigator":["\\u9996\\u9875\\u5934\\u6761","\\u53cb\\u60c5\\u94fe\\u63a5","","","","","","","","","","","","","",""],"webpath":null,"seo":{"SITE_REWRITE":"5","SITE_SEOJOIN":"_","SITE_TITLE":"PHP7CMS\\u6f14\\u793a\\u7f51\\u7ad9","SITE_KEYWORDS":"","SITE_DESCRIPTION":""}}', 0);

-- --------------------------------------------------------

--
-- 表的结构 `dr_urlrule`
--

DROP TABLE IF EXISTS `dr_urlrule`;
CREATE TABLE IF NOT EXISTS `dr_urlrule` (
  `id` smallint(5) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL COMMENT '规则类型',
  `name` varchar(50) NOT NULL COMMENT '规则名称',
  `value` text NOT NULL COMMENT '详细规则'
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='URL规则表';

-- --------------------------------------------------------

--
-- 表的结构 `dr_var`
--

DROP TABLE IF EXISTS `dr_var`;
CREATE TABLE IF NOT EXISTS `dr_var` (
  `id` int(10) NOT NULL COMMENT 'Id',
  `name` varchar(100) NOT NULL COMMENT '变量描述名称',
  `cname` varchar(100) NOT NULL COMMENT '变量名称',
  `type` tinyint(2) NOT NULL COMMENT '变量类型',
  `value` text NOT NULL COMMENT '变量值'
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='自定义变量表';

--
-- Indexes for dumped tables
--

--
-- Indexes for table `dr_1_block`
--
ALTER TABLE `dr_1_block`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `dr_1_navigator`
--
ALTER TABLE `dr_1_navigator`
  ADD PRIMARY KEY (`id`),
  ADD KEY `list` (`id`,`type`,`show`,`displayorder`),
  ADD KEY `mark` (`mark`),
  ADD KEY `extend` (`extend`),
  ADD KEY `pid` (`pid`);

--
-- Indexes for table `dr_1_news`
--
ALTER TABLE `dr_1_news`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uid` (`uid`),
  ADD KEY `catid` (`catid`,`updatetime`),
  ADD KEY `link_id` (`link_id`),
  ADD KEY `comments` (`comments`),
  ADD KEY `avgsort` (`avgsort`),
  ADD KEY `support` (`support`),
  ADD KEY `oppose` (`oppose`),
  ADD KEY `donation` (`donation`),
  ADD KEY `favorites` (`favorites`),
  ADD KEY `status` (`status`),
  ADD KEY `updatetime` (`updatetime`),
  ADD KEY `hits` (`hits`),
  ADD KEY `displayorder` (`displayorder`,`updatetime`);

--
-- Indexes for table `dr_1_news_data_0`
--
ALTER TABLE `dr_1_news_data_0`
  ADD UNIQUE KEY `id` (`id`),
  ADD KEY `uid` (`uid`),
  ADD KEY `catid` (`catid`);

--
-- Indexes for table `dr_1_news_donation`
--
ALTER TABLE `dr_1_news_donation`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cid` (`cid`),
  ADD KEY `uid` (`uid`),
  ADD KEY `inputtime` (`inputtime`);

--
-- Indexes for table `dr_1_news_draft`
--
ALTER TABLE `dr_1_news_draft`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uid` (`uid`),
  ADD KEY `cid` (`cid`),
  ADD KEY `catid` (`catid`),
  ADD KEY `inputtime` (`inputtime`);

--
-- Indexes for table `dr_1_news_favorite`
--
ALTER TABLE `dr_1_news_favorite`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uid` (`uid`),
  ADD KEY `cid` (`cid`);

--
-- Indexes for table `dr_1_news_flag`
--
ALTER TABLE `dr_1_news_flag`
  ADD KEY `flag` (`flag`,`id`,`uid`),
  ADD KEY `catid` (`catid`);

--
-- Indexes for table `dr_1_news_hits`
--
ALTER TABLE `dr_1_news_hits`
  ADD UNIQUE KEY `id` (`id`),
  ADD KEY `day_hits` (`day_hits`),
  ADD KEY `week_hits` (`week_hits`),
  ADD KEY `month_hits` (`month_hits`),
  ADD KEY `year_hits` (`year_hits`);

--
-- Indexes for table `dr_1_news_index`
--
ALTER TABLE `dr_1_news_index`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uid` (`uid`),
  ADD KEY `catid` (`catid`),
  ADD KEY `status` (`status`),
  ADD KEY `inputtime` (`inputtime`);

--
-- Indexes for table `dr_1_news_oppose`
--
ALTER TABLE `dr_1_news_oppose`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cid` (`cid`),
  ADD KEY `uid` (`uid`);

--
-- Indexes for table `dr_1_news_recycle`
--
ALTER TABLE `dr_1_news_recycle`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uid` (`uid`),
  ADD KEY `cid` (`cid`),
  ADD KEY `catid` (`catid`),
  ADD KEY `inputtime` (`inputtime`);

--
-- Indexes for table `dr_1_news_search`
--
ALTER TABLE `dr_1_news_search`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `id` (`id`),
  ADD KEY `catid` (`catid`),
  ADD KEY `keyword` (`keyword`),
  ADD KEY `inputtime` (`inputtime`);

--
-- Indexes for table `dr_1_news_search_index`
--
ALTER TABLE `dr_1_news_search_index`
  ADD KEY `id` (`id`),
  ADD KEY `cid` (`cid`),
  ADD KEY `inputtime` (`inputtime`);

--
-- Indexes for table `dr_1_news_support`
--
ALTER TABLE `dr_1_news_support`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cid` (`cid`),
  ADD KEY `uid` (`uid`);

--
-- Indexes for table `dr_1_news_time`
--
ALTER TABLE `dr_1_news_time`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uid` (`uid`),
  ADD KEY `catid` (`catid`),
  ADD KEY `posttime` (`posttime`),
  ADD KEY `inputtime` (`inputtime`);

--
-- Indexes for table `dr_1_news_verify`
--
ALTER TABLE `dr_1_news_verify`
  ADD UNIQUE KEY `id` (`id`),
  ADD KEY `uid` (`uid`),
  ADD KEY `catid` (`catid`),
  ADD KEY `status` (`status`),
  ADD KEY `inputtime` (`inputtime`),
  ADD KEY `backuid` (`backuid`);

--
-- Indexes for table `dr_1_page`
--
ALTER TABLE `dr_1_page`
  ADD PRIMARY KEY (`id`),
  ADD KEY `pid` (`pid`),
  ADD KEY `show` (`show`),
  ADD KEY `displayorder` (`displayorder`);

--
-- Indexes for table `dr_1_share_category`
--
ALTER TABLE `dr_1_share_category`
  ADD PRIMARY KEY (`id`),
  ADD KEY `mid` (`mid`),
  ADD KEY `tid` (`tid`),
  ADD KEY `show` (`show`),
  ADD KEY `dirname` (`dirname`),
  ADD KEY `module` (`pid`,`displayorder`,`id`);

--
-- Indexes for table `dr_1_share_index`
--
ALTER TABLE `dr_1_share_index`
  ADD PRIMARY KEY (`id`),
  ADD KEY `mid` (`mid`);

--
-- Indexes for table `dr_1_tag`
--
ALTER TABLE `dr_1_tag`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`),
  ADD KEY `letter` (`code`,`hits`);

--
-- Indexes for table `dr_admin`
--
ALTER TABLE `dr_admin`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uid` (`uid`);

--
-- Indexes for table `dr_admin_login`
--
ALTER TABLE `dr_admin_login`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uid` (`uid`),
  ADD KEY `loginip` (`loginip`),
  ADD KEY `logintime` (`logintime`);

--
-- Indexes for table `dr_admin_menu`
--
ALTER TABLE `dr_admin_menu`
  ADD PRIMARY KEY (`id`),
  ADD KEY `list` (`pid`),
  ADD KEY `displayorder` (`displayorder`),
  ADD KEY `mark` (`mark`),
  ADD KEY `hidden` (`hidden`),
  ADD KEY `uri` (`uri`);

--
-- Indexes for table `dr_admin_notice`
--
ALTER TABLE `dr_admin_notice`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uri` (`uri`),
  ADD KEY `site` (`site`),
  ADD KEY `status` (`status`),
  ADD KEY `uid` (`uid`),
  ADD KEY `op_uid` (`op_uid`),
  ADD KEY `to_uid` (`to_uid`),
  ADD KEY `to_rid` (`to_rid`),
  ADD KEY `updatetime` (`updatetime`),
  ADD KEY `inputtime` (`inputtime`);

--
-- Indexes for table `dr_admin_role`
--
ALTER TABLE `dr_admin_role`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `dr_admin_role_index`
--
ALTER TABLE `dr_admin_role_index`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uid` (`uid`),
  ADD KEY `roleid` (`roleid`);

--
-- Indexes for table `dr_admin_verify`
--
ALTER TABLE `dr_admin_verify`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `dr_api_auth`
--
ALTER TABLE `dr_api_auth`
  ADD PRIMARY KEY (`id`),
  ADD KEY `disabled` (`disabled`),
  ADD KEY `inputtime` (`inputtime`);

--
-- Indexes for table `dr_api_http`
--
ALTER TABLE `dr_api_http`
  ADD PRIMARY KEY (`id`),
  ADD KEY `disabled` (`disabled`),
  ADD KEY `inputtime` (`inputtime`);

--
-- Indexes for table `dr_application`
--
ALTER TABLE `dr_application`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `dirname` (`dirname`),
  ADD KEY `disabled` (`disabled`);

--
-- Indexes for table `dr_attachment`
--
ALTER TABLE `dr_attachment`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uid` (`uid`),
  ADD KEY `author` (`author`),
  ADD KEY `relatedtid` (`related`),
  ADD KEY `fileext` (`fileext`),
  ADD KEY `filemd5` (`filemd5`),
  ADD KEY `siteid` (`siteid`);

--
-- Indexes for table `dr_attachment_data`
--
ALTER TABLE `dr_attachment_data`
  ADD PRIMARY KEY (`id`),
  ADD KEY `inputtime` (`inputtime`),
  ADD KEY `fileext` (`fileext`),
  ADD KEY `remote` (`remote`),
  ADD KEY `author` (`author`),
  ADD KEY `uid` (`uid`);

--
-- Indexes for table `dr_attachment_remote`
--
ALTER TABLE `dr_attachment_remote`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `dr_attachment_unused`
--
ALTER TABLE `dr_attachment_unused`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uid` (`uid`),
  ADD KEY `inputtime` (`inputtime`),
  ADD KEY `fileext` (`fileext`),
  ADD KEY `remote` (`remote`),
  ADD KEY `author` (`author`);

--
-- Indexes for table `dr_cron`
--
ALTER TABLE `dr_cron`
  ADD PRIMARY KEY (`id`),
  ADD KEY `type` (`type`),
  ADD KEY `status` (`status`),
  ADD KEY `updatetime` (`updatetime`),
  ADD KEY `inputtime` (`inputtime`);

--
-- Indexes for table `dr_export`
--
ALTER TABLE `dr_export`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `dr_field`
--
ALTER TABLE `dr_field`
  ADD PRIMARY KEY (`id`),
  ADD KEY `list` (`relatedid`,`disabled`,`issystem`);

--
-- Indexes for table `dr_linkage`
--
ALTER TABLE `dr_linkage`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`),
  ADD KEY `module` (`id`);

--
-- Indexes for table `dr_linkage_data_1`
--
ALTER TABLE `dr_linkage_data_1`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cname` (`cname`),
  ADD KEY `hidden` (`hidden`),
  ADD KEY `list` (`site`,`displayorder`);

--
-- Indexes for table `dr_mail_smtp`
--
ALTER TABLE `dr_mail_smtp`
  ADD PRIMARY KEY (`id`),
  ADD KEY `displayorder` (`displayorder`);

--
-- Indexes for table `dr_member`
--
ALTER TABLE `dr_member`
  ADD PRIMARY KEY (`id`),
  ADD KEY `username` (`username`),
  ADD KEY `email` (`email`),
  ADD KEY `phone` (`phone`);

--
-- Indexes for table `dr_member_data`
--
ALTER TABLE `dr_member_data`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `dr_module`
--
ALTER TABLE `dr_module`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `dirname` (`dirname`),
  ADD KEY `disabled` (`disabled`),
  ADD KEY `displayorder` (`displayorder`);

--
-- Indexes for table `dr_module_form`
--
ALTER TABLE `dr_module_form`
  ADD PRIMARY KEY (`id`),
  ADD KEY `table` (`table`),
  ADD KEY `disabled` (`disabled`);

--
-- Indexes for table `dr_site`
--
ALTER TABLE `dr_site`
  ADD PRIMARY KEY (`id`),
  ADD KEY `disabled` (`disabled`);

--
-- Indexes for table `dr_urlrule`
--
ALTER TABLE `dr_urlrule`
  ADD PRIMARY KEY (`id`),
  ADD KEY `type` (`type`);

--
-- Indexes for table `dr_var`
--
ALTER TABLE `dr_var`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `dr_1_block`
--
ALTER TABLE `dr_1_block`
  MODIFY `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=4;
--
-- AUTO_INCREMENT for table `dr_1_navigator`
--
ALTER TABLE `dr_1_navigator`
  MODIFY `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=12;
--
-- AUTO_INCREMENT for table `dr_1_news`
--
ALTER TABLE `dr_1_news`
  MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=661;
--
-- AUTO_INCREMENT for table `dr_1_news_donation`
--
ALTER TABLE `dr_1_news_donation`
  MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=32;
--
-- AUTO_INCREMENT for table `dr_1_news_draft`
--
ALTER TABLE `dr_1_news_draft`
  MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `dr_1_news_favorite`
--
ALTER TABLE `dr_1_news_favorite`
  MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',AUTO_INCREMENT=10;
--
-- AUTO_INCREMENT for table `dr_1_news_index`
--
ALTER TABLE `dr_1_news_index`
  MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=661;
--
-- AUTO_INCREMENT for table `dr_1_news_oppose`
--
ALTER TABLE `dr_1_news_oppose`
  MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=11;
--
-- AUTO_INCREMENT for table `dr_1_news_recycle`
--
ALTER TABLE `dr_1_news_recycle`
  MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=6;
--
-- AUTO_INCREMENT for table `dr_1_news_support`
--
ALTER TABLE `dr_1_news_support`
  MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=18;
--
-- AUTO_INCREMENT for table `dr_1_news_time`
--
ALTER TABLE `dr_1_news_time`
  MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT for table `dr_1_page`
--
ALTER TABLE `dr_1_page`
  MODIFY `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=8;
--
-- AUTO_INCREMENT for table `dr_1_share_category`
--
ALTER TABLE `dr_1_share_category`
  MODIFY `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=11;
--
-- AUTO_INCREMENT for table `dr_1_share_index`
--
ALTER TABLE `dr_1_share_index`
  MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=661;
--
-- AUTO_INCREMENT for table `dr_1_tag`
--
ALTER TABLE `dr_1_tag`
  MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=11;
--
-- AUTO_INCREMENT for table `dr_admin`
--
ALTER TABLE `dr_admin`
  MODIFY `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT for table `dr_admin_login`
--
ALTER TABLE `dr_admin_login`
  MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=68;
--
-- AUTO_INCREMENT for table `dr_admin_menu`
--
ALTER TABLE `dr_admin_menu`
  MODIFY `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=49;
--
-- AUTO_INCREMENT for table `dr_admin_notice`
--
ALTER TABLE `dr_admin_notice`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id',AUTO_INCREMENT=30;
--
-- AUTO_INCREMENT for table `dr_admin_role`
--
ALTER TABLE `dr_admin_role`
  MODIFY `id` smallint(5) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=4;
--
-- AUTO_INCREMENT for table `dr_admin_role_index`
--
ALTER TABLE `dr_admin_role_index`
  MODIFY `id` smallint(5) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=5;
--
-- AUTO_INCREMENT for table `dr_admin_verify`
--
ALTER TABLE `dr_admin_verify`
  MODIFY `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT for table `dr_api_auth`
--
ALTER TABLE `dr_api_auth`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Id',AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT for table `dr_api_http`
--
ALTER TABLE `dr_api_http`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Id',AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT for table `dr_application`
--
ALTER TABLE `dr_application`
  MODIFY `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT for table `dr_attachment`
--
ALTER TABLE `dr_attachment`
  MODIFY `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=16;
--
-- AUTO_INCREMENT for table `dr_attachment_remote`
--
ALTER TABLE `dr_attachment_remote`
  MODIFY `id` tinyint(2) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT for table `dr_cron`
--
ALTER TABLE `dr_cron`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=79;
--
-- AUTO_INCREMENT for table `dr_export`
--
ALTER TABLE `dr_export`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Id';
--
-- AUTO_INCREMENT for table `dr_field`
--
ALTER TABLE `dr_field`
  MODIFY `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=94;
--
-- AUTO_INCREMENT for table `dr_linkage`
--
ALTER TABLE `dr_linkage`
  MODIFY `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=4;
--
-- AUTO_INCREMENT for table `dr_linkage_data_1`
--
ALTER TABLE `dr_linkage_data_1`
  MODIFY `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=3251;
--
-- AUTO_INCREMENT for table `dr_mail_smtp`
--
ALTER TABLE `dr_mail_smtp`
  MODIFY `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT for table `dr_member`
--
ALTER TABLE `dr_member`
  MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=9;
--
-- AUTO_INCREMENT for table `dr_member_data`
--
ALTER TABLE `dr_member_data`
  MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=9;
--
-- AUTO_INCREMENT for table `dr_module`
--
ALTER TABLE `dr_module`
  MODIFY `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=7;
--
-- AUTO_INCREMENT for table `dr_module_form`
--
ALTER TABLE `dr_module_form`
  MODIFY `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT for table `dr_site`
--
ALTER TABLE `dr_site`
  MODIFY `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT for table `dr_urlrule`
--
ALTER TABLE `dr_urlrule`
  MODIFY `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=6;
--
-- AUTO_INCREMENT for table `dr_var`
--
ALTER TABLE `dr_var`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Id',AUTO_INCREMENT=2;