<?php namespace Phpcmf\Field;

class Score extends \Phpcmf\Library\A_Field  {

	/**
	 * 字段相关属性参数
	 */
	public function option($option, $field = null) {
        return ['', ''];
	}

    /**
     * 创建sql语句
     */
    public function create_sql($name, $value, $cname) {
        $sql = 'ALTER TABLE `{tablename}` ADD `'.$name.'` INT(10) NULL , ADD `'.$name.'_sku` TEXT NULL';
        return $sql;
    }

    /**
     * 修改sql语句
     */
    public function alter_sql($name, $value, $cname) {
        return NULL;
    }

    /**
     * 删除sql语句
     */
    public function drop_sql($name) {
        $sql = 'ALTER TABLE `{tablename}` DROP `'.$name.'`, DROP `'.$name.'_sku`';
        return $sql;
    }

    /**
     * 字段入库值
     */
    public function insert_value($field) {

        if ((int)$_POST['is_field_'.$field['fieldname']]) {
            // 用户组
            $sku = $_POST['data'][$field['fieldname'].'_sku'];
            $price = min($sku);
            \Phpcmf\Service::L('Field')->data[$field['ismain']][$field['fieldname']] = (int)$price;
            \Phpcmf\Service::L('Field')->data[$field['ismain']][$field['fieldname'].'_sku'] = dr_array2string($sku);
        } else {
            // 单一
            \Phpcmf\Service::L('Field')->data[$field['ismain']][$field['fieldname']] = (int)$_POST[$field['fieldname']];
            \Phpcmf\Service::L('Field')->data[$field['ismain']][$field['fieldname'].'_sku'] = '';
        }

    }

    /**
     * 字段值
     */
    public function get_value($name, $data) {

    }

    /**
     * 字段输出
     *
     * @param	array	$value	值
     * @return  string
     */
    public function output($value) {
        return (int)$value;
    }

    /**
     * 字段表单输入
     *
     * @return  string
     */
    public function input($field, $value = []) {

        // 字段显示名称
        $text = ($field['setting']['validate']['required'] ? '<span class="required" aria-required="true"> * </span>' : '').$field['name'];

        // 字段提示信息
        $tips = $field['setting']['validate']['tips'] ? '<span class="help-block" id="dr_'.$field['fieldname'].'_tips">'.$field['setting']['validate']['tips'].'</span>' : '';

        // 模式
        $sku = dr_string2array(\Phpcmf\Service::L('Field')->value['score_sku']);
        $is_field = $sku? 1 : 0;
        $html = '';
        foreach (\Phpcmf\Service::C()->member_cache['group'] as $g) {
            $html.= '<label><div class="input-group">
<span class="input-group-addon">'.$g['name'].'</span>
<input type="text" class="form-control" name="data['.$field['fieldname'].'_sku]['.$g['id'].']" value="'.(string)$sku[$g['id']].'" /> 
</div></label>';
        }

        $str = '
            <div class="mt-radio-inline">
                <label class="mt-radio">
                    <input type="radio" onclick="$(\'#dr_field_'.$field['fieldname'].'\').show();$(\'#dr_field_'.$field['fieldname'].'2\').hide();" name="is_field_'.$field['fieldname'].'" value="0" '.(!$is_field ? 'checked' : '').'> 全局
                    <span></span>
                </label>
                <label class="mt-radio">
                    <input type="radio" onclick="$(\'#dr_field_'.$field['fieldname'].'2\').show();$(\'#dr_field_'.$field['fieldname'].'\').hide();" name="is_field_'.$field['fieldname'].'" value="1" '.($is_field ? 'checked' : '').'> 用户组
                    <span></span>
                </label>
            </div>
            <div id="dr_field_'.$field['fieldname'].'" style="display:'.(!$is_field ? 'block' : 'none').';">
                <label><input class="form-control " type="text" name="data['.$field['fieldname'].']" id="dr_'.$field['fieldname'].'" value="'.$value.'" /></label>
            </div>
            <div id="dr_field_'.$field['fieldname'].'2" style="display:'.($is_field ? 'block' : 'none').';">
                <div style="width: 50%">
                '.$html.'
                </div>
            </div>
            ';
        return $this->input_format($field['fieldname'], $text, $str.$tips);

	}

    /**
     * 字段表单显示
     */
    public function show($field, $value = null) {

        // 字段显示名称
        $text = ($field['setting']['validate']['required'] ? '<span class="required" aria-required="true"> * </span>' : '').$field['name'];

        // 字段提示信息
        $tips = $field['setting']['validate']['tips'] ? '<span class="help-block" id="dr_'.$field['fieldname'].'_tips">'.$field['setting']['validate']['tips'].'</span>' : '';

        // 模式
        $sku = dr_string2array(\Phpcmf\Service::L('Field')->value['score_sku']);
        $is_field = $sku? 1 : 0;
        $html = '';
        foreach (\Phpcmf\Service::C()->member_cache['group'] as $g) {
            $html.= '<label><div class="input-group">
<span class="input-group-addon">'.$g['name'].'</span>
<input type="text" class="form-control"  readonly name="data['.$field['fieldname'].'_sku]['.$g['id'].']" value="'.(string)$sku[$g['id']].'" /> 
</div></label>';
        }

        $str = '
            <div id="dr_field_'.$field['fieldname'].'" style="display:'.(!$is_field ? 'block' : 'none').';">
                <label><input class="form-control " readonly type="text" name="data['.$field['fieldname'].']" id="dr_'.$field['fieldname'].'" value="'.$value.'" /></label>
            </div>
            <div id="dr_field_'.$field['fieldname'].'2" style="display:'.($is_field ? 'block' : 'none').';">
                <div style="width: 50%">
                '.$html.'
                </div>
            </div>
            ';
        return $this->input_format($field['fieldname'], $text, $str.$tips);

    }

}