<?php namespace Phpcmf\Model;

// 菜单控制模型

class Menu extends \Phpcmf\Model {

    protected $ids;

    // 新增后台菜单
    public function _add($table, $pid, $data, $mark = '') {

        if (!$data['name'] && !$data['uri']) {
            return;
        }

        !$mark && ($mark = $data['mark'] ? $data['mark'] : '');

        if ($table == 'admin') {
            $this->db->table('admin_menu')->replace([
                'pid' => $pid,
                'name' => $data['name'],
                'uri' => $data['uri'] ? $data['uri'] : '',
                'url' => $data['url'] ? $data['url'] : '',
                'mark' => $mark,
                'icon' => $data['icon'] ? $data['icon'] : '',
                'hidden' => (int)$data['hidden'],
                'displayorder' => (int)$data['displayorder'],
            ]);
        } else {
            $this->db->table('member_menu')->replace([
                'pid' => $pid,
                'name' => $data['name'],
                'uri' => $data['uri'] ? $data['uri'] : '',
                'url' => $data['url'] ? $data['url'] : '',
                'mark' => $mark,
                'icon' => $data['icon'] ? $data['icon'] : '',
                'group' => '',
                'hidden' => (int)$data['hidden'],
                'displayorder' => (int)$data['displayorder'],
            ]);
        }

        return $this->db->insertID();
    }

    // 修改菜单
    public function _edit($table, $id, $data) {


        if ($table == 'admin') {
            $this->db->table('admin_menu')->where('id', (int)$id)->update($data);
        } else {

        }

        return $id;
    }

    // 从模块中更新菜单
    public function update_module($mdir, $config, $form) {

        // 内容模块 入库后台菜单
        if ($config['system'] == 1) {
            $left = $this->db->table('admin_menu')->where('mark', 'content-module')->get()->getRowArray();
            if ($left) {
                // 查询模块菜单
                $menu = $this->db->table('admin_menu')->where('mark', 'module-'.$mdir)->get()->getRowArray();
                $save = [
                    'uri' => $mdir.'/home/index',
                    'mark' => 'module-'.$mdir,
                    'name' => $menu && $menu['name'] ? $menu['name'] : dr_lang('%s管理', $config['name']),
                    'icon' => $menu && $menu['icon'] ? $menu['icon'] : dr_icon($config['icon']),
                    'displayorder' => $menu ? intval($menu['displayorder']) : '-1',
                ];
                $menu ? $this->_edit('admin', $menu['id'], $save) : $this->_add('admin', $left['id'], $save);
            }
            // 入库后台审核菜单
        }

        // 内容模块入库用户菜单


    }


    // 从网站表单中更新菜单
    public function form($data) {

        // 后台管理菜单
        $menu = $this->db->table('admin_menu')->where('mark', 'form-'.$data['table'])->get()->getRowArray();
        if ($menu) {
            // 更新
            $this->db->table('admin_menu')->where('id', intval($menu['id']))->update([
                'name' => dr_lang('%s管理', $data['name']),
                'icon' => (string)$data['setting']['icon'],
            ]);
        } else {
            // 新增菜单
            $menu = $this->db->table('admin_menu')->where('mark', 'content-form')->get()->getRowArray();
            if ($menu) {
                $this->_add('admin', $menu['id'], [
                    'name' => dr_lang('%s管理', $data['name']),
                    'icon' => (string)$data['setting']['icon'],
                    'uri' => 'form/'.$data['table'].'/index',
                ], 'form-'.$data['table']);
            }
        }
        // 后台审核菜单
        $menu = $this->db->table('admin_menu')->where('mark', 'verify-form-'.$data['table'])->get()->getRowArray();
        if ($menu) {
            // 更新
            $this->db->table('admin_menu')->where('id', intval($menu['id']))->update([
                'name' => dr_lang('%s审核', $data['name']),
                'icon' => $data['setting']['icon'],
            ]);
        } else {
            // 新增菜单
            $menu = $this->db->table('admin_menu')->where('mark', 'content-verify')->get()->getRowArray();
            if ($menu) {
                $this->_add('admin', $menu['id'], [
                    'name' => dr_lang('%s审核', $data['name']),
                    'icon' => (string)$data['setting']['icon'],
                    'uri' => 'form/'.$data['table'].'_verify/index',
                ], 'verify-form-'.$data['table']);
            }
        }
        // 用户菜单

    }

    // 后台菜单合并
    private function _admin_add_menu($menu, $new) {

        foreach ($new as $mk1 => $top) {
            // 合并顶级菜单
            if ($mk1 && isset($menu[$mk1])) {
                // 它存在分组菜单时才合并
                if ($top['left']) {
                    foreach ($top['left'] as $mk2 => $left) {
                        if ($mk2 && isset($menu[$mk1]['left'][$mk2])) {
                            foreach ($left['link'] as $link) {
                                $menu[$mk1]['left'][$mk2]['link'][] = $link;
                            }
                        } else {
                            $menu[$mk1]['left'][] = $left;
                        }
                    }
                }
            } else {
                $menu[$mk1] = $top;
            }
        }

        return $menu;
    }

    // 用户菜单合并
    private function _member_add_menu($menu, $new) {

        foreach ($new as $mk1 => $top) {
            // 合并顶级菜单
            if ($mk1 && isset($menu[$mk1])) {
                // 它存在下级菜单时才合并
                if ($top['link']) {
                    foreach ($top['link'] as $left) {
                        $menu[$mk1]['link'][] = $left;
                    }
                }
            } else {
                $menu[$mk1] = $top;
            }
        }

        return $menu;
    }

    // 更具mark获取id
    private function _get_id_for_mark($table, $mark) {

        if (!$mark) {
            return 0;
        }

        $data = $this->db->table($table.'_menu')->where('mark', $mark)->get()->getRowArray();

        return (int)$data['id'];
    }

    // 安装app时的操作
    public function add_app($dir) {

        if (!is_file(APPSPATH.ucfirst($dir).'/Config/Menu.php')) {
            return;
        }

        $menu = require APPSPATH.ucfirst($dir).'/Config/Menu.php';
        if (!$menu) {
            return;
        }

        if ($menu['admin']) {
            // 后台菜单
            foreach ($menu['admin'] as $mark => $top) {
                // 插入顶级菜单
                $mark = strlen($mark) > 2 ? $mark : '';
                $top_id = $top['name'] ? $this->_add('admin', 0, $top, $mark) : $this->_get_id_for_mark('admin', $mark);
                // 插入分组菜单
                if ($top_id && $top['left']) {
                    foreach ($top['left'] as $mark2 => $left) {
                        $mark2 = strlen($mark2) > 2 ? $mark2 : '';
                        $left_id = $left['name'] ? $this->_add('admin', $top_id, $left, $mark2) : $this->_get_id_for_mark('admin', $mark2);
                        // 插入链接菜单
                        if ($left_id) {
                            foreach ($left['link'] as $link) {
                                if ($this->counts('admin_menu', 'pid='.$left_id.' and `uri`="'.$link['uri'].'"')) {
                                    continue;
                                }
                                $this->_add('admin', $left_id, $link);
                            }
                        }
                    }
                }
            }
        }


    }


    // 初始化菜单
    public function init($table = '') {

        // 程序自定义菜单
        if (is_file(MYPATH.'Config/Menu.php')) {
            $menu = require MYPATH.'Config/Menu.php';
        } else {
            // 框架主菜单
            $menu = require CMSPATH.'Config/Menu.php';
        }

        // 子程序菜单
        $local = dr_dir_map(APPSPATH, 1);
        foreach ($local as $dir) {
            if (is_file(APPSPATH.$dir.'/Config/Menu.php')) {
                if (is_file(APPSPATH.$dir.'/Config/App.php')) {
                    $cfg = require APPSPATH.$dir.'/Config/App.php';
                    if ($cfg['type'] == 'app' && !is_file(APPSPATH.$dir.'/install.lock')) {
                        // 表示应用插件
                        continue;
                    } elseif ($cfg['type'] == 'module' && !$this->counts('module', '`dirname`="'.strtlowper($dir).'"')) {
                        // 表示模块
                        continue;
                    }
                    $_menu = require APPSPATH.$dir.'/Config/Menu.php';
                    if ($_menu) {
                        $_menu['admin'] && $menu['admin'] = $this->_admin_add_menu($menu['admin'], $_menu['admin']);
                        $_menu['member'] && $menu['member'] = $this->_member_add_menu($menu['member'], $_menu['member']);
                    }
                }
            }
        }

        if ($table == 'admin' || !$table) {
            // 清空表
            $this->db->table('admin_menu')->truncate();
            $this->db->table('admin_menu')->where('1')->delete();
            foreach ($menu['admin'] as $mark => $top) {
                // 插入顶级菜单
                $mark = strlen($mark) > 2 ? $mark : '';
                $top_id = $this->_add('admin', 0, $top, $mark);
                // 插入分组菜单
                if ($top_id) {
                    foreach ($top['left'] as $mark2 => $left) {
                        $mark2 = strlen($mark2) > 2 ? $mark2 : '';
                        $left_id = $this->_add('admin', $top_id, $left, $mark2);
                        // 插入链接菜单
                        if ($left_id) {
                            foreach ($left['link'] as $link) {
                                $this->_add('admin', $left_id, $link);
                            }
                        }
                    }
                }
            }
        } else {
            // 清空表
            $this->db->table('member_menu')->truncate();
            foreach ($menu['member'] as $mark => $top) {
                // 插入顶级菜单
                $mark = strlen($mark) > 2 ? $mark : '';
                $top_id = $this->_add('member', 0, $top, $mark);
                // 插入链接菜单
                if ($top_id) {
                    foreach ($top['link'] as $mark2 => $link) {
                        $this->_add('member', $top_id, $link);
                    }
                }
            }
        }

        \Phpcmf\Service::M('Form')->cache(); // 更新表单菜单

    }

    // 获取单个
    public function getRowData($table, $id) {

        return $this->db->table($table.'_menu')->where('id', $id)->get()->getRowArray();
    }

    // 获取菜单
    public function gets($table) {

        $menu = [];
        $data = $this->db->table($table.'_menu')->orderBy('displayorder ASC,id ASC')->get()->getResultArray();

        if ($data) {

            $top = $left = [];
            // 第一级
            foreach ($data as $i => $t) {
                $t['pid'] == 0 && $top[] = $t['id'];
            }
            // 第二级
            foreach ($data as $i => $t) {
                in_array($t['pid'], $top) && $left[$t['id']] = $t['pid'];
            }
            // 第三级
            foreach ($data as $i => $t) {
                if (isset($left[$t['pid']])) {
                    $data[$i]['mark'] = $t['uri'] ? $t['uri'] : $t['url'];
                    $data[$i]['tid'] = $left[$t['pid']];
                }
            }

            $menu = \Phpcmf\Service::L('tree')->get($data);
        }

        return $menu;
    }

    // 获取顶级菜单
    public function get_top($table) {

        $menu = [];
        $data = $this->db->table($table.'_menu')->where('pid', 0)->orderBy('displayorder ASC,id ASC')->get()->getResultArray();

        if ($data) {
            foreach ($data as $t) {
                $menu[$t['id']] = $t;
            }
        }

        return $menu;
    }

    // 操作菜单
    public function _uesd($table, $id) {

        return $this->table($table.'_menu')->used($id, 'hidden');
    }

    public function _save($table, $id, $name, $value) {

        return $this->table($table.'_menu')->save($id, $name, $value);
    }

    public function _update($table, $id, $data) {

        return $this->table($table.'_menu')->update($id, $data);
    }

    public function _delete($table, $ids) {

        if ($ids) {
            $this->ids = array();
            foreach ($ids as $id) {
                $this->_get_id($table, (int)$id);
            }
            $this->ids && $this->db->table($table.'_menu')->whereIn('id', $this->ids)->delete();
        }
    }

    // 获取自己id和子id
    private function _get_id($table, $id) {

        if (!$id) {
            return NULL;
        }

        $this->ids[$id] = $id;

        $data = $this->db->table($table.'_menu')->where('pid', $id)->get()->getResultArray();
        if (!$data) {
            return NULL;
        }

        foreach ($data as $t) {
            $this->ids[$t['id']] = $t['id'];
            $this->_get_id($table, (int)$t['id']);
        }
    }

    /**
     * 父级菜单选择
     *
     * @param	intval	$level	级别
     * @param	intval	$id		选中项id
     * @param	intval	$name	select部分
     * @return	string
     */
    public function parent_select($table, $level, $id = NULL, $name = NULL) {

        $select = $name ? $name : '<select class="form-control" name="data[pid]">';

        switch ($level) {
            case 1: // 顶级菜单
                $select.= '<option value="0">'.dr_lang('顶级菜单').'</option>';
                break;
            case 2: // 分组菜单
                $topdata = $this->db->table($table.'_menu')->select('id,name')->where('pid=0')->get()->getResultArray();
                foreach ($topdata as $t) {
                    $select.= '<option value="'.$t['id'].'"'.($id == $t['id'] ? ' selected' : '').'>'.$t['name'].'</option>';
                }
                break;
            case 3: // 链接菜单
                $topdata = $this->db->table($table.'_menu')->select('id,name')->where('pid=0')->get()->getResultArray();
                foreach ($topdata as $t) {
                    $select.= '<optgroup label="'.$t['name'].'">';
                    $linkdata = $this->db->table($table.'_menu')->select('id,name')->where('pid='.$t['id'])->get()->getResultArray();
                    foreach ($linkdata as $c) {
                        $select.= '<option value="'.$c['id'].'"'.($id == $c['id'] ? ' selected' : '').'>'.$c['name'].'</option>';
                    }
                    $select.= '</optgroup>';
                }
                break;
        }

        $select.= '</select>';

        return $select;
    }

    // 缓存
    public function cache() {


        $menu = [
            'admin' => [],
            'member' => [],
            'admin-uri' => [],
        ];
        \Phpcmf\Service::L('cache')->set_file('menu-admin', $menu['admin']);
        \Phpcmf\Service::L('cache')->set_file('menu-admin-uri', $menu['admin-uri']);


        // admin 菜单
        $data = $this->db->table('admin_menu')->where('hidden', 0)->orderBy('displayorder ASC,id ASC')->get()->getResultArray();
        if ($data) {
            $list = [];
            foreach ($data as $t) {
                if ($t['pid'] == 0) {
                    $list[$t['id']] = $t;
                    foreach ($data as $m) {
                        if ($m['pid'] == $t['id']) {
                            $list[$t['id']]['left'][$m['id']] = $m;
                            foreach ($data as $n) {
                                if ($n['pid'] == $m['id']) {
                                    $n['tid'] = $t['id'];
                                    $n['uri'] = str_replace('admin/', '', $n['uri']);
                                    $n['pid'] == $m['id'] && $list[$t['id']]['left'][$m['id']]['link'][$n['id']] = $n;
                                    $menu['admin-uri'][$n['uri']] = $n;
                                }
                            }
                        }
                    }
                }
            }
            $menu['admin'] = $list;
        }


        \Phpcmf\Service::L('cache')->set_file('menu-admin', $menu['admin']);
        \Phpcmf\Service::L('cache')->set_file('menu-admin-uri', $menu['admin-uri']);

        return $menu;
    }

}