<?php namespace Phpcmf\Model;

// 系统模型 - 后台
class System extends \Phpcmf\Model
{
    public $config = [

        'SYS_DEBUG'	=> '调试器开关',
        'SYS_EMAIL' => '系统收件邮箱，用于接收系统信息',
        'SYS_ADMIN_CODE' => '后台登录验证码开关',
        'SYS_ADMIN_LOG' => '后台操作日志开关',
        'SYS_AUTO_FORM' => '自动存储表单数据',
        'SYS_ADMIN_PAGESIZE' => '后台数据分页显示数量',

        'SYS_CAT_RNAME' => '栏目目录允许重复',
        'SYS_PAGE_RNAME' => '自定义页面目录允许重复',

        'SYS_KEY' => '安全密匙',
        'SYS_HTTPS'	=> 'https模式',

        'SYS_ATTACHMENT_DB'	    => '附件归属开启模式',
        'SYS_ATTACHMENT_PATH'	=> '附件上传路径',
        'SYS_ATTACHMENT_URL'	=> '附件访问地址',

    ];
    
    
    /**
	 * 保存配置文件
	 */
    public function save_config($system, $data) {

        foreach ($this->config as $name => $s) {
            isset($data[$name]) && $system[$name] = $data[$name];
        }

        \Phpcmf\Service::L('config')->file(WRITEPATH.'config/system.php', '系统配置文件', 32)->to_require_one(
            $this->config,
            $system
        );
    }

}