<?php
/**
 * TOP API: alipay.micropay.order.get request
 * 
 * @author auto create
 * @since 1.0, 2013-08-13 16:48:38
 */
class AlipayMicropayOrderGetRequest
{
	/** 
	 * 支付宝订单号，冻结流水号(创建冻结订单返回)
	 **/
	private $alipayOrderNo;
	
	/** 
	 * 支付宝用户给应用的授权.
	 **/
	private $authToken;
	
	private $apiParas = array();
	
	public function setAlipayOrderNo($alipayOrderNo)
	{
		$this->alipayOrderNo = $alipayOrderNo;
		$this->apiParas["alipay_order_no"] = $alipayOrderNo;
	}

	public function getAlipayOrderNo()
	{
		return $this->alipayOrderNo;
	}

	public function setAuthToken($authToken)
	{
		$this->authToken = $authToken;
		$this->apiParas["auth_token"] = $authToken;
	}

	public function getAuthToken()
	{
		return $this->authToken;
	}

	public function getApiMethodName()
	{
		return "alipay.micropay.order.get";
	}
	
	public function getApiParas()
	{
		return $this->apiParas;
	}
	
	public function check()
	{
		
		RequestCheckUtil::checkNotNull($this->alipayOrderNo,"alipayOrderNo");
	}
	
	public function putOtherTextParam($key, $value) {
		$this->apiParas[$key] = $value;
		$this->$key = $value;
	}
}
