<?php
/**
 * 使用了magic function的类，动态抽取数据; 自动化的代价是性能的损耗。
 *
 * @author Nutshell
 */
abstract class MagicDataOperator
{
    // 关联数组，格式是fieldName => fieldValue;
    // 设置$data后，请使用array_change_key_case方法。
    protected $_data = array();
    public function __construct ()
    {
        die('The class is only for extending.');
    }
    // array_change_key_case and strtolower
    public function __call ($method, $args)
    {
        if (preg_match("/get(.*)/", $method, $found)) {

            $fieldName = strtolower($found[1]);
            if (array_key_exists($fieldName, $this->_data)) {
                return $this->_data[$fieldName];
            }

        } else if (preg_match("/set(.*)/", $method, $found)) {

            $fieldName = strtolower($found[1]);
            if (array_key_exists($fieldName, $this->_data)) {
                $this->_data[$fieldName] = $args[0];
                return true;
            }
        }
        return false;
    }

    public function getData()
    {
        return $this->_data;
    }
}