<?php
class NutFunction
{
    // ---------------------------------------------------------------------------------------
    // 提取数组中带有同一前缀的数组对象。
    // ---------------------------------------------------------------------------------------
    public static function extractArrayByKeyPrefix ($array, $prefix = '', $erasePrefix = true)
    {
        if ($prefix == '') {
            return $array;
        }

        $returnArray = array();
        $prefix_len = strlen($prefix);
        foreach ($array as $key => $value) {
            if (stripos($key, $prefix) === 0) {
                $k = $key;
                if ($erasePrefix) {
                    $k = substr($key, $prefix_len);
                }
                $returnArray[$k] = $value;
            }
        }
        return $returnArray;
    }
    // ---------------------------------------------------------------------------------------
    // 用于Form表单的数值对比
    // ---------------------------------------------------------------------------------------
    public static function optionCompare ($value, $valueC)
    {
        if ($value == $valueC) {
            return ' selected = "selected"';
        }
    }
    // ---------------------------------------------------------------------------------------
    public static function checkboxCompare ($value, $valueC,
    $compareSection = 'value')
    {
        if ($compareSection == 'key' && is_array($valueC)) {
            $valueC = array_keys($valueC);
        }

        if (is_array($valueC)) {
            if (in_array($value, $valueC))
                return ' checked="checked"';
        } else {
            return NutFunction::radioCompare($value, $valueC);
        }
    }
    // ---------------------------------------------------------------------------------------
    public static function radioCompare ($value, $valueC)
    {
        if ($value == $valueC) {
            return ' checked="checked"';
        }
    }
    // ---------------------------------------------------------------------------------------
    // 获取文件后缀
    // ---------------------------------------------------------------------------------------
    public static function getExt ($filename)
    {
        return strtolower( end(explode('.', $filename)) );
    }

    public static function getCurrentPageFileName()
    {
        return end( explode('/', $_SERVER['PHP_SELF']) );
    }
}