<?php
require_once 'iPager.php';

class Pager implements iPager
{
	protected $curPage;
	protected $prePage;
	protected $nextPage;
	protected $totalPage;
	protected $totalRow;
	protected $curPageUrl;
	protected $prePageUrl;
	protected $nextPageUrl;
	protected $span = 9;
	protected $size = 10;
	protected $conn;
	protected $sql;
	protected $rs;

	protected $nakePageUrl = '';
	protected $pagerArg = 'p';

	public function __construct(&$conn, $sql, $size=10, $pagerArg = 'p', $span=5)
	{
		$this->setConn($conn);
		$this->setSql($sql);
		$this->pagerArg = $pagerArg;
		if ( !is_numeric($size) ) {
			$this->size = 10;
		} else {
			$this->size = $size;
		}

		$this->setTotalPage();

		$this->curPage = $_GET[$pagerArg];
		if ( $this->curPage < 1 || empty($this->curPage) ) {
			$this->curPage = 1;
		}

		if ($this->curPage > $this->totalPage) {
			$this->curPage = $this->totalPage;
		}

		if ( !is_numeric($span) ) {
			$this->span = 9;
		} else {
			$this->span = $span;
		}

		$this->page();
	}

	public function setConn(&$conn)
	{
		$this->conn = $conn;
	}

	public function setSql($sql)
	{
		$this->sql = $sql;
	}

	public function page()
	{
		$offset = $this->size * ($this->getCurPage() - 1);
		$this->sql .= " Limit $offset, {$this->size}";
		$this->rs = $this->conn->get_results($this->sql, ARRAY_A);
	}

	public function getResults()
	{
		return $this->rs;
	}

	public function getNavigation()
	{
		return $this->getPrePageButton(). $this->getDigitalButton(). $this->getNextPageButton();
	}

	public function getPrePageButton()
	{
		$prePageBtn = '';
		if ($this->curPage > 1) {
			$prePageBtn = "<span class='previous page_number'><a href='{$this->getPrePageUrl()}'>&laquo; Prev</a></span>";
		}
		return $prePageBtn;
	}

	public function getNextPageButton()
	{
		$nextPageBtn = '';
		if ($this->curPage < $this->totalPage) {
			$nextPageBtn = "<span class='next page_number'><a href='{$this->getNextPageUrl()}'>Next &raquo;</a></span>";
		}
		return $nextPageBtn;
	}

	public function getDigitalButton($form=1)
	{
		$digitalBtn = '';
		if ($this->totalPage > 1) {
			$url = $this->getNakePageUrl();
			for ($i=1; $i<=$this->totalPage; $i++) {
				if ($this->curPage == $i) {
					$digitalBtn .= "<span class='page_number page_current'>$i</span>";
				} else {
					$digitalBtn .= "<span class='page_number'><a href='{$url}$i'>$i</a></span>";
				}
			}
		}
		return $digitalBtn;
	}

	protected function getNakePageUrl()
	{
		if ( !empty($this->nakePageUrl) ) {
			return $this->nakePageUrl;
		}

		$this->nakePageUrl = getNakeUrl($this->pagerArg);
		return $this->nakePageUrl;
	}

	public function getCurPage()
	{
		return $this->curPage;
	}

	public function getPrePage()
	{
		$this->prePage = $this->curPage - 1;
		if ($this->prePage < 1) {
			$this->prePage = 1;
		}
		return $this->prePage;
	}

	public function getNextPage()
	{
		$this->nextPage = $this->curPage + 1;

		if ($this->nextPage > $this->totalPage) {
			$this->nextPage = $this->totalPage;
		}
		return $this->nextPage;
	}

	public function getTotalPage()
	{
		return $this->totalPage;
	}

	public function getSize()
	{
		return $this->size;
	}

	public function getSpan()
	{
		return $this->span;
	}

	public function getCurPageUrl()
	{
		if ( !empty($this->curPageUrl) ) {
			return $this->curPageUrl;
		}

		$this->curPageUrl =  $this->getNakePageUrl(). $this->getCurPage();
		return $this->curPageUrl;
	}

	public function getPrePageUrl()
	{
		if ($this->curPage > 1) {
			$this->prePageUrl =  $this->getNakePageUrl(). $this->getPrePage();
			return $this->prePageUrl;
		}
	}

	public function getNextPageUrl()
	{
		if ($this->curPage < $this->totalPage) {
			$this->nextPageUrl =  $this->getNakePageUrl(). $this->getNextPage();
			return $this->nextPageUrl;
		}
	}

	public function setSize($size = 10)
	{
		$this->size = $size;
	}

	public function setSpan($span = 9)
	{
		$this->span = $span;
	}

	public function getTotalRow()
	{
	    return $this->totalRow;
	}

	private function setTotalPage()
	{
		// 计算记录总数和总页数
		//$sqlC = preg_replace('/\w\,\*\(\)]+/', 'Count(*)', $this->sql);
		$rs = $this->conn->get_results($this->sql, ARRAY_N);
		$this->totalRow = count($rs);
		if ($this->totalRow == 0) {
			$this->totalPage = 1;
			return;
		}
		$this->totalPage = intval( $this->totalRow / $this->size );
		if ( $this->totalRow % $this->size ) {
			$this->totalPage += 1;
		}
	}
}