<?php
require_once ('MagicDataOperator.php');
/**
 * 数据库操作使用全局变量$nsodb;
 * 因为继承了MagicDataOperator类，所以具备了动态获取变量的能力；
 * 具体能获取哪些字段内容，主要取决于构造器里面的SQL语句获取的字段；
 * 例如:
 * $post = new Post(1);
 * echo $post->title;
 * echo $post->field;
 *
 * @author Nutshell
 */
class Posts extends MagicDataOperator
{
    private $_quickdb;
    public  $id;

    public function __construct ($id)
    {
        global $nsodb;

        $this->id = $id;

        $this->_quickdb = new QuickDatabaseOperator($nsodb);
        $sql = 'SELECT * FROM posts WHERE id = ' . $id;
        $this->_data = $nsodb->get_row($sql, ARRAY_A);

        if (empty($this->_data)) {
            return false;
        }

        array_change_key_case($this->_data);
    }

    /**
     * 获取关联的分类数据。
     * 返回所属分类。
     *
     * @return array Array(ID => categoryName, ...);
     */
    public function getCategories()
    {
        global $nsodb;

        if ($this->_data['categories']) {
            return $this->_data['categories'];
        }

        $sql = 'SELECT categories.id as id, categories.name as name
        		FROM rel_post_cat, categories
        		WHERE rel_post_cat.cat_id = categories.id
        		AND post_id = ' . $this->id;
        $rs = $nsodb->get_results($sql);
        if($rs) {
            foreach($rs as $row){
                $this->_data['categories'][$row->id] = $row->name;
            }
        }

        return $this->_data['categories'];
    }

    /**
     * 获取关联的文件数据，$fileFlag为空则是全部。
     * Array(
     *     'image' => array(
     *         array('id'=> '', 'title' =>, ...),
     *         ...
     *     ),
     *     'pdf' => array(
     *         array('id'=> '', 'title' =>, ...),
     *         ...
     *     ),
     * )
     * @param string||array $fileFlag
     * @return array
     */
    public function getRelFiles($fileFlag='')
    {
        global $nsodb;

        $sql = 'SELECT files.id as id, path, flag, od as `order`, title, `key`, `value`
        		FROM rel_post_file, files
        		WHERE rel_post_file.file_id = files.id
        		AND post_id = ' . $this->id . '
        		ORDER BY od';
        $rs = $nsodb->get_results($sql);
        $files = array();
        if ($rs) {
            foreach($rs as $row) {
                $files[$row->flag][] = array(
                    'id'    => $row->id,
                    'title' => $row->title,
                    'path'  => $row->path,
                    'flag'  => $row->flag,
                    'key'   => $row->key,
                    'value' => $row->value,
                );
            }
        }

        $this->_data['files'] = $files;

        if ($fileFlag) {
            return $this->_data['files'][$fileFlag];
        } else {
            return $this->_data['files'];
        }
    }

    /**
     * 获取相关的其他数据。
     * Array('key' => 'value', ...)
     */
    public function getMetadata()
    {
        global $nsodb;

        if ($this->_data['meta']) {
            return $this->_data['meta'];
        }

        $sql = 'SELECT id, meta_key, meta_value FROM post_meta
        		WHERE post_id = ' . $this->id;
        $rs = $nsodb->get_results($sql);
        if ($rs) {
            foreach ($rs as $row) {
                $this->_data['meta'][$row->meta_key] = $row->meta_value;
            }
        }

        return $this->_data['meta'];
    }

    /**
     *
     *
     * @param array $data
     */
    public static function add ($data)
    {
        global $nsoqdb;

        // 插入文章数据
        $postData = $data['post'];
        if (empty($postData['date']))
            $postData['date'] = date('Y-m-d H:i:s');
        if (empty($postData['date_update']))
            $postData['date_update'] = date('Y-m-d H:i:s');
        if (empty($postData['status']))
            $postData['status'] = 'published';
        $postId = $nsoqdb->insert('posts', $postData);

        // 插入文章meta数据
        $metaData = $data['meta'];
        if (! empty($metaData)) {
            foreach ($metaData as $key => $value) {
                $meta = array('post_id' => $postId, 'meta_key' => $key, 'meta_value' => $value);
                $nsoqdb->insert('post_meta', $meta);
            }
        }

        // 插入 "文章-分类" 的关联数据
        $relCategoryData = $data['rel_category']['cat_id'];
        if ($relCategoryData) {
            foreach ($relCategoryData as $catId) {
                $relCatData = array('post_id' => $postId, 'cat_id' => $catId);
                $nsoqdb->insert('rel_post_cat', $relCatData);
            }
        }

        // 插入关联文件数据
        $relFilesData = $data['rel_file'];
        if ($relFilesData) {
            foreach ($relFilesData as $index => $relFileData) {
                // 插入文件数据
                $path = $relFileData['path'];
				$size = $relFileData['size'];
                $fileData = array('path' => $path, 'date' => date('Y-m-d H:i:s'), 'size' => $size);
                $fileId = $nsoqdb->insert('files', $fileData);

                // 插入 "文章-文件" 的关联数据
                unset($relFileData['id']);
                $relFileData['post_id'] = $postId;
                $relFileData['file_id'] = $fileId;
                $nsoqdb->insert('rel_post_file', $relFileData);
            }
        }

        return $postId;
    }
    /**
     *
     *
     * @param int   $id
     * @param array $data
     */
    public static function update ($id, $data)
    {
        global $nsodb;
        global $nsoqdb;

        if (! is_numeric($id)) {
            return false;
        }

        // 更新文章数据
        $postData = $data['post'];
        if (empty($postData['date_update']))
            $postData['date_update'] = date('Y-m-d H:i:s');
        $nsoqdb->update('posts', $postData, 'id = ' . $id);

        // 插入文章meta数据
        $metaData = $data['meta'];
        if (! empty($metaData)) {
            foreach ($metaData as $key => $value) {
                $meta = array('meta_value' => $value);
                $nsoqdb->update('post_meta', $meta, "`meta_key` = '{$key}' AND `post_id` = {$id}");
            }
        }

        // 更新分类关联
        $relCategoryData = $data['rel_category']['cat_id'];
        $originalRelCatIds = array();
        $sql = 'SELECT cat_id FROM rel_post_cat WHERE post_id = ' . $id;
        $rs = $nsodb->get_results($sql);
        if ($rs) {
            foreach ($rs as $row) {
                $originalRelCatIds[] = $row->cat_id;
            }
        }

        $newCatIds = array_diff($relCategoryData, $originalRelCatIds);
        $deleteCatIds = array_diff($originalRelCatIds, $relCategoryData);
        // 删除未保留分类
        if ($deleteCatIds) {
            $sql = 'DELETE FROM rel_post_cat
            		WHERE cat_id IN (' . implode(',', $deleteCatIds) . ')
            		AND post_id = ' . $id;
            $nsodb->query($sql);
        }
        // 新增分类
        if ($newCatIds) {
            foreach ($newCatIds as $catId) {
                $array = array('post_id' => $id, 'cat_id' => $catId);
                $nsoqdb->insert('rel_post_cat', $array);
            }
        }


        // 更新文件关联
        $relFileData = $data['rel_file'];
        if ($relFileData) {
            // 原有的 文章-文件 关联的ID
            $originalRelPostFileIds = array();
            $sql = 'SELECT id, file_id FROM rel_post_file WHERE post_id = ' . $id;
            $rs = $nsodb->get_results($sql);
            if ($rs) {
                foreach ($rs as $row) {
                    $originalRelPostFileIds[] = $row->file_id;
                }
            }
            $remainRelPostFileIds = array();
            foreach ($relFileData as $index => $arrayData) {
                /**
                 * 如果文件的ID是0，则搜索数据库，判断同目录同名文件是否存在。
                 * 因为ID为0一般认为是新上传的文件，不过因为AJAX的原因，程序并没有编写JS更新文件的ID，
                 * 所以判断是否新文件需要判断同路径文件是否存在。
                 *
                 * 如果存在，则使用存在的文件ID
                 */
                $path = $arrayData['path'];
				$size = $relFileData['size'];
                if ($arrayData['id'] == 0) {
                    $sql = "SELECT id FROM files WHERE path = '{$path}'";
                    $row = $nsodb->get_row($sql);
                    if ($row) {
                        $arrayData['id'] = $row->id;
                    }
                }

                if ($arrayData['id'] == 0) { // 新增加的附件数据
                    // 插入文件数据
                    $fileData = array('path' => $path, 'date' => date('Y-m-d H:i:s'), 'size' => $size);
                    $fileId = $nsoqdb->insert('files', $fileData);
                    // 插入 "文章-文件" 的关联数据
                    unset($arrayData['id']);
                    $arrayData['post_id'] = $id;
                    $arrayData['file_id'] = $fileId;
                    $nsoqdb->insert('rel_post_file', $arrayData);
                } else {
                    $remainRelPostFileIds[$index] = $arrayData['id'];
                    $fileId = $arrayData['id'];
                    unset($arrayData['id']);
                    $sql = "SELECT id FROM rel_post_file WHERE file_id = {$fileId} AND post_id = {$id}";
                    $row = $nsodb->get_row($sql);
                    if ($row) {
                        $arrayData['path'] = $path;
                        $nsoqdb->update('rel_post_file', $arrayData, 'id = ' . $row->id);
                    }
                }
            }
            // 删除没有保留的 "文章-文件" 关联数据
            $delRelPostFileIds = array_diff($originalRelPostFileIds, $remainRelPostFileIds);
            if ($delRelPostFileIds) {
                $sql = 'DELETE FROM rel_post_file
                		WHERE post_id = ' . $id . '
                		AND file_id IN (' . implode(',', $delRelPostFileIds) . ')';
                $nsodb->query($sql);
            }
        } else { // 没有关联文件就删除全部
            $sql = 'DELETE FROM rel_post_file WHERE post_id = ' . $id;
            $nsodb->query($sql);
        }
    }
}
