<?php
interface iPager
{
    public function getCurPage ();
    public function getPrePage ();
    public function getNextPage ();
    public function getTotalPage ();
    public function getSize ();
    public function getSpan ();
    public function getCurPageUrl ();
    public function getPrePageUrl ();
    public function getNextPageUrl ();
    public function setSize ();
    public function setSpan ();
}
function getNakeUrl ($besideArg = 'p')
{
    $php_self = $_SERVER['PHP_SELF'];
    $query_string = trim($_SERVER['QUERY_STRING']);

    if (empty($query_string)) {
        $returnUrl = $php_self . "?$besideArg=";
    } else {
        $search = $besideArg . '=';
        $strpos = stripos($query_string, $search);

        if ($strpos === 0) {
            $pattern = '/' . $search . '[0-9]*(&|)/';
        } else {
            $pattern = '/&' . $search . '[0-9]*/';
        }

        $query_string = preg_replace($pattern, '', $query_string);
        $returnUrl = "{$php_self}?{$query_string}&$besideArg=";
    }

    return $returnUrl;
}