<?php
session_start();

require_once '../nsoconfig.php';
require_once NSO_INC_PATH . 'NutFunction.php';
require_once NSO_INC_PATH . 'Posts.php';
require_once 'inc/functions.php';
require_once 'inc/QuickDatabaseOperator.php';

$nsoqdb = new QuickDatabaseOperator($nsodb); // NSO Quick DB -> nsoqdb;

$nsoHeaderJavascript = array();
$nsoHeaderCss = array();

// 使用CKEditor空间必须加载的脚本文件
$nsoCkeditorJavascripts = array(
	'ckeditor/ckeditor.js',
	'ckeditor/adapters/jquery.js'
);

// 使用SWFUpload控件必须加载的脚本文件
$nsoSwfuploadScripts = array(
	'swfupload/swfupload.js',
	'swfupload/scripts/swfupload.queue.js', 'swfupload/scripts/fileprogress.js',
	'swfupload/scripts/handlers.js'
);

// NSO后台允许上传的文件格式
$nsoUploadFileAllowType = array('jpg', 'png', 'gif', 'pdf', 'rar', 'avi', 'wmv', 'doc');

// NSO后台上传的文件可选分类（关联类型）
$nsoSwfuploadFileRelTypeOptionArray = array(
	'post'   => array('null' => '未分类', 'image' => '图片', 'pdf' => 'PDF', 'vedio' => '视频', 'rar' => '压缩包'),
    'product' => array('image' => '展示图', 'paper' => '彩页', 'book' => '使用手册', 'driver' => '驱动'),
);

// NSO后台表单标签翻译
$nsoFormLabels = array(
	'title' => array('default' => '标题', 8 => '项目名称', $nsoDownloadCatId => '名称'),
	'subtitle' => array('default' => '小标题', 8 => '客户名称', $nsoDownloadCatId => '说明'),
);

// SWFUpload上传的图片需要自动生成的图片尺寸
$nsoImageSizeNeedToCreate = array(600, 400, 200, 100, 50);
rsort($nsoImageSizeNeedToCreate, SORT_NUMERIC);

// 检查是否已经登陆
$nsoScriptFileName = end(explode('/', $_SERVER['PHP_SELF']));
$filename = end(explode('/', $_SERVER['SCRIPT_NAME']));
if ( empty($_SESSION['user']) && ($nsoScriptFileName != 'login.php') && $filename != 'swfuploadUploadFile.php' ) {
    header('Location: login.php');
    exit;
}

// 默认使用的文章编辑的页面文件名
// 有些文章有可能我们需要定义文章编辑表单
$nsoPostFormFileName = 'post_form.php';