<?php
require_once '../nsoconfig.php';
function outputCurrentPage ($pageName){
    if (isCurrentPage($pageName)) {
        echo 'class="current"';
    }
}

$subCategoriesForNews = getCategoriesByParent($nsoNewsCatId);
$subCategoriesForSolutions = getCategoriesByParent($nsoResolutionCatId);
$subCategoriesForProducts = getCategoriesByParent($nsoProductCatId);
$subCategoriesForDownloads = getCategoriesByParent($nsoDownloadCatId);
$subCategoriesForKnowledge = getCategoriesByParent($nsoKnowledgeCatId);

$aboutPosts = getPostsByCategory($nsoAboutCatId);
?>
<div id="menuPane">
    <div id="quickPane"></div>
    <ul>
    	 <li><a href="posts.php?cat=1" <?php outputCurrentPage('posts.php?id=1')?>>固定文章</a></li>
    </ul>
    <div class="split_line"></div>
    <ul>
    	 <li><a href="qa.php" <?php outputCurrentPage('qa.php')?>>专家答疑</a></li>
    </ul>
    <div class="split_line"></div>
    <ul>
        <li><a href="posts.php?cat=<?php echo $nsoNewsCatId?>" <?php outputCurrentPage('posts.php?cat=' . $nsoNewsCatId)?>>新闻动态</a></li>
    </ul>
    <ul class="submenu">
    <?php if ($subCategoriesForNews): foreach ($subCategoriesForNews as $c): ?>
        <li><a href="posts.php?cat=<?php echo $c['id']?>" <?php outputCurrentPage('posts.php?cat=' . $c['id'])?>><?php echo $c['name']?></a></li>
    <?php endforeach; endif;?>
    </ul>
    <div class="split_line"></div>
    <ul>
        <li><a href="posts.php?cat=<?php echo $nsoResolutionCatId?>" <?php outputCurrentPage('posts.php?cat=' . $nsoResolutionCatId)?>>解决方案</a></li>
    </ul>
    <ul class="submenu">
    <?php if ($subCategoriesForSolutions): foreach ($subCategoriesForSolutions as $c): ?>
        <li><a href="posts.php?cat=<?php echo $c['id']?>" <?php outputCurrentPage('posts.php?cat=' . $c['id'])?>><?php echo $c['name']?></a></li>
    <?php endforeach; endif;?>
    <?php $subCategories = getCategoriesByParent(10); if ($subCategories): foreach ($subCategories as $c): ?>
        <li><a href="posts.php?cat=<?php echo $c['id']?>" <?php outputCurrentPage('posts.php?cat=' . $c['id'])?>> &nbsp;- <?php echo $c['name']?></a></li>
    <?php endforeach; endif;?>
    	<li><a href="categories.php?cat=10" <?php outputCurrentPage('categories.php?cat=10')?>> &nbsp;- 分类设置</a></li>
    </ul>
    <div class="split_line"></div>
    <ul>
        <li><a href="products.php?cat=<?php echo $nsoProductCatId?>" <?php outputCurrentPage('products.php?cat=' . $nsoProductCatId)?>>产品</a></li>
    </ul>
    <ul class="submenu">
    <?php 
	if ($subCategoriesForProducts): foreach ($subCategoriesForProducts as $c): 
		$shortName = explode('（', $c['name']);
		$shortName = $shortName[0];
	?>
        <li><a href="products.php?cat=<?php echo $c['id']?>" <?php outputCurrentPage('products.php?cat=' . $c['id'])?>><?php echo $shortName?></a></li>
    <?php endforeach; endif;?>
    	<li><a href="categories.php?cat=<?php echo $nsoProductCatId?>" <?php outputCurrentPage('categories.php?cat='.$nsoProductCatId)?>>分类设置</a></li>
    </ul>
    <div class="split_line"></div>
    <ul>
        <li><a href="posts.php?cat=<?php echo $nsoDownloadCatId?>" <?php outputCurrentPage('posts.php?cat='.$nsoDownloadCatId)?>>下载中心</a></li>
    </ul>
    <ul class="submenu">
    <?php if ($subCategoriesForDownloads): foreach ($subCategoriesForDownloads as $c): ?>
        <li><a href="posts.php?cat=<?php echo $c['id']?>" <?php outputCurrentPage('posts.php?cat=' . $c['id'])?>><?php echo $c['name']?></a></li>
    <?php endforeach; endif;?>
    	<li><a href="categories.php?cat=<?php echo $nsoDownloadCatId?>" <?php outputCurrentPage('categories.php?cat='.$nsoDownloadCatId)?>>分类设置</a></li>
    </ul>
    <div class="split_line"></div>
    <ul>
        <li><a href="posts.php?cat=<?php echo $nsoKnowledgeCatId?>" <?php outputCurrentPage('posts.php?cat='.$nsoKnowledgeCatId)?>>知识中心</a></li>
    </ul>
    <ul class="submenu">
    <?php if ($subCategoriesForKnowledge): foreach ($subCategoriesForKnowledge as $c): ?>
        <li><a href="posts.php?cat=<?php echo $c['id']?>" <?php outputCurrentPage('posts.php?cat=' . $c['id'])?>><?php echo $c['name']?></a></li>
    <?php endforeach; endif;?>
    	<li><a href="categories.php?cat=<?php echo $nsoKnowledgeCatId?>" <?php outputCurrentPage('categories.php?cat='.$nsoKnowledgeCatId)?>>分类设置</a></li>
    </ul>
    <div class="split_line"></div>
    <ul>
        <li><a href="posts.php?cat=<?php echo $nsoAboutCatId?>" <?php outputCurrentPage('posts.php?cat=' . $nsoAboutCatId)?>>关于我们</a></li>
    </ul>
    <ul class="submenu">
        <?php if ($aboutPosts): foreach ($aboutPosts as $post):?>
        <li><a href="post_form.php?cat=<?php echo $post['cat_id']?>&id=<?php echo $post['post_id']?>" <?php outputCurrentPage('post_form.php?cat='.$post['cat_id'].'&id='.$post['post_id'])?>><?php echo $post['title']?></a>
        <?php endforeach; endif;?>
    </ul>
    <div class="split_line"></div>
    <div class="getfirefox"><a href="http://www.mozilla.org" target="_blank"><img src="images/firefox.png" /></a></div>
</div>