<?php
/**
 * 结合ezsql类使用，用于快速插入和更新数据库数据。
 * 数据使用关联数组形式（表字段 -> 对应数据），对应数据自动转义字符。
 * 提供数据中包含表中不存在的字段，则自动删除。
 *
 * @author Nutshell
 *
 */
class QuickDatabaseOperator
{
    private $conn;
    // $conn是ezSql对象
    public function __construct (&$conn)
    {
        $this->conn = $conn;
    }
    /**
     * 通过给出表名和相关的数据数组添加数据
     *
     * @param String $tableName
     * @param Array $data 数组的格式为array($fieldName => $fieldValue, [...] )
     */
    public function insert ($tableName, $data)
    {
        if (! is_array($data) || empty($data)) {
            return false;
        }
        $tableFieldNames = $this->getFieldNames($tableName);
        foreach ($data as $fieldName => $fieldValue) {
            // 如果提供字段不在表字段内，则不加入SQL语句内
            if (! in_array($fieldName, $tableFieldNames)) {
                unset($data[$fieldName]);
                continue;
            }
            // 自动添加转义
            if (! get_magic_quotes_gpc()) {
                $fieldValue = addslashes($fieldValue);
            }
            $fieldNameString .= "`{$fieldName}`, ";
            $fieldValueString .= "'{$fieldValue}', ";
        }
        $fieldNameString = rtrim($fieldNameString, ', ');
        $fieldValueString = rtrim($fieldValueString, ', ');
        $sql = "INSERT INTO $tableName($fieldNameString) VALUES($fieldValueString)";
        if ($this->conn->query($sql)) {
            return $this->conn->insert_id;
        }
        return false;
    }
    /**
     * 通过给出表名、字段标示和相关的数据数组更新数据
     *
     * @param String $tableName
     * @param Array $data 数组的格式为array($fieldName => $fieldValue, [...] )
     * @param String $where 条件语句
     */
    public function update ($tableName, $data, $where = '')
    {
        if (! is_array($data) || empty($data)) {
            return false;
        }
        $tableFieldNames = $this->getFieldNames($tableName);
        // 使用set_error_handler使基本错误抛出异常
        try {
            foreach ($data as $fieldName => $fieldValue) {
                // 如果提供字段不在表字段内，则不加入SQL语句内
                if (! in_array($fieldName, $tableFieldNames)) {
                    unset($data[$fieldName]);
                    continue;
                }
                // 自动添加转义
                if (! get_magic_quotes_gpc()) {
                    $fieldValue = addslashes($fieldValue);
                }
                $setString .= "`{$fieldName}` = '{$fieldValue}', ";
            }
            $setString = rtrim($setString, ', ');
            $sql = "UPDATE $tableName SET $setString";
            if ($where) {
                $sql .= " WHERE {$where}";
            }
            $this->conn->query($sql);
        } catch (Exception $e) {
            echo "File {$e->getFile()} Line {$e->getLine()} Error: {$e->getMessage()}<br />";
            echo $e->getTrace();
            return false;
        }
        return true;
    }
    /**
     * 获取对应表的所有字段名。
     *
     * @param string $tableName
     */
    protected function getFieldNames ($tableName)
    {
        $fieldNames = array();
        $sql = "SHOW COLUMNS FROM `{$tableName}`";
        $columns = $this->conn->get_results($sql);
        foreach ($columns as $column) {
            $fieldNames[] = $column->Field;
        }
        return $fieldNames;
    }
}