<?php
/**
 * Add javascript file's path string to $nsoHeaderJavascript,
 * then output at one time.
 *
 * @param array|string $path
 */
function addHeaderJavascript ($path)
{
    global $nsoHeaderJavascript;
    $args = func_get_args();
    if ($args) {
        foreach ($args as $arg) {
            if (is_array($arg)) {
                $nsoHeaderJavascript = array_merge($nsoHeaderJavascript, $arg);
                continue;
            }
            if (is_string($arg)) {
                $nsoHeaderJavascript[] = $arg;
                continue;
            }
        }
    }
}

/**
 * Output header javascript's path in string.
 */
function outputHeaderJavascript ()
{
    global $nsoHeaderJavascript;
    if ($nsoHeaderJavascript) {
        foreach ($nsoHeaderJavascript as $path) {
            echo '<script type="text/javascript" src="' . $path . '"></script>';
        }
    }
}

/**
 * Add css file's path string to $nsoHeaderCss,
 * then output at one time.
 *
 * @param array|string $path
 */
function addHeaderCss ($path)
{
    global $nsoHeaderCss;
    $args = func_get_args();
    if ($args) {
        foreach ($args as $arg) {
            if (is_array($arg)) {
                $nsoHeaderCss = array_merge($nsoHeaderCss, $arg);
                continue;
            }
            if (is_string($arg)) {
                $nsoHeaderCss[] = $arg;
                continue;
            }
        }
    }
}

/**
 * Output header css's path in string.
 */
function outputHeaderCss ()
{
    global $nsoHeaderCss;
    if ($nsoHeaderCss) {
        foreach ($nsoHeaderCss as $path) {
            echo '<link type="text/css" rel="stylesheet" href="' . $path . '" />';
        }
    }
}

/**
 * Output SWFUpload File Rel Type Option HTML.
 */
function outputSwfuploadFileTypeOptions ($key = 'post', $valueCompare = '')
{
    global $nsoSwfuploadFileRelTypeOptionArray;

    $array = $nsoSwfuploadFileRelTypeOptionArray[$key];
    $html = '';
    foreach ($array as $key => $value) {
        $selectAttr = NutFunction::optionCompare($key, $valueCompare);
        $html .= "<option value=\"{$key}\" {$selectAttr}>{$value}</option>";
    }
    echo $html;
}

/**
 * Output Post Rel Files HTML.
 */
function outputPostRelFilesHtml($relFiles, $relType = 'post')
{
    if ($relFiles) :
        foreach ($relFiles as $flag => $files) : foreach ($files as $file):
            $json = json_encode(array('id' => $file['id']));
            $title = $file['title'];
            $flag = $file['flag'];
            $path = $file['path'];
            $fullPath = '../' . NSO_UPLOAD_DIR_NAME . '/' . $path;
            ?>
            <div class="progressWrapper">
                <div class="progressContainer">
                    <div class="progressName"><?php echo $path?></div>
                    <span class="swfuploadDeleteFileButton">☺</span>
                </div>
                <div class="swfuploadFileMeta">
                    <input class="swfuploadFileTitle" name="swfupload-file_title[]" value="<?php echo $title?>" />
                    <select class="swfuploadFileType" name="swfupload-file_flag[]">
                        <?php outputSwfuploadFileTypeOptions($relType, $flag);?>
                    </select>
                    <input type="hidden" name="swfupload-file_json[]" value='<?php echo $json?>' />
                </div>
                <div class="swfuploadFilePreivew"><?php outputFilePreviewHtml($fullPath);?></div>
            </div>
            <?php
        endforeach; endforeach;
     endif;
}

/**
 * 一般结合 outputPostRelFilesHtml 方法使用
 */
function outputFilePreviewHtml ($filePath)
{
    $ext = NutFunction::getExt($filePath);
    switch ($ext) {
        case 'pdf':
            $image = 'images/pdf.jpg';
            break;
        default:
            $image = str_replace('_source', '_thumb', $filePath);
            break;
    }
    echo '<a href="' . $filePath . '" target="_blank"><img src="'.$image.'" /></a>';
}

/**
 * 主要是把上传文件的表单数据重新整理。
 */
function reconganizeFilesData ($originalData)
{
    $newData = array();
    if ($originalData['file_json']) {
        foreach ($originalData['file_json'] as $index => $jsonString) {
            // 拔掉Slashes
            if (get_magic_quotes_gpc()) {
                $jsonString = trim(stripslashes($jsonString));
            }
            $file = json_decode($jsonString);

            // 处理JSON中的Path字段数据
            // - 取消前面的相对路径 ../
            // - 替换_thumb为_source
            $path = str_replace( '../' . NSO_UPLOAD_DIR_NAME . '/', '', $file->path);
            $path = str_replace('_thumb', '_source', $path);
            $fileId = $file->id;
            $newData[] = array(
                'id'    => $file->id,
                'title' => $originalData['file_title'][$index],
                'flag'  => $originalData['file_flag'][$index],
                'od'    => $index,
                'key'   => '',
                'value' => '',
                'path'  => $path,
				'size'  => $file->size
            );
        }
    }
    return $newData;
}

function outputCategories ($array, $catIdsCompare = array(), $layout = 'checklist')
{
    if ($array) : foreach ($array as $cat) :
        extract($cat);
        $checked = NutFunction::checkboxCompare($id, $catIdsCompare);
        echo "<div><input id=\"cat-{$id}\" type=\"checkbox\" name=\"category-cat_id[]\" value=\"{$id}\" {$checked} /><label for=\"cat-{$id}\">{$name}</label></div>";
     endforeach; endif;
}

/**
 * 上传文件时，文件误传需要立即删除的，包括自动生成的其他文件
 */
function deleteUploadFile ($filePath, $fileType = '')
{
    global $nsoImageSizeNeedToCreate;

    if (is_file($filePath)) {
        unlink($filePath); // 删除原始图片
        if ($fileType == 'image') {

            $size = '';
            // 删除系统设定生成的所有尺寸图片
            foreach ($nsoImageSizeNeedToCreate as $size){
                $filePath = str_replace('_source', '_'.$size, $filePath);
                if (is_file($filePath)) unlink($filePath);
            }

            // 删除缩略图
            $filePath = str_replace('_'.$size, '_thumb', $filePath);
            if (is_file($filePath)) unlink($filePath);

            // 删除一般尺寸图片（默认600宽度）
            $filePath = str_replace('_thumb/', '', $filePath);
            if (is_file($filePath)) unlink($filePath);
        }
    }
}

function isCurrentPage ($pageName)
{
    $requireUri = end(explode('/', $_SERVER['REQUEST_URI']));
    $requireUri2 = str_replace('_form.php', 's.php', $requireUri);
    if ($requireUri == $pageName || $requireUri2 == $pageName) {
        return true;
    } else {
        return false;
    }
}

// 输出
function __t($key, $cat)
{
	global $nsoFormLabels;
	
	if (empty($cat)) {
		$cat = 'default';
	}
	
	$string = $nsoFormLabels[$key][$cat];
	if (empty($string)) {
		$string = $nsoFormLabels[$key]['default'];
	}
	
	echo $string;
}

