$(function(){
	var catId = $('#hiddenParamCatId').html();
	var fixedToolbar = $('.toolbar:first').clone().attr('id', 'fixedToolbar');
	$('.toolbar:first').after(fixedToolbar);
	$('.table_content tbody').sortable({axis: 'y', containment: 'parent'});
	
	$(window).scroll(function(){
		if ($(window).scrollTop() > 110) {
			$('#fixedToolbar').show();
		} else {
			$('#fixedToolbar').hide();
		}
	});
	
	$('input:checkbox').removeAttr('checked');
	
	$('.table_content tr').hover(function(){$(this).toggleClass('hover');});
	$('.table_content tr td.checkbox input').live('click', selectPost);
	$('.table_content tr:even').addClass('alt');
	$('.table_content tr td a.delete').live('click', deletePost);
	
	var postFormFileName = $('#hiddenParamPostFormFileName').html();
	$('.tool_button .add_button').click(function(){ window.location = postFormFileName+'?cat='+catId; });
	$('.tool_button .delete_button').click(deleteAll);
	$('.tool_button .checkall').click(function(){
		if ( $(this).is(':checked') ) {
			$('.table_content tr td.checkbox input:not(:checked)').click();
		} else {
			$('.table_content tr td.checkbox input:checked').click();
		}
		
	});
});

function selectPost() {
	$(this).parents('tr').toggleClass('selected');
}

// ------------------------------------------
// 删除文章
// ------------------------------------------
function deleteAll() {
	var checkedPosts = $('.table_content tr td.checkbox input:checked');
	var ids = [];
	var count = checkedPosts.size();
	if (count == 0) return false;
	
	var cf = confirm('确定删除所选资料？');
	if (cf == false) return false;
	
	$('.infobar .message_box').fadeIn();
	
	$.each(checkedPosts, function(index){
		ids.push($(this).val());
	});
	
	// send
	$.ajax({
		type: 'POST',
		url: 'post_edit_action.php', 
		data: {'action' : 'deleteAll', 'ids' : ids},
		dataType: 'json',
		success: function(data){
			if (data.success = true) 
				checkedPosts.parents('tr').fadeOut( function(){ $(this).remove(); } );
			$('.infobar .message_box').fadeOut();
		}
	});
}

function deletePost() {
	var cf = confirm('确定删除？');
	if (cf == false) return false;
	
	$('.infobar .message_box').fadeIn();
	var postId = $(this).parents('tr').attr('id');
	var urlAddress = $(this).attr('href');
	$.ajax({
		url: urlAddress,
		dataType: 'json',
		success: function(data) {
			if (data.success = true) 
				$('#'+postId).fadeOut( function(){ $(this).remove(); } );
			$('.infobar .message_box').fadeOut();
		}
	});
	return false;
}
//------------------------------------------
//------------------------------------------