$(function() {
	var fixedToolbar = $('.toolbar:first').clone().attr('id', 'fixedToolbar');
	$('.toolbar:first').after(fixedToolbar);
	var fixedInfobar = $('.infobar:first').clone().attr('id', 'fixedInfobar');
	$('.infobar:first').after(fixedInfobar);
	
	$(window).scroll(function(){
		if ($(window).scrollTop() > 110) {
			$('#fixedToolbar').show();
			$('#fixedInfobar').show();
		} else {
			$('#fixedToolbar').hide();
			$('#fixedInfobar').hide();
		}
	});
	
	// ------------------------------------------
	// 编辑器
	// ------------------------------------------
	if ($('textarea.editor')) {
		var config = {
	        skin: '126',
	        toolbar: 'nso',
	        language: 'zh-cn',
	        filebrowserBrowseUrl : 'ckfinder/ckfinder.html',
			filebrowserImageBrowseUrl : 'ckfinder/ckfinder.html?Type=Images',
			filebrowserFlashBrowseUrl : 'ckfinder/ckfinder.html?Type=Flash',
			filebrowserUploadUrl : 'ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files',
			filebrowserImageUploadUrl : 'ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Images',
			filebrowserFlashUploadUrl : 'ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Flash'
	    };
	    $('textarea.editor').ckeditor(config);
	}
    
    $('.toolbar .tool_button .save_button').click(save);
    
    // ------------------------------------------
	// Ajax表单提交
	// ------------------------------------------
    var options = { 
        beforeSubmit:  formSubmit,  // pre-submit callback 
        success:       saveFeeback  // post-submit callback 
    }; 
    $('#postForm').ajaxForm( options );
});


// ------------------------------------------
// 表单提交
// ------------------------------------------
function save() {
	$('#postForm').submit();
	return false;
}

function formSubmit(formData, jqForm, options) { 
	$('.toolbar .tool_button .save_button').unbind('click').addClass('button_disable');
	$('.infobar .message_box').fadeIn();
    return true; 
}

function saveFeeback(responseText, statusText, xhr, $form) {
	$('.toolbar .tool_button .save_button').click(save).removeClass('button_disable');
	
	var json = $.parseJSON(responseText);
	if (json.success) {
		$('.infobar .message_box').html('保存成功。');
	    setTimeout("fadeOutMessage()", 2000);
	    
	    if (json.id != "") {
	    	$('#form-post-id-input').val(json.id);
	    	$('#form-action-input').val('update');
	    }
	} else {
		$('.infobar .message_box').html('保存失败。');
	    setTimeout("fadeOutMessage()", 5000);
	}
    
}

function fadeOutMessage()
{
	$('.infobar .message_box').fadeOut('fast', function(){$(this).html('正在保存...')});
}