<?php
require_once '_admin_setting.php';
require_once NSO_INC_PATH . 'Pager.php';

$sql = "SELECT * FROM qa
		ORDER BY answer, date DESC";
$pager = new Pager($nsodb, $sql, 20);
$rsPost = $pager->getResults();
$totalRow = $pager->getTotalRow();

addHeaderJavascript('javascripts/post_list.js');
require_once '_top.php';
require_once '_header.php';
require_once '_menuPane.php';
?>
<div id="godContentContainer">
    <div class="content_part">
        <div class="title">
            <h2><?php echo $categoryName?>提问（共有<strong><?php echo $totalRow; ?></strong>条）</span></h2>
        </div>
        <div id="topToolbar" class="toolbar">
            <div class="pager_navigation"><?php echo $pager->getNavigation(); ?></div>
        </div>
        <div class="infobar">
            <div class="message_box">正在处理...</div>
        </div>
        <div class="content">
            <div class="table_content">
                <table>
                    <tbody>
                    <?php if ($rsPost) : foreach ($rsPost as $post) : $updateUrl = "qa_form.php?id={$post['id']}";?>
                    	<tr id="post-<?php echo $post['id']?>">
                            <td class="drag_icon"></td>
                            <td class="checkbox"><input type="checkbox" value="<?php echo $post['id']?>" /></td>
                            <td class="title"><a href="<?php echo $updateUrl?>"><?php echo $post['title']?></a></td>
                            <td class="date"><?php echo date('m月d日', strtotime($post['date']))?></td>
                            <td class="action">
                                <a href="<?php echo $updateUrl?>" class="edit">回答</a>
                                <a href="qa_edit_action.php?action=delete&id=<?php echo $post['id']?>" class="delete">删除</a>
                            </td>
                        </tr>
                     <?php endforeach; endif;?>
                     </tbody>
                </table>
            </div>
        </div>
        <div style="display: none">
            <div id="hiddenParamCatId"><?php echo $cat;?></div>
            <div id="hiddenParamPostFormFileName"><?php echo $nsoPostFormFileName?></div>
        </div>
    </div>
</div>
<?php include_once '_bottom.php';?>