<?php
// -------------------------------------------------------------
// Swfuploadw问题
// -------------------------------------------------------------
if (isset($_POST["PHPSESSID"])) {
    session_id($_POST["PHPSESSID"]);
}

require_once '_admin_setting.php';
require_once NSO_LIBS_PATH . 'phpthumb/ThumbLib.inc.php';


session_start();
// ini_set("html_errors", "0");

// -------------------------------------------------------------
// 处理传参
// -------------------------------------------------------------


// -------------------------------------------------------------
// 检测已上传临时文件
// -------------------------------------------------------------
// In this demo we trigger the uploadError event in SWFUpload by returning a status code other than 200 (which is the default returned by PHP)
if (! isset($_FILES["Filedata"]) || ! is_uploaded_file($_FILES["Filedata"]["tmp_name"]) || $_FILES["Filedata"]["error"] != 0) {
    // Usually we'll only get an invalid upload if our PHP.INI upload sizes are smaller than the size of the file we allowed to be uploaded.
    header("HTTP/1.1 500 File Upload Error");
    if (isset($_FILES["Filedata"])) {
        echo $_FILES["Filedata"]["error"];
    }
    exit(0);
}


// -------------------------------------------------------------
// 保存数据处理
// -------------------------------------------------------------
$today = getdate();

// 按年月日建立上传目录
// -------------------------------------------------------------
$yearPath = NSO_UPLOAD_PATH . $today['year'];
$monthPath = $yearPath . '/' . $today['mon'];

if (! is_dir($yearPath))  mkdir($yearPath);
if (! is_dir($monthPath)) mkdir($monthPath);
if (! is_dir("{$monthPath}/_source")) mkdir("{$monthPath}/_source");
if (! is_dir("{$monthPath}/_thumb"))  mkdir("{$monthPath}/_thumb");
if ($nsoImageSizeNeedToCreate){
    foreach ($nsoImageSizeNeedToCreate as $size){
        if (! is_dir("{$monthPath}/_{$size}")) mkdir("{$monthPath}/_{$size}");
    }
}

// 文件保存的相对路径，主要用于返回JSON
$relativePath = "../" . NSO_UPLOAD_DIR_NAME . "/{$today['year']}/{$today['mon']}/";

$randName = date('His') . '_' . rand(10, 99);
$ext = NutFunction::getExt($_FILES['Filedata']['name']);
$saveFileName = "{$randName}.{$ext}";

$savePathSource = $relativePath . '_source/' . $saveFileName;
$savePathNormal = $relativePath . $saveFileName;
$savePathThumb  = $relativePath . '_thumb/' . $saveFileName;

$fileSize = (int) ($_FILES["Filedata"]["size"] / 1024);
if (in_array($ext, $nsoUploadFileAllowType) && move_uploaded_file($_FILES['Filedata']['tmp_name'], $savePathSource)) {

    $type = 'pdf';

    // 上传的文件是规定的图片格式，则生成系统设定的缩略图
    if (in_array($ext, array('jpg', 'jpeg', 'png', 'gif'))) {

        $image = PhpThumbFactory::create($savePathSource);
        $image->resize(600)->save($savePathNormal);

        list ($width, $height, $type, $attr) = getimagesize($savePathNormal);
        $size = ($width > $height) ? $height : $width;
        $image->cropFromCenter($size)->resize(49)->save($savePathThumb);

        // 按照$nsoImageSizeNeedToCreate生成规定的图片尺寸
        $image = PhpThumbFactory::create($savePathSource);
        rsort($nsoImageSizeNeedToCreate, SORT_NUMERIC); // 逆向排序，从大到小生成图片
        if ($nsoImageSizeNeedToCreate){
            foreach ($nsoImageSizeNeedToCreate as $size){
                $savePath = $relativePath . '_' . $size . '/' . $saveFileName;
                $image->resize($size)->save($savePath);
            }
        }
        $type = 'image';
    }

    $data = array('success' => 1, 'id' => 0, 'type' => $type, 'path' => $savePathThumb, 'size' => $fileSize);
    echo json_encode($data);
    exit();

} else {

    $data = array('success' => 0);
    echo json_encode($data);
    exit();
}