<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Ad extends Admin_Controller {
	
	function __construct(){
		parent::__construct();
		define('MODELNAME', 'ad') ;		//模型名
		$this->load->_model('model_ad','ad' ,TRUE); //载入产品管理模型
	}
	
	public function index()
	{
        //取得信息分类
        $data['info_class'] = get_tclass(MODELNAME);
        $this->_template('ad',$data);
	}

    /**
     * 后台获取列表数据
     */

    public function rows()
    {
        //获取分页参数
        $page = $this->input->post('page',true);
        $rows = $this->input->post('rows',true);
        $sort = $this->input->post('sort',true);
        $order = $this->input->post('order',true);


        //获取查询数据
        $keywords = $this->input->post('keywords',true);
        $classid = $this->input->post('classid',true);
        $where = "1=1 ";
        if($keywords)
        {
            $where  .= " and title like '%$keywords%'";
        }
        if($classid)
        {
            $where  .= " and classid = '$classid'";
        }


        //数据排序
        if($sort&&$order)
        {
            $order_str = "$sort $order";
        }

        //分析分页参数
        $per_page = $rows;   //每页显示数量
        if(empty($page)){
            $start = 0;
        }else{
            $start = ($page - 1)*$per_page;
        }



        //取得信息列表
        $info_list = $this->ad->find_all($where,'',$order_str,$start,$per_page);

        //格式化数据
        foreach ($info_list as $key=>$value) {

            //格式化时间字符串
            $info_list[$key]['time'] = date('Y-m-d H:i:s',$value['addtime']);
            $info_list[$key]['updatetime'] = date('Y-m-d H:i:s',$value['updatetime']);

            //格式化娱乐图片
            $info_list[$key]['showpic'] = '<a href="'.$info_list[$key]['image_src'].'" target=_bank     >'.$info_list[$key]['title'] .'</a> ';
            //获取分类名称
            $class = get_class_row($value['classid']);
            if($class)$info_list[$key]['classname'] = $class['classname'];

        }

        //获得记录总数
        $total = $this->ad->find_count($where);

        $rows = array('total'=>$total,'rows'=>($info_list));


        echo json_encode($rows);
    }

    /**
     * 添加广告页面
     */
    public function addinfo(){

        //取得信息分类
        $data['info_class'] = get_tclass(MODELNAME);
        $this->_template('ad_add',$data);

    }
	
	public function edit(){

        $action =  $this->input->get('action',true);
        $id = $this->input->post('id',true);
        $title = $this->input->post('title',true);
        $classid = $this->input->post('classid',true);
        $order = (int)$this->input->post('order',true);
        $image_src = $this->input->post('image_src',true);
        $image_url = $this->input->post('image_url',true);
        $image_alt = $this->input->post('image_alt',true);
        $hits = (int)$this->input->post('hits',true);
        $status = (int)$this->input->post('status',true);
        $addtime =  $this->input->post('addtime',true);

        //格式化时间
        if($addtime)
        {
            $addtime=strtotime($addtime); //生成时间戳
        }
        else
        {
            $addtime = time();  //获取当前系统时间
        }


        if($action == 'more')
        {
            //完整修改
            $items = array(
                'title'=>$title,
                'classid'=>$classid,
                'image_src'=>$image_src,
                'image_url'=>$image_url,
                'image_alt'=>$image_alt,
                'hits'=>$hits,
                'order'=>$order,
                'addtime'=>$addtime,
                'updatetime'=>time()
            );

        }
        else
        {
            //简单修改
            $items = array(
                'classid'=>$classid,
                'hits'=>$hits,
                'order'=>$order,
                'status'=>$status,
                'updatetime'=>time()
            );
        }



        //如果插入成功
        if($this->ad->save($items,$id))
        {
            echo json_encode(array('msg'=>'修改成功','success'=>true));
        }
        else
        {
            echo json_encode(array('msg'=>'修改失败','success'=>false));
        }
	}


    public function insert(){

        $title = $this->input->post('title',true);
        $classid = $this->input->post('classid',true);
        $order = (int)$this->input->post('order',true);
        $image_src = $this->input->post('image_src',true);
        $image_url = $this->input->post('image_url',true);
        $image_alt = $this->input->post('image_alt',true);
        $hits = (int)$this->input->post('hits',true);
        $addtime =  $this->input->post('addtime',true);

        if(!$classid || !$title)
        {
            echo json_encode(array('msg'=>'添加失败，标题和分类不能为空','success'=>false));
            exit;
        }

        //格式化时间
        if($addtime)
        {
            $addtime=strtotime($addtime); //生成时间戳
        }
        else
        {
            $addtime = time();  //获取当前系统时间
        }

        //完整修改
        $items = array(
            'title'=>$title,
            'classid'=>$classid,
            'image_src'=>$image_src,
            'image_url'=>$image_url,
            'image_alt'=>$image_alt,
            'hits'=>$hits,
            'order'=>$order,
            'addtime'=>$addtime,
            'updatetime'=>time()
        );


        //如果插入成功
        if($this->ad->insert($items))
        {
            echo json_encode(array('msg'=>'添加成功，返回信息列表。','success'=>true));
        }
        else
        {
            echo json_encode(array('msg'=>'添加失败','success'=>false));
        }

    }


    //编辑单页信息页面
    public function editmore(){

        $id = $this->input->get('id',true);
        //取得单条信息项目
        $data['items'] = $this->ad->read($id);

        //取得信息分类
        $data['info_class'] = get_tclass(MODELNAME);
        $this->_template('ad_edit',$data);

    }

    //ajax删除记录处理
    public function del(){
        $id_arr = $this->input->post('id_arr');
        $id_arr =  explode(',',$id_arr);

        if(!$id_arr)
        {
            echo json_encode(array('msg'=>'参数错误！','success'=>false));
            exit;
        }

        //循环删除记录
        foreach ($id_arr as $v) {
            $this->ad->remove($v);
        }

        echo json_encode(array('msg'=>'删除记录成功！','success'=>true));

    }

	
	 
}













