<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Admin extends Admin_Controller {
	/**
	 * 登录状态
	 * @var bool
	 */
	var $logined;
	
	function __construct(){
        parent::__construct();
        $this->load->library('session');
        $this->load->helper('form');
        $this->load->library('encrypt'); //加密类
        $this->load->library('parser');//
        $this->load->model('model_admin','admin'); //载入管理模型
        $this->load->model('model_info','info'); //载入管理模型
        $this->load->model('model_product','product' ,TRUE); //载入产品管理模型
        $this->load->model('model_class','cat' ); //载入分类模型
        
        $this->load->library('pagination'); //载入分页类
        //设置后台模板路径
        $this->load->switch_theme('on','',"admincp/");
        //check user login status
  		$this->logined = $this->admin->check_purview();
        
    }
    
    /**
	 * 后台主界面
	 */
	public function index()
	{
		if($this->logined)  //登录成功进入管理首页
		{
			$this->load->view('admin/admin');
		}
		else				//返回登录页面
		{
			$this->login();
		}
		
	}
	
	/**
	 * 
	 *登录界面
	 */
	public function login(){
		$this->load->view('admin/login');
	}
	
	/**
	 * 退出登录
	 */
	public function logout(){
		 $this->session->sess_destroy();  //删除session
		 redirect('admin/login');
	}
	
	/**
	 * 后台 左菜单
	 */
	public function left(){
		$this->load->view('admin/left');
	}
	
	/**
	 * 后台 顶部
	 */
	public function top(){
		$this->load->view('admin/top');
	}
	
	
	/**
	 * 后台默认页面
	 */
	public function mainfra(){
		$this->load->view('admin/mainfra');
	}
		
	/**
	 * 
	 * 后台登录验证
	 */
	public function checklogin(){

		$vcode = strtolower($this->input->post('verifycode'));
		$username = $this->input->post('username');
		$password = $this->encrypt->sha1($this->input->post('password')); //进行sha1加密
		$err_str = "";   //错误信息
		
		//判断验证码
		if($this->session->userdata('auth_code') != $vcode){
	 
			$err_str .= '<p>您输入的验证码错误！ </p>';
		}
		//判断帐号信息
		$result_admin = $this->admin->check_admin($username,$password);
		if(!$result_admin){
			$err_str .= '<p>用户名或密码错误！ </p>';
		}
		
		if($err_str){ //登录失败
			show_error($err_str.'<p><a href="javascript:history.back(-1);">返回上一页</a></p>',500,'错误提示' );
		}else{  //登录成功
			//写入session登录权限信息
 			$this->session->set_userdata($result_admin);
 			$this->session->set_userdata('logged_in', TRUE);
			header("Location:/admin");
		}
		
		
		
	}

	
	
	
	
/*
|--------------------------------------------------------------------------
| 单页信息相关应用
|--------------------------------------------------------------------------
*/
	/**
	 * 后台添加信息
	 */
	public function addinfo(){
		
		if(isset($_POST['submit'])){
			
			$title = trim($this->input->post('title'));
			$class = trim($this->input->post('class'));
			$content = $this->input->post('content');
			$url = trim($this->input->post('url'));
			$addtime = trim($this->input->post('addtime'));
			
			if($addtime == ""){$addtime = time();}
			
			$items = array(
						'title'=>$title,
						'classid'=>$class,
						'content'=>$content,
						'url'=>$url,
						'addtime'=>$addtime,
						'updatetime'=>time()
						);
			
			$this->info->save_info($items);
			show_error("添加信息成功".'<p>'.anchor('admin/addinfo','继续添加').'</p>',200,"成功提示" );
		}
		
		
		//取得信息分类
		$data['info_class'] = $this->info->get_all_info_class();
		$this->parser->parse('admin/addinfo',$data);
		
		
		
	}
	
	
	
	/**
	 * 后台修改信息
	 */
	public function editinfo(){
		
		
		
		if(isset($_POST['submit'])){
			$title = trim($this->input->post('title'));
			$class = trim($this->input->post('class'));
			$content = $this->input->post('content');
			$url = trim($this->input->post('url'));
			$order = trim($this->input->post('order'));
			$id = trim($this->input->post('id'));
			$addtime = trim($this->input->post('addtime'));
			if($addtime)$addtime=strtotime($addtime);
			
			if($addtime == ""){$addtime = time();}
			$items = array(
						'title'=>$title,
						'classid'=>$class,
						'content'=>$content,
						'url'=>$url,
						'addtime'=>$addtime,
						'order'=>$order,
						'updatetime'=>time()
						);
			$this->info->update_info($id,$items);
			show_error("修改信息成功".'<p>'.anchor('admin/list_info','返回信息列表').'</p>',200,"成功提示" );
			exit;
		}else{
			$id = $this->uri->segment(3);
			//取得单条信息项目
			$data['items'] = $this->info->get_info_items($id);
			//取得信息分类
			$data['info_class'] = $this->info->get_all_info_class();
		}
		
		
		
		$this->parser->parse('admin/editinfo',$data);
		
		
		
	}
	
	/**
	 * 
	 * 信息列表
	 */
	public function list_info(){
		
		$per_page = 10;
		
	 	$page = $this->uri->segment(4);
	     if(empty($page)){
	        $start = 0;
	     }else{
	        $start = $page;
	     }
		
		//取得信息列表
		$data['info_list'] = $this->info->get_all_info_list($per_page,$start);
		
		//分页
		$config['base_url'] = '/index.php/admin/list_info/page';
		$config['total_rows'] = $this->info->getAllrows();
		$config['per_page'] = $per_page;
		$config['uri_segment'] = 4;
		//分页数据显示的标签
		$config['full_tag_open'] = '<div>';
		$config['full_tag_close'] = '</div>';
		//当前页的其实标签 ?: 加粗一下
		$config['cur_tag_open'] = '<b>';
		$config['cur_tag_close'] = '</b>';
		$config['prev_link'] = '上一页';
		$config['next_link'] = '下一页';
		//当前页先后个显示的个数
		$config['num_links'] = 9;
		$this->pagination->initialize($config); 
		$page = $this->pagination->create_links();
		
		$data['page'] =  $page;
		$this->load->view('admin/list_info',$data);
		
		
		
	}
	
	/**
	 * 
	 * 删除信息
	 */
	public function del_info(){
		 if($this->info->del_info($this->uri->segment(3))){
		 		show_error("删除信息成功".'<p>'.anchor('admin/list_info','返回信息列表').'</p>',200,"成功提示" );
		 }
	}
	
/*
|--------------------------------------------------------------------------
| 产品相关应用
|--------------------------------------------------------------------------
*/
	
	
	
	/**
	 * 
	 * 产品分类
	 */
	public function class_product(){
		
		$action = $this->uri->segment(3);
		
		
		if($action == 'edit')
		{
			if(isset($_POST['submit']))
			{
				$classname = trim($this->input->post('classname'));
				$order = trim($this->input->post('order'));
				$id = $this->input->post('id');
				$items = array(
					'classname' => $classname,
					'order'	  => $order
				);
				//存入数据库
				$this->cat->save($items,$id);
				show_error("修改成功".'<p>'.anchor('admin/class_product','返回分类列表').'</p>',200,"成功提示" );
			}
			$id = $this->uri->segment(4);
			//取得单条信息项目
			$data['items'] = $this->cat->read($id);
			$this->load->view('admin/class_product_edit',$data);
		}
		elseif($action == 'add')
		{
			if(isset($_POST['submit']))
			{
				$classname = trim($this->input->post('classname'));
				$order = trim($this->input->post('order'));
				$items = array(
					'classname' => $classname,
					'order'	  => $order
				);
				//存入数据库
				$this->cat->insert($items);
				show_error("添加成功".'<p>'.anchor('admin/class_product','返回分类列表').'</p>',200,"成功提示" );
			}
			
			
			$this->load->view('admin/class_product_add');
		
		}
		elseif($action == 'del')
		{
			//删除
				$id = $this->uri->segment(4);
				$this->cat->remove($id);
				show_error("删除成功".'<p>'.anchor('admin/class_product','返回分类列表').'</p>',200,"成功提示" );
		}
		else 
		{
			$per_page = 10;
		 	$page = $this->input->get('p');
		     if(empty($page)){
		        $start = 0;
		     }else{
		        $start = $page;
		     }
			//取得分类列表
			$data['info_list'] = $this->cat->find_all( NULL, '*', NULL, $start, $per_page);
			
			//分页
			$config['base_url'] = '/index.php/admin/list_info/page';
			$config['total_rows'] = $this->product->getAllrows();
			$config['per_page'] = $per_page;
			$config['uri_segment'] = 4;
			//分页数据显示的标签
			$config['full_tag_open'] = '<div>';
			$config['full_tag_close'] = '</div>';
			//当前页的其实标签 ?: 加粗一下
			$config['cur_tag_open'] = '<b>';
			$config['cur_tag_close'] = '</b>';
			$config['prev_link'] = '上一页';
			$config['next_link'] = '下一页';
			//当前页先后个显示的个数
			$config['num_links'] = 9;
			$this->pagination->initialize($config); 
			$page = $this->pagination->create_links();
			
			$data['page'] =  $page;
			
			$this->load->view('admin/class_product',$data);
			
		}
		
	}
	
	
	
	/**
	 * 后台添加产品
	 */
	public function addproduct(){
		
		if(isset($_POST['submit'])){
			
			$proname = trim($this->input->post('proname'));
			$class = trim($this->input->post('class'));
			$content = $this->input->post('content');
			$notice = $this->input->post('notice');
			$showpic = $this->input->post('img_src_hidden');
			$addtime = trim($this->input->post('addtime'));

			if($addtime === ""){$addtime = time();}else{$addtime = strtotime($addtime);};
			
			$items = array(
						'proname'=>$proname,
						'classid'=>$class,
						'content'=>$content,
						'notice'=>$notice,
						'showpic'=>$showpic,
						'addtime'=>$addtime,
						'updatetime'=>time()
						);
						
			$this->product->insert($items);
			show_error("添加产品成功".'<p>'.anchor('admin/list_product','返回产品列表').'</p>',200,"成功提示" );
		}
		//取得信息分类
		$data['info_class'] = $this->product->get_all_info_class();
		$this->parser->parse('admin/addproduct',$data);
		
		
		
	}
	
	/**
	 * 后台修改产品
	 */
	public function editproduct(){
		
		if(isset($_POST['submit'])){
			$proname= trim($this->input->post('proname'));
			$class = trim($this->input->post('class'));
			$content = $this->input->post('content');
			$notice = trim($this->input->post('notice'));
			$order = trim($this->input->post('order'));
			$showpic = $this->input->post('img_src_hidden');
			$id = trim($this->input->post('id'));
			$addtime = trim($this->input->post('addtime'));
			if($addtime)$addtime=strtotime($addtime);
			
			if($addtime == ""){$addtime = time();}
			$items = array(
						'proname'=>$proname,
						'classid'=>$class,
						'content'=>$content,
						'showpic'=>$showpic,
						'notice'=>$notice,
						'addtime'=>$addtime,
						'order'=>$order,
						'updatetime'=>time()
						);
						
			$this->product->update_info($id,$items);
			show_error("修改成功".'<p>'.anchor('admin/list_product','返回产品列表').'</p>',200,"成功提示" );
			exit;
		}else{
			$id = $this->uri->segment(3);
			//取得单条信息项目
			$data['items'] = $this->product->get_info_items($id);
			//取得信息分类
			$data['info_class'] = $this->product->get_all_info_class();
		}
		
		$this->parser->parse('admin/editproduct',$data);
		
	}
	
	/**
	 * 
	 * 产品列表
	 */
	public function list_product(){
		
		$per_page = 10;
	 	$page = $this->uri->segment(4);
	     if(empty($page)){
	        $start = 0;
	     }else{
	        $start = $page;
	     }
		
		//取得信息列表
		$data['info_list'] = $this->product->get_all_info_list($per_page,$start);
		
		//分页
		$config['base_url'] = '/index.php/admin/list_info/page';
		$config['total_rows'] = $this->product->getAllrows();
		$config['per_page'] = $per_page;
		$config['uri_segment'] = 4;
		//分页数据显示的标签
		$config['full_tag_open'] = '<div>';
		$config['full_tag_close'] = '</div>';
		//当前页的其实标签 ?: 加粗一下
		$config['cur_tag_open'] = '<b>';
		$config['cur_tag_close'] = '</b>';
		$config['prev_link'] = '上一页';
		$config['next_link'] = '下一页';
		//当前页先后个显示的个数
		$config['num_links'] = 9;
		$this->pagination->initialize($config); 
		$page = $this->pagination->create_links();
		
		$data['page'] =  $page;
		$this->load->view('admin/list_product',$data);
	}
	
	
	
	/**
	 * 
	 * 删除产品
	 */
	public function del_product(){
		 if($this->product->del_info($this->uri->segment(3))){
		 		show_error("删除信息成功".'<p>'.anchor('admin/list_product','返回信息列表').'</p>',200,"成功提示" );
		 }
	}
	
	
	
	
	/**
	 * 
	 * 后台文件上传
	 */
	function do_upload(){
	  
	  $config['upload_path'] = $this->config->item('upload_path').date($this->config->item('upload_path_format'),time());
	  $config['allowed_types'] = $this->config->item('allowed_types');
	  $config['max_size'] = $this->config->item('max_size');
	  $config['max_width']  = $this->config->item('max_size');
	  $config['max_height']  = $this->config->item('max_height');
	  $config['encrypt_name']  = $this->config->item('encrypt_name');
	  
	  $this->load->library('upload', $config);
	  $field_name = "Filedata";
	  if ( ! $this->upload->do_upload($field_name))
	  {
	   $error = $this->upload->display_errors();
	   echo "0|".$error;
	  } 
	  else
	  {
	   $data = $this->upload->data();
	   echo "1|".$data['file_name'];
	  }
	  
	 }
	 
	  
	 function apply_options()
	 {
         
       }
 
	
	
}
