<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Download extends Admin_Controller {
	
	function __construct(){
		parent::__construct();
		define('MODELNAME', 'download') ;		//模型名
		$this->load->model('model_download', MODELNAME ,TRUE); //载入产品管理模型
	}
	
	public function index()
	{
        //取得信息分类
        $data['info_class'] = get_tclass(MODELNAME,$this->S['post_lang']);
        $this->_template('download',$data);
	}

    /**
     * 后台获取列表数据
     */
    public function rows()
    {
        //获取分页参数
        $page = $this->input->post('page',true);
        $rows = $this->input->post('rows',true);
        $sort = $this->input->post('sort',true);
        $order = $this->input->post('order',true);


        //获取查询数据
        $keywords = $this->input->post('keywords',true);
        $classid = $this->input->post('classid',true);
        $where = "1=1 ";
        if($keywords)
        {
            $where  .= " and title like '%$keywords%'";
        }
        if($classid)
        {
            $where  .= " and classid = '$classid'";
        }


        //数据排序
        if($sort&&$order)
        {
            $order_str = "$sort $order";
        }

        //分析分页参数
        $per_page = $rows;   //每页显示数量
        if(empty($page)){
            $start = 0;
        }else{
            $start = ($page - 1)*$per_page;
        }



        //取得信息列表
        $info_list = $this->download->find_all($where,'id,title,classid,isgood,hits,order,showpic,addtime,updatetime',$order_str,$start,$per_page);

        //格式化数据
        foreach ($info_list as $key=>$value) {

            //格式化时间字符串
            $info_list[$key]['addtime'] = date('Y-m-d H:i:s',$value['addtime']);
            $info_list[$key]['updatetime'] = date('Y-m-d H:i:s',$value['updatetime']);

            //显示ID
            $info_list[$key]['showid'] = $value['id'];
            //获取分类名称
            $class = get_class_row($value['classid'],'',$this->S['post_lang']);
            if($class)$info_list[$key]['classname'] = $class;

        }

        //获得记录总数
        $total = $this->download->find_count($where);

        $rows = array('total'=>$total,'rows'=>($info_list));

        //ini_set('display_errors', 1);
        echo json_encode($rows);

    }
	
	public function adddownload(){
        //取得信息分类
        $data['info_class'] = get_tclass(MODELNAME,$this->S['post_lang']);
        $this->_template('download_add',$data);
	}

    //添加文章
    public function insert(){


        $title = $this->input->post('title',true);
        $classid = $this->input->post('classid',true);
         $isgood = $this->input->post('isgood',true);
        $notice = $this->input->post('notice',true);
        $content = $this->input->post('content');
        $softsize = $this->input->post('softsize',true);
        $system = $this->input->post('system',true);
         $hits = (int)$this->input->post('hits',true);
        $downnum = (int)$this->input->post('downnum',true);
        $downurl = $this->input->post('downurl',true);
        $addtime = $this->input->post('addtime',true);


        //标题图片
        $showpic = $this->input->post('showpic',true);
        $updatetime = time();

        if(!$title )
        {
            echo json_encode(array('msg'=>'添加失败，标题不能为空','success'=>false));
            exit;
        }

        if(!$classid )
        {
            echo json_encode(array('msg'=>'添加失败，分类不能为空','success'=>false));
            exit;
        }



        //格式化时间
        if($addtime)
        {
            $addtime=strtotime($addtime); //生成时间戳
        }
        else
        {
            $addtime = time();  //获取当前系统时间
        }

        //要添加的项目
        $items = array(
            'title'=>$title,
            'classid'=>$classid,
            'notice'=>$notice,
            'content'=>$content,
            'isgood'=>$isgood,
            'downurl'=>$downurl,
            'showpic'=>$showpic,
            'softsize'=>$softsize,
            'system'=>$system,
            'hits' => $hits,
            'downnum' => $downnum,
             'addtime'=>$addtime,
            'updatetime'=>$updatetime
        );



        //如果插入成功
        if($this->download->insert($items))
        {
            echo json_encode(array('msg'=>'添加成功，返回文章列表。','success'=>true));
        }
        else
        {
            echo json_encode(array('msg'=>'添加失败','success'=>false));
        }



    }
	
	public function edit(){

        $action =  $this->input->get('action',true);
        $id = $this->input->post('id',true);
        $title = $this->input->post('title',true);
        $classid = $this->input->post('classid',true);
        $isgood = $this->input->post('isgood',true);
        $notice = $this->input->post('notice',true);
        $content = $this->input->post('content');
        $softsize = $this->input->post('softsize',true);
        $system = $this->input->post('system',true);
        $hits = (int)$this->input->post('hits',true);
        $downnum = (int)$this->input->post('downnum',true);
        $downurl = $this->input->post('downurl',true);
        $addtime = $this->input->post('addtime',true);
        $order = $this->input->post('order',true);

        //标题图片
        $showpic = $this->input->post('showpic',true);
        $updatetime = time();

        //格式化时间
        if($addtime)
        {
            $addtime=strtotime($addtime); //生成时间戳
        }
        else
        {
            $addtime = time();  //获取当前系统时间
        }

        if($action == 'more')
        {
            //完整修改
            $items = array(
                'title'=>$title,
                'classid'=>$classid,
                'notice'=>$notice,
                'content'=>$content,
                'isgood'=>$isgood,
                'downurl'=>$downurl,
                'showpic'=>$showpic,
                'softsize'=>$softsize,
                'system'=>$system,
                'hits' => $hits,
                'downnum' => $downnum,
                'addtime'=>$addtime,
                'updatetime'=>$updatetime
            );

        }
        else
        {
            //简单修改
            $items = array(
                'classid'=>$classid,
                'hits'=>$hits,
                'order'=>$order,
                'isgood'=>$isgood,
                'updatetime'=>time()
            );
        }

        //如果插入成功
        if($this->download->save($items,$id))
        {
            echo json_encode(array('msg'=>'修改成功','success'=>true));
        }
        else
        {
            echo json_encode(array('msg'=>'修改失败','success'=>false));
        }
	}


    //编辑单页信息页面
    public function editmore(){

        $id = $this->input->get('id',true);
        //取得单条信息项目
        $data['items'] = $this->download->read($id);

        //取得信息分类
        $data['info_class'] = get_tclass(MODELNAME,$this->S['post_lang']);
        $this->_template('download_edit',$data);

    }

    //ajax删除记录处理
    public function del(){
        $id_arr = $this->input->post('id_arr');
        $id_arr =  explode(',',$id_arr);

        if(!$id_arr)
        {
            echo json_encode(array('msg'=>'参数错误！','success'=>false));
            exit;
        }

        //循环删除记录
        foreach ($id_arr as $v) {
            $this->download->remove($v);
        }

        echo json_encode(array('msg'=>'删除记录成功！','success'=>true));

    }
	


	
	
	
	

 
 
 
	
	
	 
}
