<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Flink extends Admin_Controller {
	
	function __construct(){
		parent::__construct();
		define('MODELNAME', 'flink') ;		//模型名
		$this->load->_model('model_flink',MODELNAME ,TRUE); //载入产品管理模型
	}
	
	public function index()
	{
        $this->_template('flink');
	}

    /**
     * 后台获取列表数据
     */

    public function rows()
    {
        //获取分页参数
        $page = $this->input->post('page',true);
        $rows = $this->input->post('rows',true);
        $sort = $this->input->post('sort',true);
        $order = $this->input->post('order',true);


        //获取查询数据
        $keywords = $this->input->post('keywords',true);
        $typeid = $this->input->post('classid',true);
        $where = "1=1 ";
        if($keywords)
        {
            $where  .= " and webname like '%$keywords%'";
        }
        if($typeid)
        {
            $where  .= " and typeid = '$typeid'";
        }


        //数据排序
        if($sort&&$order)
        {
            $order_str = "$sort $order";
        }

        //分析分页参数
        $per_page = $rows;   //每页显示数量
        if(empty($page)){
            $start = 0;
        }else{
            $start = ($page - 1)*$per_page;
        }



        //取得信息列表
        $info_list = $this->flink->find_all($where,'',$order_str,$start,$per_page);


        //获得记录总数
        $total = $this->flink->find_count($where);

        $rows = array('total'=>$total,'rows'=>($info_list));


        echo json_encode($rows);
    }

    /**
     * 添加广告页面
     */
    public function addflink(){

        $this->_template('flink_add');

    }
	
	public function edit(){

        $action =  $this->input->get('action',true);
        $id = $this->input->post('id',true);
        $webname = $this->input->post('webname',true);
        $url = $this->input->post('url',true);
        $order = (int)$this->input->post('order',true);
        $weblogo = $this->input->post('image_src',true);
        $msg = $this->input->post('msg',true);
        $dayip = (int)$this->input->post('dayip',true);
        $pr = (int)$this->input->post('pr',true);
        $name = $this->input->post('name',true);
        $qq = $this->input->post('qq',true);
        $email = $this->input->post('email',true);
        $isshow = $this->input->post('isshow',true);
        $addtime =  $this->input->post('addtime',true);

        //格式化时间
        if($addtime)
        {
            $addtime=strtotime($addtime); //生成时间戳
        }
        else
        {
            $addtime = time();  //获取当前系统时间
        }


        if($action == 'more')
        {
            //完整修改
            $items = array(
                'webname'=>$webname,
                'url'=>$url,
                'weblogo'=>$weblogo,
                'msg'=>$msg,
                'dayip'=>$dayip,
                'pr'=>$pr,
                'name'=>$name,
                'qq'=>$qq,
                'email'=>$email,
                'isshow'=>$isshow,
                'order'=>$order,
                'addtime'=>$addtime,
                'updatetime'=>time()
            );

        }
        else
        {
            //简单修改
            $items = array(
                'webname'=>$webname,
                'url'=>$url,
                'pr'=>$pr,
                'isshow'=>$isshow,
                'order'=>$order,
                'updatetime'=>time()
            );
        }



        //如果插入成功
        if($this->flink->save($items,$id))
        {
            echo json_encode(array('msg'=>'修改成功','success'=>true));
        }
        else
        {
            echo json_encode(array('msg'=>'修改失败','success'=>false));
        }
	}


    public function insert(){

        $webname = $this->input->post('webname',true);
        $url = $this->input->post('url',true);
        $order = (int)$this->input->post('order',true);
        $weblogo = $this->input->post('image_src',true);
        $msg = $this->input->post('msg',true);
        $dayip = (int)$this->input->post('dayip',true);
        $pr = (int)$this->input->post('pr',true);
        $name = $this->input->post('name',true);
        $qq = $this->input->post('qq',true);
        $email = $this->input->post('email',true);
        $isshow = $this->input->post('isshow',true);
        $addtime =  $this->input->post('addtime',true);

        if(!$webname)
        {
            echo json_encode(array('msg'=>'添加失败，网站名称不能为空','success'=>false));
            exit;
        }

        //格式化时间
        if($addtime)
        {
            $addtime=strtotime($addtime); //生成时间戳
        }
        else
        {
            $addtime = time();  //获取当前系统时间
        }

        //完整修改
        $items = array(
            'webname'=>$webname,
            'url'=>$url,
            'weblogo'=>$weblogo,
            'msg'=>$msg,
            'dayip'=>$dayip,
            'pr'=>$pr,
            'name'=>$name,
            'qq'=>$qq,
            'email'=>$email,
            'isshow'=>$isshow,
            'order'=>$order,
            'addtime'=>$addtime,
            'updatetime'=>time()
        );


        //如果插入成功
        if($this->flink->insert($items))
        {
            echo json_encode(array('msg'=>'添加成功，返回信息列表。','success'=>true));
        }
        else
        {
            echo json_encode(array('msg'=>'添加失败','success'=>false));
        }

    }


    //编辑单页信息页面
    public function editmore(){

        $id = $this->input->get('id',true);
        //取得单条信息项目
        $data['items'] = $this->flink->read($id);

        $this->_template('flink_edit',$data);

    }

    //ajax删除记录处理
    public function del(){
        $id_arr = $this->input->post('id_arr');
        $id_arr =  explode(',',$id_arr);

        if(!$id_arr)
        {
            echo json_encode(array('msg'=>'参数错误！','success'=>false));
            exit;
        }

        //循环删除记录
        foreach ($id_arr as $v) {
            $this->flink->remove($v);
        }

        echo json_encode(array('msg'=>'删除记录成功！','success'=>true));

    }

	 
}



