<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Info extends Admin_Controller {
	
	function __construct(){
		parent::__construct();
		define('MODELNAME', 'info') ;		//模型名
		$this->load->_model('model_info','info' ,TRUE); //载入产品管理模型
		$this->load->library('pagination'); //载入分页类
	}
	
	public function index()
	{

        //取得信息分类
        $data['info_class'] = get_tclass(MODELNAME);
        $this->_template('info',$data);


	}


    /**
     * 后台获取列表数据
     */

    public function rows()
    {
        //获取分页参数
        $page = $this->input->post('page',true);
        $rows = $this->input->post('rows',true);
        $sort = $this->input->post('sort',true);
        $order = $this->input->post('order',true);


        //获取查询数据
        $keywords = $this->input->post('keywords',true);
        $classid = $this->input->post('classid',true);
        $where = "1=1 ";
        if($keywords)
        {
            $where  .= " and title like '%$keywords%'";
        }
        if($classid)
        {
            $where  .= " and classid = '$classid'";
        }


        //数据排序
        if($sort&&$order)
        {
            $order_str = "$sort $order";
        }

        //分析分页参数
        $per_page = $rows;   //每页显示数量
        if(empty($page)){
            $start = 0;
        }else{
            $start = ($page - 1)*$per_page;
        }



        //取得信息列表
        $info_list = $this->info->find_all($where,'id,title,addtime,classid,updatetime,url,hits,order',$order_str,$start,$per_page);

        //格式化数据
        foreach ($info_list as $key=>$value) {



            //判断外链情况
            if($info_list[$key]['url']) //如果有外链
            {
                $info_list[$key]['url_str'] = "<a href='".$info_list[$key]['url']."' target=_blank >有外链</a>";
            }
            else
            {
                $info_list[$key]['url_str'] = "无链接";
            }
            //

            //显示ID
            $info_list[$key]['showid'] = $value['id'];
            //格式化时间字符串
            $info_list[$key]['time'] = date('Y-m-d H:i:s',$value['addtime']);
            $info_list[$key]['updatetime'] = date('Y-m-d H:i:s',$value['updatetime']);

            //获取分类名称
            $class = get_class_row($value['classid']);
            if($class)$info_list[$key]['classname'] = $class['classname'];

        }

        //获得记录总数
        $total = $this->info->find_count($where);

        $rows = array('total'=>$total,'rows'=>($info_list));


        echo json_encode($rows);
    }



	public function insert(){

        $classid = $this->input->post('classid',true);
        $order = (int)$this->input->post('order',true);
        $title = $this->input->post('title',true);
        $content = $this->input->post('content',true);
        $url =  $this->input->post('url',true);
        $hits = (int)$this->input->post('hits',true);
        $addtime =  $this->input->post('addtime',true);

        if(!$classid || !$title)
        {
            echo json_encode(array('msg'=>'添加失败，标题和分类不能为空','success'=>false));
            exit;
        }

        //格式化时间
        if($addtime)
        {
            $addtime=strtotime($addtime); //生成时间戳
        }
        else
        {
            $addtime = time();  //获取当前系统时间
        }

            //完整修改
            $items = array(
                'title'=>$title,
                'classid'=>$classid,
                'content'=>$content,
                'url'=>$url,
                'hits'=>$hits,
                'order'=>$order,
                'addtime'=>$addtime,
                'updatetime'=>time()
            );



        //如果插入成功
        if($this->info->insert($items))
        {
            echo json_encode(array('msg'=>'添加成功，返回信息列表。','success'=>true));
        }
        else
        {
            echo json_encode(array('msg'=>'添加失败','success'=>false));
        }



	}
	
	public function edit(){

        $action =  $this->input->get('action',true);
        $id = $this->input->post('id',true);
        $classid = $this->input->post('classid',true);
        $order = (int)$this->input->post('order',true);
        $title = $this->input->post('title',true);
        $content = $this->input->post('content',true);
        $url =  $this->input->post('url',true);
        $hits = (int)$this->input->post('hits',true);
        $addtime =  $this->input->post('addtime',true);

        //格式化时间
        if($addtime)
        {
            $addtime=strtotime($addtime); //生成时间戳
        }
        else
        {
            $addtime = time();  //获取当前系统时间
        }


        if($action == 'more')
        {
            //完整修改
            $items = array(
                'title'=>$title,
                'classid'=>$classid,
                'content'=>$content,
                'url'=>$url,
                'hits'=>$hits,
                'addtime'=>$addtime,
                'updatetime'=>time()
            );

        }
        else
        {
            //简单修改
            $items = array(
                'title'=>$title,
                'classid'=>$classid,
                'order'=>$order,
                'updatetime'=>time()
            );
        }



        //如果插入成功
        if($this->info->save($items,$id))
        {
            echo json_encode(array('msg'=>'修改成功','success'=>true));
        }
        else
        {
            echo json_encode(array('msg'=>'修改失败','success'=>false));
        }

	}


    //编辑单页信息页面
    public function editmore(){

        $id = $this->input->get('id',true);
        //取得单条信息项目
        $data['items'] = $this->info->read($id);

        //取得信息分类
        $data['info_class'] = get_tclass(MODELNAME);
        $this->_template('info_edit',$data);

    }


    //ajax删除记录处理
	public function del(){
        $id_arr = $this->input->post('id_arr');
        $id_arr =  explode(',',$id_arr);

        if(!$id_arr)
        {
            echo json_encode(array('msg'=>'参数错误！','success'=>false));
            exit;
        }

        //循环删除记录
        foreach ($id_arr as $v) {
            $this->info->remove($v);
        }

        echo json_encode(array('msg'=>'删除记录成功！','success'=>true));

	}


    /**
     * 添加信息页面
     */

    public function addinfo(){

        //取得信息分类
        $data['info_class'] = get_tclass(MODELNAME);
        $this->_template('info_add',$data);

    }

    /**
	 * 后台添加信息
	 */
	public function _addinfo(){
		
		if(isset($_POST['submit'])){
			
			$title = trim($this->input->post('title'));
			$class = trim($this->input->post('class'));
			$content = $this->input->post('content');
			$url = trim($this->input->post('url'));
			$addtime = trim($this->input->post('addtime'));
			
			if($addtime == ""){$addtime = time();}
			
			$items = array(
						'title'=>$title,
						'classid'=>$class,
						'content'=>$content,
						'url'=>$url,
						'addtime'=>$addtime,
						'updatetime'=>time()
						);
			
			$this->info->insert($items);
			$this->_message("添加信息成功",'info', TRUE );
		}
		
		//取得信息分类
		$data['info_class'] = get_tclass(MODELNAME);
		$this->_template('addinfo',$data);
		
		
		
	}
	
	

	
	
	 

	
	
	
	
	
	
	
	
	
	
	
	

 
 
	
	
	 
}
