<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Job extends Admin_Controller {

    function __construct(){
        parent::__construct();
        define('MODELNAME', 'job') ;		//模型名
        $this->load->_model('model_job','job' ,TRUE); //载入产品管理模型
        $this->load->library('pagination'); //载入分页类
    }

    public function index()
    {

        //取得信息分类
        $data['info_class'] = get_tclass(MODELNAME);
        $this->_template('job',$data);


    }


    /**
     * 后台获取列表数据
     */

    public function rows()
    {
        //获取分页参数
        $page = $this->input->post('page',true);
        $rows = $this->input->post('rows',true);
        $sort = $this->input->post('sort',true);
        $order = $this->input->post('order',true);


        //获取查询数据
        $keywords = $this->input->post('keywords',true);
         $where = "1=1 ";
        if($keywords)
        {
            $where  .= " and position like '%$keywords%'";
        }
         


        //数据排序
        if($sort&&$order)
        {
            $order_str = "$sort $order";
        }

        //分析分页参数
        $per_page = $rows;   //每页显示数量
        if(empty($page)){
            $start = 0;
        }else{
            $start = ($page - 1)*$per_page;
        }



        //取得信息列表
        $info_list = $this->job->find_all($where,'id,position,addtime,endtime,wage,department,description,updatetime,order',$order_str,$start,$per_page);

        //格式化数据
        foreach ($info_list as $key=>$value) {

            //格式化时间字符串
           // $info_list[$key]['time'] = date('Y-m-d H:i:s',$value['addtime']);
            $info_list[$key]['showid'] = $value['id'];
            $info_list[$key]['updatetime'] = date('Y-m-d H:i:s',$value['updatetime']);

        }

        //获得记录总数
        $total = $this->job->find_count($where);

        $rows = array('total'=>$total,'rows'=>($info_list));


        echo json_encode($rows);
    }



    public function insert(){

        $position = $this->input->post('position',true);
        $number = $this->input->post('number',true);
        $sex = $this->input->post('sex',true);
        $area = $this->input->post('area',true);
        $wage = $this->input->post('wage',true);
        $workinglife = $this->input->post('workinglife',true);
        $category = $this->input->post('category',true);
        $department = $this->input->post('department',true);
        $resumelanguage = $this->input->post('resumelanguage',true);
        $degree = $this->input->post('degree',true);
        $age = $this->input->post('age',true);
        $addtime = $this->input->post('addtime',true);
        $endtime = $this->input->post('endtime',true);
        $description = $this->input->post('description',true);
        $ability = $this->input->post('ability',true);
        $other = $this->input->post('other',true);
        $hits = (int)$this->input->post('hits',true);

        if(!$position)
        {
            echo json_encode(array('msg'=>'添加失败，职位名称不能为空','success'=>false));
            exit;
        }


        //完整修改
        $items = array(
            'position'=>$position,
            'number'=>$number,
            'sex'=>$sex,
            'area'=>$area,
            'wage'=>$wage,
            'workinglife'=>$workinglife,
            'category'=>$category,
            'department'=>$department,
            'resumelanguage'=>$resumelanguage,
            'degree'=>$degree,
            'age'=>$age,
            'addtime'=>$addtime,
            'endtime'=>$endtime,
            'description'=>$description,
            'ability'=>$ability,
            'other'=>$other,
            'hits'=>$hits,
            'updatetime'=>time()
        );



        //如果插入成功
        if($this->job->insert($items))
        {
            echo json_encode(array('msg'=>'添加成功，返回招聘列表。','success'=>true));
        }
        else
        {
            echo json_encode(array('msg'=>'添加失败','success'=>false));
        }



    }

    public function edit(){

        $action =  $this->input->get('action',true);
        $id = $this->input->post('id',true);
        $position = $this->input->post('position',true);
        $number = $this->input->post('number',true);
        $sex = $this->input->post('sex',true);
        $area = $this->input->post('area',true);
        $wage = $this->input->post('wage',true);
        $workinglife = $this->input->post('workinglife',true);
        $category = $this->input->post('category',true);
        $department = $this->input->post('department',true);
        $resumelanguage = $this->input->post('resumelanguage',true);
        $degree = $this->input->post('degree',true);
        $age = $this->input->post('age',true);
        $addtime = $this->input->post('addtime',true);
        $endtime = $this->input->post('endtime',true);
        $description = $this->input->post('description',true);
        $ability = $this->input->post('ability',true);
        $other = $this->input->post('other',true);
        $order = $this->input->post('order',true);
        $hits = (int)$this->input->post('hits',true);




        if($action == 'more')
        {
            //完整修改
            $items = array(
                'position'=>$position,
                'number'=>$number,
                'sex'=>$sex,
                'area'=>$area,
                'wage'=>$wage,
                'workinglife'=>$workinglife,
                'category'=>$category,
                'department'=>$department,
                'resumelanguage'=>$resumelanguage,
                'degree'=>$degree,
                'age'=>$age,
                'addtime'=>$addtime,
                'endtime'=>$endtime,
                'description'=>$description,
                'ability'=>$ability,
                'other'=>$other,
                'order'=>$order,
                'hits'=>$hits,
                'updatetime'=>time()
            );

        }
        else
        {
            //简单修改
            $items = array(
                'order'=>$order,
                'updatetime'=>time()
            );
        }



        //如果插入成功
        if($this->job->save($items,$id))
        {
            echo json_encode(array('msg'=>'修改成功','success'=>true));
        }
        else
        {
            echo json_encode(array('msg'=>'修改失败','success'=>false));
        }

    }


    //编辑单页信息页面
    public function editmore(){

        $id = $this->input->get('id',true);
        //取得单条信息项目
        $data['items'] = $this->job->read($id);
        $this->_template('job_edit',$data);

    }


    //ajax删除记录处理
    public function del(){
        $id_arr = $this->input->post('id_arr');
        $id_arr =  explode(',',$id_arr);

        if(!$id_arr)
        {
            echo json_encode(array('msg'=>'参数错误！','success'=>false));
            exit;
        }

        //循环删除记录
        foreach ($id_arr as $v) {
            $this->job->remove($v);
        }

        echo json_encode(array('msg'=>'删除记录成功！','success'=>true));

    }


    /**
     * 添加信息页面
     */

    public function add(){

        //取得信息分类
        $data['info_class'] = get_tclass(MODELNAME);
        $this->_template('job_add',$data);

    }

    /**
     * 后台添加信息
     */
    public function _addinfo(){

        if(isset($_POST['submit'])){

            $title = trim($this->input->post('title'));
            $class = trim($this->input->post('class'));
            $content = $this->input->post('content');
            $url = trim($this->input->post('url'));
            $addtime = trim($this->input->post('addtime'));

            if($addtime == ""){$addtime = time();}

            $items = array(
                'title'=>$title,
                'classid'=>$class,
                'content'=>$content,
                'url'=>$url,
                'addtime'=>$addtime,
                'updatetime'=>time()
            );

            $this->job->insert($items);
            $this->_message("添加信息成功",'info', TRUE );
        }

        //取得信息分类
        $data['info_class'] = get_tclass(MODELNAME);
        $this->_template('addinfo',$data);



    }

























}
