<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Login extends Admin_Controller{
	
		function __construct()
		{
			parent::__construct();
			$this->load->library('session');
			$this->load->_model('model_user','user');
		}
		
		function index()
		{
			
			if( $this->session->userdata('username'))
			{
				redirect(made_admin_url('main'));  //进入后台首页
			}
			else
			{
				$this->load->view('login');
			}

		}
		
		function checklogin(){
			$this->_do_post();	
		}
		
		function quit()
		{
			$this->session->sess_destroy();
			redirect(made_admin_url(''));
		}
		
		function _do_post()
		{
			$this->load->library('encrypt'); //加密类
			
			$username = $this->input->post('username',true);
			$password = $this->input->post('pwd',true);
			$vcode = strtolower($this->input->post('verifycode',true));

			if($username && $password)
			{
				if($vcode)
				{
					//判断验证码
					if($this->session->userdata('auth_code') != $vcode)
					{
				 		$this->session->set_flashdata('error', '您输入的验证码错误！ ');
						redirect(made_admin_url('/'));
					}
				}
				else 
				{
					$this->session->set_flashdata('error', '请填写验证码!');
					redirect(made_admin_url(setting('/')));
				}
				
				$admin = $this->user->get_user_by_username( $username );
								
				if($admin)
				{
					if( $admin['password'] == $this->encrypt->sha1($password) && $admin['flag'] == 999)
					{ 
						$this->session->set_userdata('uid',$admin['id']);
                        $this->user->updatelogin($admin);  //更新登录数据

						redirect(made_admin_url('index'));
						 
					}
					else if($admin['flag'] == '')
					{
						$this->session->set_flashdata('error', "您无权登录后台!");
						redirect(made_admin_url(setting('/')));
					}
					else
					{
						$this->session->set_flashdata('error', "用户名或密码不正确!");
						redirect(made_admin_url(setting('/')));
					}
				}
				else
				{
					$this->session->set_flashdata('error', '不存在的用户!');
					redirect(made_admin_url(setting('admin_point')));
				}
			}
			else
			{
				$this->session->set_flashdata('error', '用户名和密码不能为空!');
				redirect(made_admin_url(setting('/')));
			}
			
			
			
		}
		
}