<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Message extends Admin_Controller {
	
	function __construct(){
		parent::__construct();
		define('MODELNAME', 'message') ;		//模型名
		$this->load->_model('model_message',MODELNAME ,TRUE); //载入产品管理模型
	}
	
	public function index()
	{
        $this->_template('message');
	}


    /**
     * 后台获取列表数据
     */

    public function rows()
    {
        //获取分页参数
        $page = $this->input->post('page',true);
        $rows = $this->input->post('rows',true);
        $sort = $this->input->post('sort',true);
        $order = $this->input->post('order',true);

        //获取查询数据
        $keywords = $this->input->post('keywords',true);
        $where = "1=1 ";
        if($keywords)
        {
            $where  .= " and txt_Title like '%$keywords%'";
        }

        //数据排序
        if($sort&&$order)
        {
            $order_str = "$sort $order";
        }

        //分析分页参数
        $per_page = $rows;   //每页显示数量
        if(empty($page)){
            $start = 0;
        }else{
            $start = ($page - 1)*$per_page;
        }



        //取得信息列表
        $info_list = $this->message->find_all($where,'',$order_str,$start,$per_page);

        //格式化数据
        foreach ($info_list as $key=>$value) {

            //显示ID
            $info_list[$key]['showid'] = $value['id'];
            //格式化时间字符串
            $info_list[$key]['time'] = date('Y-m-d H:i:s',$value['addtime']);

        }

        //获得记录总数
        $total = $this->message->find_count($where);

        $rows = array('total'=>$total,'rows'=>($info_list));


        echo json_encode($rows);
    }



	public function edit(){

        $action =  $this->input->get('action',true);
        $id = $this->input->post('id',true);
        $reply = $this->input->post('reply',true);
        $isshow = (int)$this->input->post('isshow',true);
        $replytime = $this->input->post('replytime',true);

        //格式化时间
        if($replytime)
        {
            $replytime=strtotime($replytime); //生成时间戳
        }
        else
        {
            $replytime = time();  //获取当前系统时间
        }


        if($action == 'more')
        {
            //完整修改
            $items = array(
                'reply'=>$reply,
                'replytime'=>$replytime
            );

        }
        else
        {
            //简单修改
            $items = array(
                'isshow'=>$isshow
            );
        }



        //如果插入成功
        if($this->message->save($items,$id))
        {
            echo json_encode(array('msg'=>'修改成功','success'=>true));
        }
        else
        {
            echo json_encode(array('msg'=>'修改失败','success'=>false));
        }

	}


    //编辑单页信息页面
    public function reply(){

        $id = $this->input->get('id',true);
        //取得单条信息项目
        $data['items'] = $this->message->read($id);

        $this->_template('message_reply',$data);

    }


    //ajax删除记录处理
	public function del(){
        $id_arr = $this->input->post('id_arr');
        $id_arr =  explode(',',$id_arr);

        if(!$id_arr)
        {
            echo json_encode(array('msg'=>'参数错误！','success'=>false));
            exit;
        }

        //循环删除记录
        foreach ($id_arr as $v) {
            $this->message->remove($v);
        }

        echo json_encode(array('msg'=>'删除记录成功！','success'=>true));

	}



	
	
	
	
	

 
 
	
	
	 
}
