<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Nav extends Admin_Controller {

    function __construct(){
        parent::__construct();
        define('MODELNAME', 'nav') ;		//模型名
        $this->load->_model('model_nav',MODELNAME ,TRUE); //载入产品管理模型
    }

    public function index()
    {
       $this->_template('nav');
    }

    /**
     * 后台获取列表数据
     */
    public function rows()
    {
        //获取分页参数
        $page = $this->input->post('page',true);
        $rows = $this->input->post('rows',true);
        $sort = $this->input->post('sort',true);
        $order = $this->input->post('order',true);

        //获取查询数据
        $type = $this->input->get_post('type',true);
        $where = "1=1 ";

        if($type)
        {
            $where  .= " and type = '$type'";
        }


        //数据排序
        if($sort&&$order)
        {
            $order_str = "$sort $order";
        }

        //分析分页参数
        $per_page = $rows;   //每页显示数量
        if(empty($page)){
            $start = 0;
        }else{
            $start = ($page - 1)*$per_page;
        }



        //取得信息列表
        $info_list = $this->nav->find_all($where,'',$order_str,$start,$per_page);


        //格式化数据
        foreach ($info_list as $key=>$value) {

            $info_list[$key]['id'] = (int)$value['id'];
            if($value['parentid'] != 0)
            $info_list[$key]['_parentId'] = (int)$value['parentid'];


        }


        //获得记录总数
        $total = $this->nav->find_count($where);

        $rows = array('total'=>$total,'rows'=>($info_list));

        //ini_set('display_errors', 1);
        echo json_encode($rows);

    }

    /**
     * 添加广告页面
     */
    public function addnav(){

        //取得根导航
        $data['info_class'] = $this->nav->get_parent_all();
        $this->_template('nav_add',$data);

    }

    public function edit(){

        $action =  $this->input->get('action',true);
        $id = $this->input->post('id',true);
        $parentid = (int)$this->input->post('parentid',true);
        $name = $this->input->post('name',true);
        $title = $this->input->post('title',true);
        $url = $this->input->post('url',true);
        $displayorder = (int)$this->input->post('displayorder',true);
        $target = (int)$this->input->post('target',true);
        $type = (int)$this->input->post('type',true);
        $available = (int)$this->input->post('available',true);
        $highlight = $this->input->post('highlight',true);

        if($action == 'more')
        {
            //完整修改
            $items = array(
                'parentid'=>$parentid,
                'name'=>$name,
                'title'=>$title,
                'url'=>$url,
                'displayorder'=>$displayorder,
                'target'=>$target,
                'type'=>$type,
                'available'=>$available,
                'highlight'=>$highlight

            );

        }
        else
        {
            $items = array(
                'name'=>$name,
                'url'=>$url,
                'displayorder'=>$displayorder,
                'target'=>$target,
                'type'=>$type,
                'available'=>$available

            );
        }




        //如果插入成功
        if($this->nav->save($items,$id))
        {
            echo json_encode(array('msg'=>'修改成功','success'=>true));
        }
        else
        {
            echo json_encode(array('msg'=>'修改失败','success'=>false));
        }
    }


    public function insert(){

        $parentid = (int)$this->input->post('parentid',true);
        $name = $this->input->post('name',true);
        $title = $this->input->post('title',true);
        $url = $this->input->post('url',true);
        $displayorder = (int)$this->input->post('displayorder',true);
        $target = (int)$this->input->post('target',true);
        $type = (int)$this->input->post('type',true);
        $available = (int)$this->input->post('available',true);
        $highlight = $this->input->post('highlight',true);


        if($parentid == '-1' )
        {
            echo json_encode(array('msg'=>'添加失败，父导航还未选择','success'=>false));
            exit;
        }

        if(!$name)
        {
            echo json_encode(array('msg'=>'添加失败，导航名称不能为空','success'=>false));
            exit;
        }


        $items = array(
            'parentid'=>$parentid,
            'name'=>$name,
            'title'=>$title,
            'url'=>$url,
            'displayorder'=>$displayorder,
            'target'=>$target,
            'type'=>$type,
            'available'=>$available,
            'highlight'=>$highlight
        );


        //如果插入成功
        if($this->nav->insert($items))
        {
            echo json_encode(array('msg'=>'添加成功，返回导航列表。','success'=>true));
        }
        else
        {
            echo json_encode(array('msg'=>'添加失败','success'=>false));
        }

    }


    //编辑单页信息页面
    public function editmore(){

        $id = $this->input->get('id',true);
        //取得单条信息项目
        $data['items'] = $this->nav->read($id);

        //取得信息分类
        $data['info_class'] = $this->nav->get_parent_all();
        $this->_template('nav_edit',$data);

    }

    //ajax删除记录处理
    public function del(){
        $id_arr = $this->input->post('id_arr');
        $id_arr =  explode(',',$id_arr);

        if(!$id_arr)
        {
            echo json_encode(array('msg'=>'参数错误！','success'=>false));
            exit;
        }

        //循环删除记录
        foreach ($id_arr as $v) {
            $this->nav->remove($v);
        }

        echo json_encode(array('msg'=>'删除记录成功！','success'=>true));

    }



}


















