<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Product extends Admin_Controller {
	
	function __construct(){
		parent::__construct();
		define('MODELNAME', 'product');
		$this->load->_model('model_product','product'); //载入产品管理模型
	}
	
	public function index()
	{
        //取得信息分类
        $data['info_class'] = get_tclass(MODELNAME);
        $this->_template('product',$data);
	}

    /**
     * 后台获取列表数据
     */
    public function rows()
    {
        //获取分页参数
        $page = $this->input->post('page',true);
        $rows = $this->input->post('rows',true);
        $sort = $this->input->post('sort',true);
        $order = $this->input->post('order',true);


        //获取查询数据
        $keywords = $this->input->post('keywords',true);
        $classid = $this->input->post('classid',true);
        $where = "1=1 ";
        if($keywords)
        {
            $where  .= " and title like '%$keywords%'";
        }
        if($classid)
        {
            $where  .= " and classid = '$classid'";
        }


        //数据排序
        if($sort&&$order)
        {
            $order_str = "$sort $order";
        }

        //分析分页参数
        $per_page = $rows;   //每页显示数量

        if(empty($page)){
            $start = 0;
        }else{
            $start = ($page - 1)*$per_page;
        }



        //取得信息列表
        $info_list = $this->product->find_all($where,'id,proname,classid,isgood,hits,order,showpic,addtime,updatetime',$order_str,$start,$per_page);

        //格式化数据
        foreach ($info_list as $key=>$value) {

            //格式化时间字符串
            $info_list[$key]['addtime'] = date('Y-m-d H:i:s',$value['addtime']);
            $info_list[$key]['updatetime'] = date('Y-m-d H:i:s',$value['updatetime']);

            //显示ID
            $info_list[$key]['showid'] = $value['id'];
            //获取分类名称
            $class = get_class_row($value['classid']);
            if($class)$info_list[$key]['classname'] = $class['classname'];

        }

        //获得记录总数
        $total = $this->product->find_count($where);

        $rows = array('total'=>$total,'rows'=>($info_list));

        //ini_set('display_errors', 1);
        echo json_encode($rows);

    }

    public function addproduct(){
        //取得信息分类
        $data['info_class'] = get_tclass(MODELNAME);
        $this->_template('product_add',$data);
    }

    //添加产品
    public function insert(){


        $proname = $this->input->post('proname',true);
        $classid = $this->input->post('classid',true);
        $notice = $this->input->post('notice',true);
        $url = $this->input->post('url',true);
        $keyboard = $this->input->post('keyboard',true);
        $isgood = $this->input->post('isgood',true);
        $content = $this->input->post('content');
        $addtime = $this->input->post('addtime',true);


        //产品图片
        $showpic = $this->input->post('showpic',true);
        $showpic2 = $this->input->post('showpic2',true);
        $showpic3 = $this->input->post('showpic3',true);
        $updatetime = time();




        if(!$proname )
        {
            echo json_encode(array('msg'=>'添加失败，产品名称不能为空','success'=>false));
            exit;
        }

        if(!$classid )
        {
            echo json_encode(array('msg'=>'添加失败，分类不能为空','success'=>false));
            exit;
        }



        //格式化时间
        if($addtime)
        {
            $addtime=strtotime($addtime); //生成时间戳
        }
        else
        {
            $addtime = time();  //获取当前系统时间
        }

        //要添加的项目
        $items = array(
            'proname'=>$proname,
            'classid'=>$classid,
            'notice'=>$notice,
            'url'=>$url,
            'showpic'=>$showpic,
            'showpic2'=>$showpic2,
            'showpic3'=>$showpic3,
            'keyboard'=>$keyboard,
            'isgood'=>$isgood,
            'content'=>$content,
            'addtime'=>$addtime,
            'updatetime'=>$updatetime
        );



        //如果插入成功
        if($this->product->insert($items))
        {
            echo json_encode(array('msg'=>'添加成功，返回产品列表。','success'=>true));
        }
        else
        {
            echo json_encode(array('msg'=>'添加失败','success'=>false));
        }



    }

    public function edit(){

        $action =  $this->input->get('action',true);
        $id = $this->input->post('id',true);
        $proname = $this->input->post('proname',true);
        $classid = $this->input->post('classid',true);
        $notice = $this->input->post('notice',true);
        $url = $this->input->post('url',true);
        $keyboard = $this->input->post('keyboard',true);
        $isgood = $this->input->post('isgood',true);
        $content = $this->input->post('content');


        $order = (int)$this->input->post('order',true);
        $hits = (int)$this->input->post('hits',true);
        $addtime = $this->input->post('addtime',true);


        //产品图片
        $showpic = $this->input->post('showpic',true);
        $showpic2 = $this->input->post('showpic2',true);
        $showpic3 = $this->input->post('showpic3',true);
        $updatetime = time();

        //格式化时间
        if($addtime)
        {
            $addtime=strtotime($addtime); //生成时间戳
        }
        else
        {
            $addtime = time();  //获取当前系统时间
        }

        if($action == 'more')
        {
            //完整修改
            $items = array(
                'proname'=>$proname,
                'classid'=>$classid,
                'notice'=>$notice,
                'url'=>$url,
                'showpic'=>$showpic,
                'showpic2'=>$showpic2,
                'showpic3'=>$showpic3,
                'keyboard'=>$keyboard,
                'isgood'=>$isgood,
                'content'=>$content,
                'hits' => $hits,
                'order' => $order,
                'addtime'=>$addtime,
                'updatetime'=>$updatetime
            );

        }
        else
        {
            //简单修改
            $items = array(
                'classid'=>$classid,
                'hits'=>$hits,
                'order'=>$order,
                'isgood'=>$isgood,
                'updatetime'=>time()
            );
        }

        //如果插入成功
        if($this->product->save($items,$id))
        {
            echo json_encode(array('msg'=>'修改成功','success'=>true));
        }
        else
        {
            echo json_encode(array('msg'=>'修改失败','success'=>false));
        }
    }

    //编辑单页信息页面
    public function editmore(){

        $id = $this->input->get('id',true);
        //取得单条信息项目
        $data['items'] = $this->product->read($id);

        //取得信息分类
        $data['info_class'] = get_tclass(MODELNAME);
        $this->_template('product_edit',$data);

    }

    //ajax删除记录处理
    public function del(){
        $id_arr = $this->input->post('id_arr');
        $id_arr =  explode(',',$id_arr);

        if(!$id_arr)
        {
            echo json_encode(array('msg'=>'参数错误！','success'=>false));
            exit;
        }

        //循环删除记录
        foreach ($id_arr as $v) {
            $this->product->remove($v);
        }

        echo json_encode(array('msg'=>'删除记录成功！','success'=>true));

    }
	

	



	

 
	
	
	 
}
