<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Tclass extends Admin_Controller {

    public $tbname;
	function __construct(){
		parent::__construct();
		define('MODELNAME', 'tclass') ;		//模型名
		$this->load->_model('model_tclass',MODELNAME ,TRUE); //载入产品管理模型
	    $this->tbname = $this->input->get_post('tbname');
    }
	
	public function index()
	{
        $this->_template('tclass');
	}

    /**
     * 后台获取列表数据
     */

    public function rows()
    {
        //获取分页参数
        $page = $this->input->post('page',true);
        $rows = $this->input->post('rows',true);
        $sort = $this->input->post('sort',true);
        $order = $this->input->post('order',true);


        //获取查询数据
        $keywords = $this->input->post('keywords',true);
        $classid = $this->input->post('classid',true);
        $where = "1=1 ";

        if($this->tbname)
        {
            $where  .= " and tbname = '$this->tbname'";
        }
        if($keywords)
        {
            $where  .= " and classname like '%$keywords%'";
        }
        if($classid)
        {
            $where  .= " and classid = '$classid'";
        }


        //数据排序
        if($sort&&$order)
        {
            $order_str = "$sort $order";
        }

        //分析分页参数
        $per_page = $rows;   //每页显示数量
        if(empty($page)){
            $start = 0;
        }else{
            $start = ($page - 1)*$per_page;
        }



        //取得信息列表
        $info_list = $this->tclass->find_all($where,'',$order_str,$start,$per_page);

        //格式化数据
        foreach ($info_list as $key=>$value) {

            if($value['bclassid'] != 0)
                $info_list[$key]['_parentId'] = (int)$value['bclassid'];

        }

        //获得记录总数
        $total = $this->tclass->find_count($where);

        $rows = array('total'=>$total,'rows'=>($info_list));


        echo json_encode($rows);
    }

    /**
     * 添加广告页面
     */
    public function addclass(){

        //取得信息分类
        $this->_template('tclass_add');

    }
	
	public function edit(){

        $action =  $this->input->get('action',true);
        $classid =(int) $this->input->post('classid',true);
        $bclassid =(int) $this->input->post('bclassid',true);
        $tbname = $this->input->post('tbname',true);
        $classname = $this->input->post('classname',true);
        $bname = $this->input->post('bname',true);
        $checkpl = (int)$this->input->post('checkpl',true);
        $islast = $this->input->post('islast',true);
        $order = (int)$this->input->post('order',true);
        $featherclass = '';

        $thisclass_data = $this->tclass->read($classid);

        if( $bclassid < 0 )
        {
            echo json_encode(array('msg'=>'修改失败，父分类不能为空','success'=>false));
            exit;
        }
        else if( $bclassid == $classid )
        {
            echo json_encode(array('msg'=>'修改失败，不能选择自己为父分类','success'=>false));
            exit;
        }
        else if($bclassid > 0)
        {
            $featherclass = $bclassid.'|';
        }
        else if($thisclass_data['bclassid']!=0 && $bclassid == 0) //二级分类修改为根分类
        {
            $featherclass = '';
        }

        if(!$classname )
        {
            echo json_encode(array('msg'=>'修改失败，分类名称不能为空','success'=>false));
            exit;
        }
        if(!$tbname )
        {
            echo json_encode(array('msg'=>'修改失败，类型不能为空','success'=>false));
            exit;
        }



        if($action == 'more')
        {
            //完整修改
            $items = array(
                'bclassid'=>$bclassid,
                'classname'=>$classname,
                'tbname'=>$tbname,
                'bname'=>$bname,
                'checkpl'=>$checkpl,
                'featherclass'=>$featherclass,
                'islast'=>$islast,
                'order'=>$order
            );

        }
        else
        {
            //简单修改
            $items = array(
                'classname'=>$classname,
                'bname'=>$bname,
                'islast'=>$islast,
                'checkpl'=>$checkpl,
                'order'=>$order
            );
        }


        if($thisclass_data['bclassid']==0 && $bclassid > 0) //根分类修改为二级分类
        {
            //判断是否有二级分类
            if($thisclass_data['sonclass'] != '|')
            {
                echo json_encode(array('msg'=>'修改失败，该分类有子类','success'=>false));
                exit;
            }
            else
            {
                $featherclass = $bclassid.'|';
                $sonclass = '';
            }

            //完整修改
            $items = array(
                'bclassid'=>$bclassid,
                'classname'=>$classname,
                'sonclass'=>$sonclass,
                'tbname'=>$tbname,
                'bname'=>$bname,
                'checkpl'=>$checkpl,
                'featherclass'=>$featherclass,
                'islast'=>$islast,
                'order'=>$order
            );

        }



        //如果插入成功
        if($this->tclass->save($items,$classid))
        {
            //如果是子栏目

            if( $bclassid > 0 )
            {

                //更新父栏目sonclass
                //无限极栏目使用
                //$this->tclass->update_sonclass($bclassid);

            }
            echo json_encode(array('msg'=>'修改成功','success'=>true));
        }
        else
        {
            echo json_encode(array('msg'=>'修改失败','success'=>false));
        }
	}


    public function insert(){

        $bclassid =(int) $this->input->post('bclassid',true);
        $tbname = $this->input->post('tbname',true);
        $classname = $this->input->post('classname',true);
        $bname = $this->input->post('bname',true);
        $checkpl = (int)$this->input->post('checkpl',true);
        $islast = $this->input->post('islast',true);
        $order = (int)$this->input->post('order',true);
        $sonclass = '';
        $featherclass = '';

        if( $bclassid < 0 )
        {
            echo json_encode(array('msg'=>'添加失败，父分类不能为空','success'=>false));
            exit;
        }
        else if($bclassid > 0)
        {
            $featherclass = $bclassid.'|';
        }
        if(!$classname )
        {
            echo json_encode(array('msg'=>'添加失败，分类名称不能为空','success'=>false));
            exit;
        }
        if(!$tbname )
        {
            echo json_encode(array('msg'=>'添加失败，类型不能为空','success'=>false));
            exit;
        }

        if($bclassid == 0)
        {
            $sonclass = '|';
        }



        //完整添加
        $items = array(
            'bclassid'=>$bclassid,
            'classname'=>$classname,
            'sonclass'=>$sonclass,
            'tbname'=>$tbname,
            'bname'=>$bname,
            'checkpl'=>$checkpl,
            'featherclass'=>$featherclass,
            'islast'=>$islast
        );

        //如果插入成功
        if($this->tclass->insert($items))
        {
            //如果是子栏目

            if( $bclassid > 0 )
            {

                //更新父栏目sonclass
                //无限极栏目使用
                $this->tclass->update_sonclass($bclassid);

            }

            echo json_encode(array('msg'=>'添加成功，返回分类列表。','success'=>true));


        }
        else
        {
            echo json_encode(array('msg'=>'添加失败','success'=>false));
        }

    }


    //编辑单页信息页面
    public function editmore(){

        $id = $this->input->get('id',true);
        //取得单条信息项目
        $data['items'] = $this->tclass->read($id);

        if($data['items'])
        {
            //取得信息分类
            $data['info_class'] = $this->tclass->get_root_class($this->tbname);
            $this->_template('tclass_edit',$data);
        }
        else
        {
            $this->_message('参数错误');
            exit;
        }


    }

    //ajax删除记录处理
    public function del(){
        $id_arr = $this->input->post('id_arr');
        $id_arr =  explode(',',$id_arr);

        if(!$id_arr)
        {
            echo json_encode(array('msg'=>'参数错误！','success'=>false));
            exit;
        }

        $del_result = 0;
        //循环删除记录
        foreach ($id_arr as $v) {
            //更新sonclass
            $r = $this->tclass->del_sonclass($v);
            if($r == 1)
            {
                $this->tclass->remove($v);
            }
            elseif($r == -1)
            {
                echo json_encode(array('msg'=>"有子类存在，请先删除子类！",'success'=>false));
                exit;
            }

        }


        if($del_result > 0)
        {
            echo json_encode(array('msg'=>"删除记录成功！",'success'=>true));
        }
        else
        {
            echo json_encode(array('msg'=>"删除失败！",'success'=>false));
        }



    }


    //生成所有可供选择的分类json数据
	public function tree_data_json(){

        //获取格式化组合分类json数组
        $class  =  $this->tclass->get_root_class($this->tbname);

        $json_class = Array();
        //$json_class1 = array();
        $json_class2 = array();


        foreach ($class as $key=>$value) {

            if($class[$key]['sonclass']) //如果有子分类
            {
                $json_class[$key]['id'] = $value['classid'];
                $json_class[$key]['text'] = $value['classname'];

                //$son_arr = $this->tclass->get_son_class($value['sonclass'],$this->tbname);


                //foreach ($son_arr as $k=>$v) {
                //    $json_class1[$k]['id'] = $v['classid'];
               //     $json_class1[$k]['text'] = $v['classname'];
               // }

              //  $json_class[$key]['children'] = $json_class1;
            }
            else if($class[$key]['bclassid'] == 0)
            {
                $json_class2[$key]['id'] = $value['classid'];
                $json_class2[$key]['text'] = $value['classname'];
            }

        }



        $root_class = array('id'=>0,'text'=>'根栏目',"iconCls"=>"icon-ok","checked"=>"true");   //根栏目数据

        $json_class_data = array_merge($json_class,$json_class2); //合并分类数组

        array_unshift($json_class_data,$root_class);  //插入数组到最前端
        echo json_encode($json_class_data);



        /* '[{
            "id":1,
            "text":"Folder1",
            "iconCls":"icon-ok",
            "children":[{
                "id":2,
                "text":"File1",
                "checked":true
            },{
                "id":3,
                "text":"Folder2",
                "state":"open",
                "children":[{
                    "id":4,
                    "text":"File3",
                    "attributes":{
                        "p1":"value1",
                        "p2":"value2"
                    },
                    "checked":true,
                    "iconCls":"icon-reload"
                },{
                    "id": 8,
                    "text":"Async Folder",
                    "state":"closed"
                }]
            }]
        },{
            "text":"Languages",
            "state":"closed",
            "children":[{
                "id":"j1",
                "text":"Java"
            },{
                "id":"j2",
                "text":"C#"
            }]
        }]';*/
    }



















	 
}


















