<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Product extends Start_Controller {

	public function __construct(){
		parent::__construct();
		$this->load->_model('model_product','product');
	}
	
	
	public function index()
	{
		$this->_products();
	}
	public function page(){
		
	}

    //重新定义方法的调用规则  获取URI第二段值
    public function _remap($arg,$arg_array)
    {
        if($arg == 'detail')
        {
            $this->_detail($arg_array);
        }
        else
        {
            if(isset($arg_array))
            {
                $this->_products($arg,$arg_array);
            }
            else
            {
                $this->_products($arg);
            }
        }


    }

    /**
     * @param $arg_array 产品id
     *
     */
    public function _detail($arg_array){
        $productid = $arg_array[0];
        $productdata = $this->product->get_info_items($productid);
        $classdata = get_class_row($productdata['classid']);
        $this->data['data'] = $productdata;
        $this->data['classname'] = $classdata['classname'];
        $this->data['pagename'] = $productdata['proname'] . ' - ' .$classdata['classname'];
        $this->_template('product_show',$this->data);

    }
	
	/**
	 *  产品分类信息处理
	 */
	public function _products($arg,$arg_array=null){


        $classid = $arg;  //获取分类id


        if(empty($classid))
        {
            die('缺少分类参数!');
        }
        else
        {


            if($classid == 'index')
            {
                $where = "";
                $this->data['classname'] = '所有产品';
                $this->data['pagename'] = $this->data['classname'];
            }
            else
            {
                //获取分类信息
                $classdata  = get_class_row($classid,'product');
                if($classdata){
                    $this->data['classname'] = $classdata['classname'];
                    $this->data['pagename'] = $classdata['classname'];
                    $this->data['classid'] = $classid;
                    $where = " classid =  '$classid'";
                }
                else
                {
                    show_404();
                }

            }


            $keys = $this->input->get_post('keys',true);
            $per_page = 9;
            $page = $this->input->get('per_page', true);

            if(empty($page)){
                $start = 0;
            }else{
                $start = ($page-1)*$per_page;
            }

            //取得信息列表
            $data['products'] = $this->product->get_all_rows($where,'*','id desc',$start, $per_page);
            //分页
            $config['base_url'] = site_url('product/'.$classid.'?keys='.$keys);

            $config['total_rows'] = $this->product->find_count($where);
            $config['per_page'] = $per_page;
            //$config['uri_segment'] = 3;
            //分页数据显示的标签
            $config['full_tag_open'] = '<div>';
            $config['full_tag_close'] = '</div>';
            //当前页的其实标签 ?: 加粗一下
            $config['cur_tag_open'] = '<b>';
            $config['cur_tag_close'] = '</b>';
            $config['prev_link'] = '上一页';
            $config['next_link'] = '下一页';
            $config['first_link'] = '第一页';
            $config['last_link'] = '最后一页';
            $config['use_page_numbers'] = TRUE;
            $config['page_query_string'] = TRUE;
            //当前页先后个显示的个数
            $config['num_links'] = 9;

            $this->load->library('pagination'); //载入分页类
            $this->pagination->initialize($config);
            $page = $this->pagination->create_links();

            $data['page'] =  $page;

            $this->data['products'] = $data['products'];
            $this->data['page'] = $data['page'];


            $this->_template('products',$this->data);





        }




		
    }
	
}




