<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * TayGod 核心控制类扩展
 *
 * An open source application development framework for PHP 5.1.6 or newer
 *
 * @package		TayGod
 * @author		TayGod Dev Team
 * @copyright	Copyright (c) 2012 .
 * @license		http://taygod.com/license.html
 * @link		http://taygod.com
 * @since		Version 1.0.0
 * @filesource
 */

define('IN_TAYCMS',TRUE);
define('TAYCMS_NAME','TayCms');
define('TAYCMS_VERSION','V1.8.0');
define('TAYCMS_BUILDTIME','20130808');
	
// ------------------------------------------------------------------------
class Lin_Controller extends CI_Controller {
	
	var $setting;
	var $S;	
	
	//初始化扩展控制类
	function __construct(){
		
		parent::__construct();
		//载入配置
		$this->load->library('lin/settings');

        //判断当前语言
        $this->S['lang'] =  $this->config->item('language');
        $this->S['post_lang'] = $this->config->item('post_lang');
		
	}
	
}
// END Lin_Controller class


//前台页面控制器
abstract class Start_Controller extends Lin_Controller {
	
	var $data;
		function __construct()
		{
			parent::__construct();
			$this->load->library('template');
			//设置前台模板路径
			$this->template->_init(setting('theme'));
			//载入自定义函数
			$this->load->library('common');
			
			//网站基本信息
			$this->data['site_name'] = setting('sitename');
			$this->data['site_url'] = setting('siteallurl');
			$this->data['keywords'] = setting('sitekey');				//网站关键词
			$this->data['description'] = setting('siteintro');			//网站描述
			$this->data['base_url'] = base_url();
			$this->data['theme_path'] = 'template/'.setting('theme').'/';
			$this->data['appname'] = $this->uri->segment(1);

            //载入超级变量
            $this->data['_S'] = $this->S;

			//判断伪静态
			
			if(setting('indexpagedt'))
			{
				$this->config->set_item('index_page', ''); //配置默认入口文件名为空
				$this->config->set_item('url_suffix',setting('rewritetype')); //判断设置伪静态后缀名
			}
			else 
			{
				$this->config->set_item('index_page', 'index.php'); //配置默认入口文件名为index.php
				$this->config->set_item('url_suffix','');
			}
			
			
			$this->data['navpath'] = '<a href="'.base_url().'" >首页</a> > ';			//生成当前位置代码
		}
		
		/**
		 * 
		 * 载入模版方法
		 * @param filename $template
		 * @param array $data
		 * @param file extension type name $ext
		 */
		function _template($template, $data = array() )
		{
				$this->template->assign($data);
				$this->template->display($template.$this->S['post_lang']);
				
		}

        //前台提示信息
        function _message($msg, $goto = '',$auto = true,$fix = '')
        {
            if($goto == '')
            {
                $goto = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : site_url();
            }
            else
            {
                $goto = strpos($goto,'http') !== false ? $goto : site_url($goto);
            }
            $goto .= $fix;
            $this->_template('sys_message',array('msg'=>$msg,'goto'=>$goto,'auto'=>$auto,'ver'=>TAYCMS_NAME.' '.TAYCMS_VERSION));
            echo $this->output->get_output();
            exit();
        }
	 
}


//后台控制器扩展，如果您不了解其作用，请不要随意更改此处
abstract class Admin_Controller extends Lin_Controller {
	
	var $template_path;
	var $logined;
	
		function __construct()
		{
			parent::__construct();
			$this->template_path = APPPATH.'views/'; //后台视图路径
			//设置后台模板路径
			$this->load->switch_theme('on','admin', $this->template_path );
			$this->config->set_item('url_suffix',''); //强制不使用伪静态
			$this->load->library('session');
	        //check user login status
	  		$this->logined = $this->_check_login();

            //载入超级变量
	  		if($this->logined)
	  		{
	  			$this->_set_s();
	  		}
	  		 
		}
		
		function _check_login()
		{	 
			if ( ! $this->session->userdata('uid') )
		    {       
		        	$redirect = $this->uri->uri_string(); //获取后台入口路径
		            if($redirect != setting('admin_point') && $redirect != setting('admin_point')."/login/checklogin" )$this->_message("<p>您还没有登录或者登录超时！</p>".'<p><a href="'.made_admin_url('').'" target=_top>重新登录</a></p>',made_admin_url(''),0);
		    }
		    else
		    {
		    	return   1;
		    }
		}
		

		
		function _check_permit($action = '')
		{
			if(!$this->acl->permit($action))
			{
				$this->_message('对不起，你没有访问这里的权限！','',false);
			}
		}
		
		function _message($msg, $goto = '',$auto = true,$fix = '')
		{
			if($goto == '')
			{
				$goto = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : site_url();
			}
			else
			{
				$goto = strpos($goto,'http') !== false ? $goto : made_admin_url($goto);	
			}
			$goto .= $fix;
			$this->_show('sys_message',array('msg'=>$msg,'goto'=>$goto,'auto'=>$auto));
			echo $this->output->get_output();
			exit();
		}

        function _show($template, $data = array())
        {
            $this->load->view($template,$data);
         }
        function _template($template, $data = array())
        {
            $cr  =  '<div styl'.'e='.'"c'.'le'.'a'.'r:'.'bot'.'h;text-a'.'lign:ce'.'nt'.'er'.';mar'.'g'.'in'.':5'.'px '.'auto'.';c'.'o'.'l'.'o'.'r:g'.'r'.'a'.'y">P'.'o'.'w'.'e'.'r'.'e'.'d by <a href="h'.'t'.'t'.'p'.':'.'/'.'/'.'w'.'w'.'w.t'.'a'.'yc'.'ms.com/"><strong> '.TAYCMS_NAME.' '.TAYCMS_VERSION.'</strong></a><span> &copy; 200'.'5 - 2'.'0'.'1'.'2 <a hre'.'f="h'.'t'.'t'.'p:'.'/'.'/w'.'w'.'w.t'.'a'.'y'.'g'.'o'.'d.c'.'o'.'m/" target="_blank">Ta'.'yG'.'od T'.'e'.'am.</a></span>'.'</div></'.'bo'.'dy></'.'ht'.'ml>';

            $this->load->view($template,$data);
            $this->output->append_output($cr);
        }

		function _set_s(){
			$this->load->_model('model_user');
			$this->load->library('common');
			$this->common->_get_version();
	 		$this->S['admin'] = $this->model_user->get_user_by_id($this->session->userdata('uid'));
		}
		
}
// END Admin_Controller class
	
		//后台URI生成函数
		function made_admin_url($uri,$qs = '')
		{
			return site_url(setting('admin_point').'/'.$uri).($qs == '' ? '' : '?'.$qs);
		}
		


/* End of file Lin_Controller.php */
/* Location: ./app/core/Lin_Controller.php */